// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package escloud

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateInstanceCommon = "CreateInstance"

// CreateInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateInstanceCommon operation. The "output" return
// value will be populated with the CreateInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateInstanceCommon Send returns without error.
//
// See CreateInstanceCommon for more information on using the CreateInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateInstanceCommonRequest method.
//    req, resp := client.CreateInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) CreateInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateInstanceCommon API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation CreateInstanceCommon for usage and error information.
func (c *ESCLOUD) CreateInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateInstanceCommonRequest(input)
	return out, req.Send()
}

// CreateInstanceCommonWithContext is the same as CreateInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) CreateInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstance = "CreateInstance"

// CreateInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateInstance operation. The "output" return
// value will be populated with the CreateInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateInstanceCommon Send returns without error.
//
// See CreateInstance for more information on using the CreateInstance
// API call, and error handling.
//
//    // Example sending a request using the CreateInstanceRequest method.
//    req, resp := client.CreateInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) CreateInstanceRequest(input *CreateInstanceInput) (req *request.Request, output *CreateInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceInput{}
	}

	output = &CreateInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateInstance API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation CreateInstance for usage and error information.
func (c *ESCLOUD) CreateInstance(input *CreateInstanceInput) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	return out, req.Send()
}

// CreateInstanceWithContext is the same as CreateInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) CreateInstanceWithContext(ctx volcengine.Context, input *CreateInstanceInput, opts ...request.Option) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	InstanceConfiguration *InstanceConfigurationForCreateInstanceInput `type:"structure" json:",omitempty"`

	Tags []*TagForCreateInstanceInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceInput"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateInstanceInput) SetClientToken(v string) *CreateInstanceInput {
	s.ClientToken = &v
	return s
}

// SetInstanceConfiguration sets the InstanceConfiguration field's value.
func (s *CreateInstanceInput) SetInstanceConfiguration(v *InstanceConfigurationForCreateInstanceInput) *CreateInstanceInput {
	s.InstanceConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInstanceInput) SetTags(v []*TagForCreateInstanceInput) *CreateInstanceInput {
	s.Tags = v
	return s
}

type CreateInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	OrderID *string `type:"string" json:",omitempty"`

	OrderNO *string `type:"string" json:",omitempty"`

	TradeEnabled *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CreateInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateInstanceOutput) SetInstanceId(v string) *CreateInstanceOutput {
	s.InstanceId = &v
	return s
}

// SetOrderID sets the OrderID field's value.
func (s *CreateInstanceOutput) SetOrderID(v string) *CreateInstanceOutput {
	s.OrderID = &v
	return s
}

// SetOrderNO sets the OrderNO field's value.
func (s *CreateInstanceOutput) SetOrderNO(v string) *CreateInstanceOutput {
	s.OrderNO = &v
	return s
}

// SetTradeEnabled sets the TradeEnabled field's value.
func (s *CreateInstanceOutput) SetTradeEnabled(v bool) *CreateInstanceOutput {
	s.TradeEnabled = &v
	return s
}

type ExtraPerformanceForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Throughput *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ExtraPerformanceForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtraPerformanceForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetThroughput sets the Throughput field's value.
func (s *ExtraPerformanceForCreateInstanceInput) SetThroughput(v int32) *ExtraPerformanceForCreateInstanceInput {
	s.Throughput = &v
	return s
}

type InstanceConfigurationForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdminPassword *string `type:"string" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForCreateInstanceInput"`

	ConfigurationCode *string `type:"string" json:",omitempty"`

	DeletionProtection *bool `type:"boolean" json:",omitempty"`

	EnableCerebro *bool `type:"boolean" json:",omitempty"`

	EnableHttps *bool `type:"boolean" json:",omitempty"`

	EnablePureMaster *bool `type:"boolean" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	NetworkSpecs []*NetworkSpecForCreateInstanceInput `type:"list" json:",omitempty"`

	NodeSpecsAssigns []*NodeSpecsAssignForCreateInstanceInput `type:"list" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RegionId *string `type:"string" json:",omitempty"`

	Subnet *SubnetForCreateInstanceInput `type:"structure" json:",omitempty"`

	VPC *VPCForCreateInstanceInput `type:"structure" json:",omitempty"`

	Version *string `type:"string" json:",omitempty" enum:"EnumOfVersionForCreateInstanceInput"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InstanceConfigurationForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceConfigurationForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetAdminPassword sets the AdminPassword field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetAdminPassword(v string) *InstanceConfigurationForCreateInstanceInput {
	s.AdminPassword = &v
	return s
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetAutoRenew(v bool) *InstanceConfigurationForCreateInstanceInput {
	s.AutoRenew = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetChargeType(v string) *InstanceConfigurationForCreateInstanceInput {
	s.ChargeType = &v
	return s
}

// SetConfigurationCode sets the ConfigurationCode field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetConfigurationCode(v string) *InstanceConfigurationForCreateInstanceInput {
	s.ConfigurationCode = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetDeletionProtection(v bool) *InstanceConfigurationForCreateInstanceInput {
	s.DeletionProtection = &v
	return s
}

// SetEnableCerebro sets the EnableCerebro field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetEnableCerebro(v bool) *InstanceConfigurationForCreateInstanceInput {
	s.EnableCerebro = &v
	return s
}

// SetEnableHttps sets the EnableHttps field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetEnableHttps(v bool) *InstanceConfigurationForCreateInstanceInput {
	s.EnableHttps = &v
	return s
}

// SetEnablePureMaster sets the EnablePureMaster field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetEnablePureMaster(v bool) *InstanceConfigurationForCreateInstanceInput {
	s.EnablePureMaster = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetInstanceName(v string) *InstanceConfigurationForCreateInstanceInput {
	s.InstanceName = &v
	return s
}

// SetNetworkSpecs sets the NetworkSpecs field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetNetworkSpecs(v []*NetworkSpecForCreateInstanceInput) *InstanceConfigurationForCreateInstanceInput {
	s.NetworkSpecs = v
	return s
}

// SetNodeSpecsAssigns sets the NodeSpecsAssigns field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetNodeSpecsAssigns(v []*NodeSpecsAssignForCreateInstanceInput) *InstanceConfigurationForCreateInstanceInput {
	s.NodeSpecsAssigns = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetPeriod(v int32) *InstanceConfigurationForCreateInstanceInput {
	s.Period = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetProjectName(v string) *InstanceConfigurationForCreateInstanceInput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetRegionId(v string) *InstanceConfigurationForCreateInstanceInput {
	s.RegionId = &v
	return s
}

// SetSubnet sets the Subnet field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetSubnet(v *SubnetForCreateInstanceInput) *InstanceConfigurationForCreateInstanceInput {
	s.Subnet = v
	return s
}

// SetVPC sets the VPC field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetVPC(v *VPCForCreateInstanceInput) *InstanceConfigurationForCreateInstanceInput {
	s.VPC = v
	return s
}

// SetVersion sets the Version field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetVersion(v string) *InstanceConfigurationForCreateInstanceInput {
	s.Version = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *InstanceConfigurationForCreateInstanceInput) SetZoneId(v string) *InstanceConfigurationForCreateInstanceInput {
	s.ZoneId = &v
	return s
}

type NetworkSpecForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *int32 `type:"int32" json:",omitempty"`

	IsOpen *bool `type:"boolean" json:",omitempty"`

	SpecName *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NetworkSpecForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkSpecForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *NetworkSpecForCreateInstanceInput) SetBandwidth(v int32) *NetworkSpecForCreateInstanceInput {
	s.Bandwidth = &v
	return s
}

// SetIsOpen sets the IsOpen field's value.
func (s *NetworkSpecForCreateInstanceInput) SetIsOpen(v bool) *NetworkSpecForCreateInstanceInput {
	s.IsOpen = &v
	return s
}

// SetSpecName sets the SpecName field's value.
func (s *NetworkSpecForCreateInstanceInput) SetSpecName(v string) *NetworkSpecForCreateInstanceInput {
	s.SpecName = &v
	return s
}

// SetType sets the Type field's value.
func (s *NetworkSpecForCreateInstanceInput) SetType(v string) *NetworkSpecForCreateInstanceInput {
	s.Type = &v
	return s
}

type NodeSpecsAssignForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExtraPerformance *ExtraPerformanceForCreateInstanceInput `type:"structure" json:",omitempty"`

	Number *int32 `type:"int32" json:",omitempty"`

	ResourceSpecName *string `type:"string" json:",omitempty"`

	StorageSize *int32 `type:"int32" json:",omitempty"`

	StorageSpecName *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForCreateInstanceInput"`
}

// String returns the string representation
func (s NodeSpecsAssignForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeSpecsAssignForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetExtraPerformance sets the ExtraPerformance field's value.
func (s *NodeSpecsAssignForCreateInstanceInput) SetExtraPerformance(v *ExtraPerformanceForCreateInstanceInput) *NodeSpecsAssignForCreateInstanceInput {
	s.ExtraPerformance = v
	return s
}

// SetNumber sets the Number field's value.
func (s *NodeSpecsAssignForCreateInstanceInput) SetNumber(v int32) *NodeSpecsAssignForCreateInstanceInput {
	s.Number = &v
	return s
}

// SetResourceSpecName sets the ResourceSpecName field's value.
func (s *NodeSpecsAssignForCreateInstanceInput) SetResourceSpecName(v string) *NodeSpecsAssignForCreateInstanceInput {
	s.ResourceSpecName = &v
	return s
}

// SetStorageSize sets the StorageSize field's value.
func (s *NodeSpecsAssignForCreateInstanceInput) SetStorageSize(v int32) *NodeSpecsAssignForCreateInstanceInput {
	s.StorageSize = &v
	return s
}

// SetStorageSpecName sets the StorageSpecName field's value.
func (s *NodeSpecsAssignForCreateInstanceInput) SetStorageSpecName(v string) *NodeSpecsAssignForCreateInstanceInput {
	s.StorageSpecName = &v
	return s
}

// SetType sets the Type field's value.
func (s *NodeSpecsAssignForCreateInstanceInput) SetType(v string) *NodeSpecsAssignForCreateInstanceInput {
	s.Type = &v
	return s
}

type SubnetForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SubnetId *string `type:"string" json:",omitempty"`

	SubnetName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SubnetForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SubnetForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *SubnetForCreateInstanceInput) SetSubnetId(v string) *SubnetForCreateInstanceInput {
	s.SubnetId = &v
	return s
}

// SetSubnetName sets the SubnetName field's value.
func (s *SubnetForCreateInstanceInput) SetSubnetName(v string) *SubnetForCreateInstanceInput {
	s.SubnetName = &v
	return s
}

type TagForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `min:"1" max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForCreateInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForCreateInstanceInput"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}
	if s.Value != nil && len(*s.Value) > 256 {
		invalidParams.Add(request.NewErrParamMaxLen("Value", 256, *s.Value))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForCreateInstanceInput) SetKey(v string) *TagForCreateInstanceInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateInstanceInput) SetValue(v string) *TagForCreateInstanceInput {
	s.Value = &v
	return s
}

type VPCForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	VpcName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VPCForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VPCForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetVpcId sets the VpcId field's value.
func (s *VPCForCreateInstanceInput) SetVpcId(v string) *VPCForCreateInstanceInput {
	s.VpcId = &v
	return s
}

// SetVpcName sets the VpcName field's value.
func (s *VPCForCreateInstanceInput) SetVpcName(v string) *VPCForCreateInstanceInput {
	s.VpcName = &v
	return s
}

const (
	// EnumOfChargeTypeForCreateInstanceInputPrePaid is a EnumOfChargeTypeForCreateInstanceInput enum value
	EnumOfChargeTypeForCreateInstanceInputPrePaid = "PrePaid"

	// EnumOfChargeTypeForCreateInstanceInputPostPaid is a EnumOfChargeTypeForCreateInstanceInput enum value
	EnumOfChargeTypeForCreateInstanceInputPostPaid = "PostPaid"
)

const (
	// EnumOfTypeForCreateInstanceInputMaster is a EnumOfTypeForCreateInstanceInput enum value
	EnumOfTypeForCreateInstanceInputMaster = "Master"

	// EnumOfTypeForCreateInstanceInputKibana is a EnumOfTypeForCreateInstanceInput enum value
	EnumOfTypeForCreateInstanceInputKibana = "Kibana"

	// EnumOfTypeForCreateInstanceInputHot is a EnumOfTypeForCreateInstanceInput enum value
	EnumOfTypeForCreateInstanceInputHot = "Hot"

	// EnumOfTypeForCreateInstanceInputWarm is a EnumOfTypeForCreateInstanceInput enum value
	EnumOfTypeForCreateInstanceInputWarm = "Warm"

	// EnumOfTypeForCreateInstanceInputCold is a EnumOfTypeForCreateInstanceInput enum value
	EnumOfTypeForCreateInstanceInputCold = "Cold"

	// EnumOfTypeForCreateInstanceInputCoordinator is a EnumOfTypeForCreateInstanceInput enum value
	EnumOfTypeForCreateInstanceInputCoordinator = "Coordinator"

	// EnumOfTypeForCreateInstanceInputOther is a EnumOfTypeForCreateInstanceInput enum value
	EnumOfTypeForCreateInstanceInputOther = "Other"
)

const (
	// EnumOfVersionForCreateInstanceInputV67 is a EnumOfVersionForCreateInstanceInput enum value
	EnumOfVersionForCreateInstanceInputV67 = "V6_7"

	// EnumOfVersionForCreateInstanceInputV710 is a EnumOfVersionForCreateInstanceInput enum value
	EnumOfVersionForCreateInstanceInputV710 = "V7_10"

	// EnumOfVersionForCreateInstanceInputV7Tls is a EnumOfVersionForCreateInstanceInput enum value
	EnumOfVersionForCreateInstanceInputV7Tls = "V7_TLS"

	// EnumOfVersionForCreateInstanceInputV7Byte is a EnumOfVersionForCreateInstanceInput enum value
	EnumOfVersionForCreateInstanceInputV7Byte = "V7_BYTE"

	// EnumOfVersionForCreateInstanceInputOpenSearch29 is a EnumOfVersionForCreateInstanceInput enum value
	EnumOfVersionForCreateInstanceInputOpenSearch29 = "OPEN_SEARCH_2_9"
)
