// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dns

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateCustomLineCommon = "CreateCustomLine"

// CreateCustomLineCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCustomLineCommon operation. The "output" return
// value will be populated with the CreateCustomLineCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateCustomLineCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateCustomLineCommon Send returns without error.
//
// See CreateCustomLineCommon for more information on using the CreateCustomLineCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateCustomLineCommonRequest method.
//    req, resp := client.CreateCustomLineCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) CreateCustomLineCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateCustomLineCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateCustomLineCommon API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation CreateCustomLineCommon for usage and error information.
func (c *DNS) CreateCustomLineCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateCustomLineCommonRequest(input)
	return out, req.Send()
}

// CreateCustomLineCommonWithContext is the same as CreateCustomLineCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomLineCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) CreateCustomLineCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateCustomLineCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomLine = "CreateCustomLine"

// CreateCustomLineRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCustomLine operation. The "output" return
// value will be populated with the CreateCustomLineCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateCustomLineCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateCustomLineCommon Send returns without error.
//
// See CreateCustomLine for more information on using the CreateCustomLine
// API call, and error handling.
//
//    // Example sending a request using the CreateCustomLineRequest method.
//    req, resp := client.CreateCustomLineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) CreateCustomLineRequest(input *CreateCustomLineInput) (req *request.Request, output *CreateCustomLineOutput) {
	op := &request.Operation{
		Name:       opCreateCustomLine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomLineInput{}
	}

	output = &CreateCustomLineOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateCustomLine API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation CreateCustomLine for usage and error information.
func (c *DNS) CreateCustomLine(input *CreateCustomLineInput) (*CreateCustomLineOutput, error) {
	req, out := c.CreateCustomLineRequest(input)
	return out, req.Send()
}

// CreateCustomLineWithContext is the same as CreateCustomLine with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomLine for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) CreateCustomLineWithContext(ctx volcengine.Context, input *CreateCustomLineInput, opts ...request.Option) (*CreateCustomLineOutput, error) {
	req, out := c.CreateCustomLineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateCustomLineInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IPSegments []*string `type:"list" json:",omitempty"`

	// NameCN is a required field
	NameCN *string `type:"string" json:",omitempty" required:"true"`

	Remark *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateCustomLineInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomLineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomLineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomLineInput"}
	if s.NameCN == nil {
		invalidParams.Add(request.NewErrParamRequired("NameCN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIPSegments sets the IPSegments field's value.
func (s *CreateCustomLineInput) SetIPSegments(v []*string) *CreateCustomLineInput {
	s.IPSegments = v
	return s
}

// SetNameCN sets the NameCN field's value.
func (s *CreateCustomLineInput) SetNameCN(v string) *CreateCustomLineInput {
	s.NameCN = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *CreateCustomLineInput) SetRemark(v string) *CreateCustomLineInput {
	s.Remark = &v
	return s
}

type CreateCustomLineOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Line *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateCustomLineOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomLineOutput) GoString() string {
	return s.String()
}

// SetLine sets the Line field's value.
func (s *CreateCustomLineOutput) SetLine(v string) *CreateCustomLineOutput {
	s.Line = &v
	return s
}
