// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataleap

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDTSOpenTagResourceGroupsCommon = "DTSOpenTagResourceGroups"

// DTSOpenTagResourceGroupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DTSOpenTagResourceGroupsCommon operation. The "output" return
// value will be populated with the DTSOpenTagResourceGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DTSOpenTagResourceGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DTSOpenTagResourceGroupsCommon Send returns without error.
//
// See DTSOpenTagResourceGroupsCommon for more information on using the DTSOpenTagResourceGroupsCommon
// API call, and error handling.
//
//    // Example sending a request using the DTSOpenTagResourceGroupsCommonRequest method.
//    req, resp := client.DTSOpenTagResourceGroupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DATALEAP) DTSOpenTagResourceGroupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDTSOpenTagResourceGroupsCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DTSOpenTagResourceGroupsCommon API operation for DATALEAP.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DATALEAP's
// API operation DTSOpenTagResourceGroupsCommon for usage and error information.
func (c *DATALEAP) DTSOpenTagResourceGroupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DTSOpenTagResourceGroupsCommonRequest(input)
	return out, req.Send()
}

// DTSOpenTagResourceGroupsCommonWithContext is the same as DTSOpenTagResourceGroupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DTSOpenTagResourceGroupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DATALEAP) DTSOpenTagResourceGroupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DTSOpenTagResourceGroupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDTSOpenTagResourceGroups = "DTSOpenTagResourceGroups"

// DTSOpenTagResourceGroupsRequest generates a "volcengine/request.Request" representing the
// client's request for the DTSOpenTagResourceGroups operation. The "output" return
// value will be populated with the DTSOpenTagResourceGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DTSOpenTagResourceGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DTSOpenTagResourceGroupsCommon Send returns without error.
//
// See DTSOpenTagResourceGroups for more information on using the DTSOpenTagResourceGroups
// API call, and error handling.
//
//    // Example sending a request using the DTSOpenTagResourceGroupsRequest method.
//    req, resp := client.DTSOpenTagResourceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DATALEAP) DTSOpenTagResourceGroupsRequest(input *DTSOpenTagResourceGroupsInput) (req *request.Request, output *DTSOpenTagResourceGroupsOutput) {
	op := &request.Operation{
		Name:       opDTSOpenTagResourceGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DTSOpenTagResourceGroupsInput{}
	}

	output = &DTSOpenTagResourceGroupsOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DTSOpenTagResourceGroups API operation for DATALEAP.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DATALEAP's
// API operation DTSOpenTagResourceGroups for usage and error information.
func (c *DATALEAP) DTSOpenTagResourceGroups(input *DTSOpenTagResourceGroupsInput) (*DTSOpenTagResourceGroupsOutput, error) {
	req, out := c.DTSOpenTagResourceGroupsRequest(input)
	return out, req.Send()
}

// DTSOpenTagResourceGroupsWithContext is the same as DTSOpenTagResourceGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DTSOpenTagResourceGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DATALEAP) DTSOpenTagResourceGroupsWithContext(ctx volcengine.Context, input *DTSOpenTagResourceGroupsInput, opts ...request.Option) (*DTSOpenTagResourceGroupsOutput, error) {
	req, out := c.DTSOpenTagResourceGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DTSOpenTagResourceGroupsInput struct {
	_ struct{} `type:"structure"`

	// ResourceIds is a required field
	ResourceIds []*string `type:"list" required:"true"`

	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`

	Tags []*TagForDTSOpenTagResourceGroupsInput `type:"list"`
}

// String returns the string representation
func (s DTSOpenTagResourceGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DTSOpenTagResourceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DTSOpenTagResourceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DTSOpenTagResourceGroupsInput"}
	if s.ResourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIds sets the ResourceIds field's value.
func (s *DTSOpenTagResourceGroupsInput) SetResourceIds(v []*string) *DTSOpenTagResourceGroupsInput {
	s.ResourceIds = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DTSOpenTagResourceGroupsInput) SetResourceType(v string) *DTSOpenTagResourceGroupsInput {
	s.ResourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DTSOpenTagResourceGroupsInput) SetTags(v []*TagForDTSOpenTagResourceGroupsInput) *DTSOpenTagResourceGroupsInput {
	s.Tags = v
	return s
}

type DTSOpenTagResourceGroupsOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s DTSOpenTagResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DTSOpenTagResourceGroupsOutput) GoString() string {
	return s.String()
}

type TagForDTSOpenTagResourceGroupsInput struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `type:"string" required:"true"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForDTSOpenTagResourceGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDTSOpenTagResourceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForDTSOpenTagResourceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForDTSOpenTagResourceGroupsInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForDTSOpenTagResourceGroupsInput) SetKey(v string) *TagForDTSOpenTagResourceGroupsInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDTSOpenTagResourceGroupsInput) SetValue(v string) *TagForDTSOpenTagResourceGroupsInput {
	s.Value = &v
	return s
}
