// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opSetUserCommon = "SetUser"

// SetUserCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the SetUserCommon operation. The "output" return
// value will be populated with the SetUserCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SetUserCommon Request to send the API call to the service.
// the "output" return value is not valid until after SetUserCommon Send returns without error.
//
// See SetUserCommon for more information on using the SetUserCommon
// API call, and error handling.
//
//    // Example sending a request using the SetUserCommonRequest method.
//    req, resp := client.SetUserCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) SetUserCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opSetUserCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SetUserCommon API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation SetUserCommon for usage and error information.
func (c *CR) SetUserCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.SetUserCommonRequest(input)
	return out, req.Send()
}

// SetUserCommonWithContext is the same as SetUserCommon with the addition of
// the ability to pass a context and additional request options.
//
// See SetUserCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) SetUserCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.SetUserCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetUser = "SetUser"

// SetUserRequest generates a "volcengine/request.Request" representing the
// client's request for the SetUser operation. The "output" return
// value will be populated with the SetUserCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SetUserCommon Request to send the API call to the service.
// the "output" return value is not valid until after SetUserCommon Send returns without error.
//
// See SetUser for more information on using the SetUser
// API call, and error handling.
//
//    // Example sending a request using the SetUserRequest method.
//    req, resp := client.SetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) SetUserRequest(input *SetUserInput) (req *request.Request, output *SetUserOutput) {
	op := &request.Operation{
		Name:       opSetUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserInput{}
	}

	output = &SetUserOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SetUser API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation SetUser for usage and error information.
func (c *CR) SetUser(input *SetUserInput) (*SetUserOutput, error) {
	req, out := c.SetUserRequest(input)
	return out, req.Send()
}

// SetUserWithContext is the same as SetUser with the addition of
// the ability to pass a context and additional request options.
//
// See SetUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) SetUserWithContext(ctx volcengine.Context, input *SetUserInput, opts ...request.Option) (*SetUserOutput, error) {
	req, out := c.SetUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type SetUserInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Password is a required field
	Password *string `type:"string" json:",omitempty" required:"true"`

	// Registry is a required field
	Registry *string `min:"3" max:"30" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s SetUserInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetUserInput"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Registry == nil {
		invalidParams.Add(request.NewErrParamRequired("Registry"))
	}
	if s.Registry != nil && len(*s.Registry) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Registry", 3))
	}
	if s.Registry != nil && len(*s.Registry) > 30 {
		invalidParams.Add(request.NewErrParamMaxLen("Registry", 30, *s.Registry))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *SetUserInput) SetPassword(v string) *SetUserInput {
	s.Password = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *SetUserInput) SetRegistry(v string) *SetUserInput {
	s.Registry = &v
	return s
}

type SetUserOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s SetUserOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserOutput) GoString() string {
	return s.String()
}
