// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cp

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRunPipelineCommon = "RunPipeline"

// RunPipelineCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RunPipelineCommon operation. The "output" return
// value will be populated with the RunPipelineCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RunPipelineCommon Request to send the API call to the service.
// the "output" return value is not valid until after RunPipelineCommon Send returns without error.
//
// See RunPipelineCommon for more information on using the RunPipelineCommon
// API call, and error handling.
//
//    // Example sending a request using the RunPipelineCommonRequest method.
//    req, resp := client.RunPipelineCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CP) RunPipelineCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRunPipelineCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RunPipelineCommon API operation for CP.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CP's
// API operation RunPipelineCommon for usage and error information.
func (c *CP) RunPipelineCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RunPipelineCommonRequest(input)
	return out, req.Send()
}

// RunPipelineCommonWithContext is the same as RunPipelineCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RunPipelineCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CP) RunPipelineCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RunPipelineCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRunPipeline = "RunPipeline"

// RunPipelineRequest generates a "volcengine/request.Request" representing the
// client's request for the RunPipeline operation. The "output" return
// value will be populated with the RunPipelineCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RunPipelineCommon Request to send the API call to the service.
// the "output" return value is not valid until after RunPipelineCommon Send returns without error.
//
// See RunPipeline for more information on using the RunPipeline
// API call, and error handling.
//
//    // Example sending a request using the RunPipelineRequest method.
//    req, resp := client.RunPipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CP) RunPipelineRequest(input *RunPipelineInput) (req *request.Request, output *RunPipelineOutput) {
	op := &request.Operation{
		Name:       opRunPipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunPipelineInput{}
	}

	output = &RunPipelineOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RunPipeline API operation for CP.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CP's
// API operation RunPipeline for usage and error information.
func (c *CP) RunPipeline(input *RunPipelineInput) (*RunPipelineOutput, error) {
	req, out := c.RunPipelineRequest(input)
	return out, req.Send()
}

// RunPipelineWithContext is the same as RunPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See RunPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CP) RunPipelineWithContext(ctx volcengine.Context, input *RunPipelineInput, opts ...request.Option) (*RunPipelineOutput, error) {
	req, out := c.RunPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ParameterForRunPipelineInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ParameterForRunPipelineInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterForRunPipelineInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ParameterForRunPipelineInput) SetKey(v string) *ParameterForRunPipelineInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ParameterForRunPipelineInput) SetValue(v string) *ParameterForRunPipelineInput {
	s.Value = &v
	return s
}

type ResourceForRunPipelineInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Reference *string `type:"string" json:",omitempty"`

	ResourceId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceForRunPipelineInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceForRunPipelineInput) GoString() string {
	return s.String()
}

// SetReference sets the Reference field's value.
func (s *ResourceForRunPipelineInput) SetReference(v string) *ResourceForRunPipelineInput {
	s.Reference = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceForRunPipelineInput) SetResourceId(v string) *ResourceForRunPipelineInput {
	s.ResourceId = &v
	return s
}

type RunPipelineInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`

	Parameters []*ParameterForRunPipelineInput `type:"list" json:",omitempty"`

	Resources []*ResourceForRunPipelineInput `type:"list" json:",omitempty"`

	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s RunPipelineInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RunPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunPipelineInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *RunPipelineInput) SetDescription(v string) *RunPipelineInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *RunPipelineInput) SetId(v string) *RunPipelineInput {
	s.Id = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *RunPipelineInput) SetParameters(v []*ParameterForRunPipelineInput) *RunPipelineInput {
	s.Parameters = v
	return s
}

// SetResources sets the Resources field's value.
func (s *RunPipelineInput) SetResources(v []*ResourceForRunPipelineInput) *RunPipelineInput {
	s.Resources = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RunPipelineInput) SetWorkspaceId(v string) *RunPipelineInput {
	s.WorkspaceId = &v
	return s
}

type RunPipelineOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RunPipelineOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RunPipelineOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *RunPipelineOutput) SetId(v string) *RunPipelineOutput {
	s.Id = &v
	return s
}
