// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package clb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateAclCommon = "CreateAcl"

// CreateAclCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateAclCommon operation. The "output" return
// value will be populated with the CreateAclCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateAclCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateAclCommon Send returns without error.
//
// See CreateAclCommon for more information on using the CreateAclCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateAclCommonRequest method.
//    req, resp := client.CreateAclCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLB) CreateAclCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateAclCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateAclCommon API operation for CLB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLB's
// API operation CreateAclCommon for usage and error information.
func (c *CLB) CreateAclCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateAclCommonRequest(input)
	return out, req.Send()
}

// CreateAclCommonWithContext is the same as CreateAclCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAclCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLB) CreateAclCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateAclCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAcl = "CreateAcl"

// CreateAclRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateAcl operation. The "output" return
// value will be populated with the CreateAclCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateAclCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateAclCommon Send returns without error.
//
// See CreateAcl for more information on using the CreateAcl
// API call, and error handling.
//
//    // Example sending a request using the CreateAclRequest method.
//    req, resp := client.CreateAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLB) CreateAclRequest(input *CreateAclInput) (req *request.Request, output *CreateAclOutput) {
	op := &request.Operation{
		Name:       opCreateAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAclInput{}
	}

	output = &CreateAclOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateAcl API operation for CLB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLB's
// API operation CreateAcl for usage and error information.
func (c *CLB) CreateAcl(input *CreateAclInput) (*CreateAclOutput, error) {
	req, out := c.CreateAclRequest(input)
	return out, req.Send()
}

// CreateAclWithContext is the same as CreateAcl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLB) CreateAclWithContext(ctx volcengine.Context, input *CreateAclInput, opts ...request.Option) (*CreateAclOutput, error) {
	req, out := c.CreateAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateAclInput struct {
	_ struct{} `type:"structure"`

	AclName *string `min:"2" max:"255" type:"string"`

	Description *string `type:"string"`

	ProjectName *string `type:"string"`

	Tags []*TagForCreateAclInput `type:"list"`
}

// String returns the string representation
func (s CreateAclInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAclInput"}
	if s.AclName != nil && len(*s.AclName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("AclName", 2))
	}
	if s.AclName != nil && len(*s.AclName) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("AclName", 255, *s.AclName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAclName sets the AclName field's value.
func (s *CreateAclInput) SetAclName(v string) *CreateAclInput {
	s.AclName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAclInput) SetDescription(v string) *CreateAclInput {
	s.Description = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateAclInput) SetProjectName(v string) *CreateAclInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAclInput) SetTags(v []*TagForCreateAclInput) *CreateAclInput {
	s.Tags = v
	return s
}

type CreateAclOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	AclId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CreateAclOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAclOutput) GoString() string {
	return s.String()
}

// SetAclId sets the AclId field's value.
func (s *CreateAclOutput) SetAclId(v string) *CreateAclOutput {
	s.AclId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateAclOutput) SetRequestId(v string) *CreateAclOutput {
	s.RequestId = &v
	return s
}

type TagForCreateAclInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateAclInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateAclInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateAclInput) SetKey(v string) *TagForCreateAclInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateAclInput) SetValue(v string) *TagForCreateAclInput {
	s.Value = &v
	return s
}
