// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateUsageReportCommon = "CreateUsageReport"

// CreateUsageReportCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateUsageReportCommon operation. The "output" return
// value will be populated with the CreateUsageReportCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateUsageReportCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateUsageReportCommon Send returns without error.
//
// See CreateUsageReportCommon for more information on using the CreateUsageReportCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateUsageReportCommonRequest method.
//    req, resp := client.CreateUsageReportCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) CreateUsageReportCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateUsageReportCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateUsageReportCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation CreateUsageReportCommon for usage and error information.
func (c *CDN) CreateUsageReportCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateUsageReportCommonRequest(input)
	return out, req.Send()
}

// CreateUsageReportCommonWithContext is the same as CreateUsageReportCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUsageReportCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) CreateUsageReportCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateUsageReportCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUsageReport = "CreateUsageReport"

// CreateUsageReportRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateUsageReport operation. The "output" return
// value will be populated with the CreateUsageReportCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateUsageReportCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateUsageReportCommon Send returns without error.
//
// See CreateUsageReport for more information on using the CreateUsageReport
// API call, and error handling.
//
//    // Example sending a request using the CreateUsageReportRequest method.
//    req, resp := client.CreateUsageReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) CreateUsageReportRequest(input *CreateUsageReportInput) (req *request.Request, output *CreateUsageReportOutput) {
	op := &request.Operation{
		Name:       opCreateUsageReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUsageReportInput{}
	}

	output = &CreateUsageReportOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateUsageReport API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation CreateUsageReport for usage and error information.
func (c *CDN) CreateUsageReport(input *CreateUsageReportInput) (*CreateUsageReportOutput, error) {
	req, out := c.CreateUsageReportRequest(input)
	return out, req.Send()
}

// CreateUsageReportWithContext is the same as CreateUsageReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUsageReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) CreateUsageReportWithContext(ctx volcengine.Context, input *CreateUsageReportInput, opts ...request.Option) (*CreateUsageReportOutput, error) {
	req, out := c.CreateUsageReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateUsageReportInput struct {
	_ struct{} `type:"structure"`

	Aggregate *string `type:"string"`

	BillingCode *string `type:"string"`

	// BillingRegion is a required field
	BillingRegion *string `type:"string" required:"true"`

	CalculationMethod *string `type:"string"`

	Domain *string `type:"string"`

	// EndTime is a required field
	EndTime *int64 `type:"int64" required:"true"`

	// ExportType is a required field
	ExportType *string `type:"string" required:"true"`

	FreeTimeTrafficCompute *bool `type:"boolean"`

	Metric *string `type:"string"`

	// StartTime is a required field
	StartTime *int64 `type:"int64" required:"true"`

	// TaskName is a required field
	TaskName *string `type:"string" required:"true"`

	TimeZone *string `type:"string"`

	TlsTopic *string `type:"string"`
}

// String returns the string representation
func (s CreateUsageReportInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUsageReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUsageReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUsageReportInput"}
	if s.BillingRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("BillingRegion"))
	}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.ExportType == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportType"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.TaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregate sets the Aggregate field's value.
func (s *CreateUsageReportInput) SetAggregate(v string) *CreateUsageReportInput {
	s.Aggregate = &v
	return s
}

// SetBillingCode sets the BillingCode field's value.
func (s *CreateUsageReportInput) SetBillingCode(v string) *CreateUsageReportInput {
	s.BillingCode = &v
	return s
}

// SetBillingRegion sets the BillingRegion field's value.
func (s *CreateUsageReportInput) SetBillingRegion(v string) *CreateUsageReportInput {
	s.BillingRegion = &v
	return s
}

// SetCalculationMethod sets the CalculationMethod field's value.
func (s *CreateUsageReportInput) SetCalculationMethod(v string) *CreateUsageReportInput {
	s.CalculationMethod = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateUsageReportInput) SetDomain(v string) *CreateUsageReportInput {
	s.Domain = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CreateUsageReportInput) SetEndTime(v int64) *CreateUsageReportInput {
	s.EndTime = &v
	return s
}

// SetExportType sets the ExportType field's value.
func (s *CreateUsageReportInput) SetExportType(v string) *CreateUsageReportInput {
	s.ExportType = &v
	return s
}

// SetFreeTimeTrafficCompute sets the FreeTimeTrafficCompute field's value.
func (s *CreateUsageReportInput) SetFreeTimeTrafficCompute(v bool) *CreateUsageReportInput {
	s.FreeTimeTrafficCompute = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *CreateUsageReportInput) SetMetric(v string) *CreateUsageReportInput {
	s.Metric = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateUsageReportInput) SetStartTime(v int64) *CreateUsageReportInput {
	s.StartTime = &v
	return s
}

// SetTaskName sets the TaskName field's value.
func (s *CreateUsageReportInput) SetTaskName(v string) *CreateUsageReportInput {
	s.TaskName = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *CreateUsageReportInput) SetTimeZone(v string) *CreateUsageReportInput {
	s.TimeZone = &v
	return s
}

// SetTlsTopic sets the TlsTopic field's value.
func (s *CreateUsageReportInput) SetTlsTopic(v string) *CreateUsageReportInput {
	s.TlsTopic = &v
	return s
}

type CreateUsageReportOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	TaskId *string `type:"string"`
}

// String returns the string representation
func (s CreateUsageReportOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUsageReportOutput) GoString() string {
	return s.String()
}

// SetTaskId sets the TaskId field's value.
func (s *CreateUsageReportOutput) SetTaskId(v string) *CreateUsageReportOutput {
	s.TaskId = &v
	return s
}
