// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opBatchUpdateCdnConfigCommon = "BatchUpdateCdnConfig"

// BatchUpdateCdnConfigCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the BatchUpdateCdnConfigCommon operation. The "output" return
// value will be populated with the BatchUpdateCdnConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BatchUpdateCdnConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after BatchUpdateCdnConfigCommon Send returns without error.
//
// See BatchUpdateCdnConfigCommon for more information on using the BatchUpdateCdnConfigCommon
// API call, and error handling.
//
//    // Example sending a request using the BatchUpdateCdnConfigCommonRequest method.
//    req, resp := client.BatchUpdateCdnConfigCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) BatchUpdateCdnConfigCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opBatchUpdateCdnConfigCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BatchUpdateCdnConfigCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation BatchUpdateCdnConfigCommon for usage and error information.
func (c *CDN) BatchUpdateCdnConfigCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.BatchUpdateCdnConfigCommonRequest(input)
	return out, req.Send()
}

// BatchUpdateCdnConfigCommonWithContext is the same as BatchUpdateCdnConfigCommon with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateCdnConfigCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) BatchUpdateCdnConfigCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.BatchUpdateCdnConfigCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateCdnConfig = "BatchUpdateCdnConfig"

// BatchUpdateCdnConfigRequest generates a "volcengine/request.Request" representing the
// client's request for the BatchUpdateCdnConfig operation. The "output" return
// value will be populated with the BatchUpdateCdnConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BatchUpdateCdnConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after BatchUpdateCdnConfigCommon Send returns without error.
//
// See BatchUpdateCdnConfig for more information on using the BatchUpdateCdnConfig
// API call, and error handling.
//
//    // Example sending a request using the BatchUpdateCdnConfigRequest method.
//    req, resp := client.BatchUpdateCdnConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) BatchUpdateCdnConfigRequest(input *BatchUpdateCdnConfigInput) (req *request.Request, output *BatchUpdateCdnConfigOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateCdnConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchUpdateCdnConfigInput{}
	}

	output = &BatchUpdateCdnConfigOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BatchUpdateCdnConfig API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation BatchUpdateCdnConfig for usage and error information.
func (c *CDN) BatchUpdateCdnConfig(input *BatchUpdateCdnConfigInput) (*BatchUpdateCdnConfigOutput, error) {
	req, out := c.BatchUpdateCdnConfigRequest(input)
	return out, req.Send()
}

// BatchUpdateCdnConfigWithContext is the same as BatchUpdateCdnConfig with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateCdnConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) BatchUpdateCdnConfigWithContext(ctx volcengine.Context, input *BatchUpdateCdnConfigInput, opts ...request.Option) (*BatchUpdateCdnConfigOutput, error) {
	req, out := c.BatchUpdateCdnConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	ListRules []*string `type:"list"`

	RequestHeader *string `type:"string"`

	RuleType *string `type:"string"`
}

// String returns the string representation
func (s AccessActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *AccessActionForBatchUpdateCdnConfigInput) SetAllowEmpty(v bool) *AccessActionForBatchUpdateCdnConfigInput {
	s.AllowEmpty = &v
	return s
}

// SetListRules sets the ListRules field's value.
func (s *AccessActionForBatchUpdateCdnConfigInput) SetListRules(v []*string) *AccessActionForBatchUpdateCdnConfigInput {
	s.ListRules = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *AccessActionForBatchUpdateCdnConfigInput) SetRequestHeader(v string) *AccessActionForBatchUpdateCdnConfigInput {
	s.RequestHeader = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *AccessActionForBatchUpdateCdnConfigInput) SetRuleType(v string) *AccessActionForBatchUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

type ActionsForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginLines []*OriginLineForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s ActionsForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionsForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginLines sets the OriginLines field's value.
func (s *ActionsForBatchUpdateCdnConfigInput) SetOriginLines(v []*OriginLineForBatchUpdateCdnConfigInput) *ActionsForBatchUpdateCdnConfigInput {
	s.OriginLines = v
	return s
}

type AreaAccessRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Area []*string `type:"list"`

	RuleType *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s AreaAccessRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AreaAccessRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetArea sets the Area field's value.
func (s *AreaAccessRuleForBatchUpdateCdnConfigInput) SetArea(v []*string) *AreaAccessRuleForBatchUpdateCdnConfigInput {
	s.Area = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *AreaAccessRuleForBatchUpdateCdnConfigInput) SetRuleType(v string) *AreaAccessRuleForBatchUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *AreaAccessRuleForBatchUpdateCdnConfigInput) SetSwitch(v bool) *AreaAccessRuleForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type AuthModeConfigForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BackupRemoteAddr *string `type:"string"`

	MasterRemoteAddr *string `type:"string"`

	PathType *string `type:"string"`

	PathValue *string `type:"string"`

	RequestMethod *string `type:"string"`
}

// String returns the string representation
func (s AuthModeConfigForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthModeConfigForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBackupRemoteAddr sets the BackupRemoteAddr field's value.
func (s *AuthModeConfigForBatchUpdateCdnConfigInput) SetBackupRemoteAddr(v string) *AuthModeConfigForBatchUpdateCdnConfigInput {
	s.BackupRemoteAddr = &v
	return s
}

// SetMasterRemoteAddr sets the MasterRemoteAddr field's value.
func (s *AuthModeConfigForBatchUpdateCdnConfigInput) SetMasterRemoteAddr(v string) *AuthModeConfigForBatchUpdateCdnConfigInput {
	s.MasterRemoteAddr = &v
	return s
}

// SetPathType sets the PathType field's value.
func (s *AuthModeConfigForBatchUpdateCdnConfigInput) SetPathType(v string) *AuthModeConfigForBatchUpdateCdnConfigInput {
	s.PathType = &v
	return s
}

// SetPathValue sets the PathValue field's value.
func (s *AuthModeConfigForBatchUpdateCdnConfigInput) SetPathValue(v string) *AuthModeConfigForBatchUpdateCdnConfigInput {
	s.PathValue = &v
	return s
}

// SetRequestMethod sets the RequestMethod field's value.
func (s *AuthModeConfigForBatchUpdateCdnConfigInput) SetRequestMethod(v string) *AuthModeConfigForBatchUpdateCdnConfigInput {
	s.RequestMethod = &v
	return s
}

type AuthResponseConfigForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheAction *ConvertCacheActionForBatchUpdateCdnConfigInput `type:"structure"`

	ResponseAction *ResponseActionForBatchUpdateCdnConfigInput `type:"structure"`

	StatusCodeAction *StatusCodeActionForBatchUpdateCdnConfigInput `type:"structure"`

	TimeOutAction *TimeOutActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s AuthResponseConfigForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthResponseConfigForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *AuthResponseConfigForBatchUpdateCdnConfigInput) SetCacheAction(v *ConvertCacheActionForBatchUpdateCdnConfigInput) *AuthResponseConfigForBatchUpdateCdnConfigInput {
	s.CacheAction = v
	return s
}

// SetResponseAction sets the ResponseAction field's value.
func (s *AuthResponseConfigForBatchUpdateCdnConfigInput) SetResponseAction(v *ResponseActionForBatchUpdateCdnConfigInput) *AuthResponseConfigForBatchUpdateCdnConfigInput {
	s.ResponseAction = v
	return s
}

// SetStatusCodeAction sets the StatusCodeAction field's value.
func (s *AuthResponseConfigForBatchUpdateCdnConfigInput) SetStatusCodeAction(v *StatusCodeActionForBatchUpdateCdnConfigInput) *AuthResponseConfigForBatchUpdateCdnConfigInput {
	s.StatusCodeAction = v
	return s
}

// SetTimeOutAction sets the TimeOutAction field's value.
func (s *AuthResponseConfigForBatchUpdateCdnConfigInput) SetTimeOutAction(v *TimeOutActionForBatchUpdateCdnConfigInput) *AuthResponseConfigForBatchUpdateCdnConfigInput {
	s.TimeOutAction = v
	return s
}

type BandwidthLimitActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BandwidthThreshold *int64 `type:"int64"`

	LimitType *string `type:"string"`

	SpeedLimitRate *int64 `type:"int64"`

	SpeedLimitRateMax *int64 `type:"int64"`
}

// String returns the string representation
func (s BandwidthLimitActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBandwidthThreshold sets the BandwidthThreshold field's value.
func (s *BandwidthLimitActionForBatchUpdateCdnConfigInput) SetBandwidthThreshold(v int64) *BandwidthLimitActionForBatchUpdateCdnConfigInput {
	s.BandwidthThreshold = &v
	return s
}

// SetLimitType sets the LimitType field's value.
func (s *BandwidthLimitActionForBatchUpdateCdnConfigInput) SetLimitType(v string) *BandwidthLimitActionForBatchUpdateCdnConfigInput {
	s.LimitType = &v
	return s
}

// SetSpeedLimitRate sets the SpeedLimitRate field's value.
func (s *BandwidthLimitActionForBatchUpdateCdnConfigInput) SetSpeedLimitRate(v int64) *BandwidthLimitActionForBatchUpdateCdnConfigInput {
	s.SpeedLimitRate = &v
	return s
}

// SetSpeedLimitRateMax sets the SpeedLimitRateMax field's value.
func (s *BandwidthLimitActionForBatchUpdateCdnConfigInput) SetSpeedLimitRateMax(v int64) *BandwidthLimitActionForBatchUpdateCdnConfigInput {
	s.SpeedLimitRateMax = &v
	return s
}

type BandwidthLimitForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BandwidthLimitRule *BandwidthLimitRuleForBatchUpdateCdnConfigInput `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s BandwidthLimitForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBandwidthLimitRule sets the BandwidthLimitRule field's value.
func (s *BandwidthLimitForBatchUpdateCdnConfigInput) SetBandwidthLimitRule(v *BandwidthLimitRuleForBatchUpdateCdnConfigInput) *BandwidthLimitForBatchUpdateCdnConfigInput {
	s.BandwidthLimitRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *BandwidthLimitForBatchUpdateCdnConfigInput) SetSwitch(v bool) *BandwidthLimitForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type BandwidthLimitRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BandwidthLimitAction *BandwidthLimitActionForBatchUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s BandwidthLimitRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBandwidthLimitAction sets the BandwidthLimitAction field's value.
func (s *BandwidthLimitRuleForBatchUpdateCdnConfigInput) SetBandwidthLimitAction(v *BandwidthLimitActionForBatchUpdateCdnConfigInput) *BandwidthLimitRuleForBatchUpdateCdnConfigInput {
	s.BandwidthLimitAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BandwidthLimitRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *BandwidthLimitRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type BatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Aggregate *bool `type:"boolean"`

	AreaAccessRule *AreaAccessRuleForBatchUpdateCdnConfigInput `type:"structure"`

	BandwidthLimit *BandwidthLimitForBatchUpdateCdnConfigInput `type:"structure"`

	BrowserCache []*BrowserCacheForBatchUpdateCdnConfigInput `type:"list"`

	Cache []*CacheForBatchUpdateCdnConfigInput `type:"list"`

	CacheHost *CacheHostForBatchUpdateCdnConfigInput `type:"structure"`

	CacheKey []*CacheKeyForBatchUpdateCdnConfigInput `type:"list"`

	Compression *CompressionForBatchUpdateCdnConfigInput `type:"structure"`

	ConditionalOrigin *ConditionalOriginForBatchUpdateCdnConfigInput `type:"structure"`

	CustomErrorPage *CustomErrorPageForBatchUpdateCdnConfigInput `type:"structure"`

	CustomizeAccessRule *CustomizeAccessRuleForBatchUpdateCdnConfigInput `type:"structure"`

	Domains []*string `type:"list"`

	DownloadSpeedLimit *DownloadSpeedLimitForBatchUpdateCdnConfigInput `type:"structure"`

	FollowRedirect *bool `type:"boolean"`

	HTTPS *HTTPSForBatchUpdateCdnConfigInput `type:"structure"`

	HttpForcedRedirect *HttpForcedRedirectForBatchUpdateCdnConfigInput `type:"structure"`

	IPv6 *IPv6ForBatchUpdateCdnConfigInput `type:"structure"`

	IpAccessRule *IpAccessRuleForBatchUpdateCdnConfigInput `type:"structure"`

	IpFreqLimit *IpFreqLimitForBatchUpdateCdnConfigInput `type:"structure"`

	MethodDeniedRule *MethodDeniedRuleForBatchUpdateCdnConfigInput `type:"structure"`

	MultiRange *MultiRangeForBatchUpdateCdnConfigInput `type:"structure"`

	NegativeCache []*NegativeCacheForBatchUpdateCdnConfigInput `type:"list"`

	Origin []*OriginForBatchUpdateCdnConfigInput `type:"list"`

	OriginAccessRule *OriginAccessRuleForBatchUpdateCdnConfigInput `type:"structure"`

	OriginArg []*OriginArgForBatchUpdateCdnConfigInput `type:"list"`

	OriginCertCheck *OriginCertCheckForBatchUpdateCdnConfigInput `type:"structure"`

	OriginHost *string `type:"string"`

	OriginIPv6 *string `type:"string"`

	OriginProtocol *string `type:"string"`

	OriginRange *bool `type:"boolean"`

	OriginRetry *OriginRetryForBatchUpdateCdnConfigInput `type:"structure"`

	OriginRewrite *OriginRewriteForBatchUpdateCdnConfigInput `type:"structure"`

	OriginSni *OriginSniForBatchUpdateCdnConfigInput `type:"structure"`

	PageOptimization *PageOptimizationForBatchUpdateCdnConfigInput `type:"structure"`

	Quic *QuicForBatchUpdateCdnConfigInput `type:"structure"`

	RedirectionRewrite *RedirectionRewriteForBatchUpdateCdnConfigInput `type:"structure"`

	RefererAccessRule *RefererAccessRuleForBatchUpdateCdnConfigInput `type:"structure"`

	RemoteAuth *RemoteAuthForBatchUpdateCdnConfigInput `type:"structure"`

	RequestBlockRule *RequestBlockRuleForBatchUpdateCdnConfigInput `type:"structure"`

	RequestHeader []*RequestHeaderForBatchUpdateCdnConfigInput `type:"list"`

	ResponseHeader []*ResponseHeaderForBatchUpdateCdnConfigInput `type:"list"`

	RewriteHLS *RewriteHLSForBatchUpdateCdnConfigInput `type:"structure"`

	ServiceRegion *string `type:"string"`

	SignedUrlAuth *SignedUrlAuthForBatchUpdateCdnConfigInput `type:"structure"`

	Timeout *TimeoutForBatchUpdateCdnConfigInput `type:"structure"`

	UaAccessRule *UaAccessRuleForBatchUpdateCdnConfigInput `type:"structure"`

	UrlNormalize *UrlNormalizeForBatchUpdateCdnConfigInput `type:"structure"`

	VideoDrag *VideoDragForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s BatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAggregate sets the Aggregate field's value.
func (s *BatchUpdateCdnConfigInput) SetAggregate(v bool) *BatchUpdateCdnConfigInput {
	s.Aggregate = &v
	return s
}

// SetAreaAccessRule sets the AreaAccessRule field's value.
func (s *BatchUpdateCdnConfigInput) SetAreaAccessRule(v *AreaAccessRuleForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.AreaAccessRule = v
	return s
}

// SetBandwidthLimit sets the BandwidthLimit field's value.
func (s *BatchUpdateCdnConfigInput) SetBandwidthLimit(v *BandwidthLimitForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.BandwidthLimit = v
	return s
}

// SetBrowserCache sets the BrowserCache field's value.
func (s *BatchUpdateCdnConfigInput) SetBrowserCache(v []*BrowserCacheForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.BrowserCache = v
	return s
}

// SetCache sets the Cache field's value.
func (s *BatchUpdateCdnConfigInput) SetCache(v []*CacheForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.Cache = v
	return s
}

// SetCacheHost sets the CacheHost field's value.
func (s *BatchUpdateCdnConfigInput) SetCacheHost(v *CacheHostForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.CacheHost = v
	return s
}

// SetCacheKey sets the CacheKey field's value.
func (s *BatchUpdateCdnConfigInput) SetCacheKey(v []*CacheKeyForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.CacheKey = v
	return s
}

// SetCompression sets the Compression field's value.
func (s *BatchUpdateCdnConfigInput) SetCompression(v *CompressionForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.Compression = v
	return s
}

// SetConditionalOrigin sets the ConditionalOrigin field's value.
func (s *BatchUpdateCdnConfigInput) SetConditionalOrigin(v *ConditionalOriginForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.ConditionalOrigin = v
	return s
}

// SetCustomErrorPage sets the CustomErrorPage field's value.
func (s *BatchUpdateCdnConfigInput) SetCustomErrorPage(v *CustomErrorPageForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.CustomErrorPage = v
	return s
}

// SetCustomizeAccessRule sets the CustomizeAccessRule field's value.
func (s *BatchUpdateCdnConfigInput) SetCustomizeAccessRule(v *CustomizeAccessRuleForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.CustomizeAccessRule = v
	return s
}

// SetDomains sets the Domains field's value.
func (s *BatchUpdateCdnConfigInput) SetDomains(v []*string) *BatchUpdateCdnConfigInput {
	s.Domains = v
	return s
}

// SetDownloadSpeedLimit sets the DownloadSpeedLimit field's value.
func (s *BatchUpdateCdnConfigInput) SetDownloadSpeedLimit(v *DownloadSpeedLimitForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.DownloadSpeedLimit = v
	return s
}

// SetFollowRedirect sets the FollowRedirect field's value.
func (s *BatchUpdateCdnConfigInput) SetFollowRedirect(v bool) *BatchUpdateCdnConfigInput {
	s.FollowRedirect = &v
	return s
}

// SetHTTPS sets the HTTPS field's value.
func (s *BatchUpdateCdnConfigInput) SetHTTPS(v *HTTPSForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.HTTPS = v
	return s
}

// SetHttpForcedRedirect sets the HttpForcedRedirect field's value.
func (s *BatchUpdateCdnConfigInput) SetHttpForcedRedirect(v *HttpForcedRedirectForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.HttpForcedRedirect = v
	return s
}

// SetIPv6 sets the IPv6 field's value.
func (s *BatchUpdateCdnConfigInput) SetIPv6(v *IPv6ForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.IPv6 = v
	return s
}

// SetIpAccessRule sets the IpAccessRule field's value.
func (s *BatchUpdateCdnConfigInput) SetIpAccessRule(v *IpAccessRuleForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.IpAccessRule = v
	return s
}

// SetIpFreqLimit sets the IpFreqLimit field's value.
func (s *BatchUpdateCdnConfigInput) SetIpFreqLimit(v *IpFreqLimitForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.IpFreqLimit = v
	return s
}

// SetMethodDeniedRule sets the MethodDeniedRule field's value.
func (s *BatchUpdateCdnConfigInput) SetMethodDeniedRule(v *MethodDeniedRuleForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.MethodDeniedRule = v
	return s
}

// SetMultiRange sets the MultiRange field's value.
func (s *BatchUpdateCdnConfigInput) SetMultiRange(v *MultiRangeForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.MultiRange = v
	return s
}

// SetNegativeCache sets the NegativeCache field's value.
func (s *BatchUpdateCdnConfigInput) SetNegativeCache(v []*NegativeCacheForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.NegativeCache = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *BatchUpdateCdnConfigInput) SetOrigin(v []*OriginForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.Origin = v
	return s
}

// SetOriginAccessRule sets the OriginAccessRule field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginAccessRule(v *OriginAccessRuleForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.OriginAccessRule = v
	return s
}

// SetOriginArg sets the OriginArg field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginArg(v []*OriginArgForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.OriginArg = v
	return s
}

// SetOriginCertCheck sets the OriginCertCheck field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginCertCheck(v *OriginCertCheckForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.OriginCertCheck = v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginHost(v string) *BatchUpdateCdnConfigInput {
	s.OriginHost = &v
	return s
}

// SetOriginIPv6 sets the OriginIPv6 field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginIPv6(v string) *BatchUpdateCdnConfigInput {
	s.OriginIPv6 = &v
	return s
}

// SetOriginProtocol sets the OriginProtocol field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginProtocol(v string) *BatchUpdateCdnConfigInput {
	s.OriginProtocol = &v
	return s
}

// SetOriginRange sets the OriginRange field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginRange(v bool) *BatchUpdateCdnConfigInput {
	s.OriginRange = &v
	return s
}

// SetOriginRetry sets the OriginRetry field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginRetry(v *OriginRetryForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.OriginRetry = v
	return s
}

// SetOriginRewrite sets the OriginRewrite field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginRewrite(v *OriginRewriteForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.OriginRewrite = v
	return s
}

// SetOriginSni sets the OriginSni field's value.
func (s *BatchUpdateCdnConfigInput) SetOriginSni(v *OriginSniForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.OriginSni = v
	return s
}

// SetPageOptimization sets the PageOptimization field's value.
func (s *BatchUpdateCdnConfigInput) SetPageOptimization(v *PageOptimizationForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.PageOptimization = v
	return s
}

// SetQuic sets the Quic field's value.
func (s *BatchUpdateCdnConfigInput) SetQuic(v *QuicForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.Quic = v
	return s
}

// SetRedirectionRewrite sets the RedirectionRewrite field's value.
func (s *BatchUpdateCdnConfigInput) SetRedirectionRewrite(v *RedirectionRewriteForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.RedirectionRewrite = v
	return s
}

// SetRefererAccessRule sets the RefererAccessRule field's value.
func (s *BatchUpdateCdnConfigInput) SetRefererAccessRule(v *RefererAccessRuleForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.RefererAccessRule = v
	return s
}

// SetRemoteAuth sets the RemoteAuth field's value.
func (s *BatchUpdateCdnConfigInput) SetRemoteAuth(v *RemoteAuthForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.RemoteAuth = v
	return s
}

// SetRequestBlockRule sets the RequestBlockRule field's value.
func (s *BatchUpdateCdnConfigInput) SetRequestBlockRule(v *RequestBlockRuleForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.RequestBlockRule = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *BatchUpdateCdnConfigInput) SetRequestHeader(v []*RequestHeaderForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.RequestHeader = v
	return s
}

// SetResponseHeader sets the ResponseHeader field's value.
func (s *BatchUpdateCdnConfigInput) SetResponseHeader(v []*ResponseHeaderForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.ResponseHeader = v
	return s
}

// SetRewriteHLS sets the RewriteHLS field's value.
func (s *BatchUpdateCdnConfigInput) SetRewriteHLS(v *RewriteHLSForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.RewriteHLS = v
	return s
}

// SetServiceRegion sets the ServiceRegion field's value.
func (s *BatchUpdateCdnConfigInput) SetServiceRegion(v string) *BatchUpdateCdnConfigInput {
	s.ServiceRegion = &v
	return s
}

// SetSignedUrlAuth sets the SignedUrlAuth field's value.
func (s *BatchUpdateCdnConfigInput) SetSignedUrlAuth(v *SignedUrlAuthForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.SignedUrlAuth = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *BatchUpdateCdnConfigInput) SetTimeout(v *TimeoutForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.Timeout = v
	return s
}

// SetUaAccessRule sets the UaAccessRule field's value.
func (s *BatchUpdateCdnConfigInput) SetUaAccessRule(v *UaAccessRuleForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.UaAccessRule = v
	return s
}

// SetUrlNormalize sets the UrlNormalize field's value.
func (s *BatchUpdateCdnConfigInput) SetUrlNormalize(v *UrlNormalizeForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.UrlNormalize = v
	return s
}

// SetVideoDrag sets the VideoDrag field's value.
func (s *BatchUpdateCdnConfigInput) SetVideoDrag(v *VideoDragForBatchUpdateCdnConfigInput) *BatchUpdateCdnConfigInput {
	s.VideoDrag = v
	return s
}

type BatchUpdateCdnConfigOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	DeployResult []*DeployResultForBatchUpdateCdnConfigOutput `type:"list"`
}

// String returns the string representation
func (s BatchUpdateCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateCdnConfigOutput) GoString() string {
	return s.String()
}

// SetDeployResult sets the DeployResult field's value.
func (s *BatchUpdateCdnConfigOutput) SetDeployResult(v []*DeployResultForBatchUpdateCdnConfigOutput) *BatchUpdateCdnConfigOutput {
	s.DeployResult = v
	return s
}

type BlockActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	ErrorPage *string `type:"string"`

	RedirectUrl *string `type:"string"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s BlockActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *BlockActionForBatchUpdateCdnConfigInput) SetAction(v string) *BlockActionForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetErrorPage sets the ErrorPage field's value.
func (s *BlockActionForBatchUpdateCdnConfigInput) SetErrorPage(v string) *BlockActionForBatchUpdateCdnConfigInput {
	s.ErrorPage = &v
	return s
}

// SetRedirectUrl sets the RedirectUrl field's value.
func (s *BlockActionForBatchUpdateCdnConfigInput) SetRedirectUrl(v string) *BlockActionForBatchUpdateCdnConfigInput {
	s.RedirectUrl = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *BlockActionForBatchUpdateCdnConfigInput) SetStatusCode(v string) *BlockActionForBatchUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type BlockRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BlockAction *BlockActionForBatchUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	RuleName *string `type:"string"`
}

// String returns the string representation
func (s BlockRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBlockAction sets the BlockAction field's value.
func (s *BlockRuleForBatchUpdateCdnConfigInput) SetBlockAction(v *BlockActionForBatchUpdateCdnConfigInput) *BlockRuleForBatchUpdateCdnConfigInput {
	s.BlockAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BlockRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *BlockRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *BlockRuleForBatchUpdateCdnConfigInput) SetRuleName(v string) *BlockRuleForBatchUpdateCdnConfigInput {
	s.RuleName = &v
	return s
}

type BrowserCacheForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheAction *CacheActionForBatchUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s BrowserCacheForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BrowserCacheForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *BrowserCacheForBatchUpdateCdnConfigInput) SetCacheAction(v *CacheActionForBatchUpdateCdnConfigInput) *BrowserCacheForBatchUpdateCdnConfigInput {
	s.CacheAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BrowserCacheForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *BrowserCacheForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type CacheActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	DefaultPolicy *string `type:"string"`

	IgnoreCase *bool `type:"boolean"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s CacheActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CacheActionForBatchUpdateCdnConfigInput) SetAction(v string) *CacheActionForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetDefaultPolicy sets the DefaultPolicy field's value.
func (s *CacheActionForBatchUpdateCdnConfigInput) SetDefaultPolicy(v string) *CacheActionForBatchUpdateCdnConfigInput {
	s.DefaultPolicy = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheActionForBatchUpdateCdnConfigInput) SetIgnoreCase(v bool) *CacheActionForBatchUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *CacheActionForBatchUpdateCdnConfigInput) SetTtl(v int64) *CacheActionForBatchUpdateCdnConfigInput {
	s.Ttl = &v
	return s
}

type CacheForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheAction *CacheActionForBatchUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CacheForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *CacheForBatchUpdateCdnConfigInput) SetCacheAction(v *CacheActionForBatchUpdateCdnConfigInput) *CacheForBatchUpdateCdnConfigInput {
	s.CacheAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *CacheForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type CacheHostActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheHost *string `type:"string"`
}

// String returns the string representation
func (s CacheHostActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheHost sets the CacheHost field's value.
func (s *CacheHostActionForBatchUpdateCdnConfigInput) SetCacheHost(v string) *CacheHostActionForBatchUpdateCdnConfigInput {
	s.CacheHost = &v
	return s
}

type CacheHostForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheHostRule []*CacheHostRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CacheHostForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheHostRule sets the CacheHostRule field's value.
func (s *CacheHostForBatchUpdateCdnConfigInput) SetCacheHostRule(v []*CacheHostRuleForBatchUpdateCdnConfigInput) *CacheHostForBatchUpdateCdnConfigInput {
	s.CacheHostRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CacheHostForBatchUpdateCdnConfigInput) SetSwitch(v bool) *CacheHostForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CacheHostRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheHostAction *CacheHostActionForBatchUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CacheHostRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheHostAction sets the CacheHostAction field's value.
func (s *CacheHostRuleForBatchUpdateCdnConfigInput) SetCacheHostAction(v *CacheHostActionForBatchUpdateCdnConfigInput) *CacheHostRuleForBatchUpdateCdnConfigInput {
	s.CacheHostAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheHostRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *CacheHostRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type CacheKeyActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheKeyComponents []*CacheKeyComponentForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s CacheKeyActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheKeyComponents sets the CacheKeyComponents field's value.
func (s *CacheKeyActionForBatchUpdateCdnConfigInput) SetCacheKeyComponents(v []*CacheKeyComponentForBatchUpdateCdnConfigInput) *CacheKeyActionForBatchUpdateCdnConfigInput {
	s.CacheKeyComponents = v
	return s
}

type CacheKeyComponentForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	IgnoreCase *bool `type:"boolean"`

	Object *string `type:"string"`

	Subobject *string `type:"string"`
}

// String returns the string representation
func (s CacheKeyComponentForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyComponentForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CacheKeyComponentForBatchUpdateCdnConfigInput) SetAction(v string) *CacheKeyComponentForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheKeyComponentForBatchUpdateCdnConfigInput) SetIgnoreCase(v bool) *CacheKeyComponentForBatchUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetObject sets the Object field's value.
func (s *CacheKeyComponentForBatchUpdateCdnConfigInput) SetObject(v string) *CacheKeyComponentForBatchUpdateCdnConfigInput {
	s.Object = &v
	return s
}

// SetSubobject sets the Subobject field's value.
func (s *CacheKeyComponentForBatchUpdateCdnConfigInput) SetSubobject(v string) *CacheKeyComponentForBatchUpdateCdnConfigInput {
	s.Subobject = &v
	return s
}

type CacheKeyForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheKeyAction *CacheKeyActionForBatchUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CacheKeyForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheKeyAction sets the CacheKeyAction field's value.
func (s *CacheKeyForBatchUpdateCdnConfigInput) SetCacheKeyAction(v *CacheKeyActionForBatchUpdateCdnConfigInput) *CacheKeyForBatchUpdateCdnConfigInput {
	s.CacheKeyAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheKeyForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *CacheKeyForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type CertCheckForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CertInfoList []*CertInfoListForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CertCheckForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertCheckForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertInfoList sets the CertInfoList field's value.
func (s *CertCheckForBatchUpdateCdnConfigInput) SetCertInfoList(v []*CertInfoListForBatchUpdateCdnConfigInput) *CertCheckForBatchUpdateCdnConfigInput {
	s.CertInfoList = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CertCheckForBatchUpdateCdnConfigInput) SetSwitch(v bool) *CertCheckForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CertInfoForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CertId *string `type:"string"`

	CertName *string `type:"string"`

	Certificate *CertificateForBatchUpdateCdnConfigInput `type:"structure"`

	Desc *string `type:"string"`

	EffectiveTime *int64 `type:"int64"`

	EncryType *string `type:"string"`

	ExpireTime *int64 `type:"int64"`

	Source *string `type:"string"`
}

// String returns the string representation
func (s CertInfoForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertInfoForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertInfoForBatchUpdateCdnConfigInput) SetCertId(v string) *CertInfoForBatchUpdateCdnConfigInput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertInfoForBatchUpdateCdnConfigInput) SetCertName(v string) *CertInfoForBatchUpdateCdnConfigInput {
	s.CertName = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *CertInfoForBatchUpdateCdnConfigInput) SetCertificate(v *CertificateForBatchUpdateCdnConfigInput) *CertInfoForBatchUpdateCdnConfigInput {
	s.Certificate = v
	return s
}

// SetDesc sets the Desc field's value.
func (s *CertInfoForBatchUpdateCdnConfigInput) SetDesc(v string) *CertInfoForBatchUpdateCdnConfigInput {
	s.Desc = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CertInfoForBatchUpdateCdnConfigInput) SetEffectiveTime(v int64) *CertInfoForBatchUpdateCdnConfigInput {
	s.EffectiveTime = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *CertInfoForBatchUpdateCdnConfigInput) SetEncryType(v string) *CertInfoForBatchUpdateCdnConfigInput {
	s.EncryType = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CertInfoForBatchUpdateCdnConfigInput) SetExpireTime(v int64) *CertInfoForBatchUpdateCdnConfigInput {
	s.ExpireTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CertInfoForBatchUpdateCdnConfigInput) SetSource(v string) *CertInfoForBatchUpdateCdnConfigInput {
	s.Source = &v
	return s
}

type CertInfoListForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CertId *string `type:"string"`

	CertName *string `type:"string"`

	Certificate *CertificateForBatchUpdateCdnConfigInput `type:"structure"`

	Desc *string `type:"string"`

	EffectiveTime *int64 `type:"int64"`

	EncryType *string `type:"string"`

	ExpireTime *int64 `type:"int64"`

	Source *string `type:"string"`
}

// String returns the string representation
func (s CertInfoListForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertInfoListForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertInfoListForBatchUpdateCdnConfigInput) SetCertId(v string) *CertInfoListForBatchUpdateCdnConfigInput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertInfoListForBatchUpdateCdnConfigInput) SetCertName(v string) *CertInfoListForBatchUpdateCdnConfigInput {
	s.CertName = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *CertInfoListForBatchUpdateCdnConfigInput) SetCertificate(v *CertificateForBatchUpdateCdnConfigInput) *CertInfoListForBatchUpdateCdnConfigInput {
	s.Certificate = v
	return s
}

// SetDesc sets the Desc field's value.
func (s *CertInfoListForBatchUpdateCdnConfigInput) SetDesc(v string) *CertInfoListForBatchUpdateCdnConfigInput {
	s.Desc = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CertInfoListForBatchUpdateCdnConfigInput) SetEffectiveTime(v int64) *CertInfoListForBatchUpdateCdnConfigInput {
	s.EffectiveTime = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *CertInfoListForBatchUpdateCdnConfigInput) SetEncryType(v string) *CertInfoListForBatchUpdateCdnConfigInput {
	s.EncryType = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CertInfoListForBatchUpdateCdnConfigInput) SetExpireTime(v int64) *CertInfoListForBatchUpdateCdnConfigInput {
	s.ExpireTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CertInfoListForBatchUpdateCdnConfigInput) SetSource(v string) *CertInfoListForBatchUpdateCdnConfigInput {
	s.Source = &v
	return s
}

type CertificateForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Certificate *string `type:"string"`

	EncryptionCert *string `type:"string"`

	EncryptionKey *string `type:"string"`

	PrivateKey *string `type:"string"`
}

// String returns the string representation
func (s CertificateForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *CertificateForBatchUpdateCdnConfigInput) SetCertificate(v string) *CertificateForBatchUpdateCdnConfigInput {
	s.Certificate = &v
	return s
}

// SetEncryptionCert sets the EncryptionCert field's value.
func (s *CertificateForBatchUpdateCdnConfigInput) SetEncryptionCert(v string) *CertificateForBatchUpdateCdnConfigInput {
	s.EncryptionCert = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CertificateForBatchUpdateCdnConfigInput) SetEncryptionKey(v string) *CertificateForBatchUpdateCdnConfigInput {
	s.EncryptionKey = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *CertificateForBatchUpdateCdnConfigInput) SetPrivateKey(v string) *CertificateForBatchUpdateCdnConfigInput {
	s.PrivateKey = &v
	return s
}

type CommonTypeForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	IgnoreCase *bool `type:"boolean"`

	IgnoreScheme *bool `type:"boolean"`

	Referers []*string `type:"list"`
}

// String returns the string representation
func (s CommonTypeForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CommonTypeForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CommonTypeForBatchUpdateCdnConfigInput) SetIgnoreCase(v bool) *CommonTypeForBatchUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetIgnoreScheme sets the IgnoreScheme field's value.
func (s *CommonTypeForBatchUpdateCdnConfigInput) SetIgnoreScheme(v bool) *CommonTypeForBatchUpdateCdnConfigInput {
	s.IgnoreScheme = &v
	return s
}

// SetReferers sets the Referers field's value.
func (s *CommonTypeForBatchUpdateCdnConfigInput) SetReferers(v []*string) *CommonTypeForBatchUpdateCdnConfigInput {
	s.Referers = v
	return s
}

type CompressionActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CompressionFormat *string `type:"string"`

	CompressionTarget *string `type:"string"`

	CompressionType []*string `type:"list"`

	MinFileSizeKB *int64 `type:"int64"`
}

// String returns the string representation
func (s CompressionActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *CompressionActionForBatchUpdateCdnConfigInput) SetCompressionFormat(v string) *CompressionActionForBatchUpdateCdnConfigInput {
	s.CompressionFormat = &v
	return s
}

// SetCompressionTarget sets the CompressionTarget field's value.
func (s *CompressionActionForBatchUpdateCdnConfigInput) SetCompressionTarget(v string) *CompressionActionForBatchUpdateCdnConfigInput {
	s.CompressionTarget = &v
	return s
}

// SetCompressionType sets the CompressionType field's value.
func (s *CompressionActionForBatchUpdateCdnConfigInput) SetCompressionType(v []*string) *CompressionActionForBatchUpdateCdnConfigInput {
	s.CompressionType = v
	return s
}

// SetMinFileSizeKB sets the MinFileSizeKB field's value.
func (s *CompressionActionForBatchUpdateCdnConfigInput) SetMinFileSizeKB(v int64) *CompressionActionForBatchUpdateCdnConfigInput {
	s.MinFileSizeKB = &v
	return s
}

type CompressionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CompressionRules []*CompressionRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CompressionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCompressionRules sets the CompressionRules field's value.
func (s *CompressionForBatchUpdateCdnConfigInput) SetCompressionRules(v []*CompressionRuleForBatchUpdateCdnConfigInput) *CompressionForBatchUpdateCdnConfigInput {
	s.CompressionRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CompressionForBatchUpdateCdnConfigInput) SetSwitch(v bool) *CompressionForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CompressionRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CompressionAction *CompressionActionForBatchUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CompressionRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCompressionAction sets the CompressionAction field's value.
func (s *CompressionRuleForBatchUpdateCdnConfigInput) SetCompressionAction(v *CompressionActionForBatchUpdateCdnConfigInput) *CompressionRuleForBatchUpdateCdnConfigInput {
	s.CompressionAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CompressionRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *CompressionRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type ConditionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ConditionRule []*ConditionRuleForBatchUpdateCdnConfigInput `type:"list"`

	Connective *string `type:"string"`
}

// String returns the string representation
func (s ConditionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetConditionRule sets the ConditionRule field's value.
func (s *ConditionForBatchUpdateCdnConfigInput) SetConditionRule(v []*ConditionRuleForBatchUpdateCdnConfigInput) *ConditionForBatchUpdateCdnConfigInput {
	s.ConditionRule = v
	return s
}

// SetConnective sets the Connective field's value.
func (s *ConditionForBatchUpdateCdnConfigInput) SetConnective(v string) *ConditionForBatchUpdateCdnConfigInput {
	s.Connective = &v
	return s
}

type ConditionGroupForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConvertConditionForBatchUpdateCdnConfigInput `type:"structure"`

	IsGroup *bool `type:"boolean"`
}

// String returns the string representation
func (s ConditionGroupForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionGroupForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *ConditionGroupForBatchUpdateCdnConfigInput) SetCondition(v *ConvertConditionForBatchUpdateCdnConfigInput) *ConditionGroupForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetIsGroup sets the IsGroup field's value.
func (s *ConditionGroupForBatchUpdateCdnConfigInput) SetIsGroup(v bool) *ConditionGroupForBatchUpdateCdnConfigInput {
	s.IsGroup = &v
	return s
}

type ConditionRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Object *string `type:"string"`

	Operator *string `type:"string"`

	Type *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s ConditionRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ConditionRuleForBatchUpdateCdnConfigInput) SetName(v string) *ConditionRuleForBatchUpdateCdnConfigInput {
	s.Name = &v
	return s
}

// SetObject sets the Object field's value.
func (s *ConditionRuleForBatchUpdateCdnConfigInput) SetObject(v string) *ConditionRuleForBatchUpdateCdnConfigInput {
	s.Object = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ConditionRuleForBatchUpdateCdnConfigInput) SetOperator(v string) *ConditionRuleForBatchUpdateCdnConfigInput {
	s.Operator = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConditionRuleForBatchUpdateCdnConfigInput) SetType(v string) *ConditionRuleForBatchUpdateCdnConfigInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConditionRuleForBatchUpdateCdnConfigInput) SetValue(v string) *ConditionRuleForBatchUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type ConditionalOriginForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginRules []*OriginRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s ConditionalOriginForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalOriginForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginRules sets the OriginRules field's value.
func (s *ConditionalOriginForBatchUpdateCdnConfigInput) SetOriginRules(v []*OriginRuleForBatchUpdateCdnConfigInput) *ConditionalOriginForBatchUpdateCdnConfigInput {
	s.OriginRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *ConditionalOriginForBatchUpdateCdnConfigInput) SetSwitch(v bool) *ConditionalOriginForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type ConvertCacheActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	CacheKey []*string `type:"list"`

	IgnoreCase *bool `type:"boolean"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s ConvertCacheActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertCacheActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ConvertCacheActionForBatchUpdateCdnConfigInput) SetAction(v string) *ConvertCacheActionForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetCacheKey sets the CacheKey field's value.
func (s *ConvertCacheActionForBatchUpdateCdnConfigInput) SetCacheKey(v []*string) *ConvertCacheActionForBatchUpdateCdnConfigInput {
	s.CacheKey = v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *ConvertCacheActionForBatchUpdateCdnConfigInput) SetIgnoreCase(v bool) *ConvertCacheActionForBatchUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *ConvertCacheActionForBatchUpdateCdnConfigInput) SetTtl(v int64) *ConvertCacheActionForBatchUpdateCdnConfigInput {
	s.Ttl = &v
	return s
}

type ConvertConditionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Object *string `type:"string"`

	Operator *string `type:"string"`

	Value []*string `type:"list"`
}

// String returns the string representation
func (s ConvertConditionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConditionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetObject sets the Object field's value.
func (s *ConvertConditionForBatchUpdateCdnConfigInput) SetObject(v string) *ConvertConditionForBatchUpdateCdnConfigInput {
	s.Object = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ConvertConditionForBatchUpdateCdnConfigInput) SetOperator(v string) *ConvertConditionForBatchUpdateCdnConfigInput {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConvertConditionForBatchUpdateCdnConfigInput) SetValue(v []*string) *ConvertConditionForBatchUpdateCdnConfigInput {
	s.Value = v
	return s
}

type ConvertConvertConditionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ConditionGroups []*ConditionGroupForBatchUpdateCdnConfigInput `type:"list"`

	Connective *string `type:"string"`

	IsGroup *bool `type:"boolean"`
}

// String returns the string representation
func (s ConvertConvertConditionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConvertConditionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetConditionGroups sets the ConditionGroups field's value.
func (s *ConvertConvertConditionForBatchUpdateCdnConfigInput) SetConditionGroups(v []*ConditionGroupForBatchUpdateCdnConfigInput) *ConvertConvertConditionForBatchUpdateCdnConfigInput {
	s.ConditionGroups = v
	return s
}

// SetConnective sets the Connective field's value.
func (s *ConvertConvertConditionForBatchUpdateCdnConfigInput) SetConnective(v string) *ConvertConvertConditionForBatchUpdateCdnConfigInput {
	s.Connective = &v
	return s
}

// SetIsGroup sets the IsGroup field's value.
func (s *ConvertConvertConditionForBatchUpdateCdnConfigInput) SetIsGroup(v bool) *ConvertConvertConditionForBatchUpdateCdnConfigInput {
	s.IsGroup = &v
	return s
}

type ConvertOriginLineForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Address *string `type:"string"`

	BucketName *string `type:"string"`

	HttpPort *string `type:"string"`

	HttpsPort *string `type:"string"`

	InstanceType *string `type:"string"`

	OriginHost *string `type:"string"`

	OriginType *string `type:"string"`

	PrivateBucketAccess *bool `type:"boolean"`

	PrivateBucketAuth *PrivateBucketAuthForBatchUpdateCdnConfigInput `type:"structure"`

	Region *string `type:"string"`

	Weight *string `type:"string"`
}

// String returns the string representation
func (s ConvertOriginLineForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOriginLineForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetAddress(v string) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.Address = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetBucketName(v string) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.BucketName = &v
	return s
}

// SetHttpPort sets the HttpPort field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetHttpPort(v string) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.HttpPort = &v
	return s
}

// SetHttpsPort sets the HttpsPort field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetHttpsPort(v string) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.HttpsPort = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetInstanceType(v string) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.InstanceType = &v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetOriginHost(v string) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.OriginHost = &v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetOriginType(v string) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.OriginType = &v
	return s
}

// SetPrivateBucketAccess sets the PrivateBucketAccess field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetPrivateBucketAccess(v bool) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.PrivateBucketAccess = &v
	return s
}

// SetPrivateBucketAuth sets the PrivateBucketAuth field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetPrivateBucketAuth(v *PrivateBucketAuthForBatchUpdateCdnConfigInput) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.PrivateBucketAuth = v
	return s
}

// SetRegion sets the Region field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetRegion(v string) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.Region = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertOriginLineForBatchUpdateCdnConfigInput) SetWeight(v string) *ConvertOriginLineForBatchUpdateCdnConfigInput {
	s.Weight = &v
	return s
}

type ConvertTimeoutActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	HttpTimeout *int64 `type:"int64"`

	TcpTimeout *int64 `type:"int64"`
}

// String returns the string representation
func (s ConvertTimeoutActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertTimeoutActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetHttpTimeout sets the HttpTimeout field's value.
func (s *ConvertTimeoutActionForBatchUpdateCdnConfigInput) SetHttpTimeout(v int64) *ConvertTimeoutActionForBatchUpdateCdnConfigInput {
	s.HttpTimeout = &v
	return s
}

// SetTcpTimeout sets the TcpTimeout field's value.
func (s *ConvertTimeoutActionForBatchUpdateCdnConfigInput) SetTcpTimeout(v int64) *ConvertTimeoutActionForBatchUpdateCdnConfigInput {
	s.TcpTimeout = &v
	return s
}

type CustomErrorPageForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ErrorPageRule []*ErrorPageRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CustomErrorPageForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorPageForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetErrorPageRule sets the ErrorPageRule field's value.
func (s *CustomErrorPageForBatchUpdateCdnConfigInput) SetErrorPageRule(v []*ErrorPageRuleForBatchUpdateCdnConfigInput) *CustomErrorPageForBatchUpdateCdnConfigInput {
	s.ErrorPageRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CustomErrorPageForBatchUpdateCdnConfigInput) SetSwitch(v bool) *CustomErrorPageForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CustomVariableInstanceForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Operator *string `type:"string"`

	Type *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s CustomVariableInstanceForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomVariableInstanceForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOperator sets the Operator field's value.
func (s *CustomVariableInstanceForBatchUpdateCdnConfigInput) SetOperator(v string) *CustomVariableInstanceForBatchUpdateCdnConfigInput {
	s.Operator = &v
	return s
}

// SetType sets the Type field's value.
func (s *CustomVariableInstanceForBatchUpdateCdnConfigInput) SetType(v string) *CustomVariableInstanceForBatchUpdateCdnConfigInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CustomVariableInstanceForBatchUpdateCdnConfigInput) SetValue(v string) *CustomVariableInstanceForBatchUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type CustomVariableRulesForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CustomVariableInstances []*CustomVariableInstanceForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s CustomVariableRulesForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomVariableRulesForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCustomVariableInstances sets the CustomVariableInstances field's value.
func (s *CustomVariableRulesForBatchUpdateCdnConfigInput) SetCustomVariableInstances(v []*CustomVariableInstanceForBatchUpdateCdnConfigInput) *CustomVariableRulesForBatchUpdateCdnConfigInput {
	s.CustomVariableInstances = v
	return s
}

type CustomizeAccessRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CustomizeInstances []*CustomizeInstanceForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CustomizeAccessRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeAccessRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCustomizeInstances sets the CustomizeInstances field's value.
func (s *CustomizeAccessRuleForBatchUpdateCdnConfigInput) SetCustomizeInstances(v []*CustomizeInstanceForBatchUpdateCdnConfigInput) *CustomizeAccessRuleForBatchUpdateCdnConfigInput {
	s.CustomizeInstances = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CustomizeAccessRuleForBatchUpdateCdnConfigInput) SetSwitch(v bool) *CustomizeAccessRuleForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CustomizeInstanceForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CustomizeRule *CustomizeRuleForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CustomizeInstanceForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeInstanceForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCustomizeRule sets the CustomizeRule field's value.
func (s *CustomizeInstanceForBatchUpdateCdnConfigInput) SetCustomizeRule(v *CustomizeRuleForBatchUpdateCdnConfigInput) *CustomizeInstanceForBatchUpdateCdnConfigInput {
	s.CustomizeRule = v
	return s
}

type CustomizeRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AccessAction *AccessActionForBatchUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CustomizeRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAccessAction sets the AccessAction field's value.
func (s *CustomizeRuleForBatchUpdateCdnConfigInput) SetAccessAction(v *AccessActionForBatchUpdateCdnConfigInput) *CustomizeRuleForBatchUpdateCdnConfigInput {
	s.AccessAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CustomizeRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *CustomizeRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type DeployResultForBatchUpdateCdnConfigOutput struct {
	_ struct{} `type:"structure"`

	Domain *string `type:"string"`

	ErrorMsg *string `type:"string"`

	Status *string `type:"string"`
}

// String returns the string representation
func (s DeployResultForBatchUpdateCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DeployResultForBatchUpdateCdnConfigOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DeployResultForBatchUpdateCdnConfigOutput) SetDomain(v string) *DeployResultForBatchUpdateCdnConfigOutput {
	s.Domain = &v
	return s
}

// SetErrorMsg sets the ErrorMsg field's value.
func (s *DeployResultForBatchUpdateCdnConfigOutput) SetErrorMsg(v string) *DeployResultForBatchUpdateCdnConfigOutput {
	s.ErrorMsg = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeployResultForBatchUpdateCdnConfigOutput) SetStatus(v string) *DeployResultForBatchUpdateCdnConfigOutput {
	s.Status = &v
	return s
}

type DownloadSpeedLimitActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	SpeedLimitRate *int64 `type:"int64"`

	SpeedLimitRateAfter *int64 `type:"int64"`

	SpeedLimitTime *SpeedLimitTimeForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s DownloadSpeedLimitActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSpeedLimitRate sets the SpeedLimitRate field's value.
func (s *DownloadSpeedLimitActionForBatchUpdateCdnConfigInput) SetSpeedLimitRate(v int64) *DownloadSpeedLimitActionForBatchUpdateCdnConfigInput {
	s.SpeedLimitRate = &v
	return s
}

// SetSpeedLimitRateAfter sets the SpeedLimitRateAfter field's value.
func (s *DownloadSpeedLimitActionForBatchUpdateCdnConfigInput) SetSpeedLimitRateAfter(v int64) *DownloadSpeedLimitActionForBatchUpdateCdnConfigInput {
	s.SpeedLimitRateAfter = &v
	return s
}

// SetSpeedLimitTime sets the SpeedLimitTime field's value.
func (s *DownloadSpeedLimitActionForBatchUpdateCdnConfigInput) SetSpeedLimitTime(v *SpeedLimitTimeForBatchUpdateCdnConfigInput) *DownloadSpeedLimitActionForBatchUpdateCdnConfigInput {
	s.SpeedLimitTime = v
	return s
}

type DownloadSpeedLimitForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	DownloadSpeedLimitRules []*DownloadSpeedLimitRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s DownloadSpeedLimitForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetDownloadSpeedLimitRules sets the DownloadSpeedLimitRules field's value.
func (s *DownloadSpeedLimitForBatchUpdateCdnConfigInput) SetDownloadSpeedLimitRules(v []*DownloadSpeedLimitRuleForBatchUpdateCdnConfigInput) *DownloadSpeedLimitForBatchUpdateCdnConfigInput {
	s.DownloadSpeedLimitRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *DownloadSpeedLimitForBatchUpdateCdnConfigInput) SetSwitch(v bool) *DownloadSpeedLimitForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type DownloadSpeedLimitRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	DownloadSpeedLimitAction *DownloadSpeedLimitActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s DownloadSpeedLimitRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *DownloadSpeedLimitRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *DownloadSpeedLimitRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetDownloadSpeedLimitAction sets the DownloadSpeedLimitAction field's value.
func (s *DownloadSpeedLimitRuleForBatchUpdateCdnConfigInput) SetDownloadSpeedLimitAction(v *DownloadSpeedLimitActionForBatchUpdateCdnConfigInput) *DownloadSpeedLimitRuleForBatchUpdateCdnConfigInput {
	s.DownloadSpeedLimitAction = v
	return s
}

type ErrorPageActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	RedirectCode *string `type:"string"`

	RedirectUrl *string `type:"string"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s ErrorPageActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorPageActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ErrorPageActionForBatchUpdateCdnConfigInput) SetAction(v string) *ErrorPageActionForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetRedirectCode sets the RedirectCode field's value.
func (s *ErrorPageActionForBatchUpdateCdnConfigInput) SetRedirectCode(v string) *ErrorPageActionForBatchUpdateCdnConfigInput {
	s.RedirectCode = &v
	return s
}

// SetRedirectUrl sets the RedirectUrl field's value.
func (s *ErrorPageActionForBatchUpdateCdnConfigInput) SetRedirectUrl(v string) *ErrorPageActionForBatchUpdateCdnConfigInput {
	s.RedirectUrl = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ErrorPageActionForBatchUpdateCdnConfigInput) SetStatusCode(v string) *ErrorPageActionForBatchUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type ErrorPageRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ErrorPageAction *ErrorPageActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s ErrorPageRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorPageRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetErrorPageAction sets the ErrorPageAction field's value.
func (s *ErrorPageRuleForBatchUpdateCdnConfigInput) SetErrorPageAction(v *ErrorPageActionForBatchUpdateCdnConfigInput) *ErrorPageRuleForBatchUpdateCdnConfigInput {
	s.ErrorPageAction = v
	return s
}

type ExpTimeCapRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CapMode *string `type:"string"`

	ParamName *string `type:"string"`

	UriLevel *int64 `type:"int64"`
}

// String returns the string representation
func (s ExpTimeCapRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpTimeCapRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCapMode sets the CapMode field's value.
func (s *ExpTimeCapRuleForBatchUpdateCdnConfigInput) SetCapMode(v string) *ExpTimeCapRuleForBatchUpdateCdnConfigInput {
	s.CapMode = &v
	return s
}

// SetParamName sets the ParamName field's value.
func (s *ExpTimeCapRuleForBatchUpdateCdnConfigInput) SetParamName(v string) *ExpTimeCapRuleForBatchUpdateCdnConfigInput {
	s.ParamName = &v
	return s
}

// SetUriLevel sets the UriLevel field's value.
func (s *ExpTimeCapRuleForBatchUpdateCdnConfigInput) SetUriLevel(v int64) *ExpTimeCapRuleForBatchUpdateCdnConfigInput {
	s.UriLevel = &v
	return s
}

type ForcedRedirectForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	EnableForcedRedirect *bool `type:"boolean"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s ForcedRedirectForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForcedRedirectForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetEnableForcedRedirect sets the EnableForcedRedirect field's value.
func (s *ForcedRedirectForBatchUpdateCdnConfigInput) SetEnableForcedRedirect(v bool) *ForcedRedirectForBatchUpdateCdnConfigInput {
	s.EnableForcedRedirect = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ForcedRedirectForBatchUpdateCdnConfigInput) SetStatusCode(v string) *ForcedRedirectForBatchUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type HTTPSForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CertCheck *CertCheckForBatchUpdateCdnConfigInput `type:"structure"`

	CertInfo *CertInfoForBatchUpdateCdnConfigInput `type:"structure"`

	CertInfoList []*CertInfoListForBatchUpdateCdnConfigInput `type:"list"`

	DisableHttp *bool `type:"boolean"`

	ForcedRedirect *ForcedRedirectForBatchUpdateCdnConfigInput `type:"structure"`

	HTTP2 *bool `type:"boolean"`

	Hsts *HstsForBatchUpdateCdnConfigInput `type:"structure"`

	OCSP *bool `type:"boolean"`

	Switch *bool `type:"boolean"`

	TlsVersion []*string `type:"list"`
}

// String returns the string representation
func (s HTTPSForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPSForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertCheck sets the CertCheck field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetCertCheck(v *CertCheckForBatchUpdateCdnConfigInput) *HTTPSForBatchUpdateCdnConfigInput {
	s.CertCheck = v
	return s
}

// SetCertInfo sets the CertInfo field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetCertInfo(v *CertInfoForBatchUpdateCdnConfigInput) *HTTPSForBatchUpdateCdnConfigInput {
	s.CertInfo = v
	return s
}

// SetCertInfoList sets the CertInfoList field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetCertInfoList(v []*CertInfoListForBatchUpdateCdnConfigInput) *HTTPSForBatchUpdateCdnConfigInput {
	s.CertInfoList = v
	return s
}

// SetDisableHttp sets the DisableHttp field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetDisableHttp(v bool) *HTTPSForBatchUpdateCdnConfigInput {
	s.DisableHttp = &v
	return s
}

// SetForcedRedirect sets the ForcedRedirect field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetForcedRedirect(v *ForcedRedirectForBatchUpdateCdnConfigInput) *HTTPSForBatchUpdateCdnConfigInput {
	s.ForcedRedirect = v
	return s
}

// SetHTTP2 sets the HTTP2 field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetHTTP2(v bool) *HTTPSForBatchUpdateCdnConfigInput {
	s.HTTP2 = &v
	return s
}

// SetHsts sets the Hsts field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetHsts(v *HstsForBatchUpdateCdnConfigInput) *HTTPSForBatchUpdateCdnConfigInput {
	s.Hsts = v
	return s
}

// SetOCSP sets the OCSP field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetOCSP(v bool) *HTTPSForBatchUpdateCdnConfigInput {
	s.OCSP = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetSwitch(v bool) *HTTPSForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetTlsVersion sets the TlsVersion field's value.
func (s *HTTPSForBatchUpdateCdnConfigInput) SetTlsVersion(v []*string) *HTTPSForBatchUpdateCdnConfigInput {
	s.TlsVersion = v
	return s
}

type HstsForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Subdomain *string `type:"string"`

	Switch *bool `type:"boolean"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s HstsForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HstsForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSubdomain sets the Subdomain field's value.
func (s *HstsForBatchUpdateCdnConfigInput) SetSubdomain(v string) *HstsForBatchUpdateCdnConfigInput {
	s.Subdomain = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *HstsForBatchUpdateCdnConfigInput) SetSwitch(v bool) *HstsForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *HstsForBatchUpdateCdnConfigInput) SetTtl(v int64) *HstsForBatchUpdateCdnConfigInput {
	s.Ttl = &v
	return s
}

type HttpForcedRedirectForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	EnableForcedRedirect *bool `type:"boolean"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s HttpForcedRedirectForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpForcedRedirectForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetEnableForcedRedirect sets the EnableForcedRedirect field's value.
func (s *HttpForcedRedirectForBatchUpdateCdnConfigInput) SetEnableForcedRedirect(v bool) *HttpForcedRedirectForBatchUpdateCdnConfigInput {
	s.EnableForcedRedirect = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *HttpForcedRedirectForBatchUpdateCdnConfigInput) SetStatusCode(v string) *HttpForcedRedirectForBatchUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type IPv6ForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s IPv6ForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IPv6ForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *IPv6ForBatchUpdateCdnConfigInput) SetSwitch(v bool) *IPv6ForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type IpAccessRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Ip []*string `type:"list"`

	RuleType *string `type:"string"`

	SharedConfig *SharedConfigForBatchUpdateCdnConfigInput `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s IpAccessRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAccessRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetIp sets the Ip field's value.
func (s *IpAccessRuleForBatchUpdateCdnConfigInput) SetIp(v []*string) *IpAccessRuleForBatchUpdateCdnConfigInput {
	s.Ip = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *IpAccessRuleForBatchUpdateCdnConfigInput) SetRuleType(v string) *IpAccessRuleForBatchUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *IpAccessRuleForBatchUpdateCdnConfigInput) SetSharedConfig(v *SharedConfigForBatchUpdateCdnConfigInput) *IpAccessRuleForBatchUpdateCdnConfigInput {
	s.SharedConfig = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *IpAccessRuleForBatchUpdateCdnConfigInput) SetSwitch(v bool) *IpAccessRuleForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type IpFreqLimitActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	FreqLimitRate *int64 `type:"int64"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s IpFreqLimitActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *IpFreqLimitActionForBatchUpdateCdnConfigInput) SetAction(v string) *IpFreqLimitActionForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetFreqLimitRate sets the FreqLimitRate field's value.
func (s *IpFreqLimitActionForBatchUpdateCdnConfigInput) SetFreqLimitRate(v int64) *IpFreqLimitActionForBatchUpdateCdnConfigInput {
	s.FreqLimitRate = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *IpFreqLimitActionForBatchUpdateCdnConfigInput) SetStatusCode(v string) *IpFreqLimitActionForBatchUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type IpFreqLimitForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	IpFreqLimitRules []*IpFreqLimitRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s IpFreqLimitForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetIpFreqLimitRules sets the IpFreqLimitRules field's value.
func (s *IpFreqLimitForBatchUpdateCdnConfigInput) SetIpFreqLimitRules(v []*IpFreqLimitRuleForBatchUpdateCdnConfigInput) *IpFreqLimitForBatchUpdateCdnConfigInput {
	s.IpFreqLimitRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *IpFreqLimitForBatchUpdateCdnConfigInput) SetSwitch(v bool) *IpFreqLimitForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type IpFreqLimitRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	IpFreqLimitAction *IpFreqLimitActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s IpFreqLimitRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *IpFreqLimitRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *IpFreqLimitRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetIpFreqLimitAction sets the IpFreqLimitAction field's value.
func (s *IpFreqLimitRuleForBatchUpdateCdnConfigInput) SetIpFreqLimitAction(v *IpFreqLimitActionForBatchUpdateCdnConfigInput) *IpFreqLimitRuleForBatchUpdateCdnConfigInput {
	s.IpFreqLimitAction = v
	return s
}

type MethodDeniedRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Methods *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s MethodDeniedRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MethodDeniedRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetMethods sets the Methods field's value.
func (s *MethodDeniedRuleForBatchUpdateCdnConfigInput) SetMethods(v string) *MethodDeniedRuleForBatchUpdateCdnConfigInput {
	s.Methods = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *MethodDeniedRuleForBatchUpdateCdnConfigInput) SetSwitch(v bool) *MethodDeniedRuleForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type MultiRangeForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s MultiRangeForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiRangeForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *MultiRangeForBatchUpdateCdnConfigInput) SetSwitch(v bool) *MultiRangeForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type NegativeCacheForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	NegativeCacheRule *NegativeCacheRuleForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s NegativeCacheForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NegativeCacheForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *NegativeCacheForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *NegativeCacheForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetNegativeCacheRule sets the NegativeCacheRule field's value.
func (s *NegativeCacheForBatchUpdateCdnConfigInput) SetNegativeCacheRule(v *NegativeCacheRuleForBatchUpdateCdnConfigInput) *NegativeCacheForBatchUpdateCdnConfigInput {
	s.NegativeCacheRule = v
	return s
}

type NegativeCacheRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	IgnoreCase *bool `type:"boolean"`

	StatusCode *string `type:"string"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s NegativeCacheRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NegativeCacheRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *NegativeCacheRuleForBatchUpdateCdnConfigInput) SetAction(v string) *NegativeCacheRuleForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *NegativeCacheRuleForBatchUpdateCdnConfigInput) SetIgnoreCase(v bool) *NegativeCacheRuleForBatchUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *NegativeCacheRuleForBatchUpdateCdnConfigInput) SetStatusCode(v string) *NegativeCacheRuleForBatchUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *NegativeCacheRuleForBatchUpdateCdnConfigInput) SetTtl(v int64) *NegativeCacheRuleForBatchUpdateCdnConfigInput {
	s.Ttl = &v
	return s
}

type OriginAccessRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	IgnoreCase *bool `type:"boolean"`

	Origins []*string `type:"list"`

	RuleType *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginAccessRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *OriginAccessRuleForBatchUpdateCdnConfigInput) SetAllowEmpty(v bool) *OriginAccessRuleForBatchUpdateCdnConfigInput {
	s.AllowEmpty = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *OriginAccessRuleForBatchUpdateCdnConfigInput) SetIgnoreCase(v bool) *OriginAccessRuleForBatchUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *OriginAccessRuleForBatchUpdateCdnConfigInput) SetOrigins(v []*string) *OriginAccessRuleForBatchUpdateCdnConfigInput {
	s.Origins = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *OriginAccessRuleForBatchUpdateCdnConfigInput) SetRuleType(v string) *OriginAccessRuleForBatchUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginAccessRuleForBatchUpdateCdnConfigInput) SetSwitch(v bool) *OriginAccessRuleForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type OriginActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginLines []*ConvertOriginLineForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s OriginActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginLines sets the OriginLines field's value.
func (s *OriginActionForBatchUpdateCdnConfigInput) SetOriginLines(v []*ConvertOriginLineForBatchUpdateCdnConfigInput) *OriginActionForBatchUpdateCdnConfigInput {
	s.OriginLines = v
	return s
}

type OriginArgActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginArgComponents []*OriginArgComponentForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s OriginArgActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginArgComponents sets the OriginArgComponents field's value.
func (s *OriginArgActionForBatchUpdateCdnConfigInput) SetOriginArgComponents(v []*OriginArgComponentForBatchUpdateCdnConfigInput) *OriginArgActionForBatchUpdateCdnConfigInput {
	s.OriginArgComponents = v
	return s
}

type OriginArgComponentForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Object *string `type:"string"`

	Subobject *string `type:"string"`
}

// String returns the string representation
func (s OriginArgComponentForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgComponentForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *OriginArgComponentForBatchUpdateCdnConfigInput) SetAction(v string) *OriginArgComponentForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetObject sets the Object field's value.
func (s *OriginArgComponentForBatchUpdateCdnConfigInput) SetObject(v string) *OriginArgComponentForBatchUpdateCdnConfigInput {
	s.Object = &v
	return s
}

// SetSubobject sets the Subobject field's value.
func (s *OriginArgComponentForBatchUpdateCdnConfigInput) SetSubobject(v string) *OriginArgComponentForBatchUpdateCdnConfigInput {
	s.Subobject = &v
	return s
}

type OriginArgForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	OriginArgAction *OriginArgActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s OriginArgForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginArgForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *OriginArgForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetOriginArgAction sets the OriginArgAction field's value.
func (s *OriginArgForBatchUpdateCdnConfigInput) SetOriginArgAction(v *OriginArgActionForBatchUpdateCdnConfigInput) *OriginArgForBatchUpdateCdnConfigInput {
	s.OriginArgAction = v
	return s
}

type OriginCertCheckForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginCertCheckForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginCertCheckForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *OriginCertCheckForBatchUpdateCdnConfigInput) SetSwitch(v bool) *OriginCertCheckForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type OriginForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	OriginAction *OriginActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s OriginForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *OriginForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetOriginAction sets the OriginAction field's value.
func (s *OriginForBatchUpdateCdnConfigInput) SetOriginAction(v *OriginActionForBatchUpdateCdnConfigInput) *OriginForBatchUpdateCdnConfigInput {
	s.OriginAction = v
	return s
}

type OriginLineForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Address *string `type:"string"`

	HttpPort *string `type:"string"`

	HttpsPort *string `type:"string"`

	InstanceType *string `type:"string"`

	OriginHost *string `type:"string"`
}

// String returns the string representation
func (s OriginLineForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginLineForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *OriginLineForBatchUpdateCdnConfigInput) SetAddress(v string) *OriginLineForBatchUpdateCdnConfigInput {
	s.Address = &v
	return s
}

// SetHttpPort sets the HttpPort field's value.
func (s *OriginLineForBatchUpdateCdnConfigInput) SetHttpPort(v string) *OriginLineForBatchUpdateCdnConfigInput {
	s.HttpPort = &v
	return s
}

// SetHttpsPort sets the HttpsPort field's value.
func (s *OriginLineForBatchUpdateCdnConfigInput) SetHttpsPort(v string) *OriginLineForBatchUpdateCdnConfigInput {
	s.HttpsPort = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *OriginLineForBatchUpdateCdnConfigInput) SetInstanceType(v string) *OriginLineForBatchUpdateCdnConfigInput {
	s.InstanceType = &v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *OriginLineForBatchUpdateCdnConfigInput) SetOriginHost(v string) *OriginLineForBatchUpdateCdnConfigInput {
	s.OriginHost = &v
	return s
}

type OriginRetryForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	StatusCode *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginRetryForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRetryForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *OriginRetryForBatchUpdateCdnConfigInput) SetStatusCode(v string) *OriginRetryForBatchUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginRetryForBatchUpdateCdnConfigInput) SetSwitch(v bool) *OriginRetryForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type OriginRewriteActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RewriteType *string `type:"string"`

	SourcePath *string `type:"string"`

	TargetPath *string `type:"string"`
}

// String returns the string representation
func (s OriginRewriteActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRewriteType sets the RewriteType field's value.
func (s *OriginRewriteActionForBatchUpdateCdnConfigInput) SetRewriteType(v string) *OriginRewriteActionForBatchUpdateCdnConfigInput {
	s.RewriteType = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *OriginRewriteActionForBatchUpdateCdnConfigInput) SetSourcePath(v string) *OriginRewriteActionForBatchUpdateCdnConfigInput {
	s.SourcePath = &v
	return s
}

// SetTargetPath sets the TargetPath field's value.
func (s *OriginRewriteActionForBatchUpdateCdnConfigInput) SetTargetPath(v string) *OriginRewriteActionForBatchUpdateCdnConfigInput {
	s.TargetPath = &v
	return s
}

type OriginRewriteForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginRewriteRule []*OriginRewriteRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginRewriteForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginRewriteRule sets the OriginRewriteRule field's value.
func (s *OriginRewriteForBatchUpdateCdnConfigInput) SetOriginRewriteRule(v []*OriginRewriteRuleForBatchUpdateCdnConfigInput) *OriginRewriteForBatchUpdateCdnConfigInput {
	s.OriginRewriteRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginRewriteForBatchUpdateCdnConfigInput) SetSwitch(v bool) *OriginRewriteForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type OriginRewriteRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	OriginRewriteAction *OriginRewriteActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s OriginRewriteRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginRewriteRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *OriginRewriteRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetOriginRewriteAction sets the OriginRewriteAction field's value.
func (s *OriginRewriteRuleForBatchUpdateCdnConfigInput) SetOriginRewriteAction(v *OriginRewriteActionForBatchUpdateCdnConfigInput) *OriginRewriteRuleForBatchUpdateCdnConfigInput {
	s.OriginRewriteAction = v
	return s
}

type OriginRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Actions *ActionsForBatchUpdateCdnConfigInput `type:"structure"`

	Condition *ConvertConvertConditionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s OriginRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *OriginRuleForBatchUpdateCdnConfigInput) SetActions(v *ActionsForBatchUpdateCdnConfigInput) *OriginRuleForBatchUpdateCdnConfigInput {
	s.Actions = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *OriginRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConvertConvertConditionForBatchUpdateCdnConfigInput) *OriginRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type OriginSniForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	SniDomain *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginSniForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSniForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSniDomain sets the SniDomain field's value.
func (s *OriginSniForBatchUpdateCdnConfigInput) SetSniDomain(v string) *OriginSniForBatchUpdateCdnConfigInput {
	s.SniDomain = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginSniForBatchUpdateCdnConfigInput) SetSwitch(v bool) *OriginSniForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type PageOptimizationForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OptimizationType []*string `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s PageOptimizationForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageOptimizationForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOptimizationType sets the OptimizationType field's value.
func (s *PageOptimizationForBatchUpdateCdnConfigInput) SetOptimizationType(v []*string) *PageOptimizationForBatchUpdateCdnConfigInput {
	s.OptimizationType = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *PageOptimizationForBatchUpdateCdnConfigInput) SetSwitch(v bool) *PageOptimizationForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type PrivateBucketAuthForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AuthType *string `type:"string"`

	Switch *bool `type:"boolean"`

	TosAuthInformation *TosAuthInformationForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s PrivateBucketAuthForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateBucketAuthForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAuthType sets the AuthType field's value.
func (s *PrivateBucketAuthForBatchUpdateCdnConfigInput) SetAuthType(v string) *PrivateBucketAuthForBatchUpdateCdnConfigInput {
	s.AuthType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *PrivateBucketAuthForBatchUpdateCdnConfigInput) SetSwitch(v bool) *PrivateBucketAuthForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetTosAuthInformation sets the TosAuthInformation field's value.
func (s *PrivateBucketAuthForBatchUpdateCdnConfigInput) SetTosAuthInformation(v *TosAuthInformationForBatchUpdateCdnConfigInput) *PrivateBucketAuthForBatchUpdateCdnConfigInput {
	s.TosAuthInformation = v
	return s
}

type QueryStringComponentsForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s QueryStringComponentsForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringComponentsForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *QueryStringComponentsForBatchUpdateCdnConfigInput) SetAction(v string) *QueryStringComponentsForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *QueryStringComponentsForBatchUpdateCdnConfigInput) SetValue(v string) *QueryStringComponentsForBatchUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type QueryStringInstanceForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Key *string `type:"string"`

	Value *string `type:"string"`

	ValueType *string `type:"string"`
}

// String returns the string representation
func (s QueryStringInstanceForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringInstanceForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *QueryStringInstanceForBatchUpdateCdnConfigInput) SetAction(v string) *QueryStringInstanceForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *QueryStringInstanceForBatchUpdateCdnConfigInput) SetKey(v string) *QueryStringInstanceForBatchUpdateCdnConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *QueryStringInstanceForBatchUpdateCdnConfigInput) SetValue(v string) *QueryStringInstanceForBatchUpdateCdnConfigInput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *QueryStringInstanceForBatchUpdateCdnConfigInput) SetValueType(v string) *QueryStringInstanceForBatchUpdateCdnConfigInput {
	s.ValueType = &v
	return s
}

type QueryStringRulesForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	QueryStringComponents *QueryStringComponentsForBatchUpdateCdnConfigInput `type:"structure"`

	QueryStringInstances []*QueryStringInstanceForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s QueryStringRulesForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringRulesForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetQueryStringComponents sets the QueryStringComponents field's value.
func (s *QueryStringRulesForBatchUpdateCdnConfigInput) SetQueryStringComponents(v *QueryStringComponentsForBatchUpdateCdnConfigInput) *QueryStringRulesForBatchUpdateCdnConfigInput {
	s.QueryStringComponents = v
	return s
}

// SetQueryStringInstances sets the QueryStringInstances field's value.
func (s *QueryStringRulesForBatchUpdateCdnConfigInput) SetQueryStringInstances(v []*QueryStringInstanceForBatchUpdateCdnConfigInput) *QueryStringRulesForBatchUpdateCdnConfigInput {
	s.QueryStringInstances = v
	return s
}

type QuicForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s QuicForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuicForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *QuicForBatchUpdateCdnConfigInput) SetSwitch(v bool) *QuicForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RedirectionActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RedirectCode *string `type:"string"`

	SourcePath *string `type:"string"`

	TargetHost *string `type:"string"`

	TargetPath *string `type:"string"`

	TargetProtocol *string `type:"string"`

	TargetQueryComponents *TargetQueryComponentsForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RedirectionActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRedirectCode sets the RedirectCode field's value.
func (s *RedirectionActionForBatchUpdateCdnConfigInput) SetRedirectCode(v string) *RedirectionActionForBatchUpdateCdnConfigInput {
	s.RedirectCode = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *RedirectionActionForBatchUpdateCdnConfigInput) SetSourcePath(v string) *RedirectionActionForBatchUpdateCdnConfigInput {
	s.SourcePath = &v
	return s
}

// SetTargetHost sets the TargetHost field's value.
func (s *RedirectionActionForBatchUpdateCdnConfigInput) SetTargetHost(v string) *RedirectionActionForBatchUpdateCdnConfigInput {
	s.TargetHost = &v
	return s
}

// SetTargetPath sets the TargetPath field's value.
func (s *RedirectionActionForBatchUpdateCdnConfigInput) SetTargetPath(v string) *RedirectionActionForBatchUpdateCdnConfigInput {
	s.TargetPath = &v
	return s
}

// SetTargetProtocol sets the TargetProtocol field's value.
func (s *RedirectionActionForBatchUpdateCdnConfigInput) SetTargetProtocol(v string) *RedirectionActionForBatchUpdateCdnConfigInput {
	s.TargetProtocol = &v
	return s
}

// SetTargetQueryComponents sets the TargetQueryComponents field's value.
func (s *RedirectionActionForBatchUpdateCdnConfigInput) SetTargetQueryComponents(v *TargetQueryComponentsForBatchUpdateCdnConfigInput) *RedirectionActionForBatchUpdateCdnConfigInput {
	s.TargetQueryComponents = v
	return s
}

type RedirectionRewriteForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RedirectionRule []*RedirectionRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RedirectionRewriteForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionRewriteForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRedirectionRule sets the RedirectionRule field's value.
func (s *RedirectionRewriteForBatchUpdateCdnConfigInput) SetRedirectionRule(v []*RedirectionRuleForBatchUpdateCdnConfigInput) *RedirectionRewriteForBatchUpdateCdnConfigInput {
	s.RedirectionRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RedirectionRewriteForBatchUpdateCdnConfigInput) SetSwitch(v bool) *RedirectionRewriteForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RedirectionRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RedirectionAction *RedirectionActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RedirectionRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRedirectionAction sets the RedirectionAction field's value.
func (s *RedirectionRuleForBatchUpdateCdnConfigInput) SetRedirectionAction(v *RedirectionActionForBatchUpdateCdnConfigInput) *RedirectionRuleForBatchUpdateCdnConfigInput {
	s.RedirectionAction = v
	return s
}

type RefererAccessRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	Referers []*string `type:"list"`

	ReferersType *ReferersTypeForBatchUpdateCdnConfigInput `type:"structure"`

	RuleType *string `type:"string"`

	SharedConfig *SharedConfigForBatchUpdateCdnConfigInput `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RefererAccessRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RefererAccessRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *RefererAccessRuleForBatchUpdateCdnConfigInput) SetAllowEmpty(v bool) *RefererAccessRuleForBatchUpdateCdnConfigInput {
	s.AllowEmpty = &v
	return s
}

// SetReferers sets the Referers field's value.
func (s *RefererAccessRuleForBatchUpdateCdnConfigInput) SetReferers(v []*string) *RefererAccessRuleForBatchUpdateCdnConfigInput {
	s.Referers = v
	return s
}

// SetReferersType sets the ReferersType field's value.
func (s *RefererAccessRuleForBatchUpdateCdnConfigInput) SetReferersType(v *ReferersTypeForBatchUpdateCdnConfigInput) *RefererAccessRuleForBatchUpdateCdnConfigInput {
	s.ReferersType = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *RefererAccessRuleForBatchUpdateCdnConfigInput) SetRuleType(v string) *RefererAccessRuleForBatchUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *RefererAccessRuleForBatchUpdateCdnConfigInput) SetSharedConfig(v *SharedConfigForBatchUpdateCdnConfigInput) *RefererAccessRuleForBatchUpdateCdnConfigInput {
	s.SharedConfig = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RefererAccessRuleForBatchUpdateCdnConfigInput) SetSwitch(v bool) *RefererAccessRuleForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type ReferersTypeForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CommonType *CommonTypeForBatchUpdateCdnConfigInput `type:"structure"`

	RegularType *RegularTypeForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s ReferersTypeForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReferersTypeForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCommonType sets the CommonType field's value.
func (s *ReferersTypeForBatchUpdateCdnConfigInput) SetCommonType(v *CommonTypeForBatchUpdateCdnConfigInput) *ReferersTypeForBatchUpdateCdnConfigInput {
	s.CommonType = v
	return s
}

// SetRegularType sets the RegularType field's value.
func (s *ReferersTypeForBatchUpdateCdnConfigInput) SetRegularType(v *RegularTypeForBatchUpdateCdnConfigInput) *ReferersTypeForBatchUpdateCdnConfigInput {
	s.RegularType = v
	return s
}

type RegularTypeForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Referers []*string `type:"list"`
}

// String returns the string representation
func (s RegularTypeForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RegularTypeForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetReferers sets the Referers field's value.
func (s *RegularTypeForBatchUpdateCdnConfigInput) SetReferers(v []*string) *RegularTypeForBatchUpdateCdnConfigInput {
	s.Referers = v
	return s
}

type RemoteAuthForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RemoteAuthRules []*RemoteAuthRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RemoteAuthForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRemoteAuthRules sets the RemoteAuthRules field's value.
func (s *RemoteAuthForBatchUpdateCdnConfigInput) SetRemoteAuthRules(v []*RemoteAuthRuleForBatchUpdateCdnConfigInput) *RemoteAuthForBatchUpdateCdnConfigInput {
	s.RemoteAuthRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RemoteAuthForBatchUpdateCdnConfigInput) SetSwitch(v bool) *RemoteAuthForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RemoteAuthRuleActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AuthModeConfig *AuthModeConfigForBatchUpdateCdnConfigInput `type:"structure"`

	AuthResponseConfig *AuthResponseConfigForBatchUpdateCdnConfigInput `type:"structure"`

	QueryStringRules *QueryStringRulesForBatchUpdateCdnConfigInput `type:"structure"`

	RequestBodyRules *string `type:"string"`

	RequestHeaderRules *RequestHeaderRulesForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RemoteAuthRuleActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthRuleActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAuthModeConfig sets the AuthModeConfig field's value.
func (s *RemoteAuthRuleActionForBatchUpdateCdnConfigInput) SetAuthModeConfig(v *AuthModeConfigForBatchUpdateCdnConfigInput) *RemoteAuthRuleActionForBatchUpdateCdnConfigInput {
	s.AuthModeConfig = v
	return s
}

// SetAuthResponseConfig sets the AuthResponseConfig field's value.
func (s *RemoteAuthRuleActionForBatchUpdateCdnConfigInput) SetAuthResponseConfig(v *AuthResponseConfigForBatchUpdateCdnConfigInput) *RemoteAuthRuleActionForBatchUpdateCdnConfigInput {
	s.AuthResponseConfig = v
	return s
}

// SetQueryStringRules sets the QueryStringRules field's value.
func (s *RemoteAuthRuleActionForBatchUpdateCdnConfigInput) SetQueryStringRules(v *QueryStringRulesForBatchUpdateCdnConfigInput) *RemoteAuthRuleActionForBatchUpdateCdnConfigInput {
	s.QueryStringRules = v
	return s
}

// SetRequestBodyRules sets the RequestBodyRules field's value.
func (s *RemoteAuthRuleActionForBatchUpdateCdnConfigInput) SetRequestBodyRules(v string) *RemoteAuthRuleActionForBatchUpdateCdnConfigInput {
	s.RequestBodyRules = &v
	return s
}

// SetRequestHeaderRules sets the RequestHeaderRules field's value.
func (s *RemoteAuthRuleActionForBatchUpdateCdnConfigInput) SetRequestHeaderRules(v *RequestHeaderRulesForBatchUpdateCdnConfigInput) *RemoteAuthRuleActionForBatchUpdateCdnConfigInput {
	s.RequestHeaderRules = v
	return s
}

type RemoteAuthRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	RemoteAuthRuleAction *RemoteAuthRuleActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RemoteAuthRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *RemoteAuthRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *RemoteAuthRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetRemoteAuthRuleAction sets the RemoteAuthRuleAction field's value.
func (s *RemoteAuthRuleForBatchUpdateCdnConfigInput) SetRemoteAuthRuleAction(v *RemoteAuthRuleActionForBatchUpdateCdnConfigInput) *RemoteAuthRuleForBatchUpdateCdnConfigInput {
	s.RemoteAuthRuleAction = v
	return s
}

type RequestBlockRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BlockRule []*BlockRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RequestBlockRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestBlockRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBlockRule sets the BlockRule field's value.
func (s *RequestBlockRuleForBatchUpdateCdnConfigInput) SetBlockRule(v []*BlockRuleForBatchUpdateCdnConfigInput) *RequestBlockRuleForBatchUpdateCdnConfigInput {
	s.BlockRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RequestBlockRuleForBatchUpdateCdnConfigInput) SetSwitch(v bool) *RequestBlockRuleForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RequestHeaderActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RequestHeaderInstances []*RequestHeaderInstanceForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s RequestHeaderActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRequestHeaderInstances sets the RequestHeaderInstances field's value.
func (s *RequestHeaderActionForBatchUpdateCdnConfigInput) SetRequestHeaderInstances(v []*RequestHeaderInstanceForBatchUpdateCdnConfigInput) *RequestHeaderActionForBatchUpdateCdnConfigInput {
	s.RequestHeaderInstances = v
	return s
}

type RequestHeaderComponentsForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s RequestHeaderComponentsForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderComponentsForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RequestHeaderComponentsForBatchUpdateCdnConfigInput) SetAction(v string) *RequestHeaderComponentsForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RequestHeaderComponentsForBatchUpdateCdnConfigInput) SetValue(v string) *RequestHeaderComponentsForBatchUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type RequestHeaderForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	RequestHeaderAction *RequestHeaderActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RequestHeaderForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *RequestHeaderForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *RequestHeaderForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetRequestHeaderAction sets the RequestHeaderAction field's value.
func (s *RequestHeaderForBatchUpdateCdnConfigInput) SetRequestHeaderAction(v *RequestHeaderActionForBatchUpdateCdnConfigInput) *RequestHeaderForBatchUpdateCdnConfigInput {
	s.RequestHeaderAction = v
	return s
}

type RequestHeaderInstanceForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Key *string `type:"string"`

	Value *string `type:"string"`

	ValueType *string `type:"string"`
}

// String returns the string representation
func (s RequestHeaderInstanceForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderInstanceForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RequestHeaderInstanceForBatchUpdateCdnConfigInput) SetAction(v string) *RequestHeaderInstanceForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *RequestHeaderInstanceForBatchUpdateCdnConfigInput) SetKey(v string) *RequestHeaderInstanceForBatchUpdateCdnConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RequestHeaderInstanceForBatchUpdateCdnConfigInput) SetValue(v string) *RequestHeaderInstanceForBatchUpdateCdnConfigInput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *RequestHeaderInstanceForBatchUpdateCdnConfigInput) SetValueType(v string) *RequestHeaderInstanceForBatchUpdateCdnConfigInput {
	s.ValueType = &v
	return s
}

type RequestHeaderRulesForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RequestHeaderComponents *RequestHeaderComponentsForBatchUpdateCdnConfigInput `type:"structure"`

	RequestHeaderInstances []*RequestHeaderInstanceForBatchUpdateCdnConfigInput `type:"list"`

	RequestHost *string `type:"string"`
}

// String returns the string representation
func (s RequestHeaderRulesForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderRulesForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRequestHeaderComponents sets the RequestHeaderComponents field's value.
func (s *RequestHeaderRulesForBatchUpdateCdnConfigInput) SetRequestHeaderComponents(v *RequestHeaderComponentsForBatchUpdateCdnConfigInput) *RequestHeaderRulesForBatchUpdateCdnConfigInput {
	s.RequestHeaderComponents = v
	return s
}

// SetRequestHeaderInstances sets the RequestHeaderInstances field's value.
func (s *RequestHeaderRulesForBatchUpdateCdnConfigInput) SetRequestHeaderInstances(v []*RequestHeaderInstanceForBatchUpdateCdnConfigInput) *RequestHeaderRulesForBatchUpdateCdnConfigInput {
	s.RequestHeaderInstances = v
	return s
}

// SetRequestHost sets the RequestHost field's value.
func (s *RequestHeaderRulesForBatchUpdateCdnConfigInput) SetRequestHost(v string) *RequestHeaderRulesForBatchUpdateCdnConfigInput {
	s.RequestHost = &v
	return s
}

type ResponseActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s ResponseActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *ResponseActionForBatchUpdateCdnConfigInput) SetStatusCode(v string) *ResponseActionForBatchUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type ResponseHeaderActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ResponseHeaderInstances []*ResponseHeaderInstanceForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s ResponseHeaderActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetResponseHeaderInstances sets the ResponseHeaderInstances field's value.
func (s *ResponseHeaderActionForBatchUpdateCdnConfigInput) SetResponseHeaderInstances(v []*ResponseHeaderInstanceForBatchUpdateCdnConfigInput) *ResponseHeaderActionForBatchUpdateCdnConfigInput {
	s.ResponseHeaderInstances = v
	return s
}

type ResponseHeaderForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	ResponseHeaderAction *ResponseHeaderActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s ResponseHeaderForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *ResponseHeaderForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *ResponseHeaderForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetResponseHeaderAction sets the ResponseHeaderAction field's value.
func (s *ResponseHeaderForBatchUpdateCdnConfigInput) SetResponseHeaderAction(v *ResponseHeaderActionForBatchUpdateCdnConfigInput) *ResponseHeaderForBatchUpdateCdnConfigInput {
	s.ResponseHeaderAction = v
	return s
}

type ResponseHeaderInstanceForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AccessOriginControl *bool `type:"boolean"`

	Action *string `type:"string"`

	Key *string `type:"string"`

	Value *string `type:"string"`

	ValueType *string `type:"string"`
}

// String returns the string representation
func (s ResponseHeaderInstanceForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderInstanceForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAccessOriginControl sets the AccessOriginControl field's value.
func (s *ResponseHeaderInstanceForBatchUpdateCdnConfigInput) SetAccessOriginControl(v bool) *ResponseHeaderInstanceForBatchUpdateCdnConfigInput {
	s.AccessOriginControl = &v
	return s
}

// SetAction sets the Action field's value.
func (s *ResponseHeaderInstanceForBatchUpdateCdnConfigInput) SetAction(v string) *ResponseHeaderInstanceForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ResponseHeaderInstanceForBatchUpdateCdnConfigInput) SetKey(v string) *ResponseHeaderInstanceForBatchUpdateCdnConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResponseHeaderInstanceForBatchUpdateCdnConfigInput) SetValue(v string) *ResponseHeaderInstanceForBatchUpdateCdnConfigInput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *ResponseHeaderInstanceForBatchUpdateCdnConfigInput) SetValueType(v string) *ResponseHeaderInstanceForBatchUpdateCdnConfigInput {
	s.ValueType = &v
	return s
}

type RewriteHLSForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	SignName *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RewriteHLSForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RewriteHLSForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSignName sets the SignName field's value.
func (s *RewriteHLSForBatchUpdateCdnConfigInput) SetSignName(v string) *RewriteHLSForBatchUpdateCdnConfigInput {
	s.SignName = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RewriteHLSForBatchUpdateCdnConfigInput) SetSwitch(v bool) *RewriteHLSForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RewriteM3u8RuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	DeleteParam *bool `type:"boolean"`

	KeepM3u8Param *bool `type:"boolean"`

	TransferEncoding *bool `type:"boolean"`
}

// String returns the string representation
func (s RewriteM3u8RuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RewriteM3u8RuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetDeleteParam sets the DeleteParam field's value.
func (s *RewriteM3u8RuleForBatchUpdateCdnConfigInput) SetDeleteParam(v bool) *RewriteM3u8RuleForBatchUpdateCdnConfigInput {
	s.DeleteParam = &v
	return s
}

// SetKeepM3u8Param sets the KeepM3u8Param field's value.
func (s *RewriteM3u8RuleForBatchUpdateCdnConfigInput) SetKeepM3u8Param(v bool) *RewriteM3u8RuleForBatchUpdateCdnConfigInput {
	s.KeepM3u8Param = &v
	return s
}

// SetTransferEncoding sets the TransferEncoding field's value.
func (s *RewriteM3u8RuleForBatchUpdateCdnConfigInput) SetTransferEncoding(v bool) *RewriteM3u8RuleForBatchUpdateCdnConfigInput {
	s.TransferEncoding = &v
	return s
}

type SharedConfigForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ConfigName *string `type:"string"`
}

// String returns the string representation
func (s SharedConfigForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedConfigForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetConfigName sets the ConfigName field's value.
func (s *SharedConfigForBatchUpdateCdnConfigInput) SetConfigName(v string) *SharedConfigForBatchUpdateCdnConfigInput {
	s.ConfigName = &v
	return s
}

type SignCapRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CapMode *string `type:"string"`

	ParamName *string `type:"string"`

	UriLevel *int64 `type:"int64"`
}

// String returns the string representation
func (s SignCapRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignCapRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCapMode sets the CapMode field's value.
func (s *SignCapRuleForBatchUpdateCdnConfigInput) SetCapMode(v string) *SignCapRuleForBatchUpdateCdnConfigInput {
	s.CapMode = &v
	return s
}

// SetParamName sets the ParamName field's value.
func (s *SignCapRuleForBatchUpdateCdnConfigInput) SetParamName(v string) *SignCapRuleForBatchUpdateCdnConfigInput {
	s.ParamName = &v
	return s
}

// SetUriLevel sets the UriLevel field's value.
func (s *SignCapRuleForBatchUpdateCdnConfigInput) SetUriLevel(v int64) *SignCapRuleForBatchUpdateCdnConfigInput {
	s.UriLevel = &v
	return s
}

type SignParamForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ParamType *string `type:"string"`

	RequestHeader *string `type:"string"`

	SupContent *string `type:"string"`

	UriParamSup *UriParamSupForBatchUpdateCdnConfigInput `type:"structure"`

	UrlParam *SignCapRuleForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s SignParamForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignParamForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetParamType sets the ParamType field's value.
func (s *SignParamForBatchUpdateCdnConfigInput) SetParamType(v string) *SignParamForBatchUpdateCdnConfigInput {
	s.ParamType = &v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *SignParamForBatchUpdateCdnConfigInput) SetRequestHeader(v string) *SignParamForBatchUpdateCdnConfigInput {
	s.RequestHeader = &v
	return s
}

// SetSupContent sets the SupContent field's value.
func (s *SignParamForBatchUpdateCdnConfigInput) SetSupContent(v string) *SignParamForBatchUpdateCdnConfigInput {
	s.SupContent = &v
	return s
}

// SetUriParamSup sets the UriParamSup field's value.
func (s *SignParamForBatchUpdateCdnConfigInput) SetUriParamSup(v *UriParamSupForBatchUpdateCdnConfigInput) *SignParamForBatchUpdateCdnConfigInput {
	s.UriParamSup = v
	return s
}

// SetUrlParam sets the UrlParam field's value.
func (s *SignParamForBatchUpdateCdnConfigInput) SetUrlParam(v *SignCapRuleForBatchUpdateCdnConfigInput) *SignParamForBatchUpdateCdnConfigInput {
	s.UrlParam = v
	return s
}

type SignedUrlAuthActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AuthAlgorithm *string `type:"string"`

	BackupSecretKey *string `type:"string"`

	CustomVariableRules *CustomVariableRulesForBatchUpdateCdnConfigInput `type:"structure"`

	Duration *int64 `type:"int64"`

	KeepOriginArg *bool `type:"boolean"`

	MasterSecretKey *string `type:"string"`

	MpdVarExpand *bool `type:"boolean"`

	RewriteM3u8 *bool `type:"boolean"`

	RewriteM3u8Rule *RewriteM3u8RuleForBatchUpdateCdnConfigInput `type:"structure"`

	RewriteMpd *bool `type:"boolean"`

	SignName *string `type:"string"`

	SignatureRule []*string `type:"list"`

	TimeFormat *string `type:"string"`

	TimeName *string `type:"string"`

	URLAuthType *string `type:"string"`

	UrlAuthCustomAction *UrlAuthCustomActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s SignedUrlAuthActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAuthAlgorithm sets the AuthAlgorithm field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetAuthAlgorithm(v string) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.AuthAlgorithm = &v
	return s
}

// SetBackupSecretKey sets the BackupSecretKey field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetBackupSecretKey(v string) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.BackupSecretKey = &v
	return s
}

// SetCustomVariableRules sets the CustomVariableRules field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetCustomVariableRules(v *CustomVariableRulesForBatchUpdateCdnConfigInput) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.CustomVariableRules = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetDuration(v int64) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.Duration = &v
	return s
}

// SetKeepOriginArg sets the KeepOriginArg field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetKeepOriginArg(v bool) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.KeepOriginArg = &v
	return s
}

// SetMasterSecretKey sets the MasterSecretKey field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetMasterSecretKey(v string) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.MasterSecretKey = &v
	return s
}

// SetMpdVarExpand sets the MpdVarExpand field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetMpdVarExpand(v bool) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.MpdVarExpand = &v
	return s
}

// SetRewriteM3u8 sets the RewriteM3u8 field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetRewriteM3u8(v bool) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.RewriteM3u8 = &v
	return s
}

// SetRewriteM3u8Rule sets the RewriteM3u8Rule field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetRewriteM3u8Rule(v *RewriteM3u8RuleForBatchUpdateCdnConfigInput) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.RewriteM3u8Rule = v
	return s
}

// SetRewriteMpd sets the RewriteMpd field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetRewriteMpd(v bool) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.RewriteMpd = &v
	return s
}

// SetSignName sets the SignName field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetSignName(v string) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.SignName = &v
	return s
}

// SetSignatureRule sets the SignatureRule field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetSignatureRule(v []*string) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.SignatureRule = v
	return s
}

// SetTimeFormat sets the TimeFormat field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetTimeFormat(v string) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.TimeFormat = &v
	return s
}

// SetTimeName sets the TimeName field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetTimeName(v string) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.TimeName = &v
	return s
}

// SetURLAuthType sets the URLAuthType field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetURLAuthType(v string) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.URLAuthType = &v
	return s
}

// SetUrlAuthCustomAction sets the UrlAuthCustomAction field's value.
func (s *SignedUrlAuthActionForBatchUpdateCdnConfigInput) SetUrlAuthCustomAction(v *UrlAuthCustomActionForBatchUpdateCdnConfigInput) *SignedUrlAuthActionForBatchUpdateCdnConfigInput {
	s.UrlAuthCustomAction = v
	return s
}

type SignedUrlAuthForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	SignedUrlAuthRules []*SignedUrlAuthRuleForBatchUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s SignedUrlAuthForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSignedUrlAuthRules sets the SignedUrlAuthRules field's value.
func (s *SignedUrlAuthForBatchUpdateCdnConfigInput) SetSignedUrlAuthRules(v []*SignedUrlAuthRuleForBatchUpdateCdnConfigInput) *SignedUrlAuthForBatchUpdateCdnConfigInput {
	s.SignedUrlAuthRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *SignedUrlAuthForBatchUpdateCdnConfigInput) SetSwitch(v bool) *SignedUrlAuthForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type SignedUrlAuthRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	SignedUrlAuthAction *SignedUrlAuthActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s SignedUrlAuthRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *SignedUrlAuthRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *SignedUrlAuthRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetSignedUrlAuthAction sets the SignedUrlAuthAction field's value.
func (s *SignedUrlAuthRuleForBatchUpdateCdnConfigInput) SetSignedUrlAuthAction(v *SignedUrlAuthActionForBatchUpdateCdnConfigInput) *SignedUrlAuthRuleForBatchUpdateCdnConfigInput {
	s.SignedUrlAuthAction = v
	return s
}

type SpeedLimitTimeForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BeginTime *string `type:"string"`

	DayWeek *string `type:"string"`

	EndTime *string `type:"string"`
}

// String returns the string representation
func (s SpeedLimitTimeForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SpeedLimitTimeForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBeginTime sets the BeginTime field's value.
func (s *SpeedLimitTimeForBatchUpdateCdnConfigInput) SetBeginTime(v string) *SpeedLimitTimeForBatchUpdateCdnConfigInput {
	s.BeginTime = &v
	return s
}

// SetDayWeek sets the DayWeek field's value.
func (s *SpeedLimitTimeForBatchUpdateCdnConfigInput) SetDayWeek(v string) *SpeedLimitTimeForBatchUpdateCdnConfigInput {
	s.DayWeek = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *SpeedLimitTimeForBatchUpdateCdnConfigInput) SetEndTime(v string) *SpeedLimitTimeForBatchUpdateCdnConfigInput {
	s.EndTime = &v
	return s
}

type StatusCodeActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	DefaultAction *string `type:"string"`

	FailCode *string `type:"string"`

	SuccessCode *string `type:"string"`
}

// String returns the string representation
func (s StatusCodeActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodeActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *StatusCodeActionForBatchUpdateCdnConfigInput) SetDefaultAction(v string) *StatusCodeActionForBatchUpdateCdnConfigInput {
	s.DefaultAction = &v
	return s
}

// SetFailCode sets the FailCode field's value.
func (s *StatusCodeActionForBatchUpdateCdnConfigInput) SetFailCode(v string) *StatusCodeActionForBatchUpdateCdnConfigInput {
	s.FailCode = &v
	return s
}

// SetSuccessCode sets the SuccessCode field's value.
func (s *StatusCodeActionForBatchUpdateCdnConfigInput) SetSuccessCode(v string) *StatusCodeActionForBatchUpdateCdnConfigInput {
	s.SuccessCode = &v
	return s
}

type TargetQueryComponentsForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TargetQueryComponentsForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetQueryComponentsForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *TargetQueryComponentsForBatchUpdateCdnConfigInput) SetAction(v string) *TargetQueryComponentsForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TargetQueryComponentsForBatchUpdateCdnConfigInput) SetValue(v string) *TargetQueryComponentsForBatchUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type TimeOutActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Time *int64 `type:"int64"`
}

// String returns the string representation
func (s TimeOutActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeOutActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *TimeOutActionForBatchUpdateCdnConfigInput) SetAction(v string) *TimeOutActionForBatchUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetTime sets the Time field's value.
func (s *TimeOutActionForBatchUpdateCdnConfigInput) SetTime(v int64) *TimeOutActionForBatchUpdateCdnConfigInput {
	s.Time = &v
	return s
}

type TimeoutForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`

	TimeoutRules []*TimeoutRuleForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s TimeoutForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeoutForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *TimeoutForBatchUpdateCdnConfigInput) SetSwitch(v bool) *TimeoutForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetTimeoutRules sets the TimeoutRules field's value.
func (s *TimeoutForBatchUpdateCdnConfigInput) SetTimeoutRules(v []*TimeoutRuleForBatchUpdateCdnConfigInput) *TimeoutForBatchUpdateCdnConfigInput {
	s.TimeoutRules = v
	return s
}

type TimeoutRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForBatchUpdateCdnConfigInput `type:"structure"`

	TimeoutAction *ConvertTimeoutActionForBatchUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s TimeoutRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeoutRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *TimeoutRuleForBatchUpdateCdnConfigInput) SetCondition(v *ConditionForBatchUpdateCdnConfigInput) *TimeoutRuleForBatchUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetTimeoutAction sets the TimeoutAction field's value.
func (s *TimeoutRuleForBatchUpdateCdnConfigInput) SetTimeoutAction(v *ConvertTimeoutActionForBatchUpdateCdnConfigInput) *TimeoutRuleForBatchUpdateCdnConfigInput {
	s.TimeoutAction = v
	return s
}

type TosAuthInformationForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AccessKeyId *string `type:"string"`

	AccessKeySecret *string `type:"string"`

	AccountKey *string `type:"string"`
}

// String returns the string representation
func (s TosAuthInformationForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosAuthInformationForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *TosAuthInformationForBatchUpdateCdnConfigInput) SetAccessKeyId(v string) *TosAuthInformationForBatchUpdateCdnConfigInput {
	s.AccessKeyId = &v
	return s
}

// SetAccessKeySecret sets the AccessKeySecret field's value.
func (s *TosAuthInformationForBatchUpdateCdnConfigInput) SetAccessKeySecret(v string) *TosAuthInformationForBatchUpdateCdnConfigInput {
	s.AccessKeySecret = &v
	return s
}

// SetAccountKey sets the AccountKey field's value.
func (s *TosAuthInformationForBatchUpdateCdnConfigInput) SetAccountKey(v string) *TosAuthInformationForBatchUpdateCdnConfigInput {
	s.AccountKey = &v
	return s
}

type UaAccessRuleForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	IgnoreCase *bool `type:"boolean"`

	RuleType *string `type:"string"`

	Switch *bool `type:"boolean"`

	UserAgent []*string `type:"list"`
}

// String returns the string representation
func (s UaAccessRuleForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UaAccessRuleForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *UaAccessRuleForBatchUpdateCdnConfigInput) SetAllowEmpty(v bool) *UaAccessRuleForBatchUpdateCdnConfigInput {
	s.AllowEmpty = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *UaAccessRuleForBatchUpdateCdnConfigInput) SetIgnoreCase(v bool) *UaAccessRuleForBatchUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *UaAccessRuleForBatchUpdateCdnConfigInput) SetRuleType(v string) *UaAccessRuleForBatchUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *UaAccessRuleForBatchUpdateCdnConfigInput) SetSwitch(v bool) *UaAccessRuleForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetUserAgent sets the UserAgent field's value.
func (s *UaAccessRuleForBatchUpdateCdnConfigInput) SetUserAgent(v []*string) *UaAccessRuleForBatchUpdateCdnConfigInput {
	s.UserAgent = v
	return s
}

type UriParamSupForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	JoinSymbol *string `type:"string"`

	SplitSymbol *string `type:"string"`

	StartLevel *int64 `type:"int64"`

	TermLevel *int64 `type:"int64"`
}

// String returns the string representation
func (s UriParamSupForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UriParamSupForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetJoinSymbol sets the JoinSymbol field's value.
func (s *UriParamSupForBatchUpdateCdnConfigInput) SetJoinSymbol(v string) *UriParamSupForBatchUpdateCdnConfigInput {
	s.JoinSymbol = &v
	return s
}

// SetSplitSymbol sets the SplitSymbol field's value.
func (s *UriParamSupForBatchUpdateCdnConfigInput) SetSplitSymbol(v string) *UriParamSupForBatchUpdateCdnConfigInput {
	s.SplitSymbol = &v
	return s
}

// SetStartLevel sets the StartLevel field's value.
func (s *UriParamSupForBatchUpdateCdnConfigInput) SetStartLevel(v int64) *UriParamSupForBatchUpdateCdnConfigInput {
	s.StartLevel = &v
	return s
}

// SetTermLevel sets the TermLevel field's value.
func (s *UriParamSupForBatchUpdateCdnConfigInput) SetTermLevel(v int64) *UriParamSupForBatchUpdateCdnConfigInput {
	s.TermLevel = &v
	return s
}

type UrlAuthCustomActionForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ExpTimeCapRule *ExpTimeCapRuleForBatchUpdateCdnConfigInput `type:"structure"`

	ParamCalRules []*string `type:"list"`

	SignCapRule *SignCapRuleForBatchUpdateCdnConfigInput `type:"structure"`

	SignJoinSymbol *string `type:"string"`

	SignParam []*SignParamForBatchUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s UrlAuthCustomActionForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlAuthCustomActionForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetExpTimeCapRule sets the ExpTimeCapRule field's value.
func (s *UrlAuthCustomActionForBatchUpdateCdnConfigInput) SetExpTimeCapRule(v *ExpTimeCapRuleForBatchUpdateCdnConfigInput) *UrlAuthCustomActionForBatchUpdateCdnConfigInput {
	s.ExpTimeCapRule = v
	return s
}

// SetParamCalRules sets the ParamCalRules field's value.
func (s *UrlAuthCustomActionForBatchUpdateCdnConfigInput) SetParamCalRules(v []*string) *UrlAuthCustomActionForBatchUpdateCdnConfigInput {
	s.ParamCalRules = v
	return s
}

// SetSignCapRule sets the SignCapRule field's value.
func (s *UrlAuthCustomActionForBatchUpdateCdnConfigInput) SetSignCapRule(v *SignCapRuleForBatchUpdateCdnConfigInput) *UrlAuthCustomActionForBatchUpdateCdnConfigInput {
	s.SignCapRule = v
	return s
}

// SetSignJoinSymbol sets the SignJoinSymbol field's value.
func (s *UrlAuthCustomActionForBatchUpdateCdnConfigInput) SetSignJoinSymbol(v string) *UrlAuthCustomActionForBatchUpdateCdnConfigInput {
	s.SignJoinSymbol = &v
	return s
}

// SetSignParam sets the SignParam field's value.
func (s *UrlAuthCustomActionForBatchUpdateCdnConfigInput) SetSignParam(v []*SignParamForBatchUpdateCdnConfigInput) *UrlAuthCustomActionForBatchUpdateCdnConfigInput {
	s.SignParam = v
	return s
}

type UrlNormalizeForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	NormalizeObject []*string `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s UrlNormalizeForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlNormalizeForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetNormalizeObject sets the NormalizeObject field's value.
func (s *UrlNormalizeForBatchUpdateCdnConfigInput) SetNormalizeObject(v []*string) *UrlNormalizeForBatchUpdateCdnConfigInput {
	s.NormalizeObject = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *UrlNormalizeForBatchUpdateCdnConfigInput) SetSwitch(v bool) *UrlNormalizeForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type VideoDragForBatchUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s VideoDragForBatchUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoDragForBatchUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *VideoDragForBatchUpdateCdnConfigInput) SetSwitch(v bool) *VideoDragForBatchUpdateCdnConfigInput {
	s.Switch = &v
	return s
}
