// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package alb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateServerGroupCommon = "CreateServerGroup"

// CreateServerGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateServerGroupCommon operation. The "output" return
// value will be populated with the CreateServerGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateServerGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateServerGroupCommon Send returns without error.
//
// See CreateServerGroupCommon for more information on using the CreateServerGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateServerGroupCommonRequest method.
//    req, resp := client.CreateServerGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CreateServerGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateServerGroupCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateServerGroupCommon API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CreateServerGroupCommon for usage and error information.
func (c *ALB) CreateServerGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateServerGroupCommonRequest(input)
	return out, req.Send()
}

// CreateServerGroupCommonWithContext is the same as CreateServerGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServerGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CreateServerGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateServerGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServerGroup = "CreateServerGroup"

// CreateServerGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateServerGroup operation. The "output" return
// value will be populated with the CreateServerGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateServerGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateServerGroupCommon Send returns without error.
//
// See CreateServerGroup for more information on using the CreateServerGroup
// API call, and error handling.
//
//    // Example sending a request using the CreateServerGroupRequest method.
//    req, resp := client.CreateServerGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CreateServerGroupRequest(input *CreateServerGroupInput) (req *request.Request, output *CreateServerGroupOutput) {
	op := &request.Operation{
		Name:       opCreateServerGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServerGroupInput{}
	}

	output = &CreateServerGroupOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateServerGroup API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CreateServerGroup for usage and error information.
func (c *ALB) CreateServerGroup(input *CreateServerGroupInput) (*CreateServerGroupOutput, error) {
	req, out := c.CreateServerGroupRequest(input)
	return out, req.Send()
}

// CreateServerGroupWithContext is the same as CreateServerGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServerGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CreateServerGroupWithContext(ctx volcengine.Context, input *CreateServerGroupInput, opts ...request.Option) (*CreateServerGroupOutput, error) {
	req, out := c.CreateServerGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateServerGroupInput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	HealthCheck *HealthCheckForCreateServerGroupInput `type:"structure"`

	ProjectName *string `type:"string"`

	Protocol *string `type:"string"`

	Scheduler *string `type:"string"`

	ServerGroupName *string `min:"1" max:"128" type:"string"`

	ServerGroupType *string `type:"string"`

	StickySessionConfig *StickySessionConfigForCreateServerGroupInput `type:"structure"`

	Tags []*TagForCreateServerGroupInput `type:"list"`

	VpcId *string `type:"string"`
}

// String returns the string representation
func (s CreateServerGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServerGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServerGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServerGroupInput"}
	if s.ServerGroupName != nil && len(*s.ServerGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerGroupName", 1))
	}
	if s.ServerGroupName != nil && len(*s.ServerGroupName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("ServerGroupName", 128, *s.ServerGroupName))
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateServerGroupInput) SetDescription(v string) *CreateServerGroupInput {
	s.Description = &v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *CreateServerGroupInput) SetHealthCheck(v *HealthCheckForCreateServerGroupInput) *CreateServerGroupInput {
	s.HealthCheck = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateServerGroupInput) SetProjectName(v string) *CreateServerGroupInput {
	s.ProjectName = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateServerGroupInput) SetProtocol(v string) *CreateServerGroupInput {
	s.Protocol = &v
	return s
}

// SetScheduler sets the Scheduler field's value.
func (s *CreateServerGroupInput) SetScheduler(v string) *CreateServerGroupInput {
	s.Scheduler = &v
	return s
}

// SetServerGroupName sets the ServerGroupName field's value.
func (s *CreateServerGroupInput) SetServerGroupName(v string) *CreateServerGroupInput {
	s.ServerGroupName = &v
	return s
}

// SetServerGroupType sets the ServerGroupType field's value.
func (s *CreateServerGroupInput) SetServerGroupType(v string) *CreateServerGroupInput {
	s.ServerGroupType = &v
	return s
}

// SetStickySessionConfig sets the StickySessionConfig field's value.
func (s *CreateServerGroupInput) SetStickySessionConfig(v *StickySessionConfigForCreateServerGroupInput) *CreateServerGroupInput {
	s.StickySessionConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServerGroupInput) SetTags(v []*TagForCreateServerGroupInput) *CreateServerGroupInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateServerGroupInput) SetVpcId(v string) *CreateServerGroupInput {
	s.VpcId = &v
	return s
}

type CreateServerGroupOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`

	ServerGroupId *string `type:"string"`
}

// String returns the string representation
func (s CreateServerGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServerGroupOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateServerGroupOutput) SetRequestId(v string) *CreateServerGroupOutput {
	s.RequestId = &v
	return s
}

// SetServerGroupId sets the ServerGroupId field's value.
func (s *CreateServerGroupOutput) SetServerGroupId(v string) *CreateServerGroupOutput {
	s.ServerGroupId = &v
	return s
}

type HealthCheckForCreateServerGroupInput struct {
	_ struct{} `type:"structure"`

	Domain *string `type:"string"`

	Enabled *string `type:"string"`

	HealthyThreshold *string `type:"string"`

	HttpCode *string `type:"string"`

	HttpVersion *string `type:"string"`

	Interval *string `type:"string"`

	Method *string `type:"string"`

	// Port is a required field
	Port *int64 `max:"65535" type:"integer" required:"true"`

	Protocol *string `type:"string"`

	Timeout *string `type:"string"`

	URI *string `type:"string"`

	UnhealthyThreshold *string `type:"string"`
}

// String returns the string representation
func (s HealthCheckForCreateServerGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckForCreateServerGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckForCreateServerGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckForCreateServerGroupInput"}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port > 65535 {
		invalidParams.Add(request.NewErrParamMaxValue("Port", 65535))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *HealthCheckForCreateServerGroupInput) SetDomain(v string) *HealthCheckForCreateServerGroupInput {
	s.Domain = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *HealthCheckForCreateServerGroupInput) SetEnabled(v string) *HealthCheckForCreateServerGroupInput {
	s.Enabled = &v
	return s
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *HealthCheckForCreateServerGroupInput) SetHealthyThreshold(v string) *HealthCheckForCreateServerGroupInput {
	s.HealthyThreshold = &v
	return s
}

// SetHttpCode sets the HttpCode field's value.
func (s *HealthCheckForCreateServerGroupInput) SetHttpCode(v string) *HealthCheckForCreateServerGroupInput {
	s.HttpCode = &v
	return s
}

// SetHttpVersion sets the HttpVersion field's value.
func (s *HealthCheckForCreateServerGroupInput) SetHttpVersion(v string) *HealthCheckForCreateServerGroupInput {
	s.HttpVersion = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *HealthCheckForCreateServerGroupInput) SetInterval(v string) *HealthCheckForCreateServerGroupInput {
	s.Interval = &v
	return s
}

// SetMethod sets the Method field's value.
func (s *HealthCheckForCreateServerGroupInput) SetMethod(v string) *HealthCheckForCreateServerGroupInput {
	s.Method = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HealthCheckForCreateServerGroupInput) SetPort(v int64) *HealthCheckForCreateServerGroupInput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *HealthCheckForCreateServerGroupInput) SetProtocol(v string) *HealthCheckForCreateServerGroupInput {
	s.Protocol = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *HealthCheckForCreateServerGroupInput) SetTimeout(v string) *HealthCheckForCreateServerGroupInput {
	s.Timeout = &v
	return s
}

// SetURI sets the URI field's value.
func (s *HealthCheckForCreateServerGroupInput) SetURI(v string) *HealthCheckForCreateServerGroupInput {
	s.URI = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *HealthCheckForCreateServerGroupInput) SetUnhealthyThreshold(v string) *HealthCheckForCreateServerGroupInput {
	s.UnhealthyThreshold = &v
	return s
}

type StickySessionConfigForCreateServerGroupInput struct {
	_ struct{} `type:"structure"`

	Cookie *string `type:"string"`

	CookieTimeout *string `type:"string"`

	StickySessionEnabled *string `type:"string"`

	StickySessionType *string `type:"string"`
}

// String returns the string representation
func (s StickySessionConfigForCreateServerGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StickySessionConfigForCreateServerGroupInput) GoString() string {
	return s.String()
}

// SetCookie sets the Cookie field's value.
func (s *StickySessionConfigForCreateServerGroupInput) SetCookie(v string) *StickySessionConfigForCreateServerGroupInput {
	s.Cookie = &v
	return s
}

// SetCookieTimeout sets the CookieTimeout field's value.
func (s *StickySessionConfigForCreateServerGroupInput) SetCookieTimeout(v string) *StickySessionConfigForCreateServerGroupInput {
	s.CookieTimeout = &v
	return s
}

// SetStickySessionEnabled sets the StickySessionEnabled field's value.
func (s *StickySessionConfigForCreateServerGroupInput) SetStickySessionEnabled(v string) *StickySessionConfigForCreateServerGroupInput {
	s.StickySessionEnabled = &v
	return s
}

// SetStickySessionType sets the StickySessionType field's value.
func (s *StickySessionConfigForCreateServerGroupInput) SetStickySessionType(v string) *StickySessionConfigForCreateServerGroupInput {
	s.StickySessionType = &v
	return s
}

type TagForCreateServerGroupInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateServerGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateServerGroupInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateServerGroupInput) SetKey(v string) *TagForCreateServerGroupInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateServerGroupInput) SetValue(v string) *TagForCreateServerGroupInput {
	s.Value = &v
	return s
}
