// Example Code generated by Beijing Volcanoengine Technology.
package autoscalingexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/autoscaling"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateScalingPolicy() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := autoscaling.New(sess)
	reqScheduledPolicy := &autoscaling.ScheduledPolicyForCreateScalingPolicyInput{
		LaunchTime: volcengine.String("2022-04-01T16:00Z"),
	}
	createScalingPolicyInput := &autoscaling.CreateScalingPolicyInput{
		AdjustmentType:    volcengine.String("QuantityChangeInCapacity"),
		AdjustmentValue:   volcengine.Int32(12),
		ScalingGroupId:    volcengine.String("scg-ybmssdnnhn5pkgyd****"),
		ScalingPolicyName: volcengine.String("test-policy"),
		ScalingPolicyType: volcengine.String("Scheduled"),
		ScheduledPolicy:   reqScheduledPolicy,
	}

	resp, err := svc.CreateScalingPolicy(createScalingPolicyInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
