---
title: Getting Started with Pinniped
cascade:
  layout: docs
menu:
  docs:
    name: Overview
    weight: 1
---

Pinniped is an authentication service for Kubernetes clusters.
As a Kubernetes cluster administrator or user, you can learn how Pinniped works, see how to use it on your clusters, and
dive into internals of Pinniped's APIs and architecture.

Have a question, comment, or idea? Please reach out via
[GitHub Issues](https://github.com/vmware-tanzu/pinniped/issues),
[GitHub Discussions](https://github.com/vmware-tanzu/pinniped/discussions),
or [join the Pinniped community]({{< ref "/community" >}}).

## New to Pinniped?

- ⚠️ **Start here:**
  - [Learn to use Pinniped for federated authentication to Kubernetes clusters in a production-like environment]({{< ref "tutorials/concierge-and-supervisor-demo" >}})
  - Or, [try Pinniped on your local computer in a demo-like environment]({{< ref "tutorials/local-concierge-and-supervisor-demo" >}})

## Background

{{< docsmenu "background" >}}

## Tutorials

{{< docsmenu "tutorials" >}}

## How-to guides

{{< docsmenu "howtos" >}}


## Concierge Configuration

{{< docsmenu "howto-configure-concierge" >}}


## Supervisor Configuration

{{< docsmenu "howto-configure-supervisor" >}}

## Reference

{{< docsmenu "reference" >}}
