// Copyright 2020-2024 the Pinniped contributors. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1alpha1 "go.pinniped.dev/generated/latest/apis/supervisor/config/v1alpha1"
	scheme "go.pinniped.dev/generated/latest/client/supervisor/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// OIDCClientsGetter has a method to return a OIDCClientInterface.
// A group's client should implement this interface.
type OIDCClientsGetter interface {
	OIDCClients(namespace string) OIDCClientInterface
}

// OIDCClientInterface has methods to work with OIDCClient resources.
type OIDCClientInterface interface {
	Create(ctx context.Context, oIDCClient *v1alpha1.OIDCClient, opts v1.CreateOptions) (*v1alpha1.OIDCClient, error)
	Update(ctx context.Context, oIDCClient *v1alpha1.OIDCClient, opts v1.UpdateOptions) (*v1alpha1.OIDCClient, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, oIDCClient *v1alpha1.OIDCClient, opts v1.UpdateOptions) (*v1alpha1.OIDCClient, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.OIDCClient, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.OIDCClientList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.OIDCClient, err error)
	OIDCClientExpansion
}

// oIDCClients implements OIDCClientInterface
type oIDCClients struct {
	*gentype.ClientWithList[*v1alpha1.OIDCClient, *v1alpha1.OIDCClientList]
}

// newOIDCClients returns a OIDCClients
func newOIDCClients(c *ConfigV1alpha1Client, namespace string) *oIDCClients {
	return &oIDCClients{
		gentype.NewClientWithList[*v1alpha1.OIDCClient, *v1alpha1.OIDCClientList](
			"oidcclients",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1alpha1.OIDCClient { return &v1alpha1.OIDCClient{} },
			func() *v1alpha1.OIDCClientList { return &v1alpha1.OIDCClientList{} }),
	}
}
