// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package datamigration

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/datamigration/mgmt/2018-04-19/datamigration"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AuthenticationType = original.AuthenticationType

const (
	ActiveDirectoryIntegrated AuthenticationType = original.ActiveDirectoryIntegrated
	ActiveDirectoryPassword   AuthenticationType = original.ActiveDirectoryPassword
	None                      AuthenticationType = original.None
	SQLAuthentication         AuthenticationType = original.SQLAuthentication
	WindowsAuthentication     AuthenticationType = original.WindowsAuthentication
)

type BackupFileStatus = original.BackupFileStatus

const (
	Arrived   BackupFileStatus = original.Arrived
	Cancelled BackupFileStatus = original.Cancelled
	Queued    BackupFileStatus = original.Queued
	Restored  BackupFileStatus = original.Restored
	Restoring BackupFileStatus = original.Restoring
	Uploaded  BackupFileStatus = original.Uploaded
	Uploading BackupFileStatus = original.Uploading
)

type BackupMode = original.BackupMode

const (
	CreateBackup   BackupMode = original.CreateBackup
	ExistingBackup BackupMode = original.ExistingBackup
)

type BackupType = original.BackupType

const (
	BackupTypeDatabase             BackupType = original.BackupTypeDatabase
	BackupTypeDifferentialDatabase BackupType = original.BackupTypeDifferentialDatabase
	BackupTypeDifferentialFile     BackupType = original.BackupTypeDifferentialFile
	BackupTypeDifferentialPartial  BackupType = original.BackupTypeDifferentialPartial
	BackupTypeFile                 BackupType = original.BackupTypeFile
	BackupTypePartial              BackupType = original.BackupTypePartial
	BackupTypeTransactionLog       BackupType = original.BackupTypeTransactionLog
)

type CommandState = original.CommandState

const (
	Accepted  CommandState = original.Accepted
	Failed    CommandState = original.Failed
	Running   CommandState = original.Running
	Succeeded CommandState = original.Succeeded
	Unknown   CommandState = original.Unknown
)

type CommandType = original.CommandType

const (
	CommandTypeCommandProperties                    CommandType = original.CommandTypeCommandProperties
	CommandTypeMigrateSQLServerAzureDbSQLMiComplete CommandType = original.CommandTypeMigrateSQLServerAzureDbSQLMiComplete
	CommandTypeMigrateSyncCompleteDatabase          CommandType = original.CommandTypeMigrateSyncCompleteDatabase
)

type DatabaseCompatLevel = original.DatabaseCompatLevel

const (
	CompatLevel100 DatabaseCompatLevel = original.CompatLevel100
	CompatLevel110 DatabaseCompatLevel = original.CompatLevel110
	CompatLevel120 DatabaseCompatLevel = original.CompatLevel120
	CompatLevel130 DatabaseCompatLevel = original.CompatLevel130
	CompatLevel140 DatabaseCompatLevel = original.CompatLevel140
	CompatLevel80  DatabaseCompatLevel = original.CompatLevel80
	CompatLevel90  DatabaseCompatLevel = original.CompatLevel90
)

type DatabaseFileType = original.DatabaseFileType

const (
	Filestream   DatabaseFileType = original.Filestream
	Fulltext     DatabaseFileType = original.Fulltext
	Log          DatabaseFileType = original.Log
	NotSupported DatabaseFileType = original.NotSupported
	Rows         DatabaseFileType = original.Rows
)

type DatabaseMigrationStage = original.DatabaseMigrationStage

const (
	DatabaseMigrationStageBackup     DatabaseMigrationStage = original.DatabaseMigrationStageBackup
	DatabaseMigrationStageCompleted  DatabaseMigrationStage = original.DatabaseMigrationStageCompleted
	DatabaseMigrationStageFileCopy   DatabaseMigrationStage = original.DatabaseMigrationStageFileCopy
	DatabaseMigrationStageInitialize DatabaseMigrationStage = original.DatabaseMigrationStageInitialize
	DatabaseMigrationStageNone       DatabaseMigrationStage = original.DatabaseMigrationStageNone
	DatabaseMigrationStageRestore    DatabaseMigrationStage = original.DatabaseMigrationStageRestore
)

type DatabaseMigrationState = original.DatabaseMigrationState

const (
	CANCELLED             DatabaseMigrationState = original.CANCELLED
	COMPLETED             DatabaseMigrationState = original.COMPLETED
	CUTOVERSTART          DatabaseMigrationState = original.CUTOVERSTART
	FAILED                DatabaseMigrationState = original.FAILED
	FULLBACKUPUPLOADSTART DatabaseMigrationState = original.FULLBACKUPUPLOADSTART
	INITIAL               DatabaseMigrationState = original.INITIAL
	LOGSHIPPINGSTART      DatabaseMigrationState = original.LOGSHIPPINGSTART
	POSTCUTOVERCOMPLETE   DatabaseMigrationState = original.POSTCUTOVERCOMPLETE
	UNDEFINED             DatabaseMigrationState = original.UNDEFINED
	UPLOADLOGFILESSTART   DatabaseMigrationState = original.UPLOADLOGFILESSTART
)

type DatabaseState = original.DatabaseState

const (
	DatabaseStateCopying          DatabaseState = original.DatabaseStateCopying
	DatabaseStateEmergency        DatabaseState = original.DatabaseStateEmergency
	DatabaseStateOffline          DatabaseState = original.DatabaseStateOffline
	DatabaseStateOfflineSecondary DatabaseState = original.DatabaseStateOfflineSecondary
	DatabaseStateOnline           DatabaseState = original.DatabaseStateOnline
	DatabaseStateRecovering       DatabaseState = original.DatabaseStateRecovering
	DatabaseStateRecoveryPending  DatabaseState = original.DatabaseStateRecoveryPending
	DatabaseStateRestoring        DatabaseState = original.DatabaseStateRestoring
	DatabaseStateSuspect          DatabaseState = original.DatabaseStateSuspect
)

type ErrorType = original.ErrorType

const (
	ErrorTypeDefault ErrorType = original.ErrorTypeDefault
	ErrorTypeError   ErrorType = original.ErrorTypeError
	ErrorTypeWarning ErrorType = original.ErrorTypeWarning
)

type LoginMigrationStage = original.LoginMigrationStage

const (
	LoginMigrationStageAssignRoleMembership       LoginMigrationStage = original.LoginMigrationStageAssignRoleMembership
	LoginMigrationStageAssignRoleOwnership        LoginMigrationStage = original.LoginMigrationStageAssignRoleOwnership
	LoginMigrationStageCompleted                  LoginMigrationStage = original.LoginMigrationStageCompleted
	LoginMigrationStageEstablishObjectPermissions LoginMigrationStage = original.LoginMigrationStageEstablishObjectPermissions
	LoginMigrationStageEstablishServerPermissions LoginMigrationStage = original.LoginMigrationStageEstablishServerPermissions
	LoginMigrationStageEstablishUserMapping       LoginMigrationStage = original.LoginMigrationStageEstablishUserMapping
	LoginMigrationStageInitialize                 LoginMigrationStage = original.LoginMigrationStageInitialize
	LoginMigrationStageLoginMigration             LoginMigrationStage = original.LoginMigrationStageLoginMigration
	LoginMigrationStageNone                       LoginMigrationStage = original.LoginMigrationStageNone
)

type LoginType = original.LoginType

const (
	AsymmetricKey LoginType = original.AsymmetricKey
	Certificate   LoginType = original.Certificate
	ExternalGroup LoginType = original.ExternalGroup
	ExternalUser  LoginType = original.ExternalUser
	SQLLogin      LoginType = original.SQLLogin
	WindowsGroup  LoginType = original.WindowsGroup
	WindowsUser   LoginType = original.WindowsUser
)

type MigrationState = original.MigrationState

const (
	MigrationStateCompleted  MigrationState = original.MigrationStateCompleted
	MigrationStateFailed     MigrationState = original.MigrationStateFailed
	MigrationStateInProgress MigrationState = original.MigrationStateInProgress
	MigrationStateNone       MigrationState = original.MigrationStateNone
	MigrationStateSkipped    MigrationState = original.MigrationStateSkipped
	MigrationStateStopped    MigrationState = original.MigrationStateStopped
	MigrationStateWarning    MigrationState = original.MigrationStateWarning
)

type MigrationStatus = original.MigrationStatus

const (
	MigrationStatusCompleted               MigrationStatus = original.MigrationStatusCompleted
	MigrationStatusCompletedWithWarnings   MigrationStatus = original.MigrationStatusCompletedWithWarnings
	MigrationStatusConfigured              MigrationStatus = original.MigrationStatusConfigured
	MigrationStatusConnecting              MigrationStatus = original.MigrationStatusConnecting
	MigrationStatusDefault                 MigrationStatus = original.MigrationStatusDefault
	MigrationStatusError                   MigrationStatus = original.MigrationStatusError
	MigrationStatusRunning                 MigrationStatus = original.MigrationStatusRunning
	MigrationStatusSelectLogins            MigrationStatus = original.MigrationStatusSelectLogins
	MigrationStatusSourceAndTargetSelected MigrationStatus = original.MigrationStatusSourceAndTargetSelected
	MigrationStatusStopped                 MigrationStatus = original.MigrationStatusStopped
)

type MySQLTargetPlatformType = original.MySQLTargetPlatformType

const (
	AzureDbForMySQL MySQLTargetPlatformType = original.AzureDbForMySQL
	SQLServer       MySQLTargetPlatformType = original.SQLServer
)

type NameCheckFailureReason = original.NameCheckFailureReason

const (
	AlreadyExists NameCheckFailureReason = original.AlreadyExists
	Invalid       NameCheckFailureReason = original.Invalid
)

type ObjectType = original.ObjectType

const (
	Function         ObjectType = original.Function
	StoredProcedures ObjectType = original.StoredProcedures
	Table            ObjectType = original.Table
	User             ObjectType = original.User
	View             ObjectType = original.View
)

type ProjectProvisioningState = original.ProjectProvisioningState

const (
	ProjectProvisioningStateDeleting  ProjectProvisioningState = original.ProjectProvisioningStateDeleting
	ProjectProvisioningStateSucceeded ProjectProvisioningState = original.ProjectProvisioningStateSucceeded
)

type ProjectSourcePlatform = original.ProjectSourcePlatform

const (
	ProjectSourcePlatformSQL     ProjectSourcePlatform = original.ProjectSourcePlatformSQL
	ProjectSourcePlatformUnknown ProjectSourcePlatform = original.ProjectSourcePlatformUnknown
)

type ProjectTargetPlatform = original.ProjectTargetPlatform

const (
	ProjectTargetPlatformSQLDB   ProjectTargetPlatform = original.ProjectTargetPlatformSQLDB
	ProjectTargetPlatformUnknown ProjectTargetPlatform = original.ProjectTargetPlatformUnknown
)

type ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleType

const (
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeAutomatic
	ResourceSkuCapacityScaleTypeManual    ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeManual
	ResourceSkuCapacityScaleTypeNone      ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeNone
)

type ResourceSkuRestrictionsReasonCode = original.ResourceSkuRestrictionsReasonCode

const (
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = original.NotAvailableForSubscription
	QuotaID                     ResourceSkuRestrictionsReasonCode = original.QuotaID
)

type ResourceSkuRestrictionsType = original.ResourceSkuRestrictionsType

const (
	Location ResourceSkuRestrictionsType = original.Location
)

type ResultCode = original.ResultCode

const (
	Completed                  ResultCode = original.Completed
	FatalError                 ResultCode = original.FatalError
	Initial                    ResultCode = original.Initial
	ObjectNotExistsInSource    ResultCode = original.ObjectNotExistsInSource
	ObjectNotExistsInTarget    ResultCode = original.ObjectNotExistsInTarget
	TargetObjectIsInaccessible ResultCode = original.TargetObjectIsInaccessible
)

type ResultType = original.ResultType

const (
	ResultTypeDatabaseLevelErrorOutput                            ResultType = original.ResultTypeDatabaseLevelErrorOutput
	ResultTypeDatabaseLevelOutput                                 ResultType = original.ResultTypeDatabaseLevelOutput
	ResultTypeErrorOutput                                         ResultType = original.ResultTypeErrorOutput
	ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput ResultType = original.ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
	ResultTypeMigrationLevelOutput                                ResultType = original.ResultTypeMigrationLevelOutput
	ResultTypeTableLevelOutput                                    ResultType = original.ResultTypeTableLevelOutput
)

type ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutput

const (
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput                ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput                ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput                   ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput                    ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput
)

type ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput

const (
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput                  ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput                       ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput                               ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput                      ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput                          ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput
)

type ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput

const (
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput            ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput                 ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput                         ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput                ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput                    ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput
)

type ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutput

const (
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput                    ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput                            ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput        ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput                   ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput              ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput                       ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput
)

type ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput

const (
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput                 ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput                         ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput                ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput
)

type ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutput

const (
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput             ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput             ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput                     ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput                ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput            ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput
)

type SQLSourcePlatform = original.SQLSourcePlatform

const (
	SQLOnPrem SQLSourcePlatform = original.SQLOnPrem
)

type SchemaMigrationStage = original.SchemaMigrationStage

const (
	SchemaMigrationStageCollectingObjects     SchemaMigrationStage = original.SchemaMigrationStageCollectingObjects
	SchemaMigrationStageCompleted             SchemaMigrationStage = original.SchemaMigrationStageCompleted
	SchemaMigrationStageCompletedWithWarnings SchemaMigrationStage = original.SchemaMigrationStageCompletedWithWarnings
	SchemaMigrationStageDeployingSchema       SchemaMigrationStage = original.SchemaMigrationStageDeployingSchema
	SchemaMigrationStageDownloadingScript     SchemaMigrationStage = original.SchemaMigrationStageDownloadingScript
	SchemaMigrationStageFailed                SchemaMigrationStage = original.SchemaMigrationStageFailed
	SchemaMigrationStageGeneratingScript      SchemaMigrationStage = original.SchemaMigrationStageGeneratingScript
	SchemaMigrationStageNotStarted            SchemaMigrationStage = original.SchemaMigrationStageNotStarted
	SchemaMigrationStageUploadingScript       SchemaMigrationStage = original.SchemaMigrationStageUploadingScript
	SchemaMigrationStageValidatingInputs      SchemaMigrationStage = original.SchemaMigrationStageValidatingInputs
)

type ServerLevelPermissionsGroup = original.ServerLevelPermissionsGroup

const (
	Default                             ServerLevelPermissionsGroup = original.Default
	MigrationFromMySQLToAzureDBForMySQL ServerLevelPermissionsGroup = original.MigrationFromMySQLToAzureDBForMySQL
	MigrationFromSQLServerToAzureDB     ServerLevelPermissionsGroup = original.MigrationFromSQLServerToAzureDB
	MigrationFromSQLServerToAzureMI     ServerLevelPermissionsGroup = original.MigrationFromSQLServerToAzureMI
)

type ServiceProvisioningState = original.ServiceProvisioningState

const (
	ServiceProvisioningStateAccepted      ServiceProvisioningState = original.ServiceProvisioningStateAccepted
	ServiceProvisioningStateDeleting      ServiceProvisioningState = original.ServiceProvisioningStateDeleting
	ServiceProvisioningStateDeploying     ServiceProvisioningState = original.ServiceProvisioningStateDeploying
	ServiceProvisioningStateFailed        ServiceProvisioningState = original.ServiceProvisioningStateFailed
	ServiceProvisioningStateFailedToStart ServiceProvisioningState = original.ServiceProvisioningStateFailedToStart
	ServiceProvisioningStateFailedToStop  ServiceProvisioningState = original.ServiceProvisioningStateFailedToStop
	ServiceProvisioningStateStarting      ServiceProvisioningState = original.ServiceProvisioningStateStarting
	ServiceProvisioningStateStopped       ServiceProvisioningState = original.ServiceProvisioningStateStopped
	ServiceProvisioningStateStopping      ServiceProvisioningState = original.ServiceProvisioningStateStopping
	ServiceProvisioningStateSucceeded     ServiceProvisioningState = original.ServiceProvisioningStateSucceeded
)

type ServiceScalability = original.ServiceScalability

const (
	ServiceScalabilityAutomatic ServiceScalability = original.ServiceScalabilityAutomatic
	ServiceScalabilityManual    ServiceScalability = original.ServiceScalabilityManual
	ServiceScalabilityNone      ServiceScalability = original.ServiceScalabilityNone
)

type Severity = original.Severity

const (
	SeverityError   Severity = original.SeverityError
	SeverityMessage Severity = original.SeverityMessage
	SeverityWarning Severity = original.SeverityWarning
)

type SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingState

const (
	SyncDatabaseMigrationReportingStateCANCELLED       SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCANCELLED
	SyncDatabaseMigrationReportingStateCANCELLING      SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCANCELLING
	SyncDatabaseMigrationReportingStateCOMPLETE        SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCOMPLETE
	SyncDatabaseMigrationReportingStateCOMPLETING      SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCOMPLETING
	SyncDatabaseMigrationReportingStateCONFIGURING     SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCONFIGURING
	SyncDatabaseMigrationReportingStateFAILED          SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateFAILED
	SyncDatabaseMigrationReportingStateINITIALIAZING   SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateINITIALIAZING
	SyncDatabaseMigrationReportingStateREADYTOCOMPLETE SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateREADYTOCOMPLETE
	SyncDatabaseMigrationReportingStateRUNNING         SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateRUNNING
	SyncDatabaseMigrationReportingStateSTARTING        SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateSTARTING
	SyncDatabaseMigrationReportingStateUNDEFINED       SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateUNDEFINED
)

type SyncTableMigrationState = original.SyncTableMigrationState

const (
	SyncTableMigrationStateBEFORELOAD SyncTableMigrationState = original.SyncTableMigrationStateBEFORELOAD
	SyncTableMigrationStateCANCELED   SyncTableMigrationState = original.SyncTableMigrationStateCANCELED
	SyncTableMigrationStateCOMPLETED  SyncTableMigrationState = original.SyncTableMigrationStateCOMPLETED
	SyncTableMigrationStateERROR      SyncTableMigrationState = original.SyncTableMigrationStateERROR
	SyncTableMigrationStateFAILED     SyncTableMigrationState = original.SyncTableMigrationStateFAILED
	SyncTableMigrationStateFULLLOAD   SyncTableMigrationState = original.SyncTableMigrationStateFULLLOAD
)

type TaskState = original.TaskState

const (
	TaskStateCanceled              TaskState = original.TaskStateCanceled
	TaskStateFailed                TaskState = original.TaskStateFailed
	TaskStateFailedInputValidation TaskState = original.TaskStateFailedInputValidation
	TaskStateFaulted               TaskState = original.TaskStateFaulted
	TaskStateQueued                TaskState = original.TaskStateQueued
	TaskStateRunning               TaskState = original.TaskStateRunning
	TaskStateSucceeded             TaskState = original.TaskStateSucceeded
	TaskStateUnknown               TaskState = original.TaskStateUnknown
)

type TaskType = original.TaskType

const (
	TaskTypeConnectToSourceMySQL                               TaskType = original.TaskTypeConnectToSourceMySQL
	TaskTypeConnectToSourcePostgreSQLSync                      TaskType = original.TaskTypeConnectToSourcePostgreSQLSync
	TaskTypeConnectToSourceSQLServer                           TaskType = original.TaskTypeConnectToSourceSQLServer
	TaskTypeConnectToSourceSQLServerSync                       TaskType = original.TaskTypeConnectToSourceSQLServerSync
	TaskTypeConnectToTargetAzureDbForMySQL                     TaskType = original.TaskTypeConnectToTargetAzureDbForMySQL
	TaskTypeConnectToTargetAzureDbForPostgreSQLSync            TaskType = original.TaskTypeConnectToTargetAzureDbForPostgreSQLSync
	TaskTypeConnectToTargetAzureSQLDbMI                        TaskType = original.TaskTypeConnectToTargetAzureSQLDbMI
	TaskTypeConnectToTargetAzureSQLDbMISyncLRS                 TaskType = original.TaskTypeConnectToTargetAzureSQLDbMISyncLRS
	TaskTypeConnectToTargetSQLDb                               TaskType = original.TaskTypeConnectToTargetSQLDb
	TaskTypeConnectToTargetSQLDbSync                           TaskType = original.TaskTypeConnectToTargetSQLDbSync
	TaskTypeGetTDECertificatesSQL                              TaskType = original.TaskTypeGetTDECertificatesSQL
	TaskTypeGetUserTablesAzureSQLDbSync                        TaskType = original.TaskTypeGetUserTablesAzureSQLDbSync
	TaskTypeGetUserTablesSQL                                   TaskType = original.TaskTypeGetUserTablesSQL
	TaskTypeMigrateMySQLAzureDbForMySQLSync                    TaskType = original.TaskTypeMigrateMySQLAzureDbForMySQLSync
	TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync          TaskType = original.TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync
	TaskTypeMigrateSQLServerAzureSQLDbMI                       TaskType = original.TaskTypeMigrateSQLServerAzureSQLDbMI
	TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS                TaskType = original.TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS
	TaskTypeMigrateSQLServerAzureSQLDbSync                     TaskType = original.TaskTypeMigrateSQLServerAzureSQLDbSync
	TaskTypeMigrateSQLServerSQLDb                              TaskType = original.TaskTypeMigrateSQLServerSQLDb
	TaskTypeProjectTaskProperties                              TaskType = original.TaskTypeProjectTaskProperties
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI        TaskType = original.TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS TaskType = original.TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS
	TaskTypeValidateMigrationInputSQLServerSQLDbSync           TaskType = original.TaskTypeValidateMigrationInputSQLServerSQLDbSync
)

type Type = original.Type

const (
	TypeConnectionInfo           Type = original.TypeConnectionInfo
	TypeMiSQLConnectionInfo      Type = original.TypeMiSQLConnectionInfo
	TypeMySQLConnectionInfo      Type = original.TypeMySQLConnectionInfo
	TypePostgreSQLConnectionInfo Type = original.TypePostgreSQLConnectionInfo
	TypeSQLConnectionInfo        Type = original.TypeSQLConnectionInfo
)

type UpdateActionType = original.UpdateActionType

const (
	AddedOnTarget   UpdateActionType = original.AddedOnTarget
	ChangedOnTarget UpdateActionType = original.ChangedOnTarget
	DeletedOnTarget UpdateActionType = original.DeletedOnTarget
)

type ValidationStatus = original.ValidationStatus

const (
	ValidationStatusCompleted           ValidationStatus = original.ValidationStatusCompleted
	ValidationStatusCompletedWithIssues ValidationStatus = original.ValidationStatusCompletedWithIssues
	ValidationStatusDefault             ValidationStatus = original.ValidationStatusDefault
	ValidationStatusFailed              ValidationStatus = original.ValidationStatusFailed
	ValidationStatusInitialized         ValidationStatus = original.ValidationStatusInitialized
	ValidationStatusInProgress          ValidationStatus = original.ValidationStatusInProgress
	ValidationStatusNotStarted          ValidationStatus = original.ValidationStatusNotStarted
	ValidationStatusStopped             ValidationStatus = original.ValidationStatusStopped
)

type APIError = original.APIError
type AvailableServiceSku = original.AvailableServiceSku
type AvailableServiceSkuCapacity = original.AvailableServiceSkuCapacity
type AvailableServiceSkuSku = original.AvailableServiceSkuSku
type AzureActiveDirectoryApp = original.AzureActiveDirectoryApp
type BackupFileInfo = original.BackupFileInfo
type BackupSetInfo = original.BackupSetInfo
type BaseClient = original.BaseClient
type BasicCommandProperties = original.BasicCommandProperties
type BasicConnectToSourceSQLServerTaskOutput = original.BasicConnectToSourceSQLServerTaskOutput
type BasicConnectionInfo = original.BasicConnectionInfo
type BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput
type BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
type BasicMigrateSQLServerSQLDbSyncTaskOutput = original.BasicMigrateSQLServerSQLDbSyncTaskOutput
type BasicMigrateSQLServerSQLDbTaskOutput = original.BasicMigrateSQLServerSQLDbTaskOutput
type BasicMigrateSQLServerSQLMISyncTaskOutput = original.BasicMigrateSQLServerSQLMISyncTaskOutput
type BasicMigrateSQLServerSQLMITaskOutput = original.BasicMigrateSQLServerSQLMITaskOutput
type BasicProjectTaskProperties = original.BasicProjectTaskProperties
type BlobShare = original.BlobShare
type CommandProperties = original.CommandProperties
type ConnectToSourceMySQLTaskInput = original.ConnectToSourceMySQLTaskInput
type ConnectToSourceMySQLTaskProperties = original.ConnectToSourceMySQLTaskProperties
type ConnectToSourceNonSQLTaskOutput = original.ConnectToSourceNonSQLTaskOutput
type ConnectToSourcePostgreSQLSyncTaskInput = original.ConnectToSourcePostgreSQLSyncTaskInput
type ConnectToSourcePostgreSQLSyncTaskOutput = original.ConnectToSourcePostgreSQLSyncTaskOutput
type ConnectToSourcePostgreSQLSyncTaskProperties = original.ConnectToSourcePostgreSQLSyncTaskProperties
type ConnectToSourceSQLServerSyncTaskProperties = original.ConnectToSourceSQLServerSyncTaskProperties
type ConnectToSourceSQLServerTaskInput = original.ConnectToSourceSQLServerTaskInput
type ConnectToSourceSQLServerTaskOutput = original.ConnectToSourceSQLServerTaskOutput
type ConnectToSourceSQLServerTaskOutputAgentJobLevel = original.ConnectToSourceSQLServerTaskOutputAgentJobLevel
type ConnectToSourceSQLServerTaskOutputDatabaseLevel = original.ConnectToSourceSQLServerTaskOutputDatabaseLevel
type ConnectToSourceSQLServerTaskOutputLoginLevel = original.ConnectToSourceSQLServerTaskOutputLoginLevel
type ConnectToSourceSQLServerTaskOutputTaskLevel = original.ConnectToSourceSQLServerTaskOutputTaskLevel
type ConnectToSourceSQLServerTaskProperties = original.ConnectToSourceSQLServerTaskProperties
type ConnectToTargetAzureDbForMySQLTaskInput = original.ConnectToTargetAzureDbForMySQLTaskInput
type ConnectToTargetAzureDbForMySQLTaskOutput = original.ConnectToTargetAzureDbForMySQLTaskOutput
type ConnectToTargetAzureDbForMySQLTaskProperties = original.ConnectToTargetAzureDbForMySQLTaskProperties
type ConnectToTargetAzureDbForPostgreSQLSyncTaskInput = original.ConnectToTargetAzureDbForPostgreSQLSyncTaskInput
type ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput = original.ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput
type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties = original.ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties
type ConnectToTargetSQLDbTaskInput = original.ConnectToTargetSQLDbTaskInput
type ConnectToTargetSQLDbTaskOutput = original.ConnectToTargetSQLDbTaskOutput
type ConnectToTargetSQLDbTaskProperties = original.ConnectToTargetSQLDbTaskProperties
type ConnectToTargetSQLMISyncTaskInput = original.ConnectToTargetSQLMISyncTaskInput
type ConnectToTargetSQLMISyncTaskOutput = original.ConnectToTargetSQLMISyncTaskOutput
type ConnectToTargetSQLMISyncTaskProperties = original.ConnectToTargetSQLMISyncTaskProperties
type ConnectToTargetSQLMITaskInput = original.ConnectToTargetSQLMITaskInput
type ConnectToTargetSQLMITaskOutput = original.ConnectToTargetSQLMITaskOutput
type ConnectToTargetSQLMITaskProperties = original.ConnectToTargetSQLMITaskProperties
type ConnectToTargetSQLSQLDbSyncTaskInput = original.ConnectToTargetSQLSQLDbSyncTaskInput
type ConnectToTargetSQLSQLDbSyncTaskProperties = original.ConnectToTargetSQLSQLDbSyncTaskProperties
type ConnectionInfo = original.ConnectionInfo
type DataIntegrityValidationResult = original.DataIntegrityValidationResult
type DataItemMigrationSummaryResult = original.DataItemMigrationSummaryResult
type Database = original.Database
type DatabaseBackupInfo = original.DatabaseBackupInfo
type DatabaseFileInfo = original.DatabaseFileInfo
type DatabaseFileInput = original.DatabaseFileInput
type DatabaseInfo = original.DatabaseInfo
type DatabaseObjectName = original.DatabaseObjectName
type DatabaseSummaryResult = original.DatabaseSummaryResult
type DatabaseTable = original.DatabaseTable
type Error = original.Error
type ExecutionStatistics = original.ExecutionStatistics
type FileShare = original.FileShare
type GetProjectDetailsNonSQLTaskInput = original.GetProjectDetailsNonSQLTaskInput
type GetTdeCertificatesSQLTaskInput = original.GetTdeCertificatesSQLTaskInput
type GetTdeCertificatesSQLTaskOutput = original.GetTdeCertificatesSQLTaskOutput
type GetTdeCertificatesSQLTaskProperties = original.GetTdeCertificatesSQLTaskProperties
type GetUserTablesSQLSyncTaskInput = original.GetUserTablesSQLSyncTaskInput
type GetUserTablesSQLSyncTaskOutput = original.GetUserTablesSQLSyncTaskOutput
type GetUserTablesSQLSyncTaskProperties = original.GetUserTablesSQLSyncTaskProperties
type GetUserTablesSQLTaskInput = original.GetUserTablesSQLTaskInput
type GetUserTablesSQLTaskOutput = original.GetUserTablesSQLTaskOutput
type GetUserTablesSQLTaskProperties = original.GetUserTablesSQLTaskProperties
type MiSQLConnectionInfo = original.MiSQLConnectionInfo
type MigrateMISyncCompleteCommandInput = original.MigrateMISyncCompleteCommandInput
type MigrateMISyncCompleteCommandOutput = original.MigrateMISyncCompleteCommandOutput
type MigrateMISyncCompleteCommandProperties = original.MigrateMISyncCompleteCommandProperties
type MigrateMySQLAzureDbForMySQLSyncDatabaseInput = original.MigrateMySQLAzureDbForMySQLSyncDatabaseInput
type MigrateMySQLAzureDbForMySQLSyncTaskInput = original.MigrateMySQLAzureDbForMySQLSyncTaskInput
type MigrateMySQLAzureDbForMySQLSyncTaskOutput = original.MigrateMySQLAzureDbForMySQLSyncTaskOutput
type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError
type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel
type MigrateMySQLAzureDbForMySQLSyncTaskOutputError = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputError
type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel
type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel
type MigrateMySQLAzureDbForMySQLSyncTaskProperties = original.MigrateMySQLAzureDbForMySQLSyncTaskProperties
type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput = original.MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties
type MigrateSQLServerSQLDbDatabaseInput = original.MigrateSQLServerSQLDbDatabaseInput
type MigrateSQLServerSQLDbSyncDatabaseInput = original.MigrateSQLServerSQLDbSyncDatabaseInput
type MigrateSQLServerSQLDbSyncTaskInput = original.MigrateSQLServerSQLDbSyncTaskInput
type MigrateSQLServerSQLDbSyncTaskOutput = original.MigrateSQLServerSQLDbSyncTaskOutput
type MigrateSQLServerSQLDbSyncTaskOutputDatabaseError = original.MigrateSQLServerSQLDbSyncTaskOutputDatabaseError
type MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel = original.MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel
type MigrateSQLServerSQLDbSyncTaskOutputError = original.MigrateSQLServerSQLDbSyncTaskOutputError
type MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel = original.MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel
type MigrateSQLServerSQLDbSyncTaskOutputTableLevel = original.MigrateSQLServerSQLDbSyncTaskOutputTableLevel
type MigrateSQLServerSQLDbSyncTaskProperties = original.MigrateSQLServerSQLDbSyncTaskProperties
type MigrateSQLServerSQLDbTaskInput = original.MigrateSQLServerSQLDbTaskInput
type MigrateSQLServerSQLDbTaskOutput = original.MigrateSQLServerSQLDbTaskOutput
type MigrateSQLServerSQLDbTaskOutputDatabaseLevel = original.MigrateSQLServerSQLDbTaskOutputDatabaseLevel
type MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult = original.MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult
type MigrateSQLServerSQLDbTaskOutputError = original.MigrateSQLServerSQLDbTaskOutputError
type MigrateSQLServerSQLDbTaskOutputMigrationLevel = original.MigrateSQLServerSQLDbTaskOutputMigrationLevel
type MigrateSQLServerSQLDbTaskOutputTableLevel = original.MigrateSQLServerSQLDbTaskOutputTableLevel
type MigrateSQLServerSQLDbTaskOutputValidationResult = original.MigrateSQLServerSQLDbTaskOutputValidationResult
type MigrateSQLServerSQLDbTaskProperties = original.MigrateSQLServerSQLDbTaskProperties
type MigrateSQLServerSQLMIDatabaseInput = original.MigrateSQLServerSQLMIDatabaseInput
type MigrateSQLServerSQLMISyncTaskInput = original.MigrateSQLServerSQLMISyncTaskInput
type MigrateSQLServerSQLMISyncTaskOutput = original.MigrateSQLServerSQLMISyncTaskOutput
type MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel = original.MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel
type MigrateSQLServerSQLMISyncTaskOutputError = original.MigrateSQLServerSQLMISyncTaskOutputError
type MigrateSQLServerSQLMISyncTaskOutputMigrationLevel = original.MigrateSQLServerSQLMISyncTaskOutputMigrationLevel
type MigrateSQLServerSQLMISyncTaskProperties = original.MigrateSQLServerSQLMISyncTaskProperties
type MigrateSQLServerSQLMITaskInput = original.MigrateSQLServerSQLMITaskInput
type MigrateSQLServerSQLMITaskOutput = original.MigrateSQLServerSQLMITaskOutput
type MigrateSQLServerSQLMITaskOutputAgentJobLevel = original.MigrateSQLServerSQLMITaskOutputAgentJobLevel
type MigrateSQLServerSQLMITaskOutputDatabaseLevel = original.MigrateSQLServerSQLMITaskOutputDatabaseLevel
type MigrateSQLServerSQLMITaskOutputError = original.MigrateSQLServerSQLMITaskOutputError
type MigrateSQLServerSQLMITaskOutputLoginLevel = original.MigrateSQLServerSQLMITaskOutputLoginLevel
type MigrateSQLServerSQLMITaskOutputMigrationLevel = original.MigrateSQLServerSQLMITaskOutputMigrationLevel
type MigrateSQLServerSQLMITaskProperties = original.MigrateSQLServerSQLMITaskProperties
type MigrateSQLServerSQLServerDatabaseInput = original.MigrateSQLServerSQLServerDatabaseInput
type MigrateSyncCompleteCommandInput = original.MigrateSyncCompleteCommandInput
type MigrateSyncCompleteCommandOutput = original.MigrateSyncCompleteCommandOutput
type MigrateSyncCompleteCommandProperties = original.MigrateSyncCompleteCommandProperties
type MigrationEligibilityInfo = original.MigrationEligibilityInfo
type MigrationReportResult = original.MigrationReportResult
type MigrationTableMetadata = original.MigrationTableMetadata
type MigrationValidationDatabaseSummaryResult = original.MigrationValidationDatabaseSummaryResult
type MigrationValidationOptions = original.MigrationValidationOptions
type MySQLConnectionInfo = original.MySQLConnectionInfo
type NameAvailabilityRequest = original.NameAvailabilityRequest
type NameAvailabilityResponse = original.NameAvailabilityResponse
type NonSQLDataMigrationTable = original.NonSQLDataMigrationTable
type NonSQLDataMigrationTableResult = original.NonSQLDataMigrationTableResult
type NonSQLMigrationTaskInput = original.NonSQLMigrationTaskInput
type NonSQLMigrationTaskOutput = original.NonSQLMigrationTaskOutput
type ODataError = original.ODataError
type OperationsClient = original.OperationsClient
type OrphanedUserInfo = original.OrphanedUserInfo
type PostgreSQLConnectionInfo = original.PostgreSQLConnectionInfo
type Project = original.Project
type ProjectList = original.ProjectList
type ProjectListIterator = original.ProjectListIterator
type ProjectListPage = original.ProjectListPage
type ProjectMetadata = original.ProjectMetadata
type ProjectProperties = original.ProjectProperties
type ProjectTask = original.ProjectTask
type ProjectTaskProperties = original.ProjectTaskProperties
type ProjectsClient = original.ProjectsClient
type QueryAnalysisValidationResult = original.QueryAnalysisValidationResult
type QueryExecutionResult = original.QueryExecutionResult
type Quota = original.Quota
type QuotaList = original.QuotaList
type QuotaListIterator = original.QuotaListIterator
type QuotaListPage = original.QuotaListPage
type QuotaName = original.QuotaName
type ReportableException = original.ReportableException
type Resource = original.Resource
type ResourceSku = original.ResourceSku
type ResourceSkuCapabilities = original.ResourceSkuCapabilities
type ResourceSkuCapacity = original.ResourceSkuCapacity
type ResourceSkuCosts = original.ResourceSkuCosts
type ResourceSkuRestrictions = original.ResourceSkuRestrictions
type ResourceSkusClient = original.ResourceSkusClient
type ResourceSkusResult = original.ResourceSkusResult
type ResourceSkusResultIterator = original.ResourceSkusResultIterator
type ResourceSkusResultPage = original.ResourceSkusResultPage
type SQLConnectionInfo = original.SQLConnectionInfo
type SQLMigrationTaskInput = original.SQLMigrationTaskInput
type SQLServerSQLMISyncTaskInput = original.SQLServerSQLMISyncTaskInput
type SchemaComparisonValidationResult = original.SchemaComparisonValidationResult
type SchemaComparisonValidationResultType = original.SchemaComparisonValidationResultType
type SelectedCertificateInput = original.SelectedCertificateInput
type ServerProperties = original.ServerProperties
type Service = original.Service
type ServiceList = original.ServiceList
type ServiceListIterator = original.ServiceListIterator
type ServiceListPage = original.ServiceListPage
type ServiceOperation = original.ServiceOperation
type ServiceOperationDisplay = original.ServiceOperationDisplay
type ServiceOperationList = original.ServiceOperationList
type ServiceOperationListIterator = original.ServiceOperationListIterator
type ServiceOperationListPage = original.ServiceOperationListPage
type ServiceProperties = original.ServiceProperties
type ServiceSku = original.ServiceSku
type ServiceSkuList = original.ServiceSkuList
type ServiceSkuListIterator = original.ServiceSkuListIterator
type ServiceSkuListPage = original.ServiceSkuListPage
type ServiceStatusResponse = original.ServiceStatusResponse
type ServicesClient = original.ServicesClient
type ServicesCreateOrUpdateFuture = original.ServicesCreateOrUpdateFuture
type ServicesDeleteFuture = original.ServicesDeleteFuture
type ServicesStartFuture = original.ServicesStartFuture
type ServicesStopFuture = original.ServicesStopFuture
type ServicesUpdateFuture = original.ServicesUpdateFuture
type StartMigrationScenarioServerRoleResult = original.StartMigrationScenarioServerRoleResult
type SyncMigrationDatabaseErrorEvent = original.SyncMigrationDatabaseErrorEvent
type TaskList = original.TaskList
type TaskListIterator = original.TaskListIterator
type TaskListPage = original.TaskListPage
type TasksClient = original.TasksClient
type TrackedResource = original.TrackedResource
type UsagesClient = original.UsagesClient
type ValidateMigrationInputSQLServerSQLDbSyncTaskProperties = original.ValidateMigrationInputSQLServerSQLDbSyncTaskProperties
type ValidateMigrationInputSQLServerSQLMISyncTaskInput = original.ValidateMigrationInputSQLServerSQLMISyncTaskInput
type ValidateMigrationInputSQLServerSQLMISyncTaskOutput = original.ValidateMigrationInputSQLServerSQLMISyncTaskOutput
type ValidateMigrationInputSQLServerSQLMISyncTaskProperties = original.ValidateMigrationInputSQLServerSQLMISyncTaskProperties
type ValidateMigrationInputSQLServerSQLMITaskInput = original.ValidateMigrationInputSQLServerSQLMITaskInput
type ValidateMigrationInputSQLServerSQLMITaskOutput = original.ValidateMigrationInputSQLServerSQLMITaskOutput
type ValidateMigrationInputSQLServerSQLMITaskProperties = original.ValidateMigrationInputSQLServerSQLMITaskProperties
type ValidateSyncMigrationInputSQLServerTaskInput = original.ValidateSyncMigrationInputSQLServerTaskInput
type ValidateSyncMigrationInputSQLServerTaskOutput = original.ValidateSyncMigrationInputSQLServerTaskOutput
type ValidationError = original.ValidationError
type WaitStatistics = original.WaitStatistics

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProjectListIterator(page ProjectListPage) ProjectListIterator {
	return original.NewProjectListIterator(page)
}
func NewProjectListPage(getNextPage func(context.Context, ProjectList) (ProjectList, error)) ProjectListPage {
	return original.NewProjectListPage(getNextPage)
}
func NewProjectsClient(subscriptionID string) ProjectsClient {
	return original.NewProjectsClient(subscriptionID)
}
func NewProjectsClientWithBaseURI(baseURI string, subscriptionID string) ProjectsClient {
	return original.NewProjectsClientWithBaseURI(baseURI, subscriptionID)
}
func NewQuotaListIterator(page QuotaListPage) QuotaListIterator {
	return original.NewQuotaListIterator(page)
}
func NewQuotaListPage(getNextPage func(context.Context, QuotaList) (QuotaList, error)) QuotaListPage {
	return original.NewQuotaListPage(getNextPage)
}
func NewResourceSkusClient(subscriptionID string) ResourceSkusClient {
	return original.NewResourceSkusClient(subscriptionID)
}
func NewResourceSkusClientWithBaseURI(baseURI string, subscriptionID string) ResourceSkusClient {
	return original.NewResourceSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceSkusResultIterator(page ResourceSkusResultPage) ResourceSkusResultIterator {
	return original.NewResourceSkusResultIterator(page)
}
func NewResourceSkusResultPage(getNextPage func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)) ResourceSkusResultPage {
	return original.NewResourceSkusResultPage(getNextPage)
}
func NewServiceListIterator(page ServiceListPage) ServiceListIterator {
	return original.NewServiceListIterator(page)
}
func NewServiceListPage(getNextPage func(context.Context, ServiceList) (ServiceList, error)) ServiceListPage {
	return original.NewServiceListPage(getNextPage)
}
func NewServiceOperationListIterator(page ServiceOperationListPage) ServiceOperationListIterator {
	return original.NewServiceOperationListIterator(page)
}
func NewServiceOperationListPage(getNextPage func(context.Context, ServiceOperationList) (ServiceOperationList, error)) ServiceOperationListPage {
	return original.NewServiceOperationListPage(getNextPage)
}
func NewServiceSkuListIterator(page ServiceSkuListPage) ServiceSkuListIterator {
	return original.NewServiceSkuListIterator(page)
}
func NewServiceSkuListPage(getNextPage func(context.Context, ServiceSkuList) (ServiceSkuList, error)) ServiceSkuListPage {
	return original.NewServiceSkuListPage(getNextPage)
}
func NewServicesClient(subscriptionID string) ServicesClient {
	return original.NewServicesClient(subscriptionID)
}
func NewServicesClientWithBaseURI(baseURI string, subscriptionID string) ServicesClient {
	return original.NewServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return original.NewTaskListIterator(page)
}
func NewTaskListPage(getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return original.NewTaskListPage(getNextPage)
}
func NewTasksClient(subscriptionID string) TasksClient {
	return original.NewTasksClient(subscriptionID)
}
func NewTasksClientWithBaseURI(baseURI string, subscriptionID string) TasksClient {
	return original.NewTasksClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesClient(subscriptionID string) UsagesClient {
	return original.NewUsagesClient(subscriptionID)
}
func NewUsagesClientWithBaseURI(baseURI string, subscriptionID string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return original.PossibleAuthenticationTypeValues()
}
func PossibleBackupFileStatusValues() []BackupFileStatus {
	return original.PossibleBackupFileStatusValues()
}
func PossibleBackupModeValues() []BackupMode {
	return original.PossibleBackupModeValues()
}
func PossibleBackupTypeValues() []BackupType {
	return original.PossibleBackupTypeValues()
}
func PossibleCommandStateValues() []CommandState {
	return original.PossibleCommandStateValues()
}
func PossibleCommandTypeValues() []CommandType {
	return original.PossibleCommandTypeValues()
}
func PossibleDatabaseCompatLevelValues() []DatabaseCompatLevel {
	return original.PossibleDatabaseCompatLevelValues()
}
func PossibleDatabaseFileTypeValues() []DatabaseFileType {
	return original.PossibleDatabaseFileTypeValues()
}
func PossibleDatabaseMigrationStageValues() []DatabaseMigrationStage {
	return original.PossibleDatabaseMigrationStageValues()
}
func PossibleDatabaseMigrationStateValues() []DatabaseMigrationState {
	return original.PossibleDatabaseMigrationStateValues()
}
func PossibleDatabaseStateValues() []DatabaseState {
	return original.PossibleDatabaseStateValues()
}
func PossibleErrorTypeValues() []ErrorType {
	return original.PossibleErrorTypeValues()
}
func PossibleLoginMigrationStageValues() []LoginMigrationStage {
	return original.PossibleLoginMigrationStageValues()
}
func PossibleLoginTypeValues() []LoginType {
	return original.PossibleLoginTypeValues()
}
func PossibleMigrationStateValues() []MigrationState {
	return original.PossibleMigrationStateValues()
}
func PossibleMigrationStatusValues() []MigrationStatus {
	return original.PossibleMigrationStatusValues()
}
func PossibleMySQLTargetPlatformTypeValues() []MySQLTargetPlatformType {
	return original.PossibleMySQLTargetPlatformTypeValues()
}
func PossibleNameCheckFailureReasonValues() []NameCheckFailureReason {
	return original.PossibleNameCheckFailureReasonValues()
}
func PossibleObjectTypeValues() []ObjectType {
	return original.PossibleObjectTypeValues()
}
func PossibleProjectProvisioningStateValues() []ProjectProvisioningState {
	return original.PossibleProjectProvisioningStateValues()
}
func PossibleProjectSourcePlatformValues() []ProjectSourcePlatform {
	return original.PossibleProjectSourcePlatformValues()
}
func PossibleProjectTargetPlatformValues() []ProjectTargetPlatform {
	return original.PossibleProjectTargetPlatformValues()
}
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return original.PossibleResourceSkuCapacityScaleTypeValues()
}
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return original.PossibleResourceSkuRestrictionsReasonCodeValues()
}
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return original.PossibleResourceSkuRestrictionsTypeValues()
}
func PossibleResultCodeValues() []ResultCode {
	return original.PossibleResultCodeValues()
}
func PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues() []ResultTypeBasicConnectToSourceSQLServerTaskOutput {
	return original.PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues()
}
func PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues() []ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return original.PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues()
}
func PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput {
	return original.PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues()
}
func PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbTaskOutput {
	return original.PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues()
}
func PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput {
	return original.PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues()
}
func PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMITaskOutput {
	return original.PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues()
}
func PossibleResultTypeValues() []ResultType {
	return original.PossibleResultTypeValues()
}
func PossibleSQLSourcePlatformValues() []SQLSourcePlatform {
	return original.PossibleSQLSourcePlatformValues()
}
func PossibleSchemaMigrationStageValues() []SchemaMigrationStage {
	return original.PossibleSchemaMigrationStageValues()
}
func PossibleServerLevelPermissionsGroupValues() []ServerLevelPermissionsGroup {
	return original.PossibleServerLevelPermissionsGroupValues()
}
func PossibleServiceProvisioningStateValues() []ServiceProvisioningState {
	return original.PossibleServiceProvisioningStateValues()
}
func PossibleServiceScalabilityValues() []ServiceScalability {
	return original.PossibleServiceScalabilityValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleSyncDatabaseMigrationReportingStateValues() []SyncDatabaseMigrationReportingState {
	return original.PossibleSyncDatabaseMigrationReportingStateValues()
}
func PossibleSyncTableMigrationStateValues() []SyncTableMigrationState {
	return original.PossibleSyncTableMigrationStateValues()
}
func PossibleTaskStateValues() []TaskState {
	return original.PossibleTaskStateValues()
}
func PossibleTaskTypeValues() []TaskType {
	return original.PossibleTaskTypeValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleUpdateActionTypeValues() []UpdateActionType {
	return original.PossibleUpdateActionTypeValues()
}
func PossibleValidationStatusValues() []ValidationStatus {
	return original.PossibleValidationStatusValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
