// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package network

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/network/mgmt/2017-10-01/network"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type Access = original.Access

const (
	Allow Access = original.Allow
	Deny  Access = original.Deny
)

type ApplicationGatewayBackendHealthServerHealth = original.ApplicationGatewayBackendHealthServerHealth

const (
	Down     ApplicationGatewayBackendHealthServerHealth = original.Down
	Draining ApplicationGatewayBackendHealthServerHealth = original.Draining
	Partial  ApplicationGatewayBackendHealthServerHealth = original.Partial
	Unknown  ApplicationGatewayBackendHealthServerHealth = original.Unknown
	Up       ApplicationGatewayBackendHealthServerHealth = original.Up
)

type ApplicationGatewayCookieBasedAffinity = original.ApplicationGatewayCookieBasedAffinity

const (
	Disabled ApplicationGatewayCookieBasedAffinity = original.Disabled
	Enabled  ApplicationGatewayCookieBasedAffinity = original.Enabled
)

type ApplicationGatewayFirewallMode = original.ApplicationGatewayFirewallMode

const (
	Detection  ApplicationGatewayFirewallMode = original.Detection
	Prevention ApplicationGatewayFirewallMode = original.Prevention
)

type ApplicationGatewayOperationalState = original.ApplicationGatewayOperationalState

const (
	Running  ApplicationGatewayOperationalState = original.Running
	Starting ApplicationGatewayOperationalState = original.Starting
	Stopped  ApplicationGatewayOperationalState = original.Stopped
	Stopping ApplicationGatewayOperationalState = original.Stopping
)

type ApplicationGatewayProtocol = original.ApplicationGatewayProtocol

const (
	HTTP  ApplicationGatewayProtocol = original.HTTP
	HTTPS ApplicationGatewayProtocol = original.HTTPS
)

type ApplicationGatewayRedirectType = original.ApplicationGatewayRedirectType

const (
	Found     ApplicationGatewayRedirectType = original.Found
	Permanent ApplicationGatewayRedirectType = original.Permanent
	SeeOther  ApplicationGatewayRedirectType = original.SeeOther
	Temporary ApplicationGatewayRedirectType = original.Temporary
)

type ApplicationGatewayRequestRoutingRuleType = original.ApplicationGatewayRequestRoutingRuleType

const (
	Basic            ApplicationGatewayRequestRoutingRuleType = original.Basic
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = original.PathBasedRouting
)

type ApplicationGatewaySkuName = original.ApplicationGatewaySkuName

const (
	StandardLarge  ApplicationGatewaySkuName = original.StandardLarge
	StandardMedium ApplicationGatewaySkuName = original.StandardMedium
	StandardSmall  ApplicationGatewaySkuName = original.StandardSmall
	WAFLarge       ApplicationGatewaySkuName = original.WAFLarge
	WAFMedium      ApplicationGatewaySkuName = original.WAFMedium
)

type ApplicationGatewaySslCipherSuite = original.ApplicationGatewaySslCipherSuite

const (
	TLSDHEDSSWITH3DESEDECBCSHA       ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITH3DESEDECBCSHA
	TLSDHEDSSWITHAES128CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES128CBCSHA
	TLSDHEDSSWITHAES128CBCSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES128CBCSHA256
	TLSDHEDSSWITHAES256CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES256CBCSHA
	TLSDHEDSSWITHAES256CBCSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES256CBCSHA256
	TLSDHERSAWITHAES128CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES128CBCSHA
	TLSDHERSAWITHAES128GCMSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES128GCMSHA256
	TLSDHERSAWITHAES256CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES256CBCSHA
	TLSDHERSAWITHAES256GCMSHA384     ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES256GCMSHA384
	TLSECDHEECDSAWITHAES128CBCSHA    ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128CBCSHA
	TLSECDHEECDSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128CBCSHA256
	TLSECDHEECDSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128GCMSHA256
	TLSECDHEECDSAWITHAES256CBCSHA    ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256CBCSHA
	TLSECDHEECDSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256CBCSHA384
	TLSECDHEECDSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256GCMSHA384
	TLSECDHERSAWITHAES128CBCSHA      ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128CBCSHA
	TLSECDHERSAWITHAES128CBCSHA256   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128CBCSHA256
	TLSECDHERSAWITHAES128GCMSHA256   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128GCMSHA256
	TLSECDHERSAWITHAES256CBCSHA      ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256CBCSHA
	TLSECDHERSAWITHAES256CBCSHA384   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256CBCSHA384
	TLSECDHERSAWITHAES256GCMSHA384   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256GCMSHA384
	TLSRSAWITH3DESEDECBCSHA          ApplicationGatewaySslCipherSuite = original.TLSRSAWITH3DESEDECBCSHA
	TLSRSAWITHAES128CBCSHA           ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128CBCSHA
	TLSRSAWITHAES128CBCSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128CBCSHA256
	TLSRSAWITHAES128GCMSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128GCMSHA256
	TLSRSAWITHAES256CBCSHA           ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256CBCSHA
	TLSRSAWITHAES256CBCSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256CBCSHA256
	TLSRSAWITHAES256GCMSHA384        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256GCMSHA384
)

type ApplicationGatewaySslPolicyName = original.ApplicationGatewaySslPolicyName

const (
	AppGwSslPolicy20150501  ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20150501
	AppGwSslPolicy20170401  ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20170401
	AppGwSslPolicy20170401S ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20170401S
)

type ApplicationGatewaySslPolicyType = original.ApplicationGatewaySslPolicyType

const (
	Custom     ApplicationGatewaySslPolicyType = original.Custom
	Predefined ApplicationGatewaySslPolicyType = original.Predefined
)

type ApplicationGatewaySslProtocol = original.ApplicationGatewaySslProtocol

const (
	TLSv10 ApplicationGatewaySslProtocol = original.TLSv10
	TLSv11 ApplicationGatewaySslProtocol = original.TLSv11
	TLSv12 ApplicationGatewaySslProtocol = original.TLSv12
)

type ApplicationGatewayTier = original.ApplicationGatewayTier

const (
	Standard ApplicationGatewayTier = original.Standard
	WAF      ApplicationGatewayTier = original.WAF
)

type AssociationType = original.AssociationType

const (
	Associated AssociationType = original.Associated
	Contains   AssociationType = original.Contains
)

type AuthenticationMethod = original.AuthenticationMethod

const (
	EAPMSCHAPv2 AuthenticationMethod = original.EAPMSCHAPv2
	EAPTLS      AuthenticationMethod = original.EAPTLS
)

type AuthorizationUseStatus = original.AuthorizationUseStatus

const (
	Available AuthorizationUseStatus = original.Available
	InUse     AuthorizationUseStatus = original.InUse
)

type BgpPeerState = original.BgpPeerState

const (
	BgpPeerStateConnected  BgpPeerState = original.BgpPeerStateConnected
	BgpPeerStateConnecting BgpPeerState = original.BgpPeerStateConnecting
	BgpPeerStateIdle       BgpPeerState = original.BgpPeerStateIdle
	BgpPeerStateStopped    BgpPeerState = original.BgpPeerStateStopped
	BgpPeerStateUnknown    BgpPeerState = original.BgpPeerStateUnknown
)

type ConnectionState = original.ConnectionState

const (
	ConnectionStateReachable   ConnectionState = original.ConnectionStateReachable
	ConnectionStateUnknown     ConnectionState = original.ConnectionStateUnknown
	ConnectionStateUnreachable ConnectionState = original.ConnectionStateUnreachable
)

type ConnectionStatus = original.ConnectionStatus

const (
	ConnectionStatusConnected    ConnectionStatus = original.ConnectionStatusConnected
	ConnectionStatusDegraded     ConnectionStatus = original.ConnectionStatusDegraded
	ConnectionStatusDisconnected ConnectionStatus = original.ConnectionStatusDisconnected
	ConnectionStatusUnknown      ConnectionStatus = original.ConnectionStatusUnknown
)

type DhGroup = original.DhGroup

const (
	DHGroup1    DhGroup = original.DHGroup1
	DHGroup14   DhGroup = original.DHGroup14
	DHGroup2    DhGroup = original.DHGroup2
	DHGroup2048 DhGroup = original.DHGroup2048
	DHGroup24   DhGroup = original.DHGroup24
	ECP256      DhGroup = original.ECP256
	ECP384      DhGroup = original.ECP384
	None        DhGroup = original.None
)

type Direction = original.Direction

const (
	Inbound  Direction = original.Inbound
	Outbound Direction = original.Outbound
)

type EffectiveRouteSource = original.EffectiveRouteSource

const (
	EffectiveRouteSourceDefault               EffectiveRouteSource = original.EffectiveRouteSourceDefault
	EffectiveRouteSourceUnknown               EffectiveRouteSource = original.EffectiveRouteSourceUnknown
	EffectiveRouteSourceUser                  EffectiveRouteSource = original.EffectiveRouteSourceUser
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = original.EffectiveRouteSourceVirtualNetworkGateway
)

type EffectiveRouteState = original.EffectiveRouteState

const (
	Active  EffectiveRouteState = original.Active
	Invalid EffectiveRouteState = original.Invalid
)

type EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocol

const (
	All EffectiveSecurityRuleProtocol = original.All
	TCP EffectiveSecurityRuleProtocol = original.TCP
	UDP EffectiveSecurityRuleProtocol = original.UDP
)

type EvaluationState = original.EvaluationState

const (
	Completed  EvaluationState = original.Completed
	InProgress EvaluationState = original.InProgress
	NotStarted EvaluationState = original.NotStarted
)

type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState

const (
	Configured       ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.Configured
	Configuring      ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.Configuring
	NotConfigured    ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.NotConfigured
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.ValidationNeeded
)

type ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringState

const (
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringStateDisabled
	ExpressRouteCircuitPeeringStateEnabled  ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringStateEnabled
)

type ExpressRouteCircuitPeeringType = original.ExpressRouteCircuitPeeringType

const (
	AzurePrivatePeering ExpressRouteCircuitPeeringType = original.AzurePrivatePeering
	AzurePublicPeering  ExpressRouteCircuitPeeringType = original.AzurePublicPeering
	MicrosoftPeering    ExpressRouteCircuitPeeringType = original.MicrosoftPeering
)

type ExpressRouteCircuitSkuFamily = original.ExpressRouteCircuitSkuFamily

const (
	MeteredData   ExpressRouteCircuitSkuFamily = original.MeteredData
	UnlimitedData ExpressRouteCircuitSkuFamily = original.UnlimitedData
)

type ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTier

const (
	ExpressRouteCircuitSkuTierPremium  ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierPremium
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierStandard
)

type IPAllocationMethod = original.IPAllocationMethod

const (
	Dynamic IPAllocationMethod = original.Dynamic
	Static  IPAllocationMethod = original.Static
)

type IPVersion = original.IPVersion

const (
	IPv4 IPVersion = original.IPv4
	IPv6 IPVersion = original.IPv6
)

type IkeEncryption = original.IkeEncryption

const (
	AES128 IkeEncryption = original.AES128
	AES192 IkeEncryption = original.AES192
	AES256 IkeEncryption = original.AES256
	DES    IkeEncryption = original.DES
	DES3   IkeEncryption = original.DES3
)

type IkeIntegrity = original.IkeIntegrity

const (
	MD5    IkeIntegrity = original.MD5
	SHA1   IkeIntegrity = original.SHA1
	SHA256 IkeIntegrity = original.SHA256
	SHA384 IkeIntegrity = original.SHA384
)

type IpsecEncryption = original.IpsecEncryption

const (
	IpsecEncryptionAES128    IpsecEncryption = original.IpsecEncryptionAES128
	IpsecEncryptionAES192    IpsecEncryption = original.IpsecEncryptionAES192
	IpsecEncryptionAES256    IpsecEncryption = original.IpsecEncryptionAES256
	IpsecEncryptionDES       IpsecEncryption = original.IpsecEncryptionDES
	IpsecEncryptionDES3      IpsecEncryption = original.IpsecEncryptionDES3
	IpsecEncryptionGCMAES128 IpsecEncryption = original.IpsecEncryptionGCMAES128
	IpsecEncryptionGCMAES192 IpsecEncryption = original.IpsecEncryptionGCMAES192
	IpsecEncryptionGCMAES256 IpsecEncryption = original.IpsecEncryptionGCMAES256
	IpsecEncryptionNone      IpsecEncryption = original.IpsecEncryptionNone
)

type IpsecIntegrity = original.IpsecIntegrity

const (
	IpsecIntegrityGCMAES128 IpsecIntegrity = original.IpsecIntegrityGCMAES128
	IpsecIntegrityGCMAES192 IpsecIntegrity = original.IpsecIntegrityGCMAES192
	IpsecIntegrityGCMAES256 IpsecIntegrity = original.IpsecIntegrityGCMAES256
	IpsecIntegrityMD5       IpsecIntegrity = original.IpsecIntegrityMD5
	IpsecIntegritySHA1      IpsecIntegrity = original.IpsecIntegritySHA1
	IpsecIntegritySHA256    IpsecIntegrity = original.IpsecIntegritySHA256
)

type IssueType = original.IssueType

const (
	IssueTypeAgentStopped        IssueType = original.IssueTypeAgentStopped
	IssueTypeDNSResolution       IssueType = original.IssueTypeDNSResolution
	IssueTypeGuestFirewall       IssueType = original.IssueTypeGuestFirewall
	IssueTypeNetworkSecurityRule IssueType = original.IssueTypeNetworkSecurityRule
	IssueTypePlatform            IssueType = original.IssueTypePlatform
	IssueTypePortThrottled       IssueType = original.IssueTypePortThrottled
	IssueTypeSocketBind          IssueType = original.IssueTypeSocketBind
	IssueTypeUnknown             IssueType = original.IssueTypeUnknown
	IssueTypeUserDefinedRoute    IssueType = original.IssueTypeUserDefinedRoute
)

type LoadBalancerSkuName = original.LoadBalancerSkuName

const (
	LoadBalancerSkuNameBasic    LoadBalancerSkuName = original.LoadBalancerSkuNameBasic
	LoadBalancerSkuNameStandard LoadBalancerSkuName = original.LoadBalancerSkuNameStandard
)

type LoadDistribution = original.LoadDistribution

const (
	Default          LoadDistribution = original.Default
	SourceIP         LoadDistribution = original.SourceIP
	SourceIPProtocol LoadDistribution = original.SourceIPProtocol
)

type NextHopType = original.NextHopType

const (
	NextHopTypeHyperNetGateway       NextHopType = original.NextHopTypeHyperNetGateway
	NextHopTypeInternet              NextHopType = original.NextHopTypeInternet
	NextHopTypeNone                  NextHopType = original.NextHopTypeNone
	NextHopTypeVirtualAppliance      NextHopType = original.NextHopTypeVirtualAppliance
	NextHopTypeVirtualNetworkGateway NextHopType = original.NextHopTypeVirtualNetworkGateway
	NextHopTypeVnetLocal             NextHopType = original.NextHopTypeVnetLocal
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
)

type Origin = original.Origin

const (
	OriginInbound  Origin = original.OriginInbound
	OriginLocal    Origin = original.OriginLocal
	OriginOutbound Origin = original.OriginOutbound
)

type PcError = original.PcError

const (
	AgentStopped    PcError = original.AgentStopped
	CaptureFailed   PcError = original.CaptureFailed
	InternalError   PcError = original.InternalError
	LocalFileFailed PcError = original.LocalFileFailed
	StorageFailed   PcError = original.StorageFailed
)

type PcProtocol = original.PcProtocol

const (
	PcProtocolAny PcProtocol = original.PcProtocolAny
	PcProtocolTCP PcProtocol = original.PcProtocolTCP
	PcProtocolUDP PcProtocol = original.PcProtocolUDP
)

type PcStatus = original.PcStatus

const (
	PcStatusError      PcStatus = original.PcStatusError
	PcStatusNotStarted PcStatus = original.PcStatusNotStarted
	PcStatusRunning    PcStatus = original.PcStatusRunning
	PcStatusStopped    PcStatus = original.PcStatusStopped
	PcStatusUnknown    PcStatus = original.PcStatusUnknown
)

type PfsGroup = original.PfsGroup

const (
	PfsGroupECP256  PfsGroup = original.PfsGroupECP256
	PfsGroupECP384  PfsGroup = original.PfsGroupECP384
	PfsGroupNone    PfsGroup = original.PfsGroupNone
	PfsGroupPFS1    PfsGroup = original.PfsGroupPFS1
	PfsGroupPFS2    PfsGroup = original.PfsGroupPFS2
	PfsGroupPFS2048 PfsGroup = original.PfsGroupPFS2048
	PfsGroupPFS24   PfsGroup = original.PfsGroupPFS24
)

type ProbeProtocol = original.ProbeProtocol

const (
	ProbeProtocolHTTP ProbeProtocol = original.ProbeProtocolHTTP
	ProbeProtocolTCP  ProbeProtocol = original.ProbeProtocolTCP
)

type ProcessorArchitecture = original.ProcessorArchitecture

const (
	Amd64 ProcessorArchitecture = original.Amd64
	X86   ProcessorArchitecture = original.X86
)

type Protocol = original.Protocol

const (
	ProtocolTCP Protocol = original.ProtocolTCP
	ProtocolUDP Protocol = original.ProtocolUDP
)

type ProvisioningState = original.ProvisioningState

const (
	Deleting  ProvisioningState = original.Deleting
	Failed    ProvisioningState = original.Failed
	Succeeded ProvisioningState = original.Succeeded
	Updating  ProvisioningState = original.Updating
)

type PublicIPAddressSkuName = original.PublicIPAddressSkuName

const (
	PublicIPAddressSkuNameBasic    PublicIPAddressSkuName = original.PublicIPAddressSkuNameBasic
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = original.PublicIPAddressSkuNameStandard
)

type RouteNextHopType = original.RouteNextHopType

const (
	RouteNextHopTypeInternet              RouteNextHopType = original.RouteNextHopTypeInternet
	RouteNextHopTypeNone                  RouteNextHopType = original.RouteNextHopTypeNone
	RouteNextHopTypeVirtualAppliance      RouteNextHopType = original.RouteNextHopTypeVirtualAppliance
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = original.RouteNextHopTypeVirtualNetworkGateway
	RouteNextHopTypeVnetLocal             RouteNextHopType = original.RouteNextHopTypeVnetLocal
)

type SecurityRuleAccess = original.SecurityRuleAccess

const (
	SecurityRuleAccessAllow SecurityRuleAccess = original.SecurityRuleAccessAllow
	SecurityRuleAccessDeny  SecurityRuleAccess = original.SecurityRuleAccessDeny
)

type SecurityRuleDirection = original.SecurityRuleDirection

const (
	SecurityRuleDirectionInbound  SecurityRuleDirection = original.SecurityRuleDirectionInbound
	SecurityRuleDirectionOutbound SecurityRuleDirection = original.SecurityRuleDirectionOutbound
)

type SecurityRuleProtocol = original.SecurityRuleProtocol

const (
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = original.SecurityRuleProtocolAsterisk
	SecurityRuleProtocolTCP      SecurityRuleProtocol = original.SecurityRuleProtocolTCP
	SecurityRuleProtocolUDP      SecurityRuleProtocol = original.SecurityRuleProtocolUDP
)

type ServiceProviderProvisioningState = original.ServiceProviderProvisioningState

const (
	Deprovisioning ServiceProviderProvisioningState = original.Deprovisioning
	NotProvisioned ServiceProviderProvisioningState = original.NotProvisioned
	Provisioned    ServiceProviderProvisioningState = original.Provisioned
	Provisioning   ServiceProviderProvisioningState = original.Provisioning
)

type Severity = original.Severity

const (
	SeverityError   Severity = original.SeverityError
	SeverityWarning Severity = original.SeverityWarning
)

type TransportProtocol = original.TransportProtocol

const (
	TransportProtocolAll TransportProtocol = original.TransportProtocolAll
	TransportProtocolTCP TransportProtocol = original.TransportProtocolTCP
	TransportProtocolUDP TransportProtocol = original.TransportProtocolUDP
)

type VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatus

const (
	VirtualNetworkGatewayConnectionStatusConnected    VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusConnected
	VirtualNetworkGatewayConnectionStatusConnecting   VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusConnecting
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusNotConnected
	VirtualNetworkGatewayConnectionStatusUnknown      VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusUnknown
)

type VirtualNetworkGatewayConnectionType = original.VirtualNetworkGatewayConnectionType

const (
	ExpressRoute VirtualNetworkGatewayConnectionType = original.ExpressRoute
	IPsec        VirtualNetworkGatewayConnectionType = original.IPsec
	Vnet2Vnet    VirtualNetworkGatewayConnectionType = original.Vnet2Vnet
	VPNClient    VirtualNetworkGatewayConnectionType = original.VPNClient
)

type VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuName

const (
	VirtualNetworkGatewaySkuNameBasic            VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameBasic
	VirtualNetworkGatewaySkuNameHighPerformance  VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameHighPerformance
	VirtualNetworkGatewaySkuNameStandard         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameStandard
	VirtualNetworkGatewaySkuNameUltraPerformance VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameUltraPerformance
	VirtualNetworkGatewaySkuNameVpnGw1           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw1
	VirtualNetworkGatewaySkuNameVpnGw2           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw2
	VirtualNetworkGatewaySkuNameVpnGw3           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw3
)

type VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTier

const (
	VirtualNetworkGatewaySkuTierBasic            VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierBasic
	VirtualNetworkGatewaySkuTierHighPerformance  VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierHighPerformance
	VirtualNetworkGatewaySkuTierStandard         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierStandard
	VirtualNetworkGatewaySkuTierUltraPerformance VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierUltraPerformance
	VirtualNetworkGatewaySkuTierVpnGw1           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw1
	VirtualNetworkGatewaySkuTierVpnGw2           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw2
	VirtualNetworkGatewaySkuTierVpnGw3           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw3
)

type VirtualNetworkGatewayType = original.VirtualNetworkGatewayType

const (
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = original.VirtualNetworkGatewayTypeExpressRoute
	VirtualNetworkGatewayTypeVpn          VirtualNetworkGatewayType = original.VirtualNetworkGatewayTypeVpn
)

type VirtualNetworkPeeringState = original.VirtualNetworkPeeringState

const (
	Connected    VirtualNetworkPeeringState = original.Connected
	Disconnected VirtualNetworkPeeringState = original.Disconnected
	Initiated    VirtualNetworkPeeringState = original.Initiated
)

type VpnClientProtocol = original.VpnClientProtocol

const (
	IkeV2 VpnClientProtocol = original.IkeV2
	SSTP  VpnClientProtocol = original.SSTP
)

type VpnType = original.VpnType

const (
	PolicyBased VpnType = original.PolicyBased
	RouteBased  VpnType = original.RouteBased
)

type AddressSpace = original.AddressSpace
type ApplicationGateway = original.ApplicationGateway
type ApplicationGatewayAuthenticationCertificate = original.ApplicationGatewayAuthenticationCertificate
type ApplicationGatewayAuthenticationCertificatePropertiesFormat = original.ApplicationGatewayAuthenticationCertificatePropertiesFormat
type ApplicationGatewayAvailableSslOptions = original.ApplicationGatewayAvailableSslOptions
type ApplicationGatewayAvailableSslOptionsPropertiesFormat = original.ApplicationGatewayAvailableSslOptionsPropertiesFormat
type ApplicationGatewayAvailableSslPredefinedPolicies = original.ApplicationGatewayAvailableSslPredefinedPolicies
type ApplicationGatewayAvailableSslPredefinedPoliciesIterator = original.ApplicationGatewayAvailableSslPredefinedPoliciesIterator
type ApplicationGatewayAvailableSslPredefinedPoliciesPage = original.ApplicationGatewayAvailableSslPredefinedPoliciesPage
type ApplicationGatewayAvailableWafRuleSetsResult = original.ApplicationGatewayAvailableWafRuleSetsResult
type ApplicationGatewayBackendAddress = original.ApplicationGatewayBackendAddress
type ApplicationGatewayBackendAddressPool = original.ApplicationGatewayBackendAddressPool
type ApplicationGatewayBackendAddressPoolPropertiesFormat = original.ApplicationGatewayBackendAddressPoolPropertiesFormat
type ApplicationGatewayBackendHTTPSettings = original.ApplicationGatewayBackendHTTPSettings
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat = original.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
type ApplicationGatewayBackendHealth = original.ApplicationGatewayBackendHealth
type ApplicationGatewayBackendHealthHTTPSettings = original.ApplicationGatewayBackendHealthHTTPSettings
type ApplicationGatewayBackendHealthPool = original.ApplicationGatewayBackendHealthPool
type ApplicationGatewayBackendHealthServer = original.ApplicationGatewayBackendHealthServer
type ApplicationGatewayConnectionDraining = original.ApplicationGatewayConnectionDraining
type ApplicationGatewayFirewallDisabledRuleGroup = original.ApplicationGatewayFirewallDisabledRuleGroup
type ApplicationGatewayFirewallRule = original.ApplicationGatewayFirewallRule
type ApplicationGatewayFirewallRuleGroup = original.ApplicationGatewayFirewallRuleGroup
type ApplicationGatewayFirewallRuleSet = original.ApplicationGatewayFirewallRuleSet
type ApplicationGatewayFirewallRuleSetPropertiesFormat = original.ApplicationGatewayFirewallRuleSetPropertiesFormat
type ApplicationGatewayFrontendIPConfiguration = original.ApplicationGatewayFrontendIPConfiguration
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat = original.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
type ApplicationGatewayFrontendPort = original.ApplicationGatewayFrontendPort
type ApplicationGatewayFrontendPortPropertiesFormat = original.ApplicationGatewayFrontendPortPropertiesFormat
type ApplicationGatewayHTTPListener = original.ApplicationGatewayHTTPListener
type ApplicationGatewayHTTPListenerPropertiesFormat = original.ApplicationGatewayHTTPListenerPropertiesFormat
type ApplicationGatewayIPConfiguration = original.ApplicationGatewayIPConfiguration
type ApplicationGatewayIPConfigurationPropertiesFormat = original.ApplicationGatewayIPConfigurationPropertiesFormat
type ApplicationGatewayListResult = original.ApplicationGatewayListResult
type ApplicationGatewayListResultIterator = original.ApplicationGatewayListResultIterator
type ApplicationGatewayListResultPage = original.ApplicationGatewayListResultPage
type ApplicationGatewayPathRule = original.ApplicationGatewayPathRule
type ApplicationGatewayPathRulePropertiesFormat = original.ApplicationGatewayPathRulePropertiesFormat
type ApplicationGatewayProbe = original.ApplicationGatewayProbe
type ApplicationGatewayProbeHealthResponseMatch = original.ApplicationGatewayProbeHealthResponseMatch
type ApplicationGatewayProbePropertiesFormat = original.ApplicationGatewayProbePropertiesFormat
type ApplicationGatewayPropertiesFormat = original.ApplicationGatewayPropertiesFormat
type ApplicationGatewayRedirectConfiguration = original.ApplicationGatewayRedirectConfiguration
type ApplicationGatewayRedirectConfigurationPropertiesFormat = original.ApplicationGatewayRedirectConfigurationPropertiesFormat
type ApplicationGatewayRequestRoutingRule = original.ApplicationGatewayRequestRoutingRule
type ApplicationGatewayRequestRoutingRulePropertiesFormat = original.ApplicationGatewayRequestRoutingRulePropertiesFormat
type ApplicationGatewaySku = original.ApplicationGatewaySku
type ApplicationGatewaySslCertificate = original.ApplicationGatewaySslCertificate
type ApplicationGatewaySslCertificatePropertiesFormat = original.ApplicationGatewaySslCertificatePropertiesFormat
type ApplicationGatewaySslPolicy = original.ApplicationGatewaySslPolicy
type ApplicationGatewaySslPredefinedPolicy = original.ApplicationGatewaySslPredefinedPolicy
type ApplicationGatewaySslPredefinedPolicyPropertiesFormat = original.ApplicationGatewaySslPredefinedPolicyPropertiesFormat
type ApplicationGatewayURLPathMap = original.ApplicationGatewayURLPathMap
type ApplicationGatewayURLPathMapPropertiesFormat = original.ApplicationGatewayURLPathMapPropertiesFormat
type ApplicationGatewayWebApplicationFirewallConfiguration = original.ApplicationGatewayWebApplicationFirewallConfiguration
type ApplicationGatewaysBackendHealthFuture = original.ApplicationGatewaysBackendHealthFuture
type ApplicationGatewaysClient = original.ApplicationGatewaysClient
type ApplicationGatewaysCreateOrUpdateFuture = original.ApplicationGatewaysCreateOrUpdateFuture
type ApplicationGatewaysDeleteFuture = original.ApplicationGatewaysDeleteFuture
type ApplicationGatewaysStartFuture = original.ApplicationGatewaysStartFuture
type ApplicationGatewaysStopFuture = original.ApplicationGatewaysStopFuture
type ApplicationGatewaysUpdateTagsFuture = original.ApplicationGatewaysUpdateTagsFuture
type ApplicationSecurityGroup = original.ApplicationSecurityGroup
type ApplicationSecurityGroupListResult = original.ApplicationSecurityGroupListResult
type ApplicationSecurityGroupListResultIterator = original.ApplicationSecurityGroupListResultIterator
type ApplicationSecurityGroupListResultPage = original.ApplicationSecurityGroupListResultPage
type ApplicationSecurityGroupPropertiesFormat = original.ApplicationSecurityGroupPropertiesFormat
type ApplicationSecurityGroupsClient = original.ApplicationSecurityGroupsClient
type ApplicationSecurityGroupsCreateOrUpdateFuture = original.ApplicationSecurityGroupsCreateOrUpdateFuture
type ApplicationSecurityGroupsDeleteFuture = original.ApplicationSecurityGroupsDeleteFuture
type AuthorizationListResult = original.AuthorizationListResult
type AuthorizationListResultIterator = original.AuthorizationListResultIterator
type AuthorizationListResultPage = original.AuthorizationListResultPage
type AuthorizationPropertiesFormat = original.AuthorizationPropertiesFormat
type Availability = original.Availability
type AvailableEndpointServicesClient = original.AvailableEndpointServicesClient
type AvailableProvidersList = original.AvailableProvidersList
type AvailableProvidersListCity = original.AvailableProvidersListCity
type AvailableProvidersListCountry = original.AvailableProvidersListCountry
type AvailableProvidersListParameters = original.AvailableProvidersListParameters
type AvailableProvidersListState = original.AvailableProvidersListState
type AzureAsyncOperationResult = original.AzureAsyncOperationResult
type AzureReachabilityReport = original.AzureReachabilityReport
type AzureReachabilityReportItem = original.AzureReachabilityReportItem
type AzureReachabilityReportLatencyInfo = original.AzureReachabilityReportLatencyInfo
type AzureReachabilityReportLocation = original.AzureReachabilityReportLocation
type AzureReachabilityReportParameters = original.AzureReachabilityReportParameters
type BGPCommunity = original.BGPCommunity
type BackendAddressPool = original.BackendAddressPool
type BackendAddressPoolPropertiesFormat = original.BackendAddressPoolPropertiesFormat
type BaseClient = original.BaseClient
type BgpPeerStatus = original.BgpPeerStatus
type BgpPeerStatusListResult = original.BgpPeerStatusListResult
type BgpServiceCommunitiesClient = original.BgpServiceCommunitiesClient
type BgpServiceCommunity = original.BgpServiceCommunity
type BgpServiceCommunityListResult = original.BgpServiceCommunityListResult
type BgpServiceCommunityListResultIterator = original.BgpServiceCommunityListResultIterator
type BgpServiceCommunityListResultPage = original.BgpServiceCommunityListResultPage
type BgpServiceCommunityPropertiesFormat = original.BgpServiceCommunityPropertiesFormat
type BgpSettings = original.BgpSettings
type ConnectionMonitor = original.ConnectionMonitor
type ConnectionMonitorDestination = original.ConnectionMonitorDestination
type ConnectionMonitorListResult = original.ConnectionMonitorListResult
type ConnectionMonitorParameters = original.ConnectionMonitorParameters
type ConnectionMonitorQueryResult = original.ConnectionMonitorQueryResult
type ConnectionMonitorResult = original.ConnectionMonitorResult
type ConnectionMonitorResultProperties = original.ConnectionMonitorResultProperties
type ConnectionMonitorSource = original.ConnectionMonitorSource
type ConnectionMonitorsClient = original.ConnectionMonitorsClient
type ConnectionMonitorsCreateOrUpdateFuture = original.ConnectionMonitorsCreateOrUpdateFuture
type ConnectionMonitorsDeleteFuture = original.ConnectionMonitorsDeleteFuture
type ConnectionMonitorsQueryFuture = original.ConnectionMonitorsQueryFuture
type ConnectionMonitorsStartFuture = original.ConnectionMonitorsStartFuture
type ConnectionMonitorsStopFuture = original.ConnectionMonitorsStopFuture
type ConnectionResetSharedKey = original.ConnectionResetSharedKey
type ConnectionSharedKey = original.ConnectionSharedKey
type ConnectionStateSnapshot = original.ConnectionStateSnapshot
type ConnectivityDestination = original.ConnectivityDestination
type ConnectivityHop = original.ConnectivityHop
type ConnectivityInformation = original.ConnectivityInformation
type ConnectivityIssue = original.ConnectivityIssue
type ConnectivityParameters = original.ConnectivityParameters
type ConnectivitySource = original.ConnectivitySource
type DNSNameAvailabilityResult = original.DNSNameAvailabilityResult
type DefaultSecurityRulesClient = original.DefaultSecurityRulesClient
type DhcpOptions = original.DhcpOptions
type Dimension = original.Dimension
type EffectiveNetworkSecurityGroup = original.EffectiveNetworkSecurityGroup
type EffectiveNetworkSecurityGroupAssociation = original.EffectiveNetworkSecurityGroupAssociation
type EffectiveNetworkSecurityGroupListResult = original.EffectiveNetworkSecurityGroupListResult
type EffectiveNetworkSecurityRule = original.EffectiveNetworkSecurityRule
type EffectiveRoute = original.EffectiveRoute
type EffectiveRouteListResult = original.EffectiveRouteListResult
type EndpointServiceResult = original.EndpointServiceResult
type EndpointServicesListResult = original.EndpointServicesListResult
type EndpointServicesListResultIterator = original.EndpointServicesListResultIterator
type EndpointServicesListResultPage = original.EndpointServicesListResultPage
type Error = original.Error
type ErrorDetails = original.ErrorDetails
type ExpressRouteCircuit = original.ExpressRouteCircuit
type ExpressRouteCircuitArpTable = original.ExpressRouteCircuitArpTable
type ExpressRouteCircuitAuthorization = original.ExpressRouteCircuitAuthorization
type ExpressRouteCircuitAuthorizationsClient = original.ExpressRouteCircuitAuthorizationsClient
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture = original.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture
type ExpressRouteCircuitAuthorizationsDeleteFuture = original.ExpressRouteCircuitAuthorizationsDeleteFuture
type ExpressRouteCircuitListResult = original.ExpressRouteCircuitListResult
type ExpressRouteCircuitListResultIterator = original.ExpressRouteCircuitListResultIterator
type ExpressRouteCircuitListResultPage = original.ExpressRouteCircuitListResultPage
type ExpressRouteCircuitPeering = original.ExpressRouteCircuitPeering
type ExpressRouteCircuitPeeringConfig = original.ExpressRouteCircuitPeeringConfig
type ExpressRouteCircuitPeeringListResult = original.ExpressRouteCircuitPeeringListResult
type ExpressRouteCircuitPeeringListResultIterator = original.ExpressRouteCircuitPeeringListResultIterator
type ExpressRouteCircuitPeeringListResultPage = original.ExpressRouteCircuitPeeringListResultPage
type ExpressRouteCircuitPeeringPropertiesFormat = original.ExpressRouteCircuitPeeringPropertiesFormat
type ExpressRouteCircuitPeeringsClient = original.ExpressRouteCircuitPeeringsClient
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture = original.ExpressRouteCircuitPeeringsCreateOrUpdateFuture
type ExpressRouteCircuitPeeringsDeleteFuture = original.ExpressRouteCircuitPeeringsDeleteFuture
type ExpressRouteCircuitPropertiesFormat = original.ExpressRouteCircuitPropertiesFormat
type ExpressRouteCircuitRoutesTable = original.ExpressRouteCircuitRoutesTable
type ExpressRouteCircuitRoutesTableSummary = original.ExpressRouteCircuitRoutesTableSummary
type ExpressRouteCircuitServiceProviderProperties = original.ExpressRouteCircuitServiceProviderProperties
type ExpressRouteCircuitSku = original.ExpressRouteCircuitSku
type ExpressRouteCircuitStats = original.ExpressRouteCircuitStats
type ExpressRouteCircuitsArpTableListResult = original.ExpressRouteCircuitsArpTableListResult
type ExpressRouteCircuitsClient = original.ExpressRouteCircuitsClient
type ExpressRouteCircuitsCreateOrUpdateFuture = original.ExpressRouteCircuitsCreateOrUpdateFuture
type ExpressRouteCircuitsDeleteFuture = original.ExpressRouteCircuitsDeleteFuture
type ExpressRouteCircuitsListArpTableFuture = original.ExpressRouteCircuitsListArpTableFuture
type ExpressRouteCircuitsListRoutesTableFuture = original.ExpressRouteCircuitsListRoutesTableFuture
type ExpressRouteCircuitsListRoutesTableSummaryFuture = original.ExpressRouteCircuitsListRoutesTableSummaryFuture
type ExpressRouteCircuitsRoutesTableListResult = original.ExpressRouteCircuitsRoutesTableListResult
type ExpressRouteCircuitsRoutesTableSummaryListResult = original.ExpressRouteCircuitsRoutesTableSummaryListResult
type ExpressRouteCircuitsUpdateTagsFuture = original.ExpressRouteCircuitsUpdateTagsFuture
type ExpressRouteServiceProvider = original.ExpressRouteServiceProvider
type ExpressRouteServiceProviderBandwidthsOffered = original.ExpressRouteServiceProviderBandwidthsOffered
type ExpressRouteServiceProviderListResult = original.ExpressRouteServiceProviderListResult
type ExpressRouteServiceProviderListResultIterator = original.ExpressRouteServiceProviderListResultIterator
type ExpressRouteServiceProviderListResultPage = original.ExpressRouteServiceProviderListResultPage
type ExpressRouteServiceProviderPropertiesFormat = original.ExpressRouteServiceProviderPropertiesFormat
type ExpressRouteServiceProvidersClient = original.ExpressRouteServiceProvidersClient
type FlowLogInformation = original.FlowLogInformation
type FlowLogProperties = original.FlowLogProperties
type FlowLogStatusParameters = original.FlowLogStatusParameters
type FrontendIPConfiguration = original.FrontendIPConfiguration
type FrontendIPConfigurationPropertiesFormat = original.FrontendIPConfigurationPropertiesFormat
type GatewayRoute = original.GatewayRoute
type GatewayRouteListResult = original.GatewayRouteListResult
type IPAddressAvailabilityResult = original.IPAddressAvailabilityResult
type IPConfiguration = original.IPConfiguration
type IPConfigurationPropertiesFormat = original.IPConfigurationPropertiesFormat
type InboundNatPool = original.InboundNatPool
type InboundNatPoolPropertiesFormat = original.InboundNatPoolPropertiesFormat
type InboundNatRule = original.InboundNatRule
type InboundNatRuleListResult = original.InboundNatRuleListResult
type InboundNatRuleListResultIterator = original.InboundNatRuleListResultIterator
type InboundNatRuleListResultPage = original.InboundNatRuleListResultPage
type InboundNatRulePropertiesFormat = original.InboundNatRulePropertiesFormat
type InboundNatRulesClient = original.InboundNatRulesClient
type InboundNatRulesCreateOrUpdateFuture = original.InboundNatRulesCreateOrUpdateFuture
type InboundNatRulesDeleteFuture = original.InboundNatRulesDeleteFuture
type Interface = original.Interface
type InterfaceAssociation = original.InterfaceAssociation
type InterfaceDNSSettings = original.InterfaceDNSSettings
type InterfaceIPConfiguration = original.InterfaceIPConfiguration
type InterfaceIPConfigurationListResult = original.InterfaceIPConfigurationListResult
type InterfaceIPConfigurationListResultIterator = original.InterfaceIPConfigurationListResultIterator
type InterfaceIPConfigurationListResultPage = original.InterfaceIPConfigurationListResultPage
type InterfaceIPConfigurationPropertiesFormat = original.InterfaceIPConfigurationPropertiesFormat
type InterfaceIPConfigurationsClient = original.InterfaceIPConfigurationsClient
type InterfaceListResult = original.InterfaceListResult
type InterfaceListResultIterator = original.InterfaceListResultIterator
type InterfaceListResultPage = original.InterfaceListResultPage
type InterfaceLoadBalancerListResult = original.InterfaceLoadBalancerListResult
type InterfaceLoadBalancerListResultIterator = original.InterfaceLoadBalancerListResultIterator
type InterfaceLoadBalancerListResultPage = original.InterfaceLoadBalancerListResultPage
type InterfaceLoadBalancersClient = original.InterfaceLoadBalancersClient
type InterfacePropertiesFormat = original.InterfacePropertiesFormat
type InterfacesClient = original.InterfacesClient
type InterfacesCreateOrUpdateFuture = original.InterfacesCreateOrUpdateFuture
type InterfacesDeleteFuture = original.InterfacesDeleteFuture
type InterfacesGetEffectiveRouteTableFuture = original.InterfacesGetEffectiveRouteTableFuture
type InterfacesListEffectiveNetworkSecurityGroupsFuture = original.InterfacesListEffectiveNetworkSecurityGroupsFuture
type InterfacesUpdateTagsFuture = original.InterfacesUpdateTagsFuture
type IpsecPolicy = original.IpsecPolicy
type Ipv6ExpressRouteCircuitPeeringConfig = original.Ipv6ExpressRouteCircuitPeeringConfig
type LoadBalancer = original.LoadBalancer
type LoadBalancerBackendAddressPoolListResult = original.LoadBalancerBackendAddressPoolListResult
type LoadBalancerBackendAddressPoolListResultIterator = original.LoadBalancerBackendAddressPoolListResultIterator
type LoadBalancerBackendAddressPoolListResultPage = original.LoadBalancerBackendAddressPoolListResultPage
type LoadBalancerBackendAddressPoolsClient = original.LoadBalancerBackendAddressPoolsClient
type LoadBalancerFrontendIPConfigurationListResult = original.LoadBalancerFrontendIPConfigurationListResult
type LoadBalancerFrontendIPConfigurationListResultIterator = original.LoadBalancerFrontendIPConfigurationListResultIterator
type LoadBalancerFrontendIPConfigurationListResultPage = original.LoadBalancerFrontendIPConfigurationListResultPage
type LoadBalancerFrontendIPConfigurationsClient = original.LoadBalancerFrontendIPConfigurationsClient
type LoadBalancerListResult = original.LoadBalancerListResult
type LoadBalancerListResultIterator = original.LoadBalancerListResultIterator
type LoadBalancerListResultPage = original.LoadBalancerListResultPage
type LoadBalancerLoadBalancingRuleListResult = original.LoadBalancerLoadBalancingRuleListResult
type LoadBalancerLoadBalancingRuleListResultIterator = original.LoadBalancerLoadBalancingRuleListResultIterator
type LoadBalancerLoadBalancingRuleListResultPage = original.LoadBalancerLoadBalancingRuleListResultPage
type LoadBalancerLoadBalancingRulesClient = original.LoadBalancerLoadBalancingRulesClient
type LoadBalancerNetworkInterfacesClient = original.LoadBalancerNetworkInterfacesClient
type LoadBalancerProbeListResult = original.LoadBalancerProbeListResult
type LoadBalancerProbeListResultIterator = original.LoadBalancerProbeListResultIterator
type LoadBalancerProbeListResultPage = original.LoadBalancerProbeListResultPage
type LoadBalancerProbesClient = original.LoadBalancerProbesClient
type LoadBalancerPropertiesFormat = original.LoadBalancerPropertiesFormat
type LoadBalancerSku = original.LoadBalancerSku
type LoadBalancersClient = original.LoadBalancersClient
type LoadBalancersCreateOrUpdateFuture = original.LoadBalancersCreateOrUpdateFuture
type LoadBalancersDeleteFuture = original.LoadBalancersDeleteFuture
type LoadBalancersUpdateTagsFuture = original.LoadBalancersUpdateTagsFuture
type LoadBalancingRule = original.LoadBalancingRule
type LoadBalancingRulePropertiesFormat = original.LoadBalancingRulePropertiesFormat
type LocalNetworkGateway = original.LocalNetworkGateway
type LocalNetworkGatewayListResult = original.LocalNetworkGatewayListResult
type LocalNetworkGatewayListResultIterator = original.LocalNetworkGatewayListResultIterator
type LocalNetworkGatewayListResultPage = original.LocalNetworkGatewayListResultPage
type LocalNetworkGatewayPropertiesFormat = original.LocalNetworkGatewayPropertiesFormat
type LocalNetworkGatewaysClient = original.LocalNetworkGatewaysClient
type LocalNetworkGatewaysCreateOrUpdateFuture = original.LocalNetworkGatewaysCreateOrUpdateFuture
type LocalNetworkGatewaysDeleteFuture = original.LocalNetworkGatewaysDeleteFuture
type LocalNetworkGatewaysUpdateTagsFuture = original.LocalNetworkGatewaysUpdateTagsFuture
type LogSpecification = original.LogSpecification
type MetricSpecification = original.MetricSpecification
type NextHopParameters = original.NextHopParameters
type NextHopResult = original.NextHopResult
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationPropertiesFormat = original.OperationPropertiesFormat
type OperationPropertiesFormatServiceSpecification = original.OperationPropertiesFormatServiceSpecification
type OperationsClient = original.OperationsClient
type OutboundNatRule = original.OutboundNatRule
type OutboundNatRulePropertiesFormat = original.OutboundNatRulePropertiesFormat
type PacketCapture = original.PacketCapture
type PacketCaptureFilter = original.PacketCaptureFilter
type PacketCaptureListResult = original.PacketCaptureListResult
type PacketCaptureParameters = original.PacketCaptureParameters
type PacketCaptureQueryStatusResult = original.PacketCaptureQueryStatusResult
type PacketCaptureResult = original.PacketCaptureResult
type PacketCaptureResultProperties = original.PacketCaptureResultProperties
type PacketCaptureStorageLocation = original.PacketCaptureStorageLocation
type PacketCapturesClient = original.PacketCapturesClient
type PacketCapturesCreateFuture = original.PacketCapturesCreateFuture
type PacketCapturesDeleteFuture = original.PacketCapturesDeleteFuture
type PacketCapturesGetStatusFuture = original.PacketCapturesGetStatusFuture
type PacketCapturesStopFuture = original.PacketCapturesStopFuture
type PatchRouteFilter = original.PatchRouteFilter
type PatchRouteFilterRule = original.PatchRouteFilterRule
type Probe = original.Probe
type ProbePropertiesFormat = original.ProbePropertiesFormat
type PublicIPAddress = original.PublicIPAddress
type PublicIPAddressDNSSettings = original.PublicIPAddressDNSSettings
type PublicIPAddressListResult = original.PublicIPAddressListResult
type PublicIPAddressListResultIterator = original.PublicIPAddressListResultIterator
type PublicIPAddressListResultPage = original.PublicIPAddressListResultPage
type PublicIPAddressPropertiesFormat = original.PublicIPAddressPropertiesFormat
type PublicIPAddressSku = original.PublicIPAddressSku
type PublicIPAddressesClient = original.PublicIPAddressesClient
type PublicIPAddressesCreateOrUpdateFuture = original.PublicIPAddressesCreateOrUpdateFuture
type PublicIPAddressesDeleteFuture = original.PublicIPAddressesDeleteFuture
type PublicIPAddressesUpdateTagsFuture = original.PublicIPAddressesUpdateTagsFuture
type QueryTroubleshootingParameters = original.QueryTroubleshootingParameters
type Resource = original.Resource
type ResourceNavigationLink = original.ResourceNavigationLink
type ResourceNavigationLinkFormat = original.ResourceNavigationLinkFormat
type RetentionPolicyParameters = original.RetentionPolicyParameters
type Route = original.Route
type RouteFilter = original.RouteFilter
type RouteFilterListResult = original.RouteFilterListResult
type RouteFilterListResultIterator = original.RouteFilterListResultIterator
type RouteFilterListResultPage = original.RouteFilterListResultPage
type RouteFilterPropertiesFormat = original.RouteFilterPropertiesFormat
type RouteFilterRule = original.RouteFilterRule
type RouteFilterRuleListResult = original.RouteFilterRuleListResult
type RouteFilterRuleListResultIterator = original.RouteFilterRuleListResultIterator
type RouteFilterRuleListResultPage = original.RouteFilterRuleListResultPage
type RouteFilterRulePropertiesFormat = original.RouteFilterRulePropertiesFormat
type RouteFilterRulesClient = original.RouteFilterRulesClient
type RouteFilterRulesCreateOrUpdateFuture = original.RouteFilterRulesCreateOrUpdateFuture
type RouteFilterRulesDeleteFuture = original.RouteFilterRulesDeleteFuture
type RouteFilterRulesUpdateFuture = original.RouteFilterRulesUpdateFuture
type RouteFiltersClient = original.RouteFiltersClient
type RouteFiltersCreateOrUpdateFuture = original.RouteFiltersCreateOrUpdateFuture
type RouteFiltersDeleteFuture = original.RouteFiltersDeleteFuture
type RouteFiltersUpdateFuture = original.RouteFiltersUpdateFuture
type RouteListResult = original.RouteListResult
type RouteListResultIterator = original.RouteListResultIterator
type RouteListResultPage = original.RouteListResultPage
type RoutePropertiesFormat = original.RoutePropertiesFormat
type RouteTable = original.RouteTable
type RouteTableListResult = original.RouteTableListResult
type RouteTableListResultIterator = original.RouteTableListResultIterator
type RouteTableListResultPage = original.RouteTableListResultPage
type RouteTablePropertiesFormat = original.RouteTablePropertiesFormat
type RouteTablesClient = original.RouteTablesClient
type RouteTablesCreateOrUpdateFuture = original.RouteTablesCreateOrUpdateFuture
type RouteTablesDeleteFuture = original.RouteTablesDeleteFuture
type RouteTablesUpdateTagsFuture = original.RouteTablesUpdateTagsFuture
type RoutesClient = original.RoutesClient
type RoutesCreateOrUpdateFuture = original.RoutesCreateOrUpdateFuture
type RoutesDeleteFuture = original.RoutesDeleteFuture
type SecurityGroup = original.SecurityGroup
type SecurityGroupListResult = original.SecurityGroupListResult
type SecurityGroupListResultIterator = original.SecurityGroupListResultIterator
type SecurityGroupListResultPage = original.SecurityGroupListResultPage
type SecurityGroupNetworkInterface = original.SecurityGroupNetworkInterface
type SecurityGroupPropertiesFormat = original.SecurityGroupPropertiesFormat
type SecurityGroupViewParameters = original.SecurityGroupViewParameters
type SecurityGroupViewResult = original.SecurityGroupViewResult
type SecurityGroupsClient = original.SecurityGroupsClient
type SecurityGroupsCreateOrUpdateFuture = original.SecurityGroupsCreateOrUpdateFuture
type SecurityGroupsDeleteFuture = original.SecurityGroupsDeleteFuture
type SecurityGroupsUpdateTagsFuture = original.SecurityGroupsUpdateTagsFuture
type SecurityRule = original.SecurityRule
type SecurityRuleAssociations = original.SecurityRuleAssociations
type SecurityRuleListResult = original.SecurityRuleListResult
type SecurityRuleListResultIterator = original.SecurityRuleListResultIterator
type SecurityRuleListResultPage = original.SecurityRuleListResultPage
type SecurityRulePropertiesFormat = original.SecurityRulePropertiesFormat
type SecurityRulesClient = original.SecurityRulesClient
type SecurityRulesCreateOrUpdateFuture = original.SecurityRulesCreateOrUpdateFuture
type SecurityRulesDeleteFuture = original.SecurityRulesDeleteFuture
type ServiceEndpointPropertiesFormat = original.ServiceEndpointPropertiesFormat
type String = original.String
type SubResource = original.SubResource
type Subnet = original.Subnet
type SubnetAssociation = original.SubnetAssociation
type SubnetListResult = original.SubnetListResult
type SubnetListResultIterator = original.SubnetListResultIterator
type SubnetListResultPage = original.SubnetListResultPage
type SubnetPropertiesFormat = original.SubnetPropertiesFormat
type SubnetsClient = original.SubnetsClient
type SubnetsCreateOrUpdateFuture = original.SubnetsCreateOrUpdateFuture
type SubnetsDeleteFuture = original.SubnetsDeleteFuture
type TagsObject = original.TagsObject
type Topology = original.Topology
type TopologyAssociation = original.TopologyAssociation
type TopologyParameters = original.TopologyParameters
type TopologyResource = original.TopologyResource
type TroubleshootingDetails = original.TroubleshootingDetails
type TroubleshootingParameters = original.TroubleshootingParameters
type TroubleshootingProperties = original.TroubleshootingProperties
type TroubleshootingRecommendedActions = original.TroubleshootingRecommendedActions
type TroubleshootingResult = original.TroubleshootingResult
type TunnelConnectionHealth = original.TunnelConnectionHealth
type Usage = original.Usage
type UsageName = original.UsageName
type UsagesClient = original.UsagesClient
type UsagesListResult = original.UsagesListResult
type UsagesListResultIterator = original.UsagesListResultIterator
type UsagesListResultPage = original.UsagesListResultPage
type VerificationIPFlowParameters = original.VerificationIPFlowParameters
type VerificationIPFlowResult = original.VerificationIPFlowResult
type VirtualNetwork = original.VirtualNetwork
type VirtualNetworkConnectionGatewayReference = original.VirtualNetworkConnectionGatewayReference
type VirtualNetworkGateway = original.VirtualNetworkGateway
type VirtualNetworkGatewayConnection = original.VirtualNetworkGatewayConnection
type VirtualNetworkGatewayConnectionListEntity = original.VirtualNetworkGatewayConnectionListEntity
type VirtualNetworkGatewayConnectionListEntityPropertiesFormat = original.VirtualNetworkGatewayConnectionListEntityPropertiesFormat
type VirtualNetworkGatewayConnectionListResult = original.VirtualNetworkGatewayConnectionListResult
type VirtualNetworkGatewayConnectionListResultIterator = original.VirtualNetworkGatewayConnectionListResultIterator
type VirtualNetworkGatewayConnectionListResultPage = original.VirtualNetworkGatewayConnectionListResultPage
type VirtualNetworkGatewayConnectionPropertiesFormat = original.VirtualNetworkGatewayConnectionPropertiesFormat
type VirtualNetworkGatewayConnectionsClient = original.VirtualNetworkGatewayConnectionsClient
type VirtualNetworkGatewayConnectionsCreateOrUpdateFuture = original.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture
type VirtualNetworkGatewayConnectionsDeleteFuture = original.VirtualNetworkGatewayConnectionsDeleteFuture
type VirtualNetworkGatewayConnectionsResetSharedKeyFuture = original.VirtualNetworkGatewayConnectionsResetSharedKeyFuture
type VirtualNetworkGatewayConnectionsSetSharedKeyFuture = original.VirtualNetworkGatewayConnectionsSetSharedKeyFuture
type VirtualNetworkGatewayConnectionsUpdateTagsFuture = original.VirtualNetworkGatewayConnectionsUpdateTagsFuture
type VirtualNetworkGatewayIPConfiguration = original.VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat = original.VirtualNetworkGatewayIPConfigurationPropertiesFormat
type VirtualNetworkGatewayListConnectionsResult = original.VirtualNetworkGatewayListConnectionsResult
type VirtualNetworkGatewayListConnectionsResultIterator = original.VirtualNetworkGatewayListConnectionsResultIterator
type VirtualNetworkGatewayListConnectionsResultPage = original.VirtualNetworkGatewayListConnectionsResultPage
type VirtualNetworkGatewayListResult = original.VirtualNetworkGatewayListResult
type VirtualNetworkGatewayListResultIterator = original.VirtualNetworkGatewayListResultIterator
type VirtualNetworkGatewayListResultPage = original.VirtualNetworkGatewayListResultPage
type VirtualNetworkGatewayPropertiesFormat = original.VirtualNetworkGatewayPropertiesFormat
type VirtualNetworkGatewaySku = original.VirtualNetworkGatewaySku
type VirtualNetworkGatewaysClient = original.VirtualNetworkGatewaysClient
type VirtualNetworkGatewaysCreateOrUpdateFuture = original.VirtualNetworkGatewaysCreateOrUpdateFuture
type VirtualNetworkGatewaysDeleteFuture = original.VirtualNetworkGatewaysDeleteFuture
type VirtualNetworkGatewaysGenerateVpnProfileFuture = original.VirtualNetworkGatewaysGenerateVpnProfileFuture
type VirtualNetworkGatewaysGeneratevpnclientpackageFuture = original.VirtualNetworkGatewaysGeneratevpnclientpackageFuture
type VirtualNetworkGatewaysGetAdvertisedRoutesFuture = original.VirtualNetworkGatewaysGetAdvertisedRoutesFuture
type VirtualNetworkGatewaysGetBgpPeerStatusFuture = original.VirtualNetworkGatewaysGetBgpPeerStatusFuture
type VirtualNetworkGatewaysGetLearnedRoutesFuture = original.VirtualNetworkGatewaysGetLearnedRoutesFuture
type VirtualNetworkGatewaysGetVpnProfilePackageURLFuture = original.VirtualNetworkGatewaysGetVpnProfilePackageURLFuture
type VirtualNetworkGatewaysResetFuture = original.VirtualNetworkGatewaysResetFuture
type VirtualNetworkGatewaysUpdateTagsFuture = original.VirtualNetworkGatewaysUpdateTagsFuture
type VirtualNetworkListResult = original.VirtualNetworkListResult
type VirtualNetworkListResultIterator = original.VirtualNetworkListResultIterator
type VirtualNetworkListResultPage = original.VirtualNetworkListResultPage
type VirtualNetworkListUsageResult = original.VirtualNetworkListUsageResult
type VirtualNetworkListUsageResultIterator = original.VirtualNetworkListUsageResultIterator
type VirtualNetworkListUsageResultPage = original.VirtualNetworkListUsageResultPage
type VirtualNetworkPeering = original.VirtualNetworkPeering
type VirtualNetworkPeeringListResult = original.VirtualNetworkPeeringListResult
type VirtualNetworkPeeringListResultIterator = original.VirtualNetworkPeeringListResultIterator
type VirtualNetworkPeeringListResultPage = original.VirtualNetworkPeeringListResultPage
type VirtualNetworkPeeringPropertiesFormat = original.VirtualNetworkPeeringPropertiesFormat
type VirtualNetworkPeeringsClient = original.VirtualNetworkPeeringsClient
type VirtualNetworkPeeringsCreateOrUpdateFuture = original.VirtualNetworkPeeringsCreateOrUpdateFuture
type VirtualNetworkPeeringsDeleteFuture = original.VirtualNetworkPeeringsDeleteFuture
type VirtualNetworkPropertiesFormat = original.VirtualNetworkPropertiesFormat
type VirtualNetworkUsage = original.VirtualNetworkUsage
type VirtualNetworkUsageName = original.VirtualNetworkUsageName
type VirtualNetworksClient = original.VirtualNetworksClient
type VirtualNetworksCreateOrUpdateFuture = original.VirtualNetworksCreateOrUpdateFuture
type VirtualNetworksDeleteFuture = original.VirtualNetworksDeleteFuture
type VirtualNetworksUpdateTagsFuture = original.VirtualNetworksUpdateTagsFuture
type VpnClientConfiguration = original.VpnClientConfiguration
type VpnClientParameters = original.VpnClientParameters
type VpnClientRevokedCertificate = original.VpnClientRevokedCertificate
type VpnClientRevokedCertificatePropertiesFormat = original.VpnClientRevokedCertificatePropertiesFormat
type VpnClientRootCertificate = original.VpnClientRootCertificate
type VpnClientRootCertificatePropertiesFormat = original.VpnClientRootCertificatePropertiesFormat
type VpnDeviceScriptParameters = original.VpnDeviceScriptParameters
type Watcher = original.Watcher
type WatcherListResult = original.WatcherListResult
type WatcherPropertiesFormat = original.WatcherPropertiesFormat
type WatchersCheckConnectivityFuture = original.WatchersCheckConnectivityFuture
type WatchersClient = original.WatchersClient
type WatchersDeleteFuture = original.WatchersDeleteFuture
type WatchersGetAzureReachabilityReportFuture = original.WatchersGetAzureReachabilityReportFuture
type WatchersGetFlowLogStatusFuture = original.WatchersGetFlowLogStatusFuture
type WatchersGetNextHopFuture = original.WatchersGetNextHopFuture
type WatchersGetTroubleshootingFuture = original.WatchersGetTroubleshootingFuture
type WatchersGetTroubleshootingResultFuture = original.WatchersGetTroubleshootingResultFuture
type WatchersGetVMSecurityRulesFuture = original.WatchersGetVMSecurityRulesFuture
type WatchersListAvailableProvidersFuture = original.WatchersListAvailableProvidersFuture
type WatchersSetFlowLogConfigurationFuture = original.WatchersSetFlowLogConfigurationFuture
type WatchersVerifyIPFlowFuture = original.WatchersVerifyIPFlowFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewApplicationGatewayAvailableSslPredefinedPoliciesIterator(page ApplicationGatewayAvailableSslPredefinedPoliciesPage) ApplicationGatewayAvailableSslPredefinedPoliciesIterator {
	return original.NewApplicationGatewayAvailableSslPredefinedPoliciesIterator(page)
}
func NewApplicationGatewayAvailableSslPredefinedPoliciesPage(getNextPage func(context.Context, ApplicationGatewayAvailableSslPredefinedPolicies) (ApplicationGatewayAvailableSslPredefinedPolicies, error)) ApplicationGatewayAvailableSslPredefinedPoliciesPage {
	return original.NewApplicationGatewayAvailableSslPredefinedPoliciesPage(getNextPage)
}
func NewApplicationGatewayListResultIterator(page ApplicationGatewayListResultPage) ApplicationGatewayListResultIterator {
	return original.NewApplicationGatewayListResultIterator(page)
}
func NewApplicationGatewayListResultPage(getNextPage func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)) ApplicationGatewayListResultPage {
	return original.NewApplicationGatewayListResultPage(getNextPage)
}
func NewApplicationGatewaysClient(subscriptionID string) ApplicationGatewaysClient {
	return original.NewApplicationGatewaysClient(subscriptionID)
}
func NewApplicationGatewaysClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGatewaysClient {
	return original.NewApplicationGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationSecurityGroupListResultIterator(page ApplicationSecurityGroupListResultPage) ApplicationSecurityGroupListResultIterator {
	return original.NewApplicationSecurityGroupListResultIterator(page)
}
func NewApplicationSecurityGroupListResultPage(getNextPage func(context.Context, ApplicationSecurityGroupListResult) (ApplicationSecurityGroupListResult, error)) ApplicationSecurityGroupListResultPage {
	return original.NewApplicationSecurityGroupListResultPage(getNextPage)
}
func NewApplicationSecurityGroupsClient(subscriptionID string) ApplicationSecurityGroupsClient {
	return original.NewApplicationSecurityGroupsClient(subscriptionID)
}
func NewApplicationSecurityGroupsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationSecurityGroupsClient {
	return original.NewApplicationSecurityGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAuthorizationListResultIterator(page AuthorizationListResultPage) AuthorizationListResultIterator {
	return original.NewAuthorizationListResultIterator(page)
}
func NewAuthorizationListResultPage(getNextPage func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)) AuthorizationListResultPage {
	return original.NewAuthorizationListResultPage(getNextPage)
}
func NewAvailableEndpointServicesClient(subscriptionID string) AvailableEndpointServicesClient {
	return original.NewAvailableEndpointServicesClient(subscriptionID)
}
func NewAvailableEndpointServicesClientWithBaseURI(baseURI string, subscriptionID string) AvailableEndpointServicesClient {
	return original.NewAvailableEndpointServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBgpServiceCommunitiesClient(subscriptionID string) BgpServiceCommunitiesClient {
	return original.NewBgpServiceCommunitiesClient(subscriptionID)
}
func NewBgpServiceCommunitiesClientWithBaseURI(baseURI string, subscriptionID string) BgpServiceCommunitiesClient {
	return original.NewBgpServiceCommunitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBgpServiceCommunityListResultIterator(page BgpServiceCommunityListResultPage) BgpServiceCommunityListResultIterator {
	return original.NewBgpServiceCommunityListResultIterator(page)
}
func NewBgpServiceCommunityListResultPage(getNextPage func(context.Context, BgpServiceCommunityListResult) (BgpServiceCommunityListResult, error)) BgpServiceCommunityListResultPage {
	return original.NewBgpServiceCommunityListResultPage(getNextPage)
}
func NewConnectionMonitorsClient(subscriptionID string) ConnectionMonitorsClient {
	return original.NewConnectionMonitorsClient(subscriptionID)
}
func NewConnectionMonitorsClientWithBaseURI(baseURI string, subscriptionID string) ConnectionMonitorsClient {
	return original.NewConnectionMonitorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDefaultSecurityRulesClient(subscriptionID string) DefaultSecurityRulesClient {
	return original.NewDefaultSecurityRulesClient(subscriptionID)
}
func NewDefaultSecurityRulesClientWithBaseURI(baseURI string, subscriptionID string) DefaultSecurityRulesClient {
	return original.NewDefaultSecurityRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewEndpointServicesListResultIterator(page EndpointServicesListResultPage) EndpointServicesListResultIterator {
	return original.NewEndpointServicesListResultIterator(page)
}
func NewEndpointServicesListResultPage(getNextPage func(context.Context, EndpointServicesListResult) (EndpointServicesListResult, error)) EndpointServicesListResultPage {
	return original.NewEndpointServicesListResultPage(getNextPage)
}
func NewExpressRouteCircuitAuthorizationsClient(subscriptionID string) ExpressRouteCircuitAuthorizationsClient {
	return original.NewExpressRouteCircuitAuthorizationsClient(subscriptionID)
}
func NewExpressRouteCircuitAuthorizationsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitAuthorizationsClient {
	return original.NewExpressRouteCircuitAuthorizationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitListResultIterator(page ExpressRouteCircuitListResultPage) ExpressRouteCircuitListResultIterator {
	return original.NewExpressRouteCircuitListResultIterator(page)
}
func NewExpressRouteCircuitListResultPage(getNextPage func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)) ExpressRouteCircuitListResultPage {
	return original.NewExpressRouteCircuitListResultPage(getNextPage)
}
func NewExpressRouteCircuitPeeringListResultIterator(page ExpressRouteCircuitPeeringListResultPage) ExpressRouteCircuitPeeringListResultIterator {
	return original.NewExpressRouteCircuitPeeringListResultIterator(page)
}
func NewExpressRouteCircuitPeeringListResultPage(getNextPage func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)) ExpressRouteCircuitPeeringListResultPage {
	return original.NewExpressRouteCircuitPeeringListResultPage(getNextPage)
}
func NewExpressRouteCircuitPeeringsClient(subscriptionID string) ExpressRouteCircuitPeeringsClient {
	return original.NewExpressRouteCircuitPeeringsClient(subscriptionID)
}
func NewExpressRouteCircuitPeeringsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitPeeringsClient {
	return original.NewExpressRouteCircuitPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitsClient(subscriptionID string) ExpressRouteCircuitsClient {
	return original.NewExpressRouteCircuitsClient(subscriptionID)
}
func NewExpressRouteCircuitsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitsClient {
	return original.NewExpressRouteCircuitsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteServiceProviderListResultIterator(page ExpressRouteServiceProviderListResultPage) ExpressRouteServiceProviderListResultIterator {
	return original.NewExpressRouteServiceProviderListResultIterator(page)
}
func NewExpressRouteServiceProviderListResultPage(getNextPage func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)) ExpressRouteServiceProviderListResultPage {
	return original.NewExpressRouteServiceProviderListResultPage(getNextPage)
}
func NewExpressRouteServiceProvidersClient(subscriptionID string) ExpressRouteServiceProvidersClient {
	return original.NewExpressRouteServiceProvidersClient(subscriptionID)
}
func NewExpressRouteServiceProvidersClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteServiceProvidersClient {
	return original.NewExpressRouteServiceProvidersClientWithBaseURI(baseURI, subscriptionID)
}
func NewInboundNatRuleListResultIterator(page InboundNatRuleListResultPage) InboundNatRuleListResultIterator {
	return original.NewInboundNatRuleListResultIterator(page)
}
func NewInboundNatRuleListResultPage(getNextPage func(context.Context, InboundNatRuleListResult) (InboundNatRuleListResult, error)) InboundNatRuleListResultPage {
	return original.NewInboundNatRuleListResultPage(getNextPage)
}
func NewInboundNatRulesClient(subscriptionID string) InboundNatRulesClient {
	return original.NewInboundNatRulesClient(subscriptionID)
}
func NewInboundNatRulesClientWithBaseURI(baseURI string, subscriptionID string) InboundNatRulesClient {
	return original.NewInboundNatRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceIPConfigurationListResultIterator(page InterfaceIPConfigurationListResultPage) InterfaceIPConfigurationListResultIterator {
	return original.NewInterfaceIPConfigurationListResultIterator(page)
}
func NewInterfaceIPConfigurationListResultPage(getNextPage func(context.Context, InterfaceIPConfigurationListResult) (InterfaceIPConfigurationListResult, error)) InterfaceIPConfigurationListResultPage {
	return original.NewInterfaceIPConfigurationListResultPage(getNextPage)
}
func NewInterfaceIPConfigurationsClient(subscriptionID string) InterfaceIPConfigurationsClient {
	return original.NewInterfaceIPConfigurationsClient(subscriptionID)
}
func NewInterfaceIPConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) InterfaceIPConfigurationsClient {
	return original.NewInterfaceIPConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceListResultIterator(page InterfaceListResultPage) InterfaceListResultIterator {
	return original.NewInterfaceListResultIterator(page)
}
func NewInterfaceListResultPage(getNextPage func(context.Context, InterfaceListResult) (InterfaceListResult, error)) InterfaceListResultPage {
	return original.NewInterfaceListResultPage(getNextPage)
}
func NewInterfaceLoadBalancerListResultIterator(page InterfaceLoadBalancerListResultPage) InterfaceLoadBalancerListResultIterator {
	return original.NewInterfaceLoadBalancerListResultIterator(page)
}
func NewInterfaceLoadBalancerListResultPage(getNextPage func(context.Context, InterfaceLoadBalancerListResult) (InterfaceLoadBalancerListResult, error)) InterfaceLoadBalancerListResultPage {
	return original.NewInterfaceLoadBalancerListResultPage(getNextPage)
}
func NewInterfaceLoadBalancersClient(subscriptionID string) InterfaceLoadBalancersClient {
	return original.NewInterfaceLoadBalancersClient(subscriptionID)
}
func NewInterfaceLoadBalancersClientWithBaseURI(baseURI string, subscriptionID string) InterfaceLoadBalancersClient {
	return original.NewInterfaceLoadBalancersClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfacesClient(subscriptionID string) InterfacesClient {
	return original.NewInterfacesClient(subscriptionID)
}
func NewInterfacesClientWithBaseURI(baseURI string, subscriptionID string) InterfacesClient {
	return original.NewInterfacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerBackendAddressPoolListResultIterator(page LoadBalancerBackendAddressPoolListResultPage) LoadBalancerBackendAddressPoolListResultIterator {
	return original.NewLoadBalancerBackendAddressPoolListResultIterator(page)
}
func NewLoadBalancerBackendAddressPoolListResultPage(getNextPage func(context.Context, LoadBalancerBackendAddressPoolListResult) (LoadBalancerBackendAddressPoolListResult, error)) LoadBalancerBackendAddressPoolListResultPage {
	return original.NewLoadBalancerBackendAddressPoolListResultPage(getNextPage)
}
func NewLoadBalancerBackendAddressPoolsClient(subscriptionID string) LoadBalancerBackendAddressPoolsClient {
	return original.NewLoadBalancerBackendAddressPoolsClient(subscriptionID)
}
func NewLoadBalancerBackendAddressPoolsClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerBackendAddressPoolsClient {
	return original.NewLoadBalancerBackendAddressPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerFrontendIPConfigurationListResultIterator(page LoadBalancerFrontendIPConfigurationListResultPage) LoadBalancerFrontendIPConfigurationListResultIterator {
	return original.NewLoadBalancerFrontendIPConfigurationListResultIterator(page)
}
func NewLoadBalancerFrontendIPConfigurationListResultPage(getNextPage func(context.Context, LoadBalancerFrontendIPConfigurationListResult) (LoadBalancerFrontendIPConfigurationListResult, error)) LoadBalancerFrontendIPConfigurationListResultPage {
	return original.NewLoadBalancerFrontendIPConfigurationListResultPage(getNextPage)
}
func NewLoadBalancerFrontendIPConfigurationsClient(subscriptionID string) LoadBalancerFrontendIPConfigurationsClient {
	return original.NewLoadBalancerFrontendIPConfigurationsClient(subscriptionID)
}
func NewLoadBalancerFrontendIPConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerFrontendIPConfigurationsClient {
	return original.NewLoadBalancerFrontendIPConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerListResultIterator(page LoadBalancerListResultPage) LoadBalancerListResultIterator {
	return original.NewLoadBalancerListResultIterator(page)
}
func NewLoadBalancerListResultPage(getNextPage func(context.Context, LoadBalancerListResult) (LoadBalancerListResult, error)) LoadBalancerListResultPage {
	return original.NewLoadBalancerListResultPage(getNextPage)
}
func NewLoadBalancerLoadBalancingRuleListResultIterator(page LoadBalancerLoadBalancingRuleListResultPage) LoadBalancerLoadBalancingRuleListResultIterator {
	return original.NewLoadBalancerLoadBalancingRuleListResultIterator(page)
}
func NewLoadBalancerLoadBalancingRuleListResultPage(getNextPage func(context.Context, LoadBalancerLoadBalancingRuleListResult) (LoadBalancerLoadBalancingRuleListResult, error)) LoadBalancerLoadBalancingRuleListResultPage {
	return original.NewLoadBalancerLoadBalancingRuleListResultPage(getNextPage)
}
func NewLoadBalancerLoadBalancingRulesClient(subscriptionID string) LoadBalancerLoadBalancingRulesClient {
	return original.NewLoadBalancerLoadBalancingRulesClient(subscriptionID)
}
func NewLoadBalancerLoadBalancingRulesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerLoadBalancingRulesClient {
	return original.NewLoadBalancerLoadBalancingRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerNetworkInterfacesClient(subscriptionID string) LoadBalancerNetworkInterfacesClient {
	return original.NewLoadBalancerNetworkInterfacesClient(subscriptionID)
}
func NewLoadBalancerNetworkInterfacesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerNetworkInterfacesClient {
	return original.NewLoadBalancerNetworkInterfacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerProbeListResultIterator(page LoadBalancerProbeListResultPage) LoadBalancerProbeListResultIterator {
	return original.NewLoadBalancerProbeListResultIterator(page)
}
func NewLoadBalancerProbeListResultPage(getNextPage func(context.Context, LoadBalancerProbeListResult) (LoadBalancerProbeListResult, error)) LoadBalancerProbeListResultPage {
	return original.NewLoadBalancerProbeListResultPage(getNextPage)
}
func NewLoadBalancerProbesClient(subscriptionID string) LoadBalancerProbesClient {
	return original.NewLoadBalancerProbesClient(subscriptionID)
}
func NewLoadBalancerProbesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerProbesClient {
	return original.NewLoadBalancerProbesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancersClient(subscriptionID string) LoadBalancersClient {
	return original.NewLoadBalancersClient(subscriptionID)
}
func NewLoadBalancersClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancersClient {
	return original.NewLoadBalancersClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocalNetworkGatewayListResultIterator(page LocalNetworkGatewayListResultPage) LocalNetworkGatewayListResultIterator {
	return original.NewLocalNetworkGatewayListResultIterator(page)
}
func NewLocalNetworkGatewayListResultPage(getNextPage func(context.Context, LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)) LocalNetworkGatewayListResultPage {
	return original.NewLocalNetworkGatewayListResultPage(getNextPage)
}
func NewLocalNetworkGatewaysClient(subscriptionID string) LocalNetworkGatewaysClient {
	return original.NewLocalNetworkGatewaysClient(subscriptionID)
}
func NewLocalNetworkGatewaysClientWithBaseURI(baseURI string, subscriptionID string) LocalNetworkGatewaysClient {
	return original.NewLocalNetworkGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPacketCapturesClient(subscriptionID string) PacketCapturesClient {
	return original.NewPacketCapturesClient(subscriptionID)
}
func NewPacketCapturesClientWithBaseURI(baseURI string, subscriptionID string) PacketCapturesClient {
	return original.NewPacketCapturesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPublicIPAddressListResultIterator(page PublicIPAddressListResultPage) PublicIPAddressListResultIterator {
	return original.NewPublicIPAddressListResultIterator(page)
}
func NewPublicIPAddressListResultPage(getNextPage func(context.Context, PublicIPAddressListResult) (PublicIPAddressListResult, error)) PublicIPAddressListResultPage {
	return original.NewPublicIPAddressListResultPage(getNextPage)
}
func NewPublicIPAddressesClient(subscriptionID string) PublicIPAddressesClient {
	return original.NewPublicIPAddressesClient(subscriptionID)
}
func NewPublicIPAddressesClientWithBaseURI(baseURI string, subscriptionID string) PublicIPAddressesClient {
	return original.NewPublicIPAddressesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteFilterListResultIterator(page RouteFilterListResultPage) RouteFilterListResultIterator {
	return original.NewRouteFilterListResultIterator(page)
}
func NewRouteFilterListResultPage(getNextPage func(context.Context, RouteFilterListResult) (RouteFilterListResult, error)) RouteFilterListResultPage {
	return original.NewRouteFilterListResultPage(getNextPage)
}
func NewRouteFilterRuleListResultIterator(page RouteFilterRuleListResultPage) RouteFilterRuleListResultIterator {
	return original.NewRouteFilterRuleListResultIterator(page)
}
func NewRouteFilterRuleListResultPage(getNextPage func(context.Context, RouteFilterRuleListResult) (RouteFilterRuleListResult, error)) RouteFilterRuleListResultPage {
	return original.NewRouteFilterRuleListResultPage(getNextPage)
}
func NewRouteFilterRulesClient(subscriptionID string) RouteFilterRulesClient {
	return original.NewRouteFilterRulesClient(subscriptionID)
}
func NewRouteFilterRulesClientWithBaseURI(baseURI string, subscriptionID string) RouteFilterRulesClient {
	return original.NewRouteFilterRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteFiltersClient(subscriptionID string) RouteFiltersClient {
	return original.NewRouteFiltersClient(subscriptionID)
}
func NewRouteFiltersClientWithBaseURI(baseURI string, subscriptionID string) RouteFiltersClient {
	return original.NewRouteFiltersClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteListResultIterator(page RouteListResultPage) RouteListResultIterator {
	return original.NewRouteListResultIterator(page)
}
func NewRouteListResultPage(getNextPage func(context.Context, RouteListResult) (RouteListResult, error)) RouteListResultPage {
	return original.NewRouteListResultPage(getNextPage)
}
func NewRouteTableListResultIterator(page RouteTableListResultPage) RouteTableListResultIterator {
	return original.NewRouteTableListResultIterator(page)
}
func NewRouteTableListResultPage(getNextPage func(context.Context, RouteTableListResult) (RouteTableListResult, error)) RouteTableListResultPage {
	return original.NewRouteTableListResultPage(getNextPage)
}
func NewRouteTablesClient(subscriptionID string) RouteTablesClient {
	return original.NewRouteTablesClient(subscriptionID)
}
func NewRouteTablesClientWithBaseURI(baseURI string, subscriptionID string) RouteTablesClient {
	return original.NewRouteTablesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRoutesClient(subscriptionID string) RoutesClient {
	return original.NewRoutesClient(subscriptionID)
}
func NewRoutesClientWithBaseURI(baseURI string, subscriptionID string) RoutesClient {
	return original.NewRoutesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityGroupListResultIterator(page SecurityGroupListResultPage) SecurityGroupListResultIterator {
	return original.NewSecurityGroupListResultIterator(page)
}
func NewSecurityGroupListResultPage(getNextPage func(context.Context, SecurityGroupListResult) (SecurityGroupListResult, error)) SecurityGroupListResultPage {
	return original.NewSecurityGroupListResultPage(getNextPage)
}
func NewSecurityGroupsClient(subscriptionID string) SecurityGroupsClient {
	return original.NewSecurityGroupsClient(subscriptionID)
}
func NewSecurityGroupsClientWithBaseURI(baseURI string, subscriptionID string) SecurityGroupsClient {
	return original.NewSecurityGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityRuleListResultIterator(page SecurityRuleListResultPage) SecurityRuleListResultIterator {
	return original.NewSecurityRuleListResultIterator(page)
}
func NewSecurityRuleListResultPage(getNextPage func(context.Context, SecurityRuleListResult) (SecurityRuleListResult, error)) SecurityRuleListResultPage {
	return original.NewSecurityRuleListResultPage(getNextPage)
}
func NewSecurityRulesClient(subscriptionID string) SecurityRulesClient {
	return original.NewSecurityRulesClient(subscriptionID)
}
func NewSecurityRulesClientWithBaseURI(baseURI string, subscriptionID string) SecurityRulesClient {
	return original.NewSecurityRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSubnetListResultIterator(page SubnetListResultPage) SubnetListResultIterator {
	return original.NewSubnetListResultIterator(page)
}
func NewSubnetListResultPage(getNextPage func(context.Context, SubnetListResult) (SubnetListResult, error)) SubnetListResultPage {
	return original.NewSubnetListResultPage(getNextPage)
}
func NewSubnetsClient(subscriptionID string) SubnetsClient {
	return original.NewSubnetsClient(subscriptionID)
}
func NewSubnetsClientWithBaseURI(baseURI string, subscriptionID string) SubnetsClient {
	return original.NewSubnetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesClient(subscriptionID string) UsagesClient {
	return original.NewUsagesClient(subscriptionID)
}
func NewUsagesClientWithBaseURI(baseURI string, subscriptionID string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesListResultIterator(page UsagesListResultPage) UsagesListResultIterator {
	return original.NewUsagesListResultIterator(page)
}
func NewUsagesListResultPage(getNextPage func(context.Context, UsagesListResult) (UsagesListResult, error)) UsagesListResultPage {
	return original.NewUsagesListResultPage(getNextPage)
}
func NewVirtualNetworkGatewayConnectionListResultIterator(page VirtualNetworkGatewayConnectionListResultPage) VirtualNetworkGatewayConnectionListResultIterator {
	return original.NewVirtualNetworkGatewayConnectionListResultIterator(page)
}
func NewVirtualNetworkGatewayConnectionListResultPage(getNextPage func(context.Context, VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)) VirtualNetworkGatewayConnectionListResultPage {
	return original.NewVirtualNetworkGatewayConnectionListResultPage(getNextPage)
}
func NewVirtualNetworkGatewayConnectionsClient(subscriptionID string) VirtualNetworkGatewayConnectionsClient {
	return original.NewVirtualNetworkGatewayConnectionsClient(subscriptionID)
}
func NewVirtualNetworkGatewayConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkGatewayConnectionsClient {
	return original.NewVirtualNetworkGatewayConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkGatewayListConnectionsResultIterator(page VirtualNetworkGatewayListConnectionsResultPage) VirtualNetworkGatewayListConnectionsResultIterator {
	return original.NewVirtualNetworkGatewayListConnectionsResultIterator(page)
}
func NewVirtualNetworkGatewayListConnectionsResultPage(getNextPage func(context.Context, VirtualNetworkGatewayListConnectionsResult) (VirtualNetworkGatewayListConnectionsResult, error)) VirtualNetworkGatewayListConnectionsResultPage {
	return original.NewVirtualNetworkGatewayListConnectionsResultPage(getNextPage)
}
func NewVirtualNetworkGatewayListResultIterator(page VirtualNetworkGatewayListResultPage) VirtualNetworkGatewayListResultIterator {
	return original.NewVirtualNetworkGatewayListResultIterator(page)
}
func NewVirtualNetworkGatewayListResultPage(getNextPage func(context.Context, VirtualNetworkGatewayListResult) (VirtualNetworkGatewayListResult, error)) VirtualNetworkGatewayListResultPage {
	return original.NewVirtualNetworkGatewayListResultPage(getNextPage)
}
func NewVirtualNetworkGatewaysClient(subscriptionID string) VirtualNetworkGatewaysClient {
	return original.NewVirtualNetworkGatewaysClient(subscriptionID)
}
func NewVirtualNetworkGatewaysClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkGatewaysClient {
	return original.NewVirtualNetworkGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkListResultIterator(page VirtualNetworkListResultPage) VirtualNetworkListResultIterator {
	return original.NewVirtualNetworkListResultIterator(page)
}
func NewVirtualNetworkListResultPage(getNextPage func(context.Context, VirtualNetworkListResult) (VirtualNetworkListResult, error)) VirtualNetworkListResultPage {
	return original.NewVirtualNetworkListResultPage(getNextPage)
}
func NewVirtualNetworkListUsageResultIterator(page VirtualNetworkListUsageResultPage) VirtualNetworkListUsageResultIterator {
	return original.NewVirtualNetworkListUsageResultIterator(page)
}
func NewVirtualNetworkListUsageResultPage(getNextPage func(context.Context, VirtualNetworkListUsageResult) (VirtualNetworkListUsageResult, error)) VirtualNetworkListUsageResultPage {
	return original.NewVirtualNetworkListUsageResultPage(getNextPage)
}
func NewVirtualNetworkPeeringListResultIterator(page VirtualNetworkPeeringListResultPage) VirtualNetworkPeeringListResultIterator {
	return original.NewVirtualNetworkPeeringListResultIterator(page)
}
func NewVirtualNetworkPeeringListResultPage(getNextPage func(context.Context, VirtualNetworkPeeringListResult) (VirtualNetworkPeeringListResult, error)) VirtualNetworkPeeringListResultPage {
	return original.NewVirtualNetworkPeeringListResultPage(getNextPage)
}
func NewVirtualNetworkPeeringsClient(subscriptionID string) VirtualNetworkPeeringsClient {
	return original.NewVirtualNetworkPeeringsClient(subscriptionID)
}
func NewVirtualNetworkPeeringsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkPeeringsClient {
	return original.NewVirtualNetworkPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworksClient(subscriptionID string) VirtualNetworksClient {
	return original.NewVirtualNetworksClient(subscriptionID)
}
func NewVirtualNetworksClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworksClient {
	return original.NewVirtualNetworksClientWithBaseURI(baseURI, subscriptionID)
}
func NewWatchersClient(subscriptionID string) WatchersClient {
	return original.NewWatchersClient(subscriptionID)
}
func NewWatchersClientWithBaseURI(baseURI string, subscriptionID string) WatchersClient {
	return original.NewWatchersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessValues() []Access {
	return original.PossibleAccessValues()
}
func PossibleApplicationGatewayBackendHealthServerHealthValues() []ApplicationGatewayBackendHealthServerHealth {
	return original.PossibleApplicationGatewayBackendHealthServerHealthValues()
}
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return original.PossibleApplicationGatewayCookieBasedAffinityValues()
}
func PossibleApplicationGatewayFirewallModeValues() []ApplicationGatewayFirewallMode {
	return original.PossibleApplicationGatewayFirewallModeValues()
}
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return original.PossibleApplicationGatewayOperationalStateValues()
}
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return original.PossibleApplicationGatewayProtocolValues()
}
func PossibleApplicationGatewayRedirectTypeValues() []ApplicationGatewayRedirectType {
	return original.PossibleApplicationGatewayRedirectTypeValues()
}
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return original.PossibleApplicationGatewayRequestRoutingRuleTypeValues()
}
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return original.PossibleApplicationGatewaySkuNameValues()
}
func PossibleApplicationGatewaySslCipherSuiteValues() []ApplicationGatewaySslCipherSuite {
	return original.PossibleApplicationGatewaySslCipherSuiteValues()
}
func PossibleApplicationGatewaySslPolicyNameValues() []ApplicationGatewaySslPolicyName {
	return original.PossibleApplicationGatewaySslPolicyNameValues()
}
func PossibleApplicationGatewaySslPolicyTypeValues() []ApplicationGatewaySslPolicyType {
	return original.PossibleApplicationGatewaySslPolicyTypeValues()
}
func PossibleApplicationGatewaySslProtocolValues() []ApplicationGatewaySslProtocol {
	return original.PossibleApplicationGatewaySslProtocolValues()
}
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return original.PossibleApplicationGatewayTierValues()
}
func PossibleAssociationTypeValues() []AssociationType {
	return original.PossibleAssociationTypeValues()
}
func PossibleAuthenticationMethodValues() []AuthenticationMethod {
	return original.PossibleAuthenticationMethodValues()
}
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return original.PossibleAuthorizationUseStatusValues()
}
func PossibleBgpPeerStateValues() []BgpPeerState {
	return original.PossibleBgpPeerStateValues()
}
func PossibleConnectionStateValues() []ConnectionState {
	return original.PossibleConnectionStateValues()
}
func PossibleConnectionStatusValues() []ConnectionStatus {
	return original.PossibleConnectionStatusValues()
}
func PossibleDhGroupValues() []DhGroup {
	return original.PossibleDhGroupValues()
}
func PossibleDirectionValues() []Direction {
	return original.PossibleDirectionValues()
}
func PossibleEffectiveRouteSourceValues() []EffectiveRouteSource {
	return original.PossibleEffectiveRouteSourceValues()
}
func PossibleEffectiveRouteStateValues() []EffectiveRouteState {
	return original.PossibleEffectiveRouteStateValues()
}
func PossibleEffectiveSecurityRuleProtocolValues() []EffectiveSecurityRuleProtocol {
	return original.PossibleEffectiveSecurityRuleProtocolValues()
}
func PossibleEvaluationStateValues() []EvaluationState {
	return original.PossibleEvaluationStateValues()
}
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return original.PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues()
}
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return original.PossibleExpressRouteCircuitPeeringStateValues()
}
func PossibleExpressRouteCircuitPeeringTypeValues() []ExpressRouteCircuitPeeringType {
	return original.PossibleExpressRouteCircuitPeeringTypeValues()
}
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return original.PossibleExpressRouteCircuitSkuFamilyValues()
}
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return original.PossibleExpressRouteCircuitSkuTierValues()
}
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return original.PossibleIPAllocationMethodValues()
}
func PossibleIPVersionValues() []IPVersion {
	return original.PossibleIPVersionValues()
}
func PossibleIkeEncryptionValues() []IkeEncryption {
	return original.PossibleIkeEncryptionValues()
}
func PossibleIkeIntegrityValues() []IkeIntegrity {
	return original.PossibleIkeIntegrityValues()
}
func PossibleIpsecEncryptionValues() []IpsecEncryption {
	return original.PossibleIpsecEncryptionValues()
}
func PossibleIpsecIntegrityValues() []IpsecIntegrity {
	return original.PossibleIpsecIntegrityValues()
}
func PossibleIssueTypeValues() []IssueType {
	return original.PossibleIssueTypeValues()
}
func PossibleLoadBalancerSkuNameValues() []LoadBalancerSkuName {
	return original.PossibleLoadBalancerSkuNameValues()
}
func PossibleLoadDistributionValues() []LoadDistribution {
	return original.PossibleLoadDistributionValues()
}
func PossibleNextHopTypeValues() []NextHopType {
	return original.PossibleNextHopTypeValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossibleOriginValues() []Origin {
	return original.PossibleOriginValues()
}
func PossiblePcErrorValues() []PcError {
	return original.PossiblePcErrorValues()
}
func PossiblePcProtocolValues() []PcProtocol {
	return original.PossiblePcProtocolValues()
}
func PossiblePcStatusValues() []PcStatus {
	return original.PossiblePcStatusValues()
}
func PossiblePfsGroupValues() []PfsGroup {
	return original.PossiblePfsGroupValues()
}
func PossibleProbeProtocolValues() []ProbeProtocol {
	return original.PossibleProbeProtocolValues()
}
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return original.PossibleProcessorArchitectureValues()
}
func PossibleProtocolValues() []Protocol {
	return original.PossibleProtocolValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return original.PossiblePublicIPAddressSkuNameValues()
}
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return original.PossibleRouteNextHopTypeValues()
}
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return original.PossibleSecurityRuleAccessValues()
}
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return original.PossibleSecurityRuleDirectionValues()
}
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return original.PossibleSecurityRuleProtocolValues()
}
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return original.PossibleServiceProviderProvisioningStateValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleTransportProtocolValues() []TransportProtocol {
	return original.PossibleTransportProtocolValues()
}
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return original.PossibleVirtualNetworkGatewayConnectionStatusValues()
}
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return original.PossibleVirtualNetworkGatewayConnectionTypeValues()
}
func PossibleVirtualNetworkGatewaySkuNameValues() []VirtualNetworkGatewaySkuName {
	return original.PossibleVirtualNetworkGatewaySkuNameValues()
}
func PossibleVirtualNetworkGatewaySkuTierValues() []VirtualNetworkGatewaySkuTier {
	return original.PossibleVirtualNetworkGatewaySkuTierValues()
}
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return original.PossibleVirtualNetworkGatewayTypeValues()
}
func PossibleVirtualNetworkPeeringStateValues() []VirtualNetworkPeeringState {
	return original.PossibleVirtualNetworkPeeringStateValues()
}
func PossibleVpnClientProtocolValues() []VpnClientProtocol {
	return original.PossibleVpnClientProtocolValues()
}
func PossibleVpnTypeValues() []VpnType {
	return original.PossibleVpnTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/2019-03-01"
}
func Version() string {
	return original.Version()
}
