// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package workmailmessageflowiface provides an interface to enable mocking the Amazon WorkMail Message Flow service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package workmailmessageflowiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/workmailmessageflow"
)

// WorkMailMessageFlowAPI provides an interface to enable mocking the
// workmailmessageflow.WorkMailMessageFlow service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon WorkMail Message Flow.
//	func myFunc(svc workmailmessageflowiface.WorkMailMessageFlowAPI) bool {
//	    // Make svc.GetRawMessageContent request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := workmailmessageflow.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockWorkMailMessageFlowClient struct {
//	    workmailmessageflowiface.WorkMailMessageFlowAPI
//	}
//	func (m *mockWorkMailMessageFlowClient) GetRawMessageContent(input *workmailmessageflow.GetRawMessageContentInput) (*workmailmessageflow.GetRawMessageContentOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockWorkMailMessageFlowClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type WorkMailMessageFlowAPI interface {
	GetRawMessageContent(*workmailmessageflow.GetRawMessageContentInput) (*workmailmessageflow.GetRawMessageContentOutput, error)
	GetRawMessageContentWithContext(aws.Context, *workmailmessageflow.GetRawMessageContentInput, ...request.Option) (*workmailmessageflow.GetRawMessageContentOutput, error)
	GetRawMessageContentRequest(*workmailmessageflow.GetRawMessageContentInput) (*request.Request, *workmailmessageflow.GetRawMessageContentOutput)

	PutRawMessageContent(*workmailmessageflow.PutRawMessageContentInput) (*workmailmessageflow.PutRawMessageContentOutput, error)
	PutRawMessageContentWithContext(aws.Context, *workmailmessageflow.PutRawMessageContentInput, ...request.Option) (*workmailmessageflow.PutRawMessageContentOutput, error)
	PutRawMessageContentRequest(*workmailmessageflow.PutRawMessageContentInput) (*request.Request, *workmailmessageflow.PutRawMessageContentOutput)
}

var _ WorkMailMessageFlowAPI = (*workmailmessageflow.WorkMailMessageFlow)(nil)
