// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package paymentcryptography

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAliasRequest method.
//	req, resp := client.CreateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/CreateAlias
func (c *PaymentCryptography) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &CreateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlias API operation for Payment Cryptography Control Plane.
//
// Creates an alias, or a friendly name, for an Amazon Web Services Payment
// Cryptography key. You can use an alias to identify a key in the console and
// when you call cryptographic operations such as EncryptData (https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_EncryptData.html)
// or DecryptData (https://docs.aws.amazon.com/payment-cryptography/latest/DataAPIReference/API_DecryptData.html).
//
// You can associate the alias with any key in the same Amazon Web Services
// Region. Each alias is associated with only one key at a time, but a key can
// have multiple aliases. You can't create an alias without a key. The alias
// must be unique in the account and Amazon Web Services Region, but you can
// create another alias with the same name in a different Amazon Web Services
// Region.
//
// To change the key that's associated with the alias, call UpdateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html).
// To delete the alias, call DeleteAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html).
// These operations don't affect the underlying key. To get the alias that you
// created, call ListAliases (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html).
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - DeleteAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html)
//
//   - GetAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetAlias.html)
//
//   - ListAliases (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html)
//
//   - UpdateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation CreateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     This request would cause a service quota to be exceeded.
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/CreateAlias
func (c *PaymentCryptography) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKey = "CreateKey"

// CreateKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKey for more information on using the CreateKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKeyRequest method.
//	req, resp := client.CreateKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/CreateKey
func (c *PaymentCryptography) CreateKeyRequest(input *CreateKeyInput) (req *request.Request, output *CreateKeyOutput) {
	op := &request.Operation{
		Name:       opCreateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyInput{}
	}

	output = &CreateKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKey API operation for Payment Cryptography Control Plane.
//
// Creates an Amazon Web Services Payment Cryptography key, a logical representation
// of a cryptographic key, that is unique in your account and Amazon Web Services
// Region. You use keys for cryptographic functions such as encryption and decryption.
//
// In addition to the key material used in cryptographic operations, an Amazon
// Web Services Payment Cryptography key includes metadata such as the key ARN,
// key usage, key origin, creation date, description, and key state.
//
// When you create a key, you specify both immutable and mutable data about
// the key. The immutable data contains key attributes that define the scope
// and cryptographic operations that you can perform using the key, for example
// key class (example: SYMMETRIC_KEY), key algorithm (example: TDES_2KEY), key
// usage (example: TR31_P0_PIN_ENCRYPTION_KEY) and key modes of use (example:
// Encrypt). For information about valid combinations of key attributes, see
// Understanding key attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// in the Amazon Web Services Payment Cryptography User Guide. The mutable data
// contained within a key includes usage timestamp and key deletion timestamp
// and can be modified after creation.
//
// Amazon Web Services Payment Cryptography binds key attributes to keys using
// key blocks when you store or export them. Amazon Web Services Payment Cryptography
// stores the key contents wrapped and never stores or transmits them in the
// clear.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - DeleteKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html)
//
//   - GetKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetKey.html)
//
//   - ListKeys (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListKeys.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation CreateKey for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     This request would cause a service quota to be exceeded.
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/CreateKey
func (c *PaymentCryptography) CreateKey(input *CreateKeyInput) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	return out, req.Send()
}

// CreateKeyWithContext is the same as CreateKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) CreateKeyWithContext(ctx aws.Context, input *CreateKeyInput, opts ...request.Option) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlias for more information on using the DeleteAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAliasRequest method.
//	req, resp := client.DeleteAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/DeleteAlias
func (c *PaymentCryptography) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlias API operation for Payment Cryptography Control Plane.
//
// Deletes the alias, but doesn't affect the underlying key.
//
// Each key can have multiple aliases. To get the aliases of all keys, use the
// UpdateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html)
// operation. To change the alias of a key, first use DeleteAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html)
// to delete the current alias and then use CreateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html)
// to create a new alias. To associate an existing alias with a different key,
// call UpdateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html).
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - CreateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html)
//
//   - GetAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetAlias.html)
//
//   - ListAliases (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html)
//
//   - UpdateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/DeleteAlias
func (c *PaymentCryptography) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	return out, req.Send()
}

// DeleteAliasWithContext is the same as DeleteAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) DeleteAliasWithContext(ctx aws.Context, input *DeleteAliasInput, opts ...request.Option) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKey = "DeleteKey"

// DeleteKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKey for more information on using the DeleteKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKeyRequest method.
//	req, resp := client.DeleteKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/DeleteKey
func (c *PaymentCryptography) DeleteKeyRequest(input *DeleteKeyInput) (req *request.Request, output *DeleteKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyInput{}
	}

	output = &DeleteKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKey API operation for Payment Cryptography Control Plane.
//
// Deletes the key material and metadata associated with Amazon Web Services
// Payment Cryptography key.
//
// Key deletion is irreversible. After a key is deleted, you can't perform cryptographic
// operations using the key. For example, you can't decrypt data that was encrypted
// by a deleted Amazon Web Services Payment Cryptography key, and the data may
// become unrecoverable. Because key deletion is destructive, Amazon Web Services
// Payment Cryptography has a safety mechanism to prevent accidental deletion
// of a key. When you call this operation, Amazon Web Services Payment Cryptography
// disables the specified key but doesn't delete it until after a waiting period
// set using DeleteKeyInDays. The default waiting period is 7 days. During the
// waiting period, the KeyState is DELETE_PENDING. After the key is deleted,
// the KeyState is DELETE_COMPLETE.
//
// You should delete a key only when you are sure that you don't need to use
// it anymore and no other parties are utilizing this key. If you aren't sure,
// consider deactivating it instead by calling StopKeyUsage (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StopKeyUsage.html).
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - RestoreKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_RestoreKey.html)
//
//   - StartKeyUsage (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StartKeyUsage.html)
//
//   - StopKeyUsage (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StopKeyUsage.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation DeleteKey for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/DeleteKey
func (c *PaymentCryptography) DeleteKey(input *DeleteKeyInput) (*DeleteKeyOutput, error) {
	req, out := c.DeleteKeyRequest(input)
	return out, req.Send()
}

// DeleteKeyWithContext is the same as DeleteKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) DeleteKeyWithContext(ctx aws.Context, input *DeleteKeyInput, opts ...request.Option) (*DeleteKeyOutput, error) {
	req, out := c.DeleteKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportKey = "ExportKey"

// ExportKeyRequest generates a "aws/request.Request" representing the
// client's request for the ExportKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportKey for more information on using the ExportKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExportKeyRequest method.
//	req, resp := client.ExportKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ExportKey
func (c *PaymentCryptography) ExportKeyRequest(input *ExportKeyInput) (req *request.Request, output *ExportKeyOutput) {
	op := &request.Operation{
		Name:       opExportKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportKeyInput{}
	}

	output = &ExportKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportKey API operation for Payment Cryptography Control Plane.
//
// Exports a key from Amazon Web Services Payment Cryptography.
//
// Amazon Web Services Payment Cryptography simplifies key exchange by replacing
// the existing paper-based approach with a modern electronic approach. With
// ExportKey you can export symmetric keys using either symmetric and asymmetric
// key exchange mechanisms. Using this operation, you can share your Amazon
// Web Services Payment Cryptography generated keys with other service partners
// to perform cryptographic operations outside of Amazon Web Services Payment
// Cryptography
//
// For symmetric key exchange, Amazon Web Services Payment Cryptography uses
// the ANSI X9 TR-31 norm in accordance with PCI PIN guidelines. And for asymmetric
// key exchange, Amazon Web Services Payment Cryptography supports ANSI X9 TR-34
// norm and RSA wrap and unwrap key exchange mechanism. Asymmetric key exchange
// methods are typically used to establish bi-directional trust between the
// two parties exhanging keys and are used for initial key exchange such as
// Key Encryption Key (KEK). After which you can export working keys using symmetric
// method to perform various cryptographic operations within Amazon Web Services
// Payment Cryptography.
//
// The TR-34 norm is intended for exchanging 3DES keys only and keys are imported
// in a WrappedKeyBlock format. Key attributes (such as KeyUsage, KeyAlgorithm,
// KeyModesOfUse, Exportability) are contained within the key block. With RSA
// wrap and unwrap, you can exchange both 3DES and AES-128 keys. The keys are
// imported in a WrappedKeyCryptogram format and you will need to specify the
// key attributes during import.
//
// You can also use ExportKey functionality to generate and export an IPEK (Initial
// Pin Encryption Key) from Amazon Web Services Payment Cryptography using either
// TR-31 or TR-34 export key exchange. IPEK is generated from BDK (Base Derivation
// Key) and ExportDukptInitialKey attribute KSN (KeySerialNumber). The generated
// IPEK does not persist within Amazon Web Services Payment Cryptography and
// has to be re-generated each time during export.
//
// For key exchange using TR-31 or TR-34 key blocks, you can also export optional
// blocks within the key block header which contain additional attribute information
// about the key. The KeyVersion within KeyBlockHeaders indicates the version
// of the key within the key block. Furthermore, KeyExportability within KeyBlockHeaders
// can be used to further restrict exportability of the key after export from
// Amazon Web Services Payment Cryptography.
//
// The OptionalBlocks contain the additional data related to the key. For information
// on data type that can be included within optional blocks, refer to ASC X9.143-2022
// (https://webstore.ansi.org/standards/ascx9/ansix91432022).
//
// Data included in key block headers is signed but transmitted in clear text.
// Sensitive or confidential information should not be included in optional
// blocks. Refer to ASC X9.143-2022 standard for information on allowed data
// type.
//
// # To export initial keys (KEK) or IPEK using TR-34
//
// Using this operation, you can export initial key using TR-34 asymmetric key
// exchange. You can only export KEK generated within Amazon Web Services Payment
// Cryptography. In TR-34 terminology, the sending party of the key is called
// Key Distribution Host (KDH) and the receiving party of the key is called
// Key Receiving Device (KRD). During key export process, KDH is Amazon Web
// Services Payment Cryptography which initiates key export and KRD is the user
// receiving the key.
//
// To initiate TR-34 key export, the KRD must obtain an export token by calling
// GetParametersForExport (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html).
// This operation also generates a key pair for the purpose of key export, signs
// the key and returns back the signing public key certificate (also known as
// KDH signing certificate) and root certificate chain. The KDH uses the private
// key to sign the the export payload and the signing public key certificate
// is provided to KRD to verify the signature. The KRD can import the root certificate
// into its Hardware Security Module (HSM), as required. The export token and
// the associated KDH signing certificate expires after 7 days.
//
// Next the KRD generates a key pair for the the purpose of encrypting the KDH
// key and provides the public key cerificate (also known as KRD wrapping certificate)
// back to KDH. The KRD will also import the root cerificate chain into Amazon
// Web Services Payment Cryptography by calling ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
// for RootCertificatePublicKey. The KDH, Amazon Web Services Payment Cryptography,
// will use the KRD wrapping cerificate to encrypt (wrap) the key under export
// and signs it with signing private key to generate a TR-34 WrappedKeyBlock.
// For more information on TR-34 key export, see section Exporting symmetric
// keys (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-export.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Set the following parameters:
//
//   - ExportAttributes: Specify export attributes in case of IPEK export.
//     This parameter is optional for KEK export.
//
//   - ExportKeyIdentifier: The KeyARN of the KEK or BDK (in case of IPEK)
//     under export.
//
//   - KeyMaterial: Use Tr34KeyBlock parameters.
//
//   - CertificateAuthorityPublicKeyIdentifier: The KeyARN of the certificate
//     chain that signed the KRD wrapping key certificate.
//
//   - ExportToken: Obtained from KDH by calling GetParametersForImport (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html).
//
//   - WrappingKeyCertificate: The public key certificate in PEM format (base64
//     encoded) of the KRD wrapping key Amazon Web Services Payment Cryptography
//     uses for encryption of the TR-34 export payload. This certificate must
//     be signed by the root certificate (CertificateAuthorityPublicKeyIdentifier)
//     imported into Amazon Web Services Payment Cryptography.
//
// When this operation is successful, Amazon Web Services Payment Cryptography
// returns the KEK or IPEK as a TR-34 WrappedKeyBlock.
//
// # To export initial keys (KEK) or IPEK using RSA Wrap and Unwrap
//
// Using this operation, you can export initial key using asymmetric RSA wrap
// and unwrap key exchange method. To initiate export, generate an asymmetric
// key pair on the receiving HSM and obtain the public key certificate in PEM
// format (base64 encoded) for the purpose of wrapping and the root certifiate
// chain. Import the root certificate into Amazon Web Services Payment Cryptography
// by calling ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
// for RootCertificatePublicKey.
//
// Next call ExportKey and set the following parameters:
//
//   - CertificateAuthorityPublicKeyIdentifier: The KeyARN of the certificate
//     chain that signed wrapping key certificate.
//
//   - KeyMaterial: Set to KeyCryptogram.
//
//   - WrappingKeyCertificate: The public key certificate in PEM format (base64
//     encoded) obtained by the receiving HSM and signed by the root certificate
//     (CertificateAuthorityPublicKeyIdentifier) imported into Amazon Web Services
//     Payment Cryptography. The receiving HSM uses its private key component
//     to unwrap the WrappedKeyCryptogram.
//
// When this operation is successful, Amazon Web Services Payment Cryptography
// returns the WrappedKeyCryptogram.
//
// # To export working keys or IPEK using TR-31
//
// Using this operation, you can export working keys or IPEK using TR-31 symmetric
// key exchange. In TR-31, you must use an initial key such as KEK to encrypt
// or wrap the key under export. To establish a KEK, you can use CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html)
// or ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html).
//
// Set the following parameters:
//
//   - ExportAttributes: Specify export attributes in case of IPEK export.
//     This parameter is optional for KEK export.
//
//   - ExportKeyIdentifier: The KeyARN of the KEK or BDK (in case of IPEK)
//     under export.
//
//   - KeyMaterial: Use Tr31KeyBlock parameters.
//
// When this operation is successful, Amazon Web Services Payment Cryptography
// returns the working key or IPEK as a TR-31 WrappedKeyBlock.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - GetParametersForExport (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html)
//
//   - ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation ExportKey for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ExportKey
func (c *PaymentCryptography) ExportKey(input *ExportKeyInput) (*ExportKeyOutput, error) {
	req, out := c.ExportKeyRequest(input)
	return out, req.Send()
}

// ExportKeyWithContext is the same as ExportKey with the addition of
// the ability to pass a context and additional request options.
//
// See ExportKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) ExportKeyWithContext(ctx aws.Context, input *ExportKeyInput, opts ...request.Option) (*ExportKeyOutput, error) {
	req, out := c.ExportKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAlias = "GetAlias"

// GetAliasRequest generates a "aws/request.Request" representing the
// client's request for the GetAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAlias for more information on using the GetAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAliasRequest method.
//	req, resp := client.GetAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetAlias
func (c *PaymentCryptography) GetAliasRequest(input *GetAliasInput) (req *request.Request, output *GetAliasOutput) {
	op := &request.Operation{
		Name:       opGetAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAliasInput{}
	}

	output = &GetAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAlias API operation for Payment Cryptography Control Plane.
//
// Gets the Amazon Web Services Payment Cryptography key associated with the
// alias.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - CreateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html)
//
//   - DeleteAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html)
//
//   - ListAliases (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html)
//
//   - UpdateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation GetAlias for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetAlias
func (c *PaymentCryptography) GetAlias(input *GetAliasInput) (*GetAliasOutput, error) {
	req, out := c.GetAliasRequest(input)
	return out, req.Send()
}

// GetAliasWithContext is the same as GetAlias with the addition of
// the ability to pass a context and additional request options.
//
// See GetAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) GetAliasWithContext(ctx aws.Context, input *GetAliasInput, opts ...request.Option) (*GetAliasOutput, error) {
	req, out := c.GetAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKey = "GetKey"

// GetKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKey for more information on using the GetKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKeyRequest method.
//	req, resp := client.GetKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetKey
func (c *PaymentCryptography) GetKeyRequest(input *GetKeyInput) (req *request.Request, output *GetKeyOutput) {
	op := &request.Operation{
		Name:       opGetKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyInput{}
	}

	output = &GetKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKey API operation for Payment Cryptography Control Plane.
//
// Gets the key material for an Amazon Web Services Payment Cryptography key,
// including the immutable and mutable data specified when the key was created.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html)
//
//   - DeleteKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html)
//
//   - ListKeys (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListKeys.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation GetKey for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetKey
func (c *PaymentCryptography) GetKey(input *GetKeyInput) (*GetKeyOutput, error) {
	req, out := c.GetKeyRequest(input)
	return out, req.Send()
}

// GetKeyWithContext is the same as GetKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) GetKeyWithContext(ctx aws.Context, input *GetKeyInput, opts ...request.Option) (*GetKeyOutput, error) {
	req, out := c.GetKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParametersForExport = "GetParametersForExport"

// GetParametersForExportRequest generates a "aws/request.Request" representing the
// client's request for the GetParametersForExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParametersForExport for more information on using the GetParametersForExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParametersForExportRequest method.
//	req, resp := client.GetParametersForExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetParametersForExport
func (c *PaymentCryptography) GetParametersForExportRequest(input *GetParametersForExportInput) (req *request.Request, output *GetParametersForExportOutput) {
	op := &request.Operation{
		Name:       opGetParametersForExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParametersForExportInput{}
	}

	output = &GetParametersForExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParametersForExport API operation for Payment Cryptography Control Plane.
//
// Gets the export token and the signing key certificate to initiate a TR-34
// key export from Amazon Web Services Payment Cryptography.
//
// The signing key certificate signs the wrapped key under export within the
// TR-34 key payload. The export token and signing key certificate must be in
// place and operational before calling ExportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ExportKey.html).
// The export token expires in 7 days. You can use the same export token to
// export multiple keys from your service account.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - ExportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ExportKey.html)
//
//   - GetParametersForImport (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation GetParametersForExport for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     This request would cause a service quota to be exceeded.
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetParametersForExport
func (c *PaymentCryptography) GetParametersForExport(input *GetParametersForExportInput) (*GetParametersForExportOutput, error) {
	req, out := c.GetParametersForExportRequest(input)
	return out, req.Send()
}

// GetParametersForExportWithContext is the same as GetParametersForExport with the addition of
// the ability to pass a context and additional request options.
//
// See GetParametersForExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) GetParametersForExportWithContext(ctx aws.Context, input *GetParametersForExportInput, opts ...request.Option) (*GetParametersForExportOutput, error) {
	req, out := c.GetParametersForExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParametersForImport = "GetParametersForImport"

// GetParametersForImportRequest generates a "aws/request.Request" representing the
// client's request for the GetParametersForImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParametersForImport for more information on using the GetParametersForImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParametersForImportRequest method.
//	req, resp := client.GetParametersForImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetParametersForImport
func (c *PaymentCryptography) GetParametersForImportRequest(input *GetParametersForImportInput) (req *request.Request, output *GetParametersForImportOutput) {
	op := &request.Operation{
		Name:       opGetParametersForImport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParametersForImportInput{}
	}

	output = &GetParametersForImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParametersForImport API operation for Payment Cryptography Control Plane.
//
// Gets the import token and the wrapping key certificate in PEM format (base64
// encoded) to initiate a TR-34 WrappedKeyBlock or a RSA WrappedKeyCryptogram
// import into Amazon Web Services Payment Cryptography.
//
// The wrapping key certificate wraps the key under import. The import token
// and wrapping key certificate must be in place and operational before calling
// ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html).
// The import token expires in 7 days. You can use the same import token to
// import multiple keys into your service account.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - GetParametersForExport (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html)
//
//   - ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation GetParametersForImport for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     This request would cause a service quota to be exceeded.
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetParametersForImport
func (c *PaymentCryptography) GetParametersForImport(input *GetParametersForImportInput) (*GetParametersForImportOutput, error) {
	req, out := c.GetParametersForImportRequest(input)
	return out, req.Send()
}

// GetParametersForImportWithContext is the same as GetParametersForImport with the addition of
// the ability to pass a context and additional request options.
//
// See GetParametersForImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) GetParametersForImportWithContext(ctx aws.Context, input *GetParametersForImportInput, opts ...request.Option) (*GetParametersForImportOutput, error) {
	req, out := c.GetParametersForImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicKeyCertificate = "GetPublicKeyCertificate"

// GetPublicKeyCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicKeyCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicKeyCertificate for more information on using the GetPublicKeyCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPublicKeyCertificateRequest method.
//	req, resp := client.GetPublicKeyCertificateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetPublicKeyCertificate
func (c *PaymentCryptography) GetPublicKeyCertificateRequest(input *GetPublicKeyCertificateInput) (req *request.Request, output *GetPublicKeyCertificateOutput) {
	op := &request.Operation{
		Name:       opGetPublicKeyCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPublicKeyCertificateInput{}
	}

	output = &GetPublicKeyCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPublicKeyCertificate API operation for Payment Cryptography Control Plane.
//
// Gets the public key certificate of the asymmetric key pair that exists within
// Amazon Web Services Payment Cryptography.
//
// Unlike the private key of an asymmetric key, which never leaves Amazon Web
// Services Payment Cryptography unencrypted, callers with GetPublicKeyCertificate
// permission can download the public key certificate of the asymmetric key.
// You can share the public key certificate to allow others to encrypt messages
// and verify signatures outside of Amazon Web Services Payment Cryptography
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation GetPublicKeyCertificate for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/GetPublicKeyCertificate
func (c *PaymentCryptography) GetPublicKeyCertificate(input *GetPublicKeyCertificateInput) (*GetPublicKeyCertificateOutput, error) {
	req, out := c.GetPublicKeyCertificateRequest(input)
	return out, req.Send()
}

// GetPublicKeyCertificateWithContext is the same as GetPublicKeyCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicKeyCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) GetPublicKeyCertificateWithContext(ctx aws.Context, input *GetPublicKeyCertificateInput, opts ...request.Option) (*GetPublicKeyCertificateOutput, error) {
	req, out := c.GetPublicKeyCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportKey = "ImportKey"

// ImportKeyRequest generates a "aws/request.Request" representing the
// client's request for the ImportKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportKey for more information on using the ImportKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportKeyRequest method.
//	req, resp := client.ImportKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ImportKey
func (c *PaymentCryptography) ImportKeyRequest(input *ImportKeyInput) (req *request.Request, output *ImportKeyOutput) {
	op := &request.Operation{
		Name:       opImportKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyInput{}
	}

	output = &ImportKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportKey API operation for Payment Cryptography Control Plane.
//
// Imports symmetric keys and public key certificates in PEM format (base64
// encoded) into Amazon Web Services Payment Cryptography.
//
// Amazon Web Services Payment Cryptography simplifies key exchange by replacing
// the existing paper-based approach with a modern electronic approach. With
// ImportKey you can import symmetric keys using either symmetric and asymmetric
// key exchange mechanisms.
//
// For symmetric key exchange, Amazon Web Services Payment Cryptography uses
// the ANSI X9 TR-31 norm in accordance with PCI PIN guidelines. And for asymmetric
// key exchange, Amazon Web Services Payment Cryptography supports ANSI X9 TR-34
// norm and RSA wrap and unwrap key exchange mechanisms. Asymmetric key exchange
// methods are typically used to establish bi-directional trust between the
// two parties exhanging keys and are used for initial key exchange such as
// Key Encryption Key (KEK) or Zone Master Key (ZMK). After which you can import
// working keys using symmetric method to perform various cryptographic operations
// within Amazon Web Services Payment Cryptography.
//
// The TR-34 norm is intended for exchanging 3DES keys only and keys are imported
// in a WrappedKeyBlock format. Key attributes (such as KeyUsage, KeyAlgorithm,
// KeyModesOfUse, Exportability) are contained within the key block. With RSA
// wrap and unwrap, you can exchange both 3DES and AES-128 keys. The keys are
// imported in a WrappedKeyCryptogram format and you will need to specify the
// key attributes during import.
//
// You can also import a root public key certificate, used to sign other public
// key certificates, or a trusted public key certificate under an already established
// root public key certificate.
//
// # To import a public root key certificate
//
// You can also import a root public key certificate, used to sign other public
// key certificates, or a trusted public key certificate under an already established
// root public key certificate.
//
// # To import a public root key certificate
//
// Using this operation, you can import the public component (in PEM cerificate
// format) of your private root key. You can use the imported public root key
// certificate for digital signatures, for example signing wrapping key or signing
// key in TR-34, within your Amazon Web Services Payment Cryptography account.
//
// Set the following parameters:
//
//   - KeyMaterial: RootCertificatePublicKey
//
//   - KeyClass: PUBLIC_KEY
//
//   - KeyModesOfUse: Verify
//
//   - KeyUsage: TR31_S0_ASYMMETRIC_KEY_FOR_DIGITAL_SIGNATURE
//
//   - PublicKeyCertificate: The public key certificate in PEM format (base64
//     encoded) of the private root key under import.
//
// # To import a trusted public key certificate
//
// The root public key certificate must be in place and operational before you
// import a trusted public key certificate. Set the following parameters:
//
//   - KeyMaterial: TrustedCertificatePublicKey
//
//   - CertificateAuthorityPublicKeyIdentifier: KeyArn of the RootCertificatePublicKey.
//
//   - KeyModesOfUse and KeyUsage: Corresponding to the cryptographic operations
//     such as wrap, sign, or encrypt that you will allow the trusted public
//     key certificate to perform.
//
//   - PublicKeyCertificate: The trusted public key certificate in PEM format
//     (base64 encoded) under import.
//
// # To import initial keys (KEK or ZMK or similar) using TR-34
//
// Using this operation, you can import initial key using TR-34 asymmetric key
// exchange. In TR-34 terminology, the sending party of the key is called Key
// Distribution Host (KDH) and the receiving party of the key is called Key
// Receiving Device (KRD). During the key import process, KDH is the user who
// initiates the key import and KRD is Amazon Web Services Payment Cryptography
// who receives the key.
//
// To initiate TR-34 key import, the KDH must obtain an import token by calling
// GetParametersForImport (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html).
// This operation generates an encryption keypair for the purpose of key import,
// signs the key and returns back the wrapping key certificate (also known as
// KRD wrapping certificate) and the root certificate chain. The KDH must trust
// and install the KRD wrapping certificate on its HSM and use it to encrypt
// (wrap) the KDH key during TR-34 WrappedKeyBlock generation. The import token
// and associated KRD wrapping certificate expires after 7 days.
//
// Next the KDH generates a key pair for the purpose of signing the encrypted
// KDH key and provides the public certificate of the signing key to Amazon
// Web Services Payment Cryptography. The KDH will also need to import the root
// certificate chain of the KDH signing certificate by calling ImportKey for
// RootCertificatePublicKey. For more information on TR-34 key import, see section
// Importing symmetric keys (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-import.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Set the following parameters:
//
//   - KeyMaterial: Use Tr34KeyBlock parameters.
//
//   - CertificateAuthorityPublicKeyIdentifier: The KeyARN of the certificate
//     chain that signed the KDH signing key certificate.
//
//   - ImportToken: Obtained from KRD by calling GetParametersForImport (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html).
//
//   - WrappedKeyBlock: The TR-34 wrapped key material from KDH. It contains
//     the KDH key under import, wrapped with KRD wrapping certificate and signed
//     by KDH signing private key. This TR-34 key block is typically generated
//     by the KDH Hardware Security Module (HSM) outside of Amazon Web Services
//     Payment Cryptography.
//
//   - SigningKeyCertificate: The public key certificate in PEM format (base64
//     encoded) of the KDH signing key generated under the root certificate (CertificateAuthorityPublicKeyIdentifier)
//     imported in Amazon Web Services Payment Cryptography.
//
// # To import initial keys (KEK or ZMK or similar) using RSA Wrap and Unwrap
//
// Using this operation, you can import initial key using asymmetric RSA wrap
// and unwrap key exchange method. To initiate import, call GetParametersForImport
// (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html)
// with KeyMaterial set to KEY_CRYPTOGRAM to generate an import token. This
// operation also generates an encryption keypair for the purpose of key import,
// signs the key and returns back the wrapping key certificate in PEM format
// (base64 encoded) and its root certificate chain. The import token and associated
// KRD wrapping certificate expires after 7 days.
//
// You must trust and install the wrapping certificate and its certificate chain
// on the sending HSM and use it to wrap the key under export for WrappedKeyCryptogram
// generation. Next call ImportKey with KeyMaterial set to KEY_CRYPTOGRAM and
// provide the ImportToken and KeyAttributes for the key under import.
//
// # To import working keys using TR-31
//
// Amazon Web Services Payment Cryptography uses TR-31 symmetric key exchange
// norm to import working keys. A KEK must be established within Amazon Web
// Services Payment Cryptography by using TR-34 key import or by using CreateKey
// (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html).
// To initiate a TR-31 key import, set the following parameters:
//
//   - KeyMaterial: Use Tr31KeyBlock parameters.
//
//   - WrappedKeyBlock: The TR-31 wrapped key material. It contains the key
//     under import, encrypted using KEK. The TR-31 key block is typically generated
//     by a HSM outside of Amazon Web Services Payment Cryptography.
//
//   - WrappingKeyIdentifier: The KeyArn of the KEK that Amazon Web Services
//     Payment Cryptography uses to decrypt or unwrap the key under import.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - ExportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ExportKey.html)
//
//   - GetParametersForImport (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation ImportKey for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     This request would cause a service quota to be exceeded.
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ImportKey
func (c *PaymentCryptography) ImportKey(input *ImportKeyInput) (*ImportKeyOutput, error) {
	req, out := c.ImportKeyRequest(input)
	return out, req.Send()
}

// ImportKeyWithContext is the same as ImportKey with the addition of
// the ability to pass a context and additional request options.
//
// See ImportKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) ImportKeyWithContext(ctx aws.Context, input *ImportKeyInput, opts ...request.Option) (*ImportKeyOutput, error) {
	req, out := c.ImportKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAliases for more information on using the ListAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAliasesRequest method.
//	req, resp := client.ListAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ListAliases
func (c *PaymentCryptography) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for Payment Cryptography Control Plane.
//
// Lists the aliases for all keys in the caller's Amazon Web Services account
// and Amazon Web Services Region. You can filter the list of aliases. For more
// information, see Using aliases (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-managealias.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// This is a paginated operation, which means that each response might contain
// only a subset of all the aliases. When the response contains only a subset
// of aliases, it includes a NextToken value. Use this value in a subsequent
// ListAliases request to get more aliases. When you receive a response with
// no NextToken (or an empty or null value), that means there are no more aliases
// to get.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - CreateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html)
//
//   - DeleteAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html)
//
//   - GetAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetAlias.html)
//
//   - UpdateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UpdateAlias.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation ListAliases for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ListAliases
func (c *PaymentCryptography) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	return out, req.Send()
}

// ListAliasesWithContext is the same as ListAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) ListAliasesWithContext(ctx aws.Context, input *ListAliasesInput, opts ...request.Option) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAliasesPages iterates over the pages of a ListAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAliases operation.
//	pageNum := 0
//	err := client.ListAliasesPages(params,
//	    func(page *paymentcryptography.ListAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PaymentCryptography) ListAliasesPages(input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool) error {
	return c.ListAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAliasesPagesWithContext same as ListAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) ListAliasesPagesWithContext(ctx aws.Context, input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKeys = "ListKeys"

// ListKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeys for more information on using the ListKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKeysRequest method.
//	req, resp := client.ListKeysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ListKeys
func (c *PaymentCryptography) ListKeysRequest(input *ListKeysInput) (req *request.Request, output *ListKeysOutput) {
	op := &request.Operation{
		Name:       opListKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeysInput{}
	}

	output = &ListKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeys API operation for Payment Cryptography Control Plane.
//
// Lists the keys in the caller's Amazon Web Services account and Amazon Web
// Services Region. You can filter the list of keys.
//
// This is a paginated operation, which means that each response might contain
// only a subset of all the keys. When the response contains only a subset of
// keys, it includes a NextToken value. Use this value in a subsequent ListKeys
// request to get more keys. When you receive a response with no NextToken (or
// an empty or null value), that means there are no more keys to get.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html)
//
//   - DeleteKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html)
//
//   - GetKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetKey.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation ListKeys for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ListKeys
func (c *PaymentCryptography) ListKeys(input *ListKeysInput) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	return out, req.Send()
}

// ListKeysWithContext is the same as ListKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) ListKeysWithContext(ctx aws.Context, input *ListKeysInput, opts ...request.Option) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeysPages iterates over the pages of a ListKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKeys operation.
//	pageNum := 0
//	err := client.ListKeysPages(params,
//	    func(page *paymentcryptography.ListKeysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PaymentCryptography) ListKeysPages(input *ListKeysInput, fn func(*ListKeysOutput, bool) bool) error {
	return c.ListKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeysPagesWithContext same as ListKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) ListKeysPagesWithContext(ctx aws.Context, input *ListKeysInput, fn func(*ListKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ListTagsForResource
func (c *PaymentCryptography) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Payment Cryptography Control Plane.
//
// Lists the tags for an Amazon Web Services resource.
//
// This is a paginated operation, which means that each response might contain
// only a subset of all the tags. When the response contains only a subset of
// tags, it includes a NextToken value. Use this value in a subsequent ListTagsForResource
// request to get more tags. When you receive a response with no NextToken (or
// an empty or null value), that means there are no more tags to get.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - TagResource (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html)
//
//   - UntagResource (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UntagResource.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/ListTagsForResource
func (c *PaymentCryptography) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *paymentcryptography.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PaymentCryptography) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRestoreKey = "RestoreKey"

// RestoreKeyRequest generates a "aws/request.Request" representing the
// client's request for the RestoreKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreKey for more information on using the RestoreKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreKeyRequest method.
//	req, resp := client.RestoreKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/RestoreKey
func (c *PaymentCryptography) RestoreKeyRequest(input *RestoreKeyInput) (req *request.Request, output *RestoreKeyOutput) {
	op := &request.Operation{
		Name:       opRestoreKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreKeyInput{}
	}

	output = &RestoreKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreKey API operation for Payment Cryptography Control Plane.
//
// Cancels a scheduled key deletion during the waiting period. Use this operation
// to restore a Key that is scheduled for deletion.
//
// During the waiting period, the KeyState is DELETE_PENDING and deletePendingTimestamp
// contains the date and time after which the Key will be deleted. After Key
// is restored, the KeyState is CREATE_COMPLETE, and the value for deletePendingTimestamp
// is removed.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - DeleteKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html)
//
//   - StartKeyUsage (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StartKeyUsage.html)
//
//   - StopKeyUsage (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StopKeyUsage.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation RestoreKey for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     This request would cause a service quota to be exceeded.
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/RestoreKey
func (c *PaymentCryptography) RestoreKey(input *RestoreKeyInput) (*RestoreKeyOutput, error) {
	req, out := c.RestoreKeyRequest(input)
	return out, req.Send()
}

// RestoreKeyWithContext is the same as RestoreKey with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) RestoreKeyWithContext(ctx aws.Context, input *RestoreKeyInput, opts ...request.Option) (*RestoreKeyOutput, error) {
	req, out := c.RestoreKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartKeyUsage = "StartKeyUsage"

// StartKeyUsageRequest generates a "aws/request.Request" representing the
// client's request for the StartKeyUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartKeyUsage for more information on using the StartKeyUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartKeyUsageRequest method.
//	req, resp := client.StartKeyUsageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/StartKeyUsage
func (c *PaymentCryptography) StartKeyUsageRequest(input *StartKeyUsageInput) (req *request.Request, output *StartKeyUsageOutput) {
	op := &request.Operation{
		Name:       opStartKeyUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartKeyUsageInput{}
	}

	output = &StartKeyUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartKeyUsage API operation for Payment Cryptography Control Plane.
//
// Enables an Amazon Web Services Payment Cryptography key, which makes it active
// for cryptographic operations within Amazon Web Services Payment Cryptography
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - StopKeyUsage (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StopKeyUsage.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation StartKeyUsage for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     This request would cause a service quota to be exceeded.
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/StartKeyUsage
func (c *PaymentCryptography) StartKeyUsage(input *StartKeyUsageInput) (*StartKeyUsageOutput, error) {
	req, out := c.StartKeyUsageRequest(input)
	return out, req.Send()
}

// StartKeyUsageWithContext is the same as StartKeyUsage with the addition of
// the ability to pass a context and additional request options.
//
// See StartKeyUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) StartKeyUsageWithContext(ctx aws.Context, input *StartKeyUsageInput, opts ...request.Option) (*StartKeyUsageOutput, error) {
	req, out := c.StartKeyUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopKeyUsage = "StopKeyUsage"

// StopKeyUsageRequest generates a "aws/request.Request" representing the
// client's request for the StopKeyUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopKeyUsage for more information on using the StopKeyUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopKeyUsageRequest method.
//	req, resp := client.StopKeyUsageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/StopKeyUsage
func (c *PaymentCryptography) StopKeyUsageRequest(input *StopKeyUsageInput) (req *request.Request, output *StopKeyUsageOutput) {
	op := &request.Operation{
		Name:       opStopKeyUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopKeyUsageInput{}
	}

	output = &StopKeyUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopKeyUsage API operation for Payment Cryptography Control Plane.
//
// Disables an Amazon Web Services Payment Cryptography key, which makes it
// inactive within Amazon Web Services Payment Cryptography.
//
// You can use this operation instead of DeleteKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html)
// to deactivate a key. You can enable the key in the future by calling StartKeyUsage
// (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StartKeyUsage.html).
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - DeleteKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html)
//
//   - StartKeyUsage (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_StartKeyUsage.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation StopKeyUsage for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     This request would cause a service quota to be exceeded.
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/StopKeyUsage
func (c *PaymentCryptography) StopKeyUsage(input *StopKeyUsageInput) (*StopKeyUsageOutput, error) {
	req, out := c.StopKeyUsageRequest(input)
	return out, req.Send()
}

// StopKeyUsageWithContext is the same as StopKeyUsage with the addition of
// the ability to pass a context and additional request options.
//
// See StopKeyUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) StopKeyUsageWithContext(ctx aws.Context, input *StopKeyUsageInput, opts ...request.Option) (*StopKeyUsageOutput, error) {
	req, out := c.StopKeyUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/TagResource
func (c *PaymentCryptography) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Payment Cryptography Control Plane.
//
// Adds or edits tags on an Amazon Web Services Payment Cryptography key.
//
// Tagging or untagging an Amazon Web Services Payment Cryptography key can
// allow or deny permission to the key.
//
// Each tag consists of a tag key and a tag value, both of which are case-sensitive
// strings. The tag value can be an empty (null) string. To add a tag, specify
// a new tag key and a tag value. To edit a tag, specify an existing tag key
// and a new tag value. You can also add tags to an Amazon Web Services Payment
// Cryptography key when you create it with CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html).
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - ListTagsForResource (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListTagsForResource.html)
//
//   - UntagResource (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_UntagResource.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     This request would cause a service quota to be exceeded.
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/TagResource
func (c *PaymentCryptography) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/UntagResource
func (c *PaymentCryptography) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Payment Cryptography Control Plane.
//
// Deletes a tag from an Amazon Web Services Payment Cryptography key.
//
// Tagging or untagging an Amazon Web Services Payment Cryptography key can
// allow or deny permission to the key.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - ListTagsForResource (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListTagsForResource.html)
//
//   - TagResource (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/UntagResource
func (c *PaymentCryptography) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAlias for more information on using the UpdateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAliasRequest method.
//	req, resp := client.UpdateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/UpdateAlias
func (c *PaymentCryptography) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *UpdateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	output = &UpdateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAlias API operation for Payment Cryptography Control Plane.
//
// Associates an existing Amazon Web Services Payment Cryptography alias with
// a different key. Each alias is associated with only one Amazon Web Services
// Payment Cryptography key at a time, although a key can have multiple aliases.
// The alias and the Amazon Web Services Payment Cryptography key must be in
// the same Amazon Web Services account and Amazon Web Services Region
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - CreateAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateAlias.html)
//
//   - DeleteAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteAlias.html)
//
//   - GetAlias (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetAlias.html)
//
//   - ListAliases (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListAliases.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Control Plane's
// API operation UpdateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service cannot complete the request.
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - ConflictException
//     This request can cause an inconsistent state for the resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-2021-09-14/UpdateAlias
func (c *PaymentCryptography) UpdateAlias(input *UpdateAliasInput) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	return out, req.Send()
}

// UpdateAliasWithContext is the same as UpdateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptography) UpdateAliasWithContext(ctx aws.Context, input *UpdateAliasInput, opts ...request.Option) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about an alias.
type Alias struct {
	_ struct{} `type:"structure"`

	// A friendly name that you can use to refer to a key. The value must begin
	// with alias/.
	//
	// Do not include confidential or sensitive information in this field. This
	// field may be displayed in plaintext in CloudTrail logs and other output.
	//
	// AliasName is a required field
	AliasName *string `min:"7" type:"string" required:"true"`

	// The KeyARN of the key associated with the alias.
	KeyArn *string `min:"70" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alias) GoString() string {
	return s.String()
}

// SetAliasName sets the AliasName field's value.
func (s *Alias) SetAliasName(v string) *Alias {
	s.AliasName = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *Alias) SetKeyArn(v string) *Alias {
	s.KeyArn = &v
	return s
}

// This request can cause an inconsistent state for the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// A friendly name that you can use to refer to a key. An alias must begin with
	// alias/ followed by a name, for example alias/ExampleAlias. It can contain
	// only alphanumeric characters, forward slashes (/), underscores (_), and dashes
	// (-).
	//
	// Don't include personal, confidential or sensitive information in this field.
	// This field may be displayed in plaintext in CloudTrail logs and other output.
	//
	// AliasName is a required field
	AliasName *string `min:"7" type:"string" required:"true"`

	// The KeyARN of the key to associate with the alias.
	KeyArn *string `min:"70" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 7))
	}
	if s.KeyArn != nil && len(*s.KeyArn) < 70 {
		invalidParams.Add(request.NewErrParamMinLen("KeyArn", 70))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *CreateAliasInput) SetAliasName(v string) *CreateAliasInput {
	s.AliasName = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *CreateAliasInput) SetKeyArn(v string) *CreateAliasInput {
	s.KeyArn = &v
	return s
}

type CreateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The alias for the key.
	//
	// Alias is a required field
	Alias *Alias `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *CreateAliasOutput) SetAlias(v *Alias) *CreateAliasOutput {
	s.Alias = v
	return s
}

type CreateKeyInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to enable the key. If the key is enabled, it is activated
	// for use within the service. If the key is not enabled, then it is created
	// but not activated. The default value is enabled.
	Enabled *bool `type:"boolean"`

	// Specifies whether the key is exportable from the service.
	//
	// Exportable is a required field
	Exportable *bool `type:"boolean" required:"true"`

	// The role of the key, the algorithm it supports, and the cryptographic operations
	// allowed with the key. This data is immutable after the key is created.
	//
	// KeyAttributes is a required field
	KeyAttributes *KeyAttributes `type:"structure" required:"true"`

	// The algorithm that Amazon Web Services Payment Cryptography uses to calculate
	// the key check value (KCV). It is used to validate the key integrity.
	//
	// For TDES keys, the KCV is computed by encrypting 8 bytes, each with value
	// of zero, with the key to be checked and retaining the 3 highest order bytes
	// of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm
	// where the input data is 16 bytes of zero and retaining the 3 highest order
	// bytes of the encrypted result.
	KeyCheckValueAlgorithm *string `type:"string" enum:"KeyCheckValueAlgorithm"`

	// Assigns one or more tags to the Amazon Web Services Payment Cryptography
	// key. Use this parameter to tag a key when it is created. To tag an existing
	// Amazon Web Services Payment Cryptography key, use the TagResource (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html)
	// operation.
	//
	// Each tag consists of a tag key and a tag value. Both the tag key and the
	// tag value are required, but the tag value can be an empty (null) string.
	// You can't have more than one tag on an Amazon Web Services Payment Cryptography
	// key with the same tag key.
	//
	// Don't include personal, confidential or sensitive information in this field.
	// This field may be displayed in plaintext in CloudTrail logs and other output.
	//
	// Tagging or untagging an Amazon Web Services Payment Cryptography key can
	// allow or deny permission to the key.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyInput"}
	if s.Exportable == nil {
		invalidParams.Add(request.NewErrParamRequired("Exportable"))
	}
	if s.KeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAttributes"))
	}
	if s.KeyAttributes != nil {
		if err := s.KeyAttributes.Validate(); err != nil {
			invalidParams.AddNested("KeyAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateKeyInput) SetEnabled(v bool) *CreateKeyInput {
	s.Enabled = &v
	return s
}

// SetExportable sets the Exportable field's value.
func (s *CreateKeyInput) SetExportable(v bool) *CreateKeyInput {
	s.Exportable = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *CreateKeyInput) SetKeyAttributes(v *KeyAttributes) *CreateKeyInput {
	s.KeyAttributes = v
	return s
}

// SetKeyCheckValueAlgorithm sets the KeyCheckValueAlgorithm field's value.
func (s *CreateKeyInput) SetKeyCheckValueAlgorithm(v string) *CreateKeyInput {
	s.KeyCheckValueAlgorithm = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKeyInput) SetTags(v []*Tag) *CreateKeyInput {
	s.Tags = v
	return s
}

type CreateKeyOutput struct {
	_ struct{} `type:"structure"`

	// The key material that contains all the key attributes.
	//
	// Key is a required field
	Key *Key `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *CreateKeyOutput) SetKey(v *Key) *CreateKeyOutput {
	s.Key = v
	return s
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// A friendly name that you can use to refer Amazon Web Services Payment Cryptography
	// key. This value must begin with alias/ followed by a name, such as alias/ExampleAlias.
	//
	// AliasName is a required field
	AliasName *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DeleteAliasInput) SetAliasName(v string) *DeleteAliasInput {
	s.AliasName = &v
	return s
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteKeyInput struct {
	_ struct{} `type:"structure"`

	// The waiting period for key deletion. The default value is seven days.
	DeleteKeyInDays *int64 `min:"3" type:"integer"`

	// The KeyARN of the key that is scheduled for deletion.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyInput"}
	if s.DeleteKeyInDays != nil && *s.DeleteKeyInDays < 3 {
		invalidParams.Add(request.NewErrParamMinValue("DeleteKeyInDays", 3))
	}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteKeyInDays sets the DeleteKeyInDays field's value.
func (s *DeleteKeyInput) SetDeleteKeyInDays(v int64) *DeleteKeyInput {
	s.DeleteKeyInDays = &v
	return s
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *DeleteKeyInput) SetKeyIdentifier(v string) *DeleteKeyInput {
	s.KeyIdentifier = &v
	return s
}

type DeleteKeyOutput struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the key that is scheduled for deletion.
	//
	// Key is a required field
	Key *Key `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *DeleteKeyOutput) SetKey(v *Key) *DeleteKeyOutput {
	s.Key = v
	return s
}

// The attributes for IPEK generation during export.
type ExportAttributes struct {
	_ struct{} `type:"structure"`

	// Parameter information for IPEK export.
	ExportDukptInitialKey *ExportDukptInitialKey `type:"structure"`

	// The algorithm that Amazon Web Services Payment Cryptography uses to calculate
	// the key check value (KCV). It is used to validate the key integrity. Specify
	// KCV for IPEK export only.
	//
	// For TDES keys, the KCV is computed by encrypting 8 bytes, each with value
	// of zero, with the key to be checked and retaining the 3 highest order bytes
	// of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm
	// where the input data is 16 bytes of zero and retaining the 3 highest order
	// bytes of the encrypted result.
	KeyCheckValueAlgorithm *string `type:"string" enum:"KeyCheckValueAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportAttributes"}
	if s.ExportDukptInitialKey != nil {
		if err := s.ExportDukptInitialKey.Validate(); err != nil {
			invalidParams.AddNested("ExportDukptInitialKey", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportDukptInitialKey sets the ExportDukptInitialKey field's value.
func (s *ExportAttributes) SetExportDukptInitialKey(v *ExportDukptInitialKey) *ExportAttributes {
	s.ExportDukptInitialKey = v
	return s
}

// SetKeyCheckValueAlgorithm sets the KeyCheckValueAlgorithm field's value.
func (s *ExportAttributes) SetKeyCheckValueAlgorithm(v string) *ExportAttributes {
	s.KeyCheckValueAlgorithm = &v
	return s
}

// Parameter information for IPEK generation during export.
type ExportDukptInitialKey struct {
	_ struct{} `type:"structure"`

	// The KSN for IPEK generation using DUKPT.
	//
	// KSN must be padded before sending to Amazon Web Services Payment Cryptography.
	// KSN hex length should be 20 for a TDES_2KEY key or 24 for an AES key.
	//
	// KeySerialNumber is a required field
	KeySerialNumber *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportDukptInitialKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportDukptInitialKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportDukptInitialKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportDukptInitialKey"}
	if s.KeySerialNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySerialNumber"))
	}
	if s.KeySerialNumber != nil && len(*s.KeySerialNumber) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KeySerialNumber", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeySerialNumber sets the KeySerialNumber field's value.
func (s *ExportDukptInitialKey) SetKeySerialNumber(v string) *ExportDukptInitialKey {
	s.KeySerialNumber = &v
	return s
}

// Parameter information for key material export using asymmetric RSA wrap and
// unwrap key exchange method.
type ExportKeyCryptogram struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the certificate chain that signs the wrapping key certificate
	// during RSA wrap and unwrap key export.
	//
	// CertificateAuthorityPublicKeyIdentifier is a required field
	CertificateAuthorityPublicKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The wrapping key certificate in PEM format (base64 encoded). Amazon Web Services
	// Payment Cryptography uses this certificate to wrap the key under export.
	//
	// WrappingKeyCertificate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ExportKeyCryptogram's
	// String and GoString methods.
	//
	// WrappingKeyCertificate is a required field
	WrappingKeyCertificate *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The wrapping spec for the key under export.
	WrappingSpec *string `type:"string" enum:"WrappingKeySpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportKeyCryptogram) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportKeyCryptogram) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportKeyCryptogram) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportKeyCryptogram"}
	if s.CertificateAuthorityPublicKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityPublicKeyIdentifier"))
	}
	if s.CertificateAuthorityPublicKeyIdentifier != nil && len(*s.CertificateAuthorityPublicKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityPublicKeyIdentifier", 7))
	}
	if s.WrappingKeyCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappingKeyCertificate"))
	}
	if s.WrappingKeyCertificate != nil && len(*s.WrappingKeyCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WrappingKeyCertificate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityPublicKeyIdentifier sets the CertificateAuthorityPublicKeyIdentifier field's value.
func (s *ExportKeyCryptogram) SetCertificateAuthorityPublicKeyIdentifier(v string) *ExportKeyCryptogram {
	s.CertificateAuthorityPublicKeyIdentifier = &v
	return s
}

// SetWrappingKeyCertificate sets the WrappingKeyCertificate field's value.
func (s *ExportKeyCryptogram) SetWrappingKeyCertificate(v string) *ExportKeyCryptogram {
	s.WrappingKeyCertificate = &v
	return s
}

// SetWrappingSpec sets the WrappingSpec field's value.
func (s *ExportKeyCryptogram) SetWrappingSpec(v string) *ExportKeyCryptogram {
	s.WrappingSpec = &v
	return s
}

type ExportKeyInput struct {
	_ struct{} `type:"structure"`

	// The attributes for IPEK generation during export.
	ExportAttributes *ExportAttributes `type:"structure"`

	// The KeyARN of the key under export from Amazon Web Services Payment Cryptography.
	//
	// ExportKeyIdentifier is a required field
	ExportKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The key block format type, for example, TR-34 or TR-31, to use during key
	// material export.
	//
	// KeyMaterial is a required field
	KeyMaterial *ExportKeyMaterial `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportKeyInput"}
	if s.ExportKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportKeyIdentifier"))
	}
	if s.ExportKeyIdentifier != nil && len(*s.ExportKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("ExportKeyIdentifier", 7))
	}
	if s.KeyMaterial == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyMaterial"))
	}
	if s.ExportAttributes != nil {
		if err := s.ExportAttributes.Validate(); err != nil {
			invalidParams.AddNested("ExportAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.KeyMaterial != nil {
		if err := s.KeyMaterial.Validate(); err != nil {
			invalidParams.AddNested("KeyMaterial", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportAttributes sets the ExportAttributes field's value.
func (s *ExportKeyInput) SetExportAttributes(v *ExportAttributes) *ExportKeyInput {
	s.ExportAttributes = v
	return s
}

// SetExportKeyIdentifier sets the ExportKeyIdentifier field's value.
func (s *ExportKeyInput) SetExportKeyIdentifier(v string) *ExportKeyInput {
	s.ExportKeyIdentifier = &v
	return s
}

// SetKeyMaterial sets the KeyMaterial field's value.
func (s *ExportKeyInput) SetKeyMaterial(v *ExportKeyMaterial) *ExportKeyInput {
	s.KeyMaterial = v
	return s
}

// Parameter information for key material export from Amazon Web Services Payment
// Cryptography using TR-31 or TR-34 or RSA wrap and unwrap key exchange method.
type ExportKeyMaterial struct {
	_ struct{} `type:"structure"`

	// Parameter information for key material export using asymmetric RSA wrap and
	// unwrap key exchange method
	KeyCryptogram *ExportKeyCryptogram `type:"structure"`

	// Parameter information for key material export using symmetric TR-31 key exchange
	// method.
	Tr31KeyBlock *ExportTr31KeyBlock `type:"structure"`

	// Parameter information for key material export using the asymmetric TR-34
	// key exchange method.
	Tr34KeyBlock *ExportTr34KeyBlock `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportKeyMaterial) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportKeyMaterial) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportKeyMaterial) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportKeyMaterial"}
	if s.KeyCryptogram != nil {
		if err := s.KeyCryptogram.Validate(); err != nil {
			invalidParams.AddNested("KeyCryptogram", err.(request.ErrInvalidParams))
		}
	}
	if s.Tr31KeyBlock != nil {
		if err := s.Tr31KeyBlock.Validate(); err != nil {
			invalidParams.AddNested("Tr31KeyBlock", err.(request.ErrInvalidParams))
		}
	}
	if s.Tr34KeyBlock != nil {
		if err := s.Tr34KeyBlock.Validate(); err != nil {
			invalidParams.AddNested("Tr34KeyBlock", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyCryptogram sets the KeyCryptogram field's value.
func (s *ExportKeyMaterial) SetKeyCryptogram(v *ExportKeyCryptogram) *ExportKeyMaterial {
	s.KeyCryptogram = v
	return s
}

// SetTr31KeyBlock sets the Tr31KeyBlock field's value.
func (s *ExportKeyMaterial) SetTr31KeyBlock(v *ExportTr31KeyBlock) *ExportKeyMaterial {
	s.Tr31KeyBlock = v
	return s
}

// SetTr34KeyBlock sets the Tr34KeyBlock field's value.
func (s *ExportKeyMaterial) SetTr34KeyBlock(v *ExportTr34KeyBlock) *ExportKeyMaterial {
	s.Tr34KeyBlock = v
	return s
}

type ExportKeyOutput struct {
	_ struct{} `type:"structure"`

	// The key material under export as a TR-34 WrappedKeyBlock or a TR-31 WrappedKeyBlock.
	// or a RSA WrappedKeyCryptogram.
	WrappedKey *WrappedKey `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportKeyOutput) GoString() string {
	return s.String()
}

// SetWrappedKey sets the WrappedKey field's value.
func (s *ExportKeyOutput) SetWrappedKey(v *WrappedKey) *ExportKeyOutput {
	s.WrappedKey = v
	return s
}

// Parameter information for key material export using symmetric TR-31 key exchange
// method.
type ExportTr31KeyBlock struct {
	_ struct{} `type:"structure"`

	// Optional metadata for export associated with the key material. This data
	// is signed but transmitted in clear text.
	KeyBlockHeaders *KeyBlockHeaders `type:"structure"`

	// The KeyARN of the the wrapping key. This key encrypts or wraps the key under
	// export for TR-31 key block generation.
	//
	// WrappingKeyIdentifier is a required field
	WrappingKeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportTr31KeyBlock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportTr31KeyBlock) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportTr31KeyBlock) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportTr31KeyBlock"}
	if s.WrappingKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappingKeyIdentifier"))
	}
	if s.WrappingKeyIdentifier != nil && len(*s.WrappingKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WrappingKeyIdentifier", 7))
	}
	if s.KeyBlockHeaders != nil {
		if err := s.KeyBlockHeaders.Validate(); err != nil {
			invalidParams.AddNested("KeyBlockHeaders", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyBlockHeaders sets the KeyBlockHeaders field's value.
func (s *ExportTr31KeyBlock) SetKeyBlockHeaders(v *KeyBlockHeaders) *ExportTr31KeyBlock {
	s.KeyBlockHeaders = v
	return s
}

// SetWrappingKeyIdentifier sets the WrappingKeyIdentifier field's value.
func (s *ExportTr31KeyBlock) SetWrappingKeyIdentifier(v string) *ExportTr31KeyBlock {
	s.WrappingKeyIdentifier = &v
	return s
}

// Parameter information for key material export using the asymmetric TR-34
// key exchange method.
type ExportTr34KeyBlock struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the certificate chain that signs the wrapping key certificate
	// during TR-34 key export.
	//
	// CertificateAuthorityPublicKeyIdentifier is a required field
	CertificateAuthorityPublicKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The export token to initiate key export from Amazon Web Services Payment
	// Cryptography. It also contains the signing key certificate that will sign
	// the wrapped key during TR-34 key block generation. Call GetParametersForExport
	// (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html)
	// to receive an export token. It expires after 7 days. You can use the same
	// export token to export multiple keys from the same service account.
	//
	// ExportToken is a required field
	ExportToken *string `type:"string" required:"true"`

	// The format of key block that Amazon Web Services Payment Cryptography will
	// use during key export.
	//
	// KeyBlockFormat is a required field
	KeyBlockFormat *string `type:"string" required:"true" enum:"Tr34KeyBlockFormat"`

	// Optional metadata for export associated with the key material. This data
	// is signed but transmitted in clear text.
	KeyBlockHeaders *KeyBlockHeaders `type:"structure"`

	// A random number value that is unique to the TR-34 key block generated using
	// 2 pass. The operation will fail, if a random nonce value is not provided
	// for a TR-34 key block generated using 2 pass.
	RandomNonce *string `min:"16" type:"string"`

	// The KeyARN of the wrapping key certificate. Amazon Web Services Payment Cryptography
	// uses this certificate to wrap the key under export.
	//
	// WrappingKeyCertificate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ExportTr34KeyBlock's
	// String and GoString methods.
	//
	// WrappingKeyCertificate is a required field
	WrappingKeyCertificate *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportTr34KeyBlock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportTr34KeyBlock) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportTr34KeyBlock) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportTr34KeyBlock"}
	if s.CertificateAuthorityPublicKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityPublicKeyIdentifier"))
	}
	if s.CertificateAuthorityPublicKeyIdentifier != nil && len(*s.CertificateAuthorityPublicKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityPublicKeyIdentifier", 7))
	}
	if s.ExportToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportToken"))
	}
	if s.KeyBlockFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyBlockFormat"))
	}
	if s.RandomNonce != nil && len(*s.RandomNonce) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("RandomNonce", 16))
	}
	if s.WrappingKeyCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappingKeyCertificate"))
	}
	if s.WrappingKeyCertificate != nil && len(*s.WrappingKeyCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WrappingKeyCertificate", 1))
	}
	if s.KeyBlockHeaders != nil {
		if err := s.KeyBlockHeaders.Validate(); err != nil {
			invalidParams.AddNested("KeyBlockHeaders", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityPublicKeyIdentifier sets the CertificateAuthorityPublicKeyIdentifier field's value.
func (s *ExportTr34KeyBlock) SetCertificateAuthorityPublicKeyIdentifier(v string) *ExportTr34KeyBlock {
	s.CertificateAuthorityPublicKeyIdentifier = &v
	return s
}

// SetExportToken sets the ExportToken field's value.
func (s *ExportTr34KeyBlock) SetExportToken(v string) *ExportTr34KeyBlock {
	s.ExportToken = &v
	return s
}

// SetKeyBlockFormat sets the KeyBlockFormat field's value.
func (s *ExportTr34KeyBlock) SetKeyBlockFormat(v string) *ExportTr34KeyBlock {
	s.KeyBlockFormat = &v
	return s
}

// SetKeyBlockHeaders sets the KeyBlockHeaders field's value.
func (s *ExportTr34KeyBlock) SetKeyBlockHeaders(v *KeyBlockHeaders) *ExportTr34KeyBlock {
	s.KeyBlockHeaders = v
	return s
}

// SetRandomNonce sets the RandomNonce field's value.
func (s *ExportTr34KeyBlock) SetRandomNonce(v string) *ExportTr34KeyBlock {
	s.RandomNonce = &v
	return s
}

// SetWrappingKeyCertificate sets the WrappingKeyCertificate field's value.
func (s *ExportTr34KeyBlock) SetWrappingKeyCertificate(v string) *ExportTr34KeyBlock {
	s.WrappingKeyCertificate = &v
	return s
}

type GetAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias of the Amazon Web Services Payment Cryptography key.
	//
	// AliasName is a required field
	AliasName *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *GetAliasInput) SetAliasName(v string) *GetAliasInput {
	s.AliasName = &v
	return s
}

type GetAliasOutput struct {
	_ struct{} `type:"structure"`

	// The alias of the Amazon Web Services Payment Cryptography key.
	//
	// Alias is a required field
	Alias *Alias `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *GetAliasOutput) SetAlias(v *Alias) *GetAliasOutput {
	s.Alias = v
	return s
}

type GetKeyInput struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the Amazon Web Services Payment Cryptography key.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyInput"}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *GetKeyInput) SetKeyIdentifier(v string) *GetKeyInput {
	s.KeyIdentifier = &v
	return s
}

type GetKeyOutput struct {
	_ struct{} `type:"structure"`

	// The key material, including the immutable and mutable data for the key.
	//
	// Key is a required field
	Key *Key `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *GetKeyOutput) SetKey(v *Key) *GetKeyOutput {
	s.Key = v
	return s
}

type GetParametersForExportInput struct {
	_ struct{} `type:"structure"`

	// The key block format type (for example, TR-34 or TR-31) to use during key
	// material export. Export token is only required for a TR-34 key export, TR34_KEY_BLOCK.
	// Export token is not required for TR-31 key export.
	//
	// KeyMaterialType is a required field
	KeyMaterialType *string `type:"string" required:"true" enum:"KeyMaterialType"`

	// The signing key algorithm to generate a signing key certificate. This certificate
	// signs the wrapped key under export within the TR-34 key block. RSA_2048 is
	// the only signing key algorithm allowed.
	//
	// SigningKeyAlgorithm is a required field
	SigningKeyAlgorithm *string `type:"string" required:"true" enum:"KeyAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParametersForExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParametersForExportInput"}
	if s.KeyMaterialType == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyMaterialType"))
	}
	if s.SigningKeyAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningKeyAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyMaterialType sets the KeyMaterialType field's value.
func (s *GetParametersForExportInput) SetKeyMaterialType(v string) *GetParametersForExportInput {
	s.KeyMaterialType = &v
	return s
}

// SetSigningKeyAlgorithm sets the SigningKeyAlgorithm field's value.
func (s *GetParametersForExportInput) SetSigningKeyAlgorithm(v string) *GetParametersForExportInput {
	s.SigningKeyAlgorithm = &v
	return s
}

type GetParametersForExportOutput struct {
	_ struct{} `type:"structure"`

	// The export token to initiate key export from Amazon Web Services Payment
	// Cryptography. The export token expires after 7 days. You can use the same
	// export token to export multiple keys from the same service account.
	//
	// ExportToken is a required field
	ExportToken *string `type:"string" required:"true"`

	// The validity period of the export token.
	//
	// ParametersValidUntilTimestamp is a required field
	ParametersValidUntilTimestamp *time.Time `type:"timestamp" required:"true"`

	// The algorithm of the signing key certificate for use in TR-34 key block generation.
	// RSA_2048 is the only signing key algorithm allowed.
	//
	// SigningKeyAlgorithm is a required field
	SigningKeyAlgorithm *string `type:"string" required:"true" enum:"KeyAlgorithm"`

	// The signing key certificate in PEM format (base64 encoded) of the public
	// key for signature within the TR-34 key block. The certificate expires after
	// 7 days.
	//
	// SigningKeyCertificate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetParametersForExportOutput's
	// String and GoString methods.
	//
	// SigningKeyCertificate is a required field
	SigningKeyCertificate *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The root certificate authority (CA) that signed the signing key certificate
	// in PEM format (base64 encoded).
	//
	// SigningKeyCertificateChain is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetParametersForExportOutput's
	// String and GoString methods.
	//
	// SigningKeyCertificateChain is a required field
	SigningKeyCertificateChain *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForExportOutput) GoString() string {
	return s.String()
}

// SetExportToken sets the ExportToken field's value.
func (s *GetParametersForExportOutput) SetExportToken(v string) *GetParametersForExportOutput {
	s.ExportToken = &v
	return s
}

// SetParametersValidUntilTimestamp sets the ParametersValidUntilTimestamp field's value.
func (s *GetParametersForExportOutput) SetParametersValidUntilTimestamp(v time.Time) *GetParametersForExportOutput {
	s.ParametersValidUntilTimestamp = &v
	return s
}

// SetSigningKeyAlgorithm sets the SigningKeyAlgorithm field's value.
func (s *GetParametersForExportOutput) SetSigningKeyAlgorithm(v string) *GetParametersForExportOutput {
	s.SigningKeyAlgorithm = &v
	return s
}

// SetSigningKeyCertificate sets the SigningKeyCertificate field's value.
func (s *GetParametersForExportOutput) SetSigningKeyCertificate(v string) *GetParametersForExportOutput {
	s.SigningKeyCertificate = &v
	return s
}

// SetSigningKeyCertificateChain sets the SigningKeyCertificateChain field's value.
func (s *GetParametersForExportOutput) SetSigningKeyCertificateChain(v string) *GetParametersForExportOutput {
	s.SigningKeyCertificateChain = &v
	return s
}

type GetParametersForImportInput struct {
	_ struct{} `type:"structure"`

	// The method to use for key material import. Import token is only required
	// for TR-34 WrappedKeyBlock (TR34_KEY_BLOCK) and RSA WrappedKeyCryptogram (KEY_CRYPTOGRAM).
	//
	// Import token is not required for TR-31, root public key cerificate or trusted
	// public key certificate.
	//
	// KeyMaterialType is a required field
	KeyMaterialType *string `type:"string" required:"true" enum:"KeyMaterialType"`

	// The wrapping key algorithm to generate a wrapping key certificate. This certificate
	// wraps the key under import.
	//
	// At this time, RSA_2048 is the allowed algorithm for TR-34 WrappedKeyBlock
	// import. Additionally, RSA_2048, RSA_3072, RSA_4096 are the allowed algorithms
	// for RSA WrappedKeyCryptogram import.
	//
	// WrappingKeyAlgorithm is a required field
	WrappingKeyAlgorithm *string `type:"string" required:"true" enum:"KeyAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParametersForImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParametersForImportInput"}
	if s.KeyMaterialType == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyMaterialType"))
	}
	if s.WrappingKeyAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappingKeyAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyMaterialType sets the KeyMaterialType field's value.
func (s *GetParametersForImportInput) SetKeyMaterialType(v string) *GetParametersForImportInput {
	s.KeyMaterialType = &v
	return s
}

// SetWrappingKeyAlgorithm sets the WrappingKeyAlgorithm field's value.
func (s *GetParametersForImportInput) SetWrappingKeyAlgorithm(v string) *GetParametersForImportInput {
	s.WrappingKeyAlgorithm = &v
	return s
}

type GetParametersForImportOutput struct {
	_ struct{} `type:"structure"`

	// The import token to initiate key import into Amazon Web Services Payment
	// Cryptography. The import token expires after 7 days. You can use the same
	// import token to import multiple keys to the same service account.
	//
	// ImportToken is a required field
	ImportToken *string `type:"string" required:"true"`

	// The validity period of the import token.
	//
	// ParametersValidUntilTimestamp is a required field
	ParametersValidUntilTimestamp *time.Time `type:"timestamp" required:"true"`

	// The algorithm of the wrapping key for use within TR-34 WrappedKeyBlock or
	// RSA WrappedKeyCryptogram.
	//
	// WrappingKeyAlgorithm is a required field
	WrappingKeyAlgorithm *string `type:"string" required:"true" enum:"KeyAlgorithm"`

	// The wrapping key certificate in PEM format (base64 encoded) of the wrapping
	// key for use within the TR-34 key block. The certificate expires in 7 days.
	//
	// WrappingKeyCertificate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetParametersForImportOutput's
	// String and GoString methods.
	//
	// WrappingKeyCertificate is a required field
	WrappingKeyCertificate *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The Amazon Web Services Payment Cryptography root certificate authority (CA)
	// that signed the wrapping key certificate in PEM format (base64 encoded).
	//
	// WrappingKeyCertificateChain is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetParametersForImportOutput's
	// String and GoString methods.
	//
	// WrappingKeyCertificateChain is a required field
	WrappingKeyCertificateChain *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForImportOutput) GoString() string {
	return s.String()
}

// SetImportToken sets the ImportToken field's value.
func (s *GetParametersForImportOutput) SetImportToken(v string) *GetParametersForImportOutput {
	s.ImportToken = &v
	return s
}

// SetParametersValidUntilTimestamp sets the ParametersValidUntilTimestamp field's value.
func (s *GetParametersForImportOutput) SetParametersValidUntilTimestamp(v time.Time) *GetParametersForImportOutput {
	s.ParametersValidUntilTimestamp = &v
	return s
}

// SetWrappingKeyAlgorithm sets the WrappingKeyAlgorithm field's value.
func (s *GetParametersForImportOutput) SetWrappingKeyAlgorithm(v string) *GetParametersForImportOutput {
	s.WrappingKeyAlgorithm = &v
	return s
}

// SetWrappingKeyCertificate sets the WrappingKeyCertificate field's value.
func (s *GetParametersForImportOutput) SetWrappingKeyCertificate(v string) *GetParametersForImportOutput {
	s.WrappingKeyCertificate = &v
	return s
}

// SetWrappingKeyCertificateChain sets the WrappingKeyCertificateChain field's value.
func (s *GetParametersForImportOutput) SetWrappingKeyCertificateChain(v string) *GetParametersForImportOutput {
	s.WrappingKeyCertificateChain = &v
	return s
}

type GetPublicKeyCertificateInput struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the asymmetric key pair.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicKeyCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicKeyCertificateInput"}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *GetPublicKeyCertificateInput) SetKeyIdentifier(v string) *GetPublicKeyCertificateInput {
	s.KeyIdentifier = &v
	return s
}

type GetPublicKeyCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The public key component of the asymmetric key pair in a certificate PEM
	// format (base64 encoded). It is signed by the root certificate authority (CA).
	// The certificate expires in 90 days.
	//
	// KeyCertificate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPublicKeyCertificateOutput's
	// String and GoString methods.
	//
	// KeyCertificate is a required field
	KeyCertificate *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The root certificate authority (CA) that signed the public key certificate
	// in PEM format (base64 encoded) of the asymmetric key pair.
	//
	// KeyCertificateChain is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPublicKeyCertificateOutput's
	// String and GoString methods.
	//
	// KeyCertificateChain is a required field
	KeyCertificateChain *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyCertificateOutput) GoString() string {
	return s.String()
}

// SetKeyCertificate sets the KeyCertificate field's value.
func (s *GetPublicKeyCertificateOutput) SetKeyCertificate(v string) *GetPublicKeyCertificateOutput {
	s.KeyCertificate = &v
	return s
}

// SetKeyCertificateChain sets the KeyCertificateChain field's value.
func (s *GetPublicKeyCertificateOutput) SetKeyCertificateChain(v string) *GetPublicKeyCertificateOutput {
	s.KeyCertificateChain = &v
	return s
}

// Parameter information for key material import using asymmetric RSA wrap and
// unwrap key exchange method.
type ImportKeyCryptogram struct {
	_ struct{} `type:"structure"`

	// Specifies whether the key is exportable from the service.
	//
	// Exportable is a required field
	Exportable *bool `type:"boolean" required:"true"`

	// The import token that initiates key import using the asymmetric RSA wrap
	// and unwrap key exchange method into AWS Payment Cryptography. It expires
	// after 7 days. You can use the same import token to import multiple keys to
	// the same service account.
	//
	// ImportToken is a required field
	ImportToken *string `type:"string" required:"true"`

	// The role of the key, the algorithm it supports, and the cryptographic operations
	// allowed with the key. This data is immutable after the key is created.
	//
	// KeyAttributes is a required field
	KeyAttributes *KeyAttributes `type:"structure" required:"true"`

	// The RSA wrapped key cryptogram under import.
	//
	// WrappedKeyCryptogram is a required field
	WrappedKeyCryptogram *string `min:"16" type:"string" required:"true"`

	// The wrapping spec for the wrapped key cryptogram.
	WrappingSpec *string `type:"string" enum:"WrappingKeySpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyCryptogram) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyCryptogram) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyCryptogram) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportKeyCryptogram"}
	if s.Exportable == nil {
		invalidParams.Add(request.NewErrParamRequired("Exportable"))
	}
	if s.ImportToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportToken"))
	}
	if s.KeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAttributes"))
	}
	if s.WrappedKeyCryptogram == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappedKeyCryptogram"))
	}
	if s.WrappedKeyCryptogram != nil && len(*s.WrappedKeyCryptogram) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("WrappedKeyCryptogram", 16))
	}
	if s.KeyAttributes != nil {
		if err := s.KeyAttributes.Validate(); err != nil {
			invalidParams.AddNested("KeyAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportable sets the Exportable field's value.
func (s *ImportKeyCryptogram) SetExportable(v bool) *ImportKeyCryptogram {
	s.Exportable = &v
	return s
}

// SetImportToken sets the ImportToken field's value.
func (s *ImportKeyCryptogram) SetImportToken(v string) *ImportKeyCryptogram {
	s.ImportToken = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *ImportKeyCryptogram) SetKeyAttributes(v *KeyAttributes) *ImportKeyCryptogram {
	s.KeyAttributes = v
	return s
}

// SetWrappedKeyCryptogram sets the WrappedKeyCryptogram field's value.
func (s *ImportKeyCryptogram) SetWrappedKeyCryptogram(v string) *ImportKeyCryptogram {
	s.WrappedKeyCryptogram = &v
	return s
}

// SetWrappingSpec sets the WrappingSpec field's value.
func (s *ImportKeyCryptogram) SetWrappingSpec(v string) *ImportKeyCryptogram {
	s.WrappingSpec = &v
	return s
}

type ImportKeyInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether import key is enabled.
	Enabled *bool `type:"boolean"`

	// The algorithm that Amazon Web Services Payment Cryptography uses to calculate
	// the key check value (KCV). It is used to validate the key integrity.
	//
	// For TDES keys, the KCV is computed by encrypting 8 bytes, each with value
	// of zero, with the key to be checked and retaining the 3 highest order bytes
	// of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm
	// where the input data is 16 bytes of zero and retaining the 3 highest order
	// bytes of the encrypted result.
	KeyCheckValueAlgorithm *string `type:"string" enum:"KeyCheckValueAlgorithm"`

	// The key or public key certificate type to use during key material import,
	// for example TR-34 or RootCertificatePublicKey.
	//
	// KeyMaterial is a required field
	KeyMaterial *ImportKeyMaterial `type:"structure" required:"true"`

	// Assigns one or more tags to the Amazon Web Services Payment Cryptography
	// key. Use this parameter to tag a key when it is imported. To tag an existing
	// Amazon Web Services Payment Cryptography key, use the TagResource (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html)
	// operation.
	//
	// Each tag consists of a tag key and a tag value. Both the tag key and the
	// tag value are required, but the tag value can be an empty (null) string.
	// You can't have more than one tag on an Amazon Web Services Payment Cryptography
	// key with the same tag key. If you specify an existing tag key with a different
	// tag value, Amazon Web Services Payment Cryptography replaces the current
	// tag value with the specified one.
	//
	// Don't include personal, confidential or sensitive information in this field.
	// This field may be displayed in plaintext in CloudTrail logs and other output.
	//
	// Tagging or untagging an Amazon Web Services Payment Cryptography key can
	// allow or deny permission to the key.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportKeyInput"}
	if s.KeyMaterial == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyMaterial"))
	}
	if s.KeyMaterial != nil {
		if err := s.KeyMaterial.Validate(); err != nil {
			invalidParams.AddNested("KeyMaterial", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ImportKeyInput) SetEnabled(v bool) *ImportKeyInput {
	s.Enabled = &v
	return s
}

// SetKeyCheckValueAlgorithm sets the KeyCheckValueAlgorithm field's value.
func (s *ImportKeyInput) SetKeyCheckValueAlgorithm(v string) *ImportKeyInput {
	s.KeyCheckValueAlgorithm = &v
	return s
}

// SetKeyMaterial sets the KeyMaterial field's value.
func (s *ImportKeyInput) SetKeyMaterial(v *ImportKeyMaterial) *ImportKeyInput {
	s.KeyMaterial = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportKeyInput) SetTags(v []*Tag) *ImportKeyInput {
	s.Tags = v
	return s
}

// Parameter information for key material import into Amazon Web Services Payment
// Cryptography using TR-31 or TR-34 or RSA wrap and unwrap key exchange method.
type ImportKeyMaterial struct {
	_ struct{} `type:"structure"`

	// Parameter information for key material import using asymmetric RSA wrap and
	// unwrap key exchange method.
	KeyCryptogram *ImportKeyCryptogram `type:"structure"`

	// Parameter information for root public key certificate import.
	RootCertificatePublicKey *RootCertificatePublicKey `type:"structure"`

	// Parameter information for key material import using symmetric TR-31 key exchange
	// method.
	Tr31KeyBlock *ImportTr31KeyBlock `type:"structure"`

	// Parameter information for key material import using the asymmetric TR-34
	// key exchange method.
	Tr34KeyBlock *ImportTr34KeyBlock `type:"structure"`

	// Parameter information for trusted public key certificate import.
	TrustedCertificatePublicKey *TrustedCertificatePublicKey `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyMaterial) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyMaterial) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyMaterial) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportKeyMaterial"}
	if s.KeyCryptogram != nil {
		if err := s.KeyCryptogram.Validate(); err != nil {
			invalidParams.AddNested("KeyCryptogram", err.(request.ErrInvalidParams))
		}
	}
	if s.RootCertificatePublicKey != nil {
		if err := s.RootCertificatePublicKey.Validate(); err != nil {
			invalidParams.AddNested("RootCertificatePublicKey", err.(request.ErrInvalidParams))
		}
	}
	if s.Tr31KeyBlock != nil {
		if err := s.Tr31KeyBlock.Validate(); err != nil {
			invalidParams.AddNested("Tr31KeyBlock", err.(request.ErrInvalidParams))
		}
	}
	if s.Tr34KeyBlock != nil {
		if err := s.Tr34KeyBlock.Validate(); err != nil {
			invalidParams.AddNested("Tr34KeyBlock", err.(request.ErrInvalidParams))
		}
	}
	if s.TrustedCertificatePublicKey != nil {
		if err := s.TrustedCertificatePublicKey.Validate(); err != nil {
			invalidParams.AddNested("TrustedCertificatePublicKey", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyCryptogram sets the KeyCryptogram field's value.
func (s *ImportKeyMaterial) SetKeyCryptogram(v *ImportKeyCryptogram) *ImportKeyMaterial {
	s.KeyCryptogram = v
	return s
}

// SetRootCertificatePublicKey sets the RootCertificatePublicKey field's value.
func (s *ImportKeyMaterial) SetRootCertificatePublicKey(v *RootCertificatePublicKey) *ImportKeyMaterial {
	s.RootCertificatePublicKey = v
	return s
}

// SetTr31KeyBlock sets the Tr31KeyBlock field's value.
func (s *ImportKeyMaterial) SetTr31KeyBlock(v *ImportTr31KeyBlock) *ImportKeyMaterial {
	s.Tr31KeyBlock = v
	return s
}

// SetTr34KeyBlock sets the Tr34KeyBlock field's value.
func (s *ImportKeyMaterial) SetTr34KeyBlock(v *ImportTr34KeyBlock) *ImportKeyMaterial {
	s.Tr34KeyBlock = v
	return s
}

// SetTrustedCertificatePublicKey sets the TrustedCertificatePublicKey field's value.
func (s *ImportKeyMaterial) SetTrustedCertificatePublicKey(v *TrustedCertificatePublicKey) *ImportKeyMaterial {
	s.TrustedCertificatePublicKey = v
	return s
}

type ImportKeyOutput struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the key material imported within Amazon Web Services Payment
	// Cryptography.
	//
	// Key is a required field
	Key *Key `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ImportKeyOutput) SetKey(v *Key) *ImportKeyOutput {
	s.Key = v
	return s
}

// Parameter information for key material import using symmetric TR-31 key exchange
// method.
type ImportTr31KeyBlock struct {
	_ struct{} `type:"structure"`

	// The TR-31 wrapped key block to import.
	//
	// WrappedKeyBlock is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ImportTr31KeyBlock's
	// String and GoString methods.
	//
	// WrappedKeyBlock is a required field
	WrappedKeyBlock *string `min:"56" type:"string" required:"true" sensitive:"true"`

	// The KeyARN of the key that will decrypt or unwrap a TR-31 key block during
	// import.
	//
	// WrappingKeyIdentifier is a required field
	WrappingKeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportTr31KeyBlock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportTr31KeyBlock) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportTr31KeyBlock) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportTr31KeyBlock"}
	if s.WrappedKeyBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappedKeyBlock"))
	}
	if s.WrappedKeyBlock != nil && len(*s.WrappedKeyBlock) < 56 {
		invalidParams.Add(request.NewErrParamMinLen("WrappedKeyBlock", 56))
	}
	if s.WrappingKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappingKeyIdentifier"))
	}
	if s.WrappingKeyIdentifier != nil && len(*s.WrappingKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WrappingKeyIdentifier", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWrappedKeyBlock sets the WrappedKeyBlock field's value.
func (s *ImportTr31KeyBlock) SetWrappedKeyBlock(v string) *ImportTr31KeyBlock {
	s.WrappedKeyBlock = &v
	return s
}

// SetWrappingKeyIdentifier sets the WrappingKeyIdentifier field's value.
func (s *ImportTr31KeyBlock) SetWrappingKeyIdentifier(v string) *ImportTr31KeyBlock {
	s.WrappingKeyIdentifier = &v
	return s
}

// Parameter information for key material import using the asymmetric TR-34
// key exchange method.
type ImportTr34KeyBlock struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the certificate chain that signs the signing key certificate
	// during TR-34 key import.
	//
	// CertificateAuthorityPublicKeyIdentifier is a required field
	CertificateAuthorityPublicKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The import token that initiates key import using the asymmetric TR-34 key
	// exchange method into Amazon Web Services Payment Cryptography. It expires
	// after 7 days. You can use the same import token to import multiple keys to
	// the same service account.
	//
	// ImportToken is a required field
	ImportToken *string `type:"string" required:"true"`

	// The key block format to use during key import. The only value allowed is
	// X9_TR34_2012.
	//
	// KeyBlockFormat is a required field
	KeyBlockFormat *string `type:"string" required:"true" enum:"Tr34KeyBlockFormat"`

	// A random number value that is unique to the TR-34 key block generated using
	// 2 pass. The operation will fail, if a random nonce value is not provided
	// for a TR-34 key block generated using 2 pass.
	RandomNonce *string `min:"16" type:"string"`

	// The public key component in PEM certificate format of the private key that
	// signs the KDH TR-34 WrappedKeyBlock.
	//
	// SigningKeyCertificate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ImportTr34KeyBlock's
	// String and GoString methods.
	//
	// SigningKeyCertificate is a required field
	SigningKeyCertificate *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The TR-34 wrapped key block to import.
	//
	// WrappedKeyBlock is a required field
	WrappedKeyBlock *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportTr34KeyBlock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportTr34KeyBlock) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportTr34KeyBlock) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportTr34KeyBlock"}
	if s.CertificateAuthorityPublicKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityPublicKeyIdentifier"))
	}
	if s.CertificateAuthorityPublicKeyIdentifier != nil && len(*s.CertificateAuthorityPublicKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityPublicKeyIdentifier", 7))
	}
	if s.ImportToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportToken"))
	}
	if s.KeyBlockFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyBlockFormat"))
	}
	if s.RandomNonce != nil && len(*s.RandomNonce) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("RandomNonce", 16))
	}
	if s.SigningKeyCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningKeyCertificate"))
	}
	if s.SigningKeyCertificate != nil && len(*s.SigningKeyCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SigningKeyCertificate", 1))
	}
	if s.WrappedKeyBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappedKeyBlock"))
	}
	if s.WrappedKeyBlock != nil && len(*s.WrappedKeyBlock) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("WrappedKeyBlock", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityPublicKeyIdentifier sets the CertificateAuthorityPublicKeyIdentifier field's value.
func (s *ImportTr34KeyBlock) SetCertificateAuthorityPublicKeyIdentifier(v string) *ImportTr34KeyBlock {
	s.CertificateAuthorityPublicKeyIdentifier = &v
	return s
}

// SetImportToken sets the ImportToken field's value.
func (s *ImportTr34KeyBlock) SetImportToken(v string) *ImportTr34KeyBlock {
	s.ImportToken = &v
	return s
}

// SetKeyBlockFormat sets the KeyBlockFormat field's value.
func (s *ImportTr34KeyBlock) SetKeyBlockFormat(v string) *ImportTr34KeyBlock {
	s.KeyBlockFormat = &v
	return s
}

// SetRandomNonce sets the RandomNonce field's value.
func (s *ImportTr34KeyBlock) SetRandomNonce(v string) *ImportTr34KeyBlock {
	s.RandomNonce = &v
	return s
}

// SetSigningKeyCertificate sets the SigningKeyCertificate field's value.
func (s *ImportTr34KeyBlock) SetSigningKeyCertificate(v string) *ImportTr34KeyBlock {
	s.SigningKeyCertificate = &v
	return s
}

// SetWrappedKeyBlock sets the WrappedKeyBlock field's value.
func (s *ImportTr34KeyBlock) SetWrappedKeyBlock(v string) *ImportTr34KeyBlock {
	s.WrappedKeyBlock = &v
	return s
}

// The request processing has failed because of an unknown error, exception,
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Metadata about an Amazon Web Services Payment Cryptography key.
type Key struct {
	_ struct{} `type:"structure"`

	// The date and time when the key was created.
	//
	// CreateTimestamp is a required field
	CreateTimestamp *time.Time `type:"timestamp" required:"true"`

	// The date and time after which Amazon Web Services Payment Cryptography will
	// delete the key. This value is present only when KeyState is DELETE_PENDING
	// and the key is scheduled for deletion.
	DeletePendingTimestamp *time.Time `type:"timestamp"`

	// The date and time after which Amazon Web Services Payment Cryptography will
	// delete the key. This value is present only when when the KeyState is DELETE_COMPLETE
	// and the Amazon Web Services Payment Cryptography key is deleted.
	DeleteTimestamp *time.Time `type:"timestamp"`

	// Specifies whether the key is enabled.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specifies whether the key is exportable. This data is immutable after the
	// key is created.
	//
	// Exportable is a required field
	Exportable *bool `type:"boolean" required:"true"`

	// The Amazon Resource Name (ARN) of the key.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The role of the key, the algorithm it supports, and the cryptographic operations
	// allowed with the key. This data is immutable after the key is created.
	//
	// KeyAttributes is a required field
	KeyAttributes *KeyAttributes `type:"structure" required:"true"`

	// The key check value (KCV) is used to check if all parties holding a given
	// key have the same key or to detect that a key has changed.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`

	// The algorithm that Amazon Web Services Payment Cryptography uses to calculate
	// the key check value (KCV). It is used to validate the key integrity.
	//
	// For TDES keys, the KCV is computed by encrypting 8 bytes, each with value
	// of zero, with the key to be checked and retaining the 3 highest order bytes
	// of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm
	// where the input data is 16 bytes of zero and retaining the 3 highest order
	// bytes of the encrypted result.
	//
	// KeyCheckValueAlgorithm is a required field
	KeyCheckValueAlgorithm *string `type:"string" required:"true" enum:"KeyCheckValueAlgorithm"`

	// The source of the key material. For keys created within Amazon Web Services
	// Payment Cryptography, the value is AWS_PAYMENT_CRYPTOGRAPHY. For keys imported
	// into Amazon Web Services Payment Cryptography, the value is EXTERNAL.
	//
	// KeyOrigin is a required field
	KeyOrigin *string `type:"string" required:"true" enum:"KeyOrigin"`

	// The state of key that is being created or deleted.
	//
	// KeyState is a required field
	KeyState *string `type:"string" required:"true" enum:"KeyState"`

	// The date and time after which Amazon Web Services Payment Cryptography will
	// start using the key material for cryptographic operations.
	UsageStartTimestamp *time.Time `type:"timestamp"`

	// The date and time after which Amazon Web Services Payment Cryptography will
	// stop using the key material for cryptographic operations.
	UsageStopTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Key) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Key) GoString() string {
	return s.String()
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *Key) SetCreateTimestamp(v time.Time) *Key {
	s.CreateTimestamp = &v
	return s
}

// SetDeletePendingTimestamp sets the DeletePendingTimestamp field's value.
func (s *Key) SetDeletePendingTimestamp(v time.Time) *Key {
	s.DeletePendingTimestamp = &v
	return s
}

// SetDeleteTimestamp sets the DeleteTimestamp field's value.
func (s *Key) SetDeleteTimestamp(v time.Time) *Key {
	s.DeleteTimestamp = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *Key) SetEnabled(v bool) *Key {
	s.Enabled = &v
	return s
}

// SetExportable sets the Exportable field's value.
func (s *Key) SetExportable(v bool) *Key {
	s.Exportable = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *Key) SetKeyArn(v string) *Key {
	s.KeyArn = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *Key) SetKeyAttributes(v *KeyAttributes) *Key {
	s.KeyAttributes = v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *Key) SetKeyCheckValue(v string) *Key {
	s.KeyCheckValue = &v
	return s
}

// SetKeyCheckValueAlgorithm sets the KeyCheckValueAlgorithm field's value.
func (s *Key) SetKeyCheckValueAlgorithm(v string) *Key {
	s.KeyCheckValueAlgorithm = &v
	return s
}

// SetKeyOrigin sets the KeyOrigin field's value.
func (s *Key) SetKeyOrigin(v string) *Key {
	s.KeyOrigin = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *Key) SetKeyState(v string) *Key {
	s.KeyState = &v
	return s
}

// SetUsageStartTimestamp sets the UsageStartTimestamp field's value.
func (s *Key) SetUsageStartTimestamp(v time.Time) *Key {
	s.UsageStartTimestamp = &v
	return s
}

// SetUsageStopTimestamp sets the UsageStopTimestamp field's value.
func (s *Key) SetUsageStopTimestamp(v time.Time) *Key {
	s.UsageStopTimestamp = &v
	return s
}

// The role of the key, the algorithm it supports, and the cryptographic operations
// allowed with the key. This data is immutable after the key is created.
type KeyAttributes struct {
	_ struct{} `type:"structure"`

	// The key algorithm to be use during creation of an Amazon Web Services Payment
	// Cryptography key.
	//
	// For symmetric keys, Amazon Web Services Payment Cryptography supports AES
	// and TDES algorithms. For asymmetric keys, Amazon Web Services Payment Cryptography
	// supports RSA and ECC_NIST algorithms.
	//
	// KeyAlgorithm is a required field
	KeyAlgorithm *string `type:"string" required:"true" enum:"KeyAlgorithm"`

	// The type of Amazon Web Services Payment Cryptography key to create, which
	// determines the classiﬁcation of the cryptographic method and whether Amazon
	// Web Services Payment Cryptography key contains a symmetric key or an asymmetric
	// key pair.
	//
	// KeyClass is a required field
	KeyClass *string `type:"string" required:"true" enum:"KeyClass"`

	// The list of cryptographic operations that you can perform using the key.
	//
	// KeyModesOfUse is a required field
	KeyModesOfUse *KeyModesOfUse `type:"structure" required:"true"`

	// The cryptographic usage of an Amazon Web Services Payment Cryptography key
	// as deﬁned in section A.5.2 of the TR-31 spec.
	//
	// KeyUsage is a required field
	KeyUsage *string `type:"string" required:"true" enum:"KeyUsage"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyAttributes"}
	if s.KeyAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAlgorithm"))
	}
	if s.KeyClass == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyClass"))
	}
	if s.KeyModesOfUse == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyModesOfUse"))
	}
	if s.KeyUsage == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyUsage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyAlgorithm sets the KeyAlgorithm field's value.
func (s *KeyAttributes) SetKeyAlgorithm(v string) *KeyAttributes {
	s.KeyAlgorithm = &v
	return s
}

// SetKeyClass sets the KeyClass field's value.
func (s *KeyAttributes) SetKeyClass(v string) *KeyAttributes {
	s.KeyClass = &v
	return s
}

// SetKeyModesOfUse sets the KeyModesOfUse field's value.
func (s *KeyAttributes) SetKeyModesOfUse(v *KeyModesOfUse) *KeyAttributes {
	s.KeyModesOfUse = v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *KeyAttributes) SetKeyUsage(v string) *KeyAttributes {
	s.KeyUsage = &v
	return s
}

// Optional metadata for export associated with the key material. This data
// is signed but transmitted in clear text.
type KeyBlockHeaders struct {
	_ struct{} `type:"structure"`

	// Specifies subsequent exportability of the key within the key block after
	// it is received by the receiving party. It can be used to further restrict
	// exportability of the key after export from Amazon Web Services Payment Cryptography.
	//
	// When set to EXPORTABLE, the key can be subsequently exported by the receiver
	// under a KEK using TR-31 or TR-34 key block export only. When set to NON_EXPORTABLE,
	// the key cannot be subsequently exported by the receiver. When set to SENSITIVE,
	// the key can be exported by the receiver under a KEK using TR-31, TR-34, RSA
	// wrap and unwrap cryptogram or using a symmetric cryptogram key export method.
	// For further information refer to ANSI X9.143-2022 (https://webstore.ansi.org/standards/ascx9/ansix91432022).
	KeyExportability *string `type:"string" enum:"KeyExportability"`

	// The list of cryptographic operations that you can perform using the key.
	// The modes of use are deﬁned in section A.5.3 of the TR-31 spec.
	KeyModesOfUse *KeyModesOfUse `type:"structure"`

	// Parameter used to indicate the version of the key carried in the key block
	// or indicate the value carried in the key block is a component of a key.
	KeyVersion *string `min:"2" type:"string"`

	// Parameter used to indicate the type of optional data in key block headers.
	// Refer to ANSI X9.143-2022 (https://webstore.ansi.org/standards/ascx9/ansix91432022)
	// for information on allowed data type for optional blocks.
	//
	// Optional block character limit is 112 characters. For each optional block,
	// 2 characters are reserved for optional block ID and 2 characters reserved
	// for optional block length. More than one optional blocks can be included
	// as long as the combined length does not increase 112 characters.
	OptionalBlocks map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyBlockHeaders) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyBlockHeaders) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyBlockHeaders) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyBlockHeaders"}
	if s.KeyVersion != nil && len(*s.KeyVersion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyVersion", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyExportability sets the KeyExportability field's value.
func (s *KeyBlockHeaders) SetKeyExportability(v string) *KeyBlockHeaders {
	s.KeyExportability = &v
	return s
}

// SetKeyModesOfUse sets the KeyModesOfUse field's value.
func (s *KeyBlockHeaders) SetKeyModesOfUse(v *KeyModesOfUse) *KeyBlockHeaders {
	s.KeyModesOfUse = v
	return s
}

// SetKeyVersion sets the KeyVersion field's value.
func (s *KeyBlockHeaders) SetKeyVersion(v string) *KeyBlockHeaders {
	s.KeyVersion = &v
	return s
}

// SetOptionalBlocks sets the OptionalBlocks field's value.
func (s *KeyBlockHeaders) SetOptionalBlocks(v map[string]*string) *KeyBlockHeaders {
	s.OptionalBlocks = v
	return s
}

// The list of cryptographic operations that you can perform using the key.
// The modes of use are deﬁned in section A.5.3 of the TR-31 spec.
type KeyModesOfUse struct {
	_ struct{} `type:"structure"`

	// Speciﬁes whether an Amazon Web Services Payment Cryptography key can be
	// used to decrypt data.
	Decrypt *bool `type:"boolean"`

	// Speciﬁes whether an Amazon Web Services Payment Cryptography key can be
	// used to derive new keys.
	DeriveKey *bool `type:"boolean"`

	// Speciﬁes whether an Amazon Web Services Payment Cryptography key can be
	// used to encrypt data.
	Encrypt *bool `type:"boolean"`

	// Speciﬁes whether an Amazon Web Services Payment Cryptography key can be
	// used to generate and verify other card and PIN verification keys.
	Generate *bool `type:"boolean"`

	// Speciﬁes whether an Amazon Web Services Payment Cryptography key has no
	// special restrictions other than the restrictions implied by KeyUsage.
	NoRestrictions *bool `type:"boolean"`

	// Speciﬁes whether an Amazon Web Services Payment Cryptography key can be
	// used for signing.
	Sign *bool `type:"boolean"`

	// Speciﬁes whether an Amazon Web Services Payment Cryptography key can be
	// used to unwrap other keys.
	Unwrap *bool `type:"boolean"`

	// Speciﬁes whether an Amazon Web Services Payment Cryptography key can be
	// used to verify signatures.
	Verify *bool `type:"boolean"`

	// Speciﬁes whether an Amazon Web Services Payment Cryptography key can be
	// used to wrap other keys.
	Wrap *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyModesOfUse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyModesOfUse) GoString() string {
	return s.String()
}

// SetDecrypt sets the Decrypt field's value.
func (s *KeyModesOfUse) SetDecrypt(v bool) *KeyModesOfUse {
	s.Decrypt = &v
	return s
}

// SetDeriveKey sets the DeriveKey field's value.
func (s *KeyModesOfUse) SetDeriveKey(v bool) *KeyModesOfUse {
	s.DeriveKey = &v
	return s
}

// SetEncrypt sets the Encrypt field's value.
func (s *KeyModesOfUse) SetEncrypt(v bool) *KeyModesOfUse {
	s.Encrypt = &v
	return s
}

// SetGenerate sets the Generate field's value.
func (s *KeyModesOfUse) SetGenerate(v bool) *KeyModesOfUse {
	s.Generate = &v
	return s
}

// SetNoRestrictions sets the NoRestrictions field's value.
func (s *KeyModesOfUse) SetNoRestrictions(v bool) *KeyModesOfUse {
	s.NoRestrictions = &v
	return s
}

// SetSign sets the Sign field's value.
func (s *KeyModesOfUse) SetSign(v bool) *KeyModesOfUse {
	s.Sign = &v
	return s
}

// SetUnwrap sets the Unwrap field's value.
func (s *KeyModesOfUse) SetUnwrap(v bool) *KeyModesOfUse {
	s.Unwrap = &v
	return s
}

// SetVerify sets the Verify field's value.
func (s *KeyModesOfUse) SetVerify(v bool) *KeyModesOfUse {
	s.Verify = &v
	return s
}

// SetWrap sets the Wrap field's value.
func (s *KeyModesOfUse) SetWrap(v bool) *KeyModesOfUse {
	s.Wrap = &v
	return s
}

// Metadata about an Amazon Web Services Payment Cryptography key.
type KeySummary struct {
	_ struct{} `type:"structure"`

	// Specifies whether the key is enabled.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specifies whether the key is exportable. This data is immutable after the
	// key is created.
	//
	// Exportable is a required field
	Exportable *bool `type:"boolean" required:"true"`

	// The Amazon Resource Name (ARN) of the key.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The role of the key, the algorithm it supports, and the cryptographic operations
	// allowed with the key. This data is immutable after the key is created.
	//
	// KeyAttributes is a required field
	KeyAttributes *KeyAttributes `type:"structure" required:"true"`

	// The key check value (KCV) is used to check if all parties holding a given
	// key have the same key or to detect that a key has changed.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`

	// The state of an Amazon Web Services Payment Cryptography that is being created
	// or deleted.
	//
	// KeyState is a required field
	KeyState *string `type:"string" required:"true" enum:"KeyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeySummary) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *KeySummary) SetEnabled(v bool) *KeySummary {
	s.Enabled = &v
	return s
}

// SetExportable sets the Exportable field's value.
func (s *KeySummary) SetExportable(v bool) *KeySummary {
	s.Exportable = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *KeySummary) SetKeyArn(v string) *KeySummary {
	s.KeyArn = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *KeySummary) SetKeyAttributes(v *KeyAttributes) *KeySummary {
	s.KeyAttributes = v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *KeySummary) SetKeyCheckValue(v string) *KeySummary {
	s.KeyCheckValue = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *KeySummary) SetKeyState(v string) *KeySummary {
	s.KeyState = &v
	return s
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, Amazon Web Services Payment Cryptography does not
	// return more than the specified number of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextToken from the truncated response
	// you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAliasesInput) SetMaxResults(v int64) *ListAliasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesInput) SetNextToken(v string) *ListAliasesInput {
	s.NextToken = &v
	return s
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// The list of aliases. Each alias describes the KeyArn contained within.
	//
	// Aliases is a required field
	Aliases []*Alias `type:"list" required:"true"`

	// The token for the next set of results, or an empty or null value if there
	// are no more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*Alias) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesOutput) SetNextToken(v string) *ListAliasesOutput {
	s.NextToken = &v
	return s
}

type ListKeysInput struct {
	_ struct{} `type:"structure"`

	// The key state of the keys you want to list.
	KeyState *string `type:"string" enum:"KeyState"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, Amazon Web Services Payment Cryptography does not
	// return more than the specified number of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextToken from the truncated response
	// you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeysInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyState sets the KeyState field's value.
func (s *ListKeysInput) SetKeyState(v string) *ListKeysInput {
	s.KeyState = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKeysInput) SetMaxResults(v int64) *ListKeysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeysInput) SetNextToken(v string) *ListKeysInput {
	s.NextToken = &v
	return s
}

type ListKeysOutput struct {
	_ struct{} `type:"structure"`

	// The list of keys created within the caller's Amazon Web Services account
	// and Amazon Web Services Region.
	//
	// Keys is a required field
	Keys []*KeySummary `type:"list" required:"true"`

	// The token for the next set of results, or an empty or null value if there
	// are no more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysOutput) GoString() string {
	return s.String()
}

// SetKeys sets the Keys field's value.
func (s *ListKeysOutput) SetKeys(v []*KeySummary) *ListKeysOutput {
	s.Keys = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeysOutput) SetNextToken(v string) *ListKeysOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, Amazon Web Services Payment Cryptography does not
	// return more than the specified number of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextToken from the truncated response
	// you just received.
	NextToken *string `min:"1" type:"string"`

	// The KeyARN of the key whose tags you are getting.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"70" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 70 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 70))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or an empty or null value if there
	// are no more results.
	NextToken *string `min:"1" type:"string"`

	// The list of tags associated with a ResourceArn. Each tag will list the key-value
	// pair contained within that tag.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The request was denied due to an invalid resource error.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The string for the exception.
	ResourceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestoreKeyInput struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the key to be restored within Amazon Web Services Payment Cryptography.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreKeyInput"}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *RestoreKeyInput) SetKeyIdentifier(v string) *RestoreKeyInput {
	s.KeyIdentifier = &v
	return s
}

type RestoreKeyOutput struct {
	_ struct{} `type:"structure"`

	// The key material of the restored key. The KeyState will change to CREATE_COMPLETE
	// and value for DeletePendingTimestamp gets removed.
	//
	// Key is a required field
	Key *Key `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreKeyOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *RestoreKeyOutput) SetKey(v *Key) *RestoreKeyOutput {
	s.Key = v
	return s
}

// Parameter information for root public key certificate import.
type RootCertificatePublicKey struct {
	_ struct{} `type:"structure"`

	// The role of the key, the algorithm it supports, and the cryptographic operations
	// allowed with the key. This data is immutable after the root public key is
	// imported.
	//
	// KeyAttributes is a required field
	KeyAttributes *KeyAttributes `type:"structure" required:"true"`

	// Parameter information for root public key certificate import.
	//
	// PublicKeyCertificate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RootCertificatePublicKey's
	// String and GoString methods.
	//
	// PublicKeyCertificate is a required field
	PublicKeyCertificate *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootCertificatePublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootCertificatePublicKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RootCertificatePublicKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RootCertificatePublicKey"}
	if s.KeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAttributes"))
	}
	if s.PublicKeyCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyCertificate"))
	}
	if s.PublicKeyCertificate != nil && len(*s.PublicKeyCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublicKeyCertificate", 1))
	}
	if s.KeyAttributes != nil {
		if err := s.KeyAttributes.Validate(); err != nil {
			invalidParams.AddNested("KeyAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *RootCertificatePublicKey) SetKeyAttributes(v *KeyAttributes) *RootCertificatePublicKey {
	s.KeyAttributes = v
	return s
}

// SetPublicKeyCertificate sets the PublicKeyCertificate field's value.
func (s *RootCertificatePublicKey) SetPublicKeyCertificate(v string) *RootCertificatePublicKey {
	s.PublicKeyCertificate = &v
	return s
}

// This request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service cannot complete the request.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartKeyUsageInput struct {
	_ struct{} `type:"structure"`

	// The KeyArn of the key.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartKeyUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartKeyUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartKeyUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartKeyUsageInput"}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *StartKeyUsageInput) SetKeyIdentifier(v string) *StartKeyUsageInput {
	s.KeyIdentifier = &v
	return s
}

type StartKeyUsageOutput struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the Amazon Web Services Payment Cryptography key activated
	// for use.
	//
	// Key is a required field
	Key *Key `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartKeyUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartKeyUsageOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *StartKeyUsageOutput) SetKey(v *Key) *StartKeyUsageOutput {
	s.Key = v
	return s
}

type StopKeyUsageInput struct {
	_ struct{} `type:"structure"`

	// The KeyArn of the key.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopKeyUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopKeyUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopKeyUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopKeyUsageInput"}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *StopKeyUsageInput) SetKeyIdentifier(v string) *StopKeyUsageInput {
	s.KeyIdentifier = &v
	return s
}

type StopKeyUsageOutput struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the key.
	//
	// Key is a required field
	Key *Key `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopKeyUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopKeyUsageOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *StopKeyUsageOutput) SetKey(v *Key) *StopKeyUsageOutput {
	s.Key = v
	return s
}

// A structure that contains information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the key whose tags are being updated.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"70" type:"string" required:"true"`

	// One or more tags. Each tag consists of a tag key and a tag value. The tag
	// value can be an empty (null) string. You can't have more than one tag on
	// an Amazon Web Services Payment Cryptography key with the same tag key. If
	// you specify an existing tag key with a different tag value, Amazon Web Services
	// Payment Cryptography replaces the current tag value with the new one.
	//
	// Don't include personal, confidential or sensitive information in this field.
	// This field may be displayed in plaintext in CloudTrail logs and other output.
	//
	// To use this parameter, you must have TagResource (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_TagResource.html)
	// permission in an IAM policy.
	//
	// Don't include personal, confidential or sensitive information in this field.
	// This field may be displayed in plaintext in CloudTrail logs and other output.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 70 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 70))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Parameter information for trusted public key certificate import.
type TrustedCertificatePublicKey struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the root public key certificate or certificate chain that signs
	// the trusted public key certificate import.
	//
	// CertificateAuthorityPublicKeyIdentifier is a required field
	CertificateAuthorityPublicKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The role of the key, the algorithm it supports, and the cryptographic operations
	// allowed with the key. This data is immutable after a trusted public key is
	// imported.
	//
	// KeyAttributes is a required field
	KeyAttributes *KeyAttributes `type:"structure" required:"true"`

	// Parameter information for trusted public key certificate import.
	//
	// PublicKeyCertificate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TrustedCertificatePublicKey's
	// String and GoString methods.
	//
	// PublicKeyCertificate is a required field
	PublicKeyCertificate *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustedCertificatePublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustedCertificatePublicKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrustedCertificatePublicKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrustedCertificatePublicKey"}
	if s.CertificateAuthorityPublicKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityPublicKeyIdentifier"))
	}
	if s.CertificateAuthorityPublicKeyIdentifier != nil && len(*s.CertificateAuthorityPublicKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityPublicKeyIdentifier", 7))
	}
	if s.KeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAttributes"))
	}
	if s.PublicKeyCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyCertificate"))
	}
	if s.PublicKeyCertificate != nil && len(*s.PublicKeyCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublicKeyCertificate", 1))
	}
	if s.KeyAttributes != nil {
		if err := s.KeyAttributes.Validate(); err != nil {
			invalidParams.AddNested("KeyAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityPublicKeyIdentifier sets the CertificateAuthorityPublicKeyIdentifier field's value.
func (s *TrustedCertificatePublicKey) SetCertificateAuthorityPublicKeyIdentifier(v string) *TrustedCertificatePublicKey {
	s.CertificateAuthorityPublicKeyIdentifier = &v
	return s
}

// SetKeyAttributes sets the KeyAttributes field's value.
func (s *TrustedCertificatePublicKey) SetKeyAttributes(v *KeyAttributes) *TrustedCertificatePublicKey {
	s.KeyAttributes = v
	return s
}

// SetPublicKeyCertificate sets the PublicKeyCertificate field's value.
func (s *TrustedCertificatePublicKey) SetPublicKeyCertificate(v string) *TrustedCertificatePublicKey {
	s.PublicKeyCertificate = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The KeyARN of the key whose tags are being removed.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"70" type:"string" required:"true"`

	// One or more tag keys. Don't include the tag values.
	//
	// If the Amazon Web Services Payment Cryptography key doesn't have the specified
	// tag key, Amazon Web Services Payment Cryptography doesn't throw an exception
	// or return a response. To confirm that the operation succeeded, use the ListTagsForResource
	// (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListTagsForResource.html)
	// operation.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 70 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 70))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias whose associated key is changing.
	//
	// AliasName is a required field
	AliasName *string `min:"7" type:"string" required:"true"`

	// The KeyARN for the key that you are updating or removing from the alias.
	KeyArn *string `min:"70" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 7))
	}
	if s.KeyArn != nil && len(*s.KeyArn) < 70 {
		invalidParams.Add(request.NewErrParamMinLen("KeyArn", 70))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *UpdateAliasInput) SetAliasName(v string) *UpdateAliasInput {
	s.AliasName = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *UpdateAliasInput) SetKeyArn(v string) *UpdateAliasInput {
	s.KeyArn = &v
	return s
}

type UpdateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The alias name.
	//
	// Alias is a required field
	Alias *Alias `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *UpdateAliasOutput) SetAlias(v *Alias) *UpdateAliasOutput {
	s.Alias = v
	return s
}

// The request was denied due to an invalid request error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Parameter information for generating a WrappedKeyBlock for key exchange.
type WrappedKey struct {
	_ struct{} `type:"structure"`

	// The key check value (KCV) is used to check if all parties holding a given
	// key have the same key or to detect that a key has changed.
	KeyCheckValue *string `min:"4" type:"string"`

	// The algorithm that Amazon Web Services Payment Cryptography uses to calculate
	// the key check value (KCV). It is used to validate the key integrity.
	//
	// For TDES keys, the KCV is computed by encrypting 8 bytes, each with value
	// of zero, with the key to be checked and retaining the 3 highest order bytes
	// of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm
	// where the input data is 16 bytes of zero and retaining the 3 highest order
	// bytes of the encrypted result.
	KeyCheckValueAlgorithm *string `type:"string" enum:"KeyCheckValueAlgorithm"`

	// Parameter information for generating a wrapped key using TR-31 or TR-34 skey
	// exchange method.
	//
	// KeyMaterial is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WrappedKey's
	// String and GoString methods.
	//
	// KeyMaterial is a required field
	KeyMaterial *string `min:"48" type:"string" required:"true" sensitive:"true"`

	// The key block format of a wrapped key.
	//
	// WrappedKeyMaterialFormat is a required field
	WrappedKeyMaterialFormat *string `type:"string" required:"true" enum:"WrappedKeyMaterialFormat"`

	// The KeyARN of the wrapped key.
	//
	// WrappingKeyArn is a required field
	WrappingKeyArn *string `min:"70" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WrappedKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WrappedKey) GoString() string {
	return s.String()
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *WrappedKey) SetKeyCheckValue(v string) *WrappedKey {
	s.KeyCheckValue = &v
	return s
}

// SetKeyCheckValueAlgorithm sets the KeyCheckValueAlgorithm field's value.
func (s *WrappedKey) SetKeyCheckValueAlgorithm(v string) *WrappedKey {
	s.KeyCheckValueAlgorithm = &v
	return s
}

// SetKeyMaterial sets the KeyMaterial field's value.
func (s *WrappedKey) SetKeyMaterial(v string) *WrappedKey {
	s.KeyMaterial = &v
	return s
}

// SetWrappedKeyMaterialFormat sets the WrappedKeyMaterialFormat field's value.
func (s *WrappedKey) SetWrappedKeyMaterialFormat(v string) *WrappedKey {
	s.WrappedKeyMaterialFormat = &v
	return s
}

// SetWrappingKeyArn sets the WrappingKeyArn field's value.
func (s *WrappedKey) SetWrappingKeyArn(v string) *WrappedKey {
	s.WrappingKeyArn = &v
	return s
}

const (
	// KeyAlgorithmTdes2key is a KeyAlgorithm enum value
	KeyAlgorithmTdes2key = "TDES_2KEY"

	// KeyAlgorithmTdes3key is a KeyAlgorithm enum value
	KeyAlgorithmTdes3key = "TDES_3KEY"

	// KeyAlgorithmAes128 is a KeyAlgorithm enum value
	KeyAlgorithmAes128 = "AES_128"

	// KeyAlgorithmAes192 is a KeyAlgorithm enum value
	KeyAlgorithmAes192 = "AES_192"

	// KeyAlgorithmAes256 is a KeyAlgorithm enum value
	KeyAlgorithmAes256 = "AES_256"

	// KeyAlgorithmRsa2048 is a KeyAlgorithm enum value
	KeyAlgorithmRsa2048 = "RSA_2048"

	// KeyAlgorithmRsa3072 is a KeyAlgorithm enum value
	KeyAlgorithmRsa3072 = "RSA_3072"

	// KeyAlgorithmRsa4096 is a KeyAlgorithm enum value
	KeyAlgorithmRsa4096 = "RSA_4096"
)

// KeyAlgorithm_Values returns all elements of the KeyAlgorithm enum
func KeyAlgorithm_Values() []string {
	return []string{
		KeyAlgorithmTdes2key,
		KeyAlgorithmTdes3key,
		KeyAlgorithmAes128,
		KeyAlgorithmAes192,
		KeyAlgorithmAes256,
		KeyAlgorithmRsa2048,
		KeyAlgorithmRsa3072,
		KeyAlgorithmRsa4096,
	}
}

const (
	// KeyCheckValueAlgorithmCmac is a KeyCheckValueAlgorithm enum value
	KeyCheckValueAlgorithmCmac = "CMAC"

	// KeyCheckValueAlgorithmAnsiX924 is a KeyCheckValueAlgorithm enum value
	KeyCheckValueAlgorithmAnsiX924 = "ANSI_X9_24"
)

// KeyCheckValueAlgorithm_Values returns all elements of the KeyCheckValueAlgorithm enum
func KeyCheckValueAlgorithm_Values() []string {
	return []string{
		KeyCheckValueAlgorithmCmac,
		KeyCheckValueAlgorithmAnsiX924,
	}
}

const (
	// KeyClassSymmetricKey is a KeyClass enum value
	KeyClassSymmetricKey = "SYMMETRIC_KEY"

	// KeyClassAsymmetricKeyPair is a KeyClass enum value
	KeyClassAsymmetricKeyPair = "ASYMMETRIC_KEY_PAIR"

	// KeyClassPrivateKey is a KeyClass enum value
	KeyClassPrivateKey = "PRIVATE_KEY"

	// KeyClassPublicKey is a KeyClass enum value
	KeyClassPublicKey = "PUBLIC_KEY"
)

// KeyClass_Values returns all elements of the KeyClass enum
func KeyClass_Values() []string {
	return []string{
		KeyClassSymmetricKey,
		KeyClassAsymmetricKeyPair,
		KeyClassPrivateKey,
		KeyClassPublicKey,
	}
}

const (
	// KeyExportabilityExportable is a KeyExportability enum value
	KeyExportabilityExportable = "EXPORTABLE"

	// KeyExportabilityNonExportable is a KeyExportability enum value
	KeyExportabilityNonExportable = "NON_EXPORTABLE"

	// KeyExportabilitySensitive is a KeyExportability enum value
	KeyExportabilitySensitive = "SENSITIVE"
)

// KeyExportability_Values returns all elements of the KeyExportability enum
func KeyExportability_Values() []string {
	return []string{
		KeyExportabilityExportable,
		KeyExportabilityNonExportable,
		KeyExportabilitySensitive,
	}
}

const (
	// KeyMaterialTypeTr34KeyBlock is a KeyMaterialType enum value
	KeyMaterialTypeTr34KeyBlock = "TR34_KEY_BLOCK"

	// KeyMaterialTypeTr31KeyBlock is a KeyMaterialType enum value
	KeyMaterialTypeTr31KeyBlock = "TR31_KEY_BLOCK"

	// KeyMaterialTypeRootPublicKeyCertificate is a KeyMaterialType enum value
	KeyMaterialTypeRootPublicKeyCertificate = "ROOT_PUBLIC_KEY_CERTIFICATE"

	// KeyMaterialTypeTrustedPublicKeyCertificate is a KeyMaterialType enum value
	KeyMaterialTypeTrustedPublicKeyCertificate = "TRUSTED_PUBLIC_KEY_CERTIFICATE"

	// KeyMaterialTypeKeyCryptogram is a KeyMaterialType enum value
	KeyMaterialTypeKeyCryptogram = "KEY_CRYPTOGRAM"
)

// KeyMaterialType_Values returns all elements of the KeyMaterialType enum
func KeyMaterialType_Values() []string {
	return []string{
		KeyMaterialTypeTr34KeyBlock,
		KeyMaterialTypeTr31KeyBlock,
		KeyMaterialTypeRootPublicKeyCertificate,
		KeyMaterialTypeTrustedPublicKeyCertificate,
		KeyMaterialTypeKeyCryptogram,
	}
}

// Defines the source of a key
const (
	// KeyOriginExternal is a KeyOrigin enum value
	KeyOriginExternal = "EXTERNAL"

	// KeyOriginAwsPaymentCryptography is a KeyOrigin enum value
	KeyOriginAwsPaymentCryptography = "AWS_PAYMENT_CRYPTOGRAPHY"
)

// KeyOrigin_Values returns all elements of the KeyOrigin enum
func KeyOrigin_Values() []string {
	return []string{
		KeyOriginExternal,
		KeyOriginAwsPaymentCryptography,
	}
}

// Defines the state of a key
const (
	// KeyStateCreateInProgress is a KeyState enum value
	KeyStateCreateInProgress = "CREATE_IN_PROGRESS"

	// KeyStateCreateComplete is a KeyState enum value
	KeyStateCreateComplete = "CREATE_COMPLETE"

	// KeyStateDeletePending is a KeyState enum value
	KeyStateDeletePending = "DELETE_PENDING"

	// KeyStateDeleteComplete is a KeyState enum value
	KeyStateDeleteComplete = "DELETE_COMPLETE"
)

// KeyState_Values returns all elements of the KeyState enum
func KeyState_Values() []string {
	return []string{
		KeyStateCreateInProgress,
		KeyStateCreateComplete,
		KeyStateDeletePending,
		KeyStateDeleteComplete,
	}
}

const (
	// KeyUsageTr31B0BaseDerivationKey is a KeyUsage enum value
	KeyUsageTr31B0BaseDerivationKey = "TR31_B0_BASE_DERIVATION_KEY"

	// KeyUsageTr31C0CardVerificationKey is a KeyUsage enum value
	KeyUsageTr31C0CardVerificationKey = "TR31_C0_CARD_VERIFICATION_KEY"

	// KeyUsageTr31D0SymmetricDataEncryptionKey is a KeyUsage enum value
	KeyUsageTr31D0SymmetricDataEncryptionKey = "TR31_D0_SYMMETRIC_DATA_ENCRYPTION_KEY"

	// KeyUsageTr31D1AsymmetricKeyForDataEncryption is a KeyUsage enum value
	KeyUsageTr31D1AsymmetricKeyForDataEncryption = "TR31_D1_ASYMMETRIC_KEY_FOR_DATA_ENCRYPTION"

	// KeyUsageTr31E0EmvMkeyAppCryptograms is a KeyUsage enum value
	KeyUsageTr31E0EmvMkeyAppCryptograms = "TR31_E0_EMV_MKEY_APP_CRYPTOGRAMS"

	// KeyUsageTr31E1EmvMkeyConfidentiality is a KeyUsage enum value
	KeyUsageTr31E1EmvMkeyConfidentiality = "TR31_E1_EMV_MKEY_CONFIDENTIALITY"

	// KeyUsageTr31E2EmvMkeyIntegrity is a KeyUsage enum value
	KeyUsageTr31E2EmvMkeyIntegrity = "TR31_E2_EMV_MKEY_INTEGRITY"

	// KeyUsageTr31E4EmvMkeyDynamicNumbers is a KeyUsage enum value
	KeyUsageTr31E4EmvMkeyDynamicNumbers = "TR31_E4_EMV_MKEY_DYNAMIC_NUMBERS"

	// KeyUsageTr31E5EmvMkeyCardPersonalization is a KeyUsage enum value
	KeyUsageTr31E5EmvMkeyCardPersonalization = "TR31_E5_EMV_MKEY_CARD_PERSONALIZATION"

	// KeyUsageTr31E6EmvMkeyOther is a KeyUsage enum value
	KeyUsageTr31E6EmvMkeyOther = "TR31_E6_EMV_MKEY_OTHER"

	// KeyUsageTr31K0KeyEncryptionKey is a KeyUsage enum value
	KeyUsageTr31K0KeyEncryptionKey = "TR31_K0_KEY_ENCRYPTION_KEY"

	// KeyUsageTr31K1KeyBlockProtectionKey is a KeyUsage enum value
	KeyUsageTr31K1KeyBlockProtectionKey = "TR31_K1_KEY_BLOCK_PROTECTION_KEY"

	// KeyUsageTr31K3AsymmetricKeyForKeyAgreement is a KeyUsage enum value
	KeyUsageTr31K3AsymmetricKeyForKeyAgreement = "TR31_K3_ASYMMETRIC_KEY_FOR_KEY_AGREEMENT"

	// KeyUsageTr31M3Iso97973MacKey is a KeyUsage enum value
	KeyUsageTr31M3Iso97973MacKey = "TR31_M3_ISO_9797_3_MAC_KEY"

	// KeyUsageTr31M1Iso97971MacKey is a KeyUsage enum value
	KeyUsageTr31M1Iso97971MacKey = "TR31_M1_ISO_9797_1_MAC_KEY"

	// KeyUsageTr31M6Iso97975CmacKey is a KeyUsage enum value
	KeyUsageTr31M6Iso97975CmacKey = "TR31_M6_ISO_9797_5_CMAC_KEY"

	// KeyUsageTr31M7HmacKey is a KeyUsage enum value
	KeyUsageTr31M7HmacKey = "TR31_M7_HMAC_KEY"

	// KeyUsageTr31P0PinEncryptionKey is a KeyUsage enum value
	KeyUsageTr31P0PinEncryptionKey = "TR31_P0_PIN_ENCRYPTION_KEY"

	// KeyUsageTr31P1PinGenerationKey is a KeyUsage enum value
	KeyUsageTr31P1PinGenerationKey = "TR31_P1_PIN_GENERATION_KEY"

	// KeyUsageTr31S0AsymmetricKeyForDigitalSignature is a KeyUsage enum value
	KeyUsageTr31S0AsymmetricKeyForDigitalSignature = "TR31_S0_ASYMMETRIC_KEY_FOR_DIGITAL_SIGNATURE"

	// KeyUsageTr31V1Ibm3624PinVerificationKey is a KeyUsage enum value
	KeyUsageTr31V1Ibm3624PinVerificationKey = "TR31_V1_IBM3624_PIN_VERIFICATION_KEY"

	// KeyUsageTr31V2VisaPinVerificationKey is a KeyUsage enum value
	KeyUsageTr31V2VisaPinVerificationKey = "TR31_V2_VISA_PIN_VERIFICATION_KEY"

	// KeyUsageTr31K2Tr34AsymmetricKey is a KeyUsage enum value
	KeyUsageTr31K2Tr34AsymmetricKey = "TR31_K2_TR34_ASYMMETRIC_KEY"
)

// KeyUsage_Values returns all elements of the KeyUsage enum
func KeyUsage_Values() []string {
	return []string{
		KeyUsageTr31B0BaseDerivationKey,
		KeyUsageTr31C0CardVerificationKey,
		KeyUsageTr31D0SymmetricDataEncryptionKey,
		KeyUsageTr31D1AsymmetricKeyForDataEncryption,
		KeyUsageTr31E0EmvMkeyAppCryptograms,
		KeyUsageTr31E1EmvMkeyConfidentiality,
		KeyUsageTr31E2EmvMkeyIntegrity,
		KeyUsageTr31E4EmvMkeyDynamicNumbers,
		KeyUsageTr31E5EmvMkeyCardPersonalization,
		KeyUsageTr31E6EmvMkeyOther,
		KeyUsageTr31K0KeyEncryptionKey,
		KeyUsageTr31K1KeyBlockProtectionKey,
		KeyUsageTr31K3AsymmetricKeyForKeyAgreement,
		KeyUsageTr31M3Iso97973MacKey,
		KeyUsageTr31M1Iso97971MacKey,
		KeyUsageTr31M6Iso97975CmacKey,
		KeyUsageTr31M7HmacKey,
		KeyUsageTr31P0PinEncryptionKey,
		KeyUsageTr31P1PinGenerationKey,
		KeyUsageTr31S0AsymmetricKeyForDigitalSignature,
		KeyUsageTr31V1Ibm3624PinVerificationKey,
		KeyUsageTr31V2VisaPinVerificationKey,
		KeyUsageTr31K2Tr34AsymmetricKey,
	}
}

const (
	// Tr34KeyBlockFormatX9Tr342012 is a Tr34KeyBlockFormat enum value
	Tr34KeyBlockFormatX9Tr342012 = "X9_TR34_2012"
)

// Tr34KeyBlockFormat_Values returns all elements of the Tr34KeyBlockFormat enum
func Tr34KeyBlockFormat_Values() []string {
	return []string{
		Tr34KeyBlockFormatX9Tr342012,
	}
}

const (
	// WrappedKeyMaterialFormatKeyCryptogram is a WrappedKeyMaterialFormat enum value
	WrappedKeyMaterialFormatKeyCryptogram = "KEY_CRYPTOGRAM"

	// WrappedKeyMaterialFormatTr31KeyBlock is a WrappedKeyMaterialFormat enum value
	WrappedKeyMaterialFormatTr31KeyBlock = "TR31_KEY_BLOCK"

	// WrappedKeyMaterialFormatTr34KeyBlock is a WrappedKeyMaterialFormat enum value
	WrappedKeyMaterialFormatTr34KeyBlock = "TR34_KEY_BLOCK"
)

// WrappedKeyMaterialFormat_Values returns all elements of the WrappedKeyMaterialFormat enum
func WrappedKeyMaterialFormat_Values() []string {
	return []string{
		WrappedKeyMaterialFormatKeyCryptogram,
		WrappedKeyMaterialFormatTr31KeyBlock,
		WrappedKeyMaterialFormatTr34KeyBlock,
	}
}

const (
	// WrappingKeySpecRsaOaepSha256 is a WrappingKeySpec enum value
	WrappingKeySpecRsaOaepSha256 = "RSA_OAEP_SHA_256"

	// WrappingKeySpecRsaOaepSha512 is a WrappingKeySpec enum value
	WrappingKeySpecRsaOaepSha512 = "RSA_OAEP_SHA_512"
)

// WrappingKeySpec_Values returns all elements of the WrappingKeySpec enum
func WrappingKeySpec_Values() []string {
	return []string{
		WrappingKeySpecRsaOaepSha256,
		WrappingKeySpecRsaOaepSha512,
	}
}
