// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package bedrockagentruntimeiface provides an interface to enable mocking the Agents for Amazon Bedrock Runtime service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package bedrockagentruntimeiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/bedrockagentruntime"
)

// BedrockAgentRuntimeAPI provides an interface to enable mocking the
// bedrockagentruntime.BedrockAgentRuntime service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Agents for Amazon Bedrock Runtime.
//	func myFunc(svc bedrockagentruntimeiface.BedrockAgentRuntimeAPI) bool {
//	    // Make svc.DeleteAgentMemory request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := bedrockagentruntime.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockBedrockAgentRuntimeClient struct {
//	    bedrockagentruntimeiface.BedrockAgentRuntimeAPI
//	}
//	func (m *mockBedrockAgentRuntimeClient) DeleteAgentMemory(input *bedrockagentruntime.DeleteAgentMemoryInput) (*bedrockagentruntime.DeleteAgentMemoryOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockBedrockAgentRuntimeClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type BedrockAgentRuntimeAPI interface {
	DeleteAgentMemory(*bedrockagentruntime.DeleteAgentMemoryInput) (*bedrockagentruntime.DeleteAgentMemoryOutput, error)
	DeleteAgentMemoryWithContext(aws.Context, *bedrockagentruntime.DeleteAgentMemoryInput, ...request.Option) (*bedrockagentruntime.DeleteAgentMemoryOutput, error)
	DeleteAgentMemoryRequest(*bedrockagentruntime.DeleteAgentMemoryInput) (*request.Request, *bedrockagentruntime.DeleteAgentMemoryOutput)

	GetAgentMemory(*bedrockagentruntime.GetAgentMemoryInput) (*bedrockagentruntime.GetAgentMemoryOutput, error)
	GetAgentMemoryWithContext(aws.Context, *bedrockagentruntime.GetAgentMemoryInput, ...request.Option) (*bedrockagentruntime.GetAgentMemoryOutput, error)
	GetAgentMemoryRequest(*bedrockagentruntime.GetAgentMemoryInput) (*request.Request, *bedrockagentruntime.GetAgentMemoryOutput)

	GetAgentMemoryPages(*bedrockagentruntime.GetAgentMemoryInput, func(*bedrockagentruntime.GetAgentMemoryOutput, bool) bool) error
	GetAgentMemoryPagesWithContext(aws.Context, *bedrockagentruntime.GetAgentMemoryInput, func(*bedrockagentruntime.GetAgentMemoryOutput, bool) bool, ...request.Option) error

	InvokeAgent(*bedrockagentruntime.InvokeAgentInput) (*bedrockagentruntime.InvokeAgentOutput, error)
	InvokeAgentWithContext(aws.Context, *bedrockagentruntime.InvokeAgentInput, ...request.Option) (*bedrockagentruntime.InvokeAgentOutput, error)
	InvokeAgentRequest(*bedrockagentruntime.InvokeAgentInput) (*request.Request, *bedrockagentruntime.InvokeAgentOutput)

	InvokeFlow(*bedrockagentruntime.InvokeFlowInput) (*bedrockagentruntime.InvokeFlowOutput, error)
	InvokeFlowWithContext(aws.Context, *bedrockagentruntime.InvokeFlowInput, ...request.Option) (*bedrockagentruntime.InvokeFlowOutput, error)
	InvokeFlowRequest(*bedrockagentruntime.InvokeFlowInput) (*request.Request, *bedrockagentruntime.InvokeFlowOutput)

	Retrieve(*bedrockagentruntime.RetrieveInput) (*bedrockagentruntime.RetrieveOutput, error)
	RetrieveWithContext(aws.Context, *bedrockagentruntime.RetrieveInput, ...request.Option) (*bedrockagentruntime.RetrieveOutput, error)
	RetrieveRequest(*bedrockagentruntime.RetrieveInput) (*request.Request, *bedrockagentruntime.RetrieveOutput)

	RetrievePages(*bedrockagentruntime.RetrieveInput, func(*bedrockagentruntime.RetrieveOutput, bool) bool) error
	RetrievePagesWithContext(aws.Context, *bedrockagentruntime.RetrieveInput, func(*bedrockagentruntime.RetrieveOutput, bool) bool, ...request.Option) error

	RetrieveAndGenerate(*bedrockagentruntime.RetrieveAndGenerateInput) (*bedrockagentruntime.RetrieveAndGenerateOutput, error)
	RetrieveAndGenerateWithContext(aws.Context, *bedrockagentruntime.RetrieveAndGenerateInput, ...request.Option) (*bedrockagentruntime.RetrieveAndGenerateOutput, error)
	RetrieveAndGenerateRequest(*bedrockagentruntime.RetrieveAndGenerateInput) (*request.Request, *bedrockagentruntime.RetrieveAndGenerateOutput)
}

var _ BedrockAgentRuntimeAPI = (*bedrockagentruntime.BedrockAgentRuntime)(nil)
