// Copyright 2020-2024 the Pinniped contributors. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "go.pinniped.dev/generated/latest/apis/supervisor/config/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeOIDCClients implements OIDCClientInterface
type FakeOIDCClients struct {
	Fake *FakeConfigV1alpha1
	ns   string
}

var oidcclientsResource = v1alpha1.SchemeGroupVersion.WithResource("oidcclients")

var oidcclientsKind = v1alpha1.SchemeGroupVersion.WithKind("OIDCClient")

// Get takes name of the oIDCClient, and returns the corresponding oIDCClient object, and an error if there is any.
func (c *FakeOIDCClients) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.OIDCClient, err error) {
	emptyResult := &v1alpha1.OIDCClient{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(oidcclientsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.OIDCClient), err
}

// List takes label and field selectors, and returns the list of OIDCClients that match those selectors.
func (c *FakeOIDCClients) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.OIDCClientList, err error) {
	emptyResult := &v1alpha1.OIDCClientList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(oidcclientsResource, oidcclientsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.OIDCClientList{ListMeta: obj.(*v1alpha1.OIDCClientList).ListMeta}
	for _, item := range obj.(*v1alpha1.OIDCClientList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested oIDCClients.
func (c *FakeOIDCClients) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(oidcclientsResource, c.ns, opts))

}

// Create takes the representation of a oIDCClient and creates it.  Returns the server's representation of the oIDCClient, and an error, if there is any.
func (c *FakeOIDCClients) Create(ctx context.Context, oIDCClient *v1alpha1.OIDCClient, opts v1.CreateOptions) (result *v1alpha1.OIDCClient, err error) {
	emptyResult := &v1alpha1.OIDCClient{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(oidcclientsResource, c.ns, oIDCClient, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.OIDCClient), err
}

// Update takes the representation of a oIDCClient and updates it. Returns the server's representation of the oIDCClient, and an error, if there is any.
func (c *FakeOIDCClients) Update(ctx context.Context, oIDCClient *v1alpha1.OIDCClient, opts v1.UpdateOptions) (result *v1alpha1.OIDCClient, err error) {
	emptyResult := &v1alpha1.OIDCClient{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(oidcclientsResource, c.ns, oIDCClient, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.OIDCClient), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeOIDCClients) UpdateStatus(ctx context.Context, oIDCClient *v1alpha1.OIDCClient, opts v1.UpdateOptions) (result *v1alpha1.OIDCClient, err error) {
	emptyResult := &v1alpha1.OIDCClient{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(oidcclientsResource, "status", c.ns, oIDCClient, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.OIDCClient), err
}

// Delete takes name of the oIDCClient and deletes it. Returns an error if one occurs.
func (c *FakeOIDCClients) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(oidcclientsResource, c.ns, name, opts), &v1alpha1.OIDCClient{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeOIDCClients) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(oidcclientsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.OIDCClientList{})
	return err
}

// Patch applies the patch and returns the patched oIDCClient.
func (c *FakeOIDCClients) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.OIDCClient, err error) {
	emptyResult := &v1alpha1.OIDCClient{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(oidcclientsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.OIDCClient), err
}
