// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListDomainCommon = "ListDomain"

// ListDomainCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDomainCommon operation. The "output" return
// value will be populated with the ListDomainCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDomainCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDomainCommon Send returns without error.
//
// See ListDomainCommon for more information on using the ListDomainCommon
// API call, and error handling.
//
//    // Example sending a request using the ListDomainCommonRequest method.
//    req, resp := client.ListDomainCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *WAF) ListDomainCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListDomainCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDomainCommon API operation for WAF.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for WAF's
// API operation ListDomainCommon for usage and error information.
func (c *WAF) ListDomainCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListDomainCommonRequest(input)
	return out, req.Send()
}

// ListDomainCommonWithContext is the same as ListDomainCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListDomainCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListDomainCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomain = "ListDomain"

// ListDomainRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDomain operation. The "output" return
// value will be populated with the ListDomainCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDomainCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDomainCommon Send returns without error.
//
// See ListDomain for more information on using the ListDomain
// API call, and error handling.
//
//    // Example sending a request using the ListDomainRequest method.
//    req, resp := client.ListDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *WAF) ListDomainRequest(input *ListDomainInput) (req *request.Request, output *ListDomainOutput) {
	op := &request.Operation{
		Name:       opListDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDomainInput{}
	}

	output = &ListDomainOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDomain API operation for WAF.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for WAF's
// API operation ListDomain for usage and error information.
func (c *WAF) ListDomain(input *ListDomainInput) (*ListDomainOutput, error) {
	req, out := c.ListDomainRequest(input)
	return out, req.Send()
}

// ListDomainWithContext is the same as ListDomain with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListDomainWithContext(ctx volcengine.Context, input *ListDomainInput, opts ...request.Option) (*ListDomainOutput, error) {
	req, out := c.ListDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BackendForListDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IP *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Protocol *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s BackendForListDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackendForListDomainOutput) GoString() string {
	return s.String()
}

// SetIP sets the IP field's value.
func (s *BackendForListDomainOutput) SetIP(v string) *BackendForListDomainOutput {
	s.IP = &v
	return s
}

// SetPort sets the Port field's value.
func (s *BackendForListDomainOutput) SetPort(v int32) *BackendForListDomainOutput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *BackendForListDomainOutput) SetProtocol(v string) *BackendForListDomainOutput {
	s.Protocol = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *BackendForListDomainOutput) SetWeight(v int32) *BackendForListDomainOutput {
	s.Weight = &v
	return s
}

type BackendGroupForListDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessPort []*int32 `type:"list" json:",omitempty"`

	Backends []*BackendForListDomainOutput `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BackendGroupForListDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackendGroupForListDomainOutput) GoString() string {
	return s.String()
}

// SetAccessPort sets the AccessPort field's value.
func (s *BackendGroupForListDomainOutput) SetAccessPort(v []*int32) *BackendGroupForListDomainOutput {
	s.AccessPort = v
	return s
}

// SetBackends sets the Backends field's value.
func (s *BackendGroupForListDomainOutput) SetBackends(v []*BackendForListDomainOutput) *BackendGroupForListDomainOutput {
	s.Backends = v
	return s
}

// SetName sets the Name field's value.
func (s *BackendGroupForListDomainOutput) SetName(v string) *BackendGroupForListDomainOutput {
	s.Name = &v
	return s
}

type CloudAccessConfigForListDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessProtocol *string `type:"string" json:",omitempty"`

	DefenceMode *int32 `type:"int32" json:",omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	ListenerID *string `type:"string" json:",omitempty"`

	LostAssociationFromALB *int32 `type:"int32" json:",omitempty"`

	Port *string `type:"string" json:",omitempty"`

	Protocol *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CloudAccessConfigForListDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudAccessConfigForListDomainOutput) GoString() string {
	return s.String()
}

// SetAccessProtocol sets the AccessProtocol field's value.
func (s *CloudAccessConfigForListDomainOutput) SetAccessProtocol(v string) *CloudAccessConfigForListDomainOutput {
	s.AccessProtocol = &v
	return s
}

// SetDefenceMode sets the DefenceMode field's value.
func (s *CloudAccessConfigForListDomainOutput) SetDefenceMode(v int32) *CloudAccessConfigForListDomainOutput {
	s.DefenceMode = &v
	return s
}

// SetInstanceID sets the InstanceID field's value.
func (s *CloudAccessConfigForListDomainOutput) SetInstanceID(v string) *CloudAccessConfigForListDomainOutput {
	s.InstanceID = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *CloudAccessConfigForListDomainOutput) SetInstanceName(v string) *CloudAccessConfigForListDomainOutput {
	s.InstanceName = &v
	return s
}

// SetListenerID sets the ListenerID field's value.
func (s *CloudAccessConfigForListDomainOutput) SetListenerID(v string) *CloudAccessConfigForListDomainOutput {
	s.ListenerID = &v
	return s
}

// SetLostAssociationFromALB sets the LostAssociationFromALB field's value.
func (s *CloudAccessConfigForListDomainOutput) SetLostAssociationFromALB(v int32) *CloudAccessConfigForListDomainOutput {
	s.LostAssociationFromALB = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CloudAccessConfigForListDomainOutput) SetPort(v string) *CloudAccessConfigForListDomainOutput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CloudAccessConfigForListDomainOutput) SetProtocol(v string) *CloudAccessConfigForListDomainOutput {
	s.Protocol = &v
	return s
}

type DataForListDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessMode *int32 `type:"int32" json:",omitempty"`

	AdvancedDefenseIP *string `type:"string" json:",omitempty"`

	AdvancedDefenseIPv6 *string `type:"string" json:",omitempty"`

	ApiEnable *int32 `type:"int32" json:",omitempty"`

	AttackStatus *int32 `type:"int32" json:",omitempty"`

	AutoCCEnable *int32 `type:"int32" json:",omitempty"`

	AutomaticBlackEnable *int32 `type:"int32" json:",omitempty"`

	BackendGroups []*BackendGroupForListDomainOutput `type:"list" json:",omitempty"`

	BlackIpEnable *int32 `type:"int32" json:",omitempty"`

	BlackLctEnable *int32 `type:"int32" json:",omitempty"`

	BotDytokenEnable *int32 `type:"int32" json:",omitempty"`

	BotFrequencyEnable *int32 `type:"int32" json:",omitempty"`

	BotRepeatEnable *int32 `type:"int32" json:",omitempty"`

	BotSequenceDefaultAction *int32 `type:"int32" json:",omitempty"`

	BotSequenceEnable *int32 `type:"int32" json:",omitempty"`

	CcEnable *int32 `type:"int32" json:",omitempty"`

	CertificateID *int32 `type:"int32" json:",omitempty"`

	CertificateName *string `type:"string" json:",omitempty"`

	CertificatePlatform *string `type:"string" json:",omitempty"`

	ClbInstanceIDs *string `type:"string" json:",omitempty"`

	ClbListenerId *string `type:"string" json:",omitempty"`

	ClbPoolId *string `type:"string" json:",omitempty"`

	ClbServerId *string `type:"string" json:",omitempty"`

	ClientIPLocation *string `type:"string" json:",omitempty"`

	ClientMaxBodySize *int32 `type:"int32" json:",omitempty"`

	CloudAccessConfig []*CloudAccessConfigForListDomainOutput `type:"list" json:",omitempty"`

	Cname *string `type:"string" json:",omitempty"`

	CustomBotEnable *int32 `type:"int32" json:",omitempty"`

	CustomHeader []*string `type:"list" json:",omitempty"`

	CustomRspEnable *int32 `type:"int32" json:",omitempty"`

	DefenceMode *int32 `type:"int32" json:",omitempty"`

	DlpEnable *int32 `type:"int32" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	EnableHTTP2 *int32 `type:"int32" json:",omitempty"`

	EnableIPv6 *int32 `type:"int32" json:",omitempty"`

	KeepAliveRequest *int32 `type:"int32" json:",omitempty"`

	KeepAliveTimeOut *int32 `type:"int32" json:",omitempty"`

	LBAlgorithm *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	ProtocolFollow *int32 `type:"int32" json:",omitempty"`

	ProtocolPorts *ProtocolPortsForListDomainOutput `type:"structure" json:",omitempty"`

	Protocols *string `type:"string" json:",omitempty"`

	ProxyConfig *int32 `type:"int32" json:",omitempty"`

	ProxyConnectTimeOut *int32 `type:"int32" json:",omitempty"`

	ProxyKeepAlive *int32 `type:"int32" json:",omitempty"`

	ProxyKeepAliveTimeOut *int32 `type:"int32" json:",omitempty"`

	ProxyReadTimeOut *int32 `type:"int32" json:",omitempty"`

	ProxyRetry *int32 `type:"int32" json:",omitempty"`

	ProxyWriteTimeOut *int32 `type:"int32" json:",omitempty"`

	PublicRealServer *int32 `type:"int32" json:",omitempty"`

	RedirectHTTPS *bool `type:"boolean" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	RspAbnormalEnable *int32 `type:"int32" json:",omitempty"`

	SSLCiphers []*string `type:"list" json:",omitempty"`

	SSLProtocols []*string `type:"list" json:",omitempty"`

	ServerIps *string `type:"string" json:",omitempty"`

	SrcIps *string `type:"string" json:",omitempty"`

	SrcProtocol *string `type:"string" json:",omitempty"`

	Status *int32 `type:"int32" json:",omitempty"`

	SystemBotEnable *int32 `type:"int32" json:",omitempty"`

	TCPListenerConfig []*TCPListenerConfigForListDomainOutput `type:"list" json:",omitempty"`

	TLSEnable *int32 `type:"int32" json:",omitempty"`

	TamperProofEnable *int32 `type:"int32" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	VolcCertificateID *string `type:"string" json:",omitempty"`

	VpcID *string `type:"string" json:",omitempty"`

	WafEnable *int32 `type:"int32" json:",omitempty"`

	WafWhiteReqEnable *int32 `type:"int32" json:",omitempty"`

	WhiteEnable *int32 `type:"int32" json:",omitempty"`

	WhiteFieldEnable *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DataForListDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForListDomainOutput) GoString() string {
	return s.String()
}

// SetAccessMode sets the AccessMode field's value.
func (s *DataForListDomainOutput) SetAccessMode(v int32) *DataForListDomainOutput {
	s.AccessMode = &v
	return s
}

// SetAdvancedDefenseIP sets the AdvancedDefenseIP field's value.
func (s *DataForListDomainOutput) SetAdvancedDefenseIP(v string) *DataForListDomainOutput {
	s.AdvancedDefenseIP = &v
	return s
}

// SetAdvancedDefenseIPv6 sets the AdvancedDefenseIPv6 field's value.
func (s *DataForListDomainOutput) SetAdvancedDefenseIPv6(v string) *DataForListDomainOutput {
	s.AdvancedDefenseIPv6 = &v
	return s
}

// SetApiEnable sets the ApiEnable field's value.
func (s *DataForListDomainOutput) SetApiEnable(v int32) *DataForListDomainOutput {
	s.ApiEnable = &v
	return s
}

// SetAttackStatus sets the AttackStatus field's value.
func (s *DataForListDomainOutput) SetAttackStatus(v int32) *DataForListDomainOutput {
	s.AttackStatus = &v
	return s
}

// SetAutoCCEnable sets the AutoCCEnable field's value.
func (s *DataForListDomainOutput) SetAutoCCEnable(v int32) *DataForListDomainOutput {
	s.AutoCCEnable = &v
	return s
}

// SetAutomaticBlackEnable sets the AutomaticBlackEnable field's value.
func (s *DataForListDomainOutput) SetAutomaticBlackEnable(v int32) *DataForListDomainOutput {
	s.AutomaticBlackEnable = &v
	return s
}

// SetBackendGroups sets the BackendGroups field's value.
func (s *DataForListDomainOutput) SetBackendGroups(v []*BackendGroupForListDomainOutput) *DataForListDomainOutput {
	s.BackendGroups = v
	return s
}

// SetBlackIpEnable sets the BlackIpEnable field's value.
func (s *DataForListDomainOutput) SetBlackIpEnable(v int32) *DataForListDomainOutput {
	s.BlackIpEnable = &v
	return s
}

// SetBlackLctEnable sets the BlackLctEnable field's value.
func (s *DataForListDomainOutput) SetBlackLctEnable(v int32) *DataForListDomainOutput {
	s.BlackLctEnable = &v
	return s
}

// SetBotDytokenEnable sets the BotDytokenEnable field's value.
func (s *DataForListDomainOutput) SetBotDytokenEnable(v int32) *DataForListDomainOutput {
	s.BotDytokenEnable = &v
	return s
}

// SetBotFrequencyEnable sets the BotFrequencyEnable field's value.
func (s *DataForListDomainOutput) SetBotFrequencyEnable(v int32) *DataForListDomainOutput {
	s.BotFrequencyEnable = &v
	return s
}

// SetBotRepeatEnable sets the BotRepeatEnable field's value.
func (s *DataForListDomainOutput) SetBotRepeatEnable(v int32) *DataForListDomainOutput {
	s.BotRepeatEnable = &v
	return s
}

// SetBotSequenceDefaultAction sets the BotSequenceDefaultAction field's value.
func (s *DataForListDomainOutput) SetBotSequenceDefaultAction(v int32) *DataForListDomainOutput {
	s.BotSequenceDefaultAction = &v
	return s
}

// SetBotSequenceEnable sets the BotSequenceEnable field's value.
func (s *DataForListDomainOutput) SetBotSequenceEnable(v int32) *DataForListDomainOutput {
	s.BotSequenceEnable = &v
	return s
}

// SetCcEnable sets the CcEnable field's value.
func (s *DataForListDomainOutput) SetCcEnable(v int32) *DataForListDomainOutput {
	s.CcEnable = &v
	return s
}

// SetCertificateID sets the CertificateID field's value.
func (s *DataForListDomainOutput) SetCertificateID(v int32) *DataForListDomainOutput {
	s.CertificateID = &v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *DataForListDomainOutput) SetCertificateName(v string) *DataForListDomainOutput {
	s.CertificateName = &v
	return s
}

// SetCertificatePlatform sets the CertificatePlatform field's value.
func (s *DataForListDomainOutput) SetCertificatePlatform(v string) *DataForListDomainOutput {
	s.CertificatePlatform = &v
	return s
}

// SetClbInstanceIDs sets the ClbInstanceIDs field's value.
func (s *DataForListDomainOutput) SetClbInstanceIDs(v string) *DataForListDomainOutput {
	s.ClbInstanceIDs = &v
	return s
}

// SetClbListenerId sets the ClbListenerId field's value.
func (s *DataForListDomainOutput) SetClbListenerId(v string) *DataForListDomainOutput {
	s.ClbListenerId = &v
	return s
}

// SetClbPoolId sets the ClbPoolId field's value.
func (s *DataForListDomainOutput) SetClbPoolId(v string) *DataForListDomainOutput {
	s.ClbPoolId = &v
	return s
}

// SetClbServerId sets the ClbServerId field's value.
func (s *DataForListDomainOutput) SetClbServerId(v string) *DataForListDomainOutput {
	s.ClbServerId = &v
	return s
}

// SetClientIPLocation sets the ClientIPLocation field's value.
func (s *DataForListDomainOutput) SetClientIPLocation(v string) *DataForListDomainOutput {
	s.ClientIPLocation = &v
	return s
}

// SetClientMaxBodySize sets the ClientMaxBodySize field's value.
func (s *DataForListDomainOutput) SetClientMaxBodySize(v int32) *DataForListDomainOutput {
	s.ClientMaxBodySize = &v
	return s
}

// SetCloudAccessConfig sets the CloudAccessConfig field's value.
func (s *DataForListDomainOutput) SetCloudAccessConfig(v []*CloudAccessConfigForListDomainOutput) *DataForListDomainOutput {
	s.CloudAccessConfig = v
	return s
}

// SetCname sets the Cname field's value.
func (s *DataForListDomainOutput) SetCname(v string) *DataForListDomainOutput {
	s.Cname = &v
	return s
}

// SetCustomBotEnable sets the CustomBotEnable field's value.
func (s *DataForListDomainOutput) SetCustomBotEnable(v int32) *DataForListDomainOutput {
	s.CustomBotEnable = &v
	return s
}

// SetCustomHeader sets the CustomHeader field's value.
func (s *DataForListDomainOutput) SetCustomHeader(v []*string) *DataForListDomainOutput {
	s.CustomHeader = v
	return s
}

// SetCustomRspEnable sets the CustomRspEnable field's value.
func (s *DataForListDomainOutput) SetCustomRspEnable(v int32) *DataForListDomainOutput {
	s.CustomRspEnable = &v
	return s
}

// SetDefenceMode sets the DefenceMode field's value.
func (s *DataForListDomainOutput) SetDefenceMode(v int32) *DataForListDomainOutput {
	s.DefenceMode = &v
	return s
}

// SetDlpEnable sets the DlpEnable field's value.
func (s *DataForListDomainOutput) SetDlpEnable(v int32) *DataForListDomainOutput {
	s.DlpEnable = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DataForListDomainOutput) SetDomain(v string) *DataForListDomainOutput {
	s.Domain = &v
	return s
}

// SetEnableHTTP2 sets the EnableHTTP2 field's value.
func (s *DataForListDomainOutput) SetEnableHTTP2(v int32) *DataForListDomainOutput {
	s.EnableHTTP2 = &v
	return s
}

// SetEnableIPv6 sets the EnableIPv6 field's value.
func (s *DataForListDomainOutput) SetEnableIPv6(v int32) *DataForListDomainOutput {
	s.EnableIPv6 = &v
	return s
}

// SetKeepAliveRequest sets the KeepAliveRequest field's value.
func (s *DataForListDomainOutput) SetKeepAliveRequest(v int32) *DataForListDomainOutput {
	s.KeepAliveRequest = &v
	return s
}

// SetKeepAliveTimeOut sets the KeepAliveTimeOut field's value.
func (s *DataForListDomainOutput) SetKeepAliveTimeOut(v int32) *DataForListDomainOutput {
	s.KeepAliveTimeOut = &v
	return s
}

// SetLBAlgorithm sets the LBAlgorithm field's value.
func (s *DataForListDomainOutput) SetLBAlgorithm(v string) *DataForListDomainOutput {
	s.LBAlgorithm = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DataForListDomainOutput) SetPort(v int32) *DataForListDomainOutput {
	s.Port = &v
	return s
}

// SetProtocolFollow sets the ProtocolFollow field's value.
func (s *DataForListDomainOutput) SetProtocolFollow(v int32) *DataForListDomainOutput {
	s.ProtocolFollow = &v
	return s
}

// SetProtocolPorts sets the ProtocolPorts field's value.
func (s *DataForListDomainOutput) SetProtocolPorts(v *ProtocolPortsForListDomainOutput) *DataForListDomainOutput {
	s.ProtocolPorts = v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *DataForListDomainOutput) SetProtocols(v string) *DataForListDomainOutput {
	s.Protocols = &v
	return s
}

// SetProxyConfig sets the ProxyConfig field's value.
func (s *DataForListDomainOutput) SetProxyConfig(v int32) *DataForListDomainOutput {
	s.ProxyConfig = &v
	return s
}

// SetProxyConnectTimeOut sets the ProxyConnectTimeOut field's value.
func (s *DataForListDomainOutput) SetProxyConnectTimeOut(v int32) *DataForListDomainOutput {
	s.ProxyConnectTimeOut = &v
	return s
}

// SetProxyKeepAlive sets the ProxyKeepAlive field's value.
func (s *DataForListDomainOutput) SetProxyKeepAlive(v int32) *DataForListDomainOutput {
	s.ProxyKeepAlive = &v
	return s
}

// SetProxyKeepAliveTimeOut sets the ProxyKeepAliveTimeOut field's value.
func (s *DataForListDomainOutput) SetProxyKeepAliveTimeOut(v int32) *DataForListDomainOutput {
	s.ProxyKeepAliveTimeOut = &v
	return s
}

// SetProxyReadTimeOut sets the ProxyReadTimeOut field's value.
func (s *DataForListDomainOutput) SetProxyReadTimeOut(v int32) *DataForListDomainOutput {
	s.ProxyReadTimeOut = &v
	return s
}

// SetProxyRetry sets the ProxyRetry field's value.
func (s *DataForListDomainOutput) SetProxyRetry(v int32) *DataForListDomainOutput {
	s.ProxyRetry = &v
	return s
}

// SetProxyWriteTimeOut sets the ProxyWriteTimeOut field's value.
func (s *DataForListDomainOutput) SetProxyWriteTimeOut(v int32) *DataForListDomainOutput {
	s.ProxyWriteTimeOut = &v
	return s
}

// SetPublicRealServer sets the PublicRealServer field's value.
func (s *DataForListDomainOutput) SetPublicRealServer(v int32) *DataForListDomainOutput {
	s.PublicRealServer = &v
	return s
}

// SetRedirectHTTPS sets the RedirectHTTPS field's value.
func (s *DataForListDomainOutput) SetRedirectHTTPS(v bool) *DataForListDomainOutput {
	s.RedirectHTTPS = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DataForListDomainOutput) SetRegion(v string) *DataForListDomainOutput {
	s.Region = &v
	return s
}

// SetRspAbnormalEnable sets the RspAbnormalEnable field's value.
func (s *DataForListDomainOutput) SetRspAbnormalEnable(v int32) *DataForListDomainOutput {
	s.RspAbnormalEnable = &v
	return s
}

// SetSSLCiphers sets the SSLCiphers field's value.
func (s *DataForListDomainOutput) SetSSLCiphers(v []*string) *DataForListDomainOutput {
	s.SSLCiphers = v
	return s
}

// SetSSLProtocols sets the SSLProtocols field's value.
func (s *DataForListDomainOutput) SetSSLProtocols(v []*string) *DataForListDomainOutput {
	s.SSLProtocols = v
	return s
}

// SetServerIps sets the ServerIps field's value.
func (s *DataForListDomainOutput) SetServerIps(v string) *DataForListDomainOutput {
	s.ServerIps = &v
	return s
}

// SetSrcIps sets the SrcIps field's value.
func (s *DataForListDomainOutput) SetSrcIps(v string) *DataForListDomainOutput {
	s.SrcIps = &v
	return s
}

// SetSrcProtocol sets the SrcProtocol field's value.
func (s *DataForListDomainOutput) SetSrcProtocol(v string) *DataForListDomainOutput {
	s.SrcProtocol = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataForListDomainOutput) SetStatus(v int32) *DataForListDomainOutput {
	s.Status = &v
	return s
}

// SetSystemBotEnable sets the SystemBotEnable field's value.
func (s *DataForListDomainOutput) SetSystemBotEnable(v int32) *DataForListDomainOutput {
	s.SystemBotEnable = &v
	return s
}

// SetTCPListenerConfig sets the TCPListenerConfig field's value.
func (s *DataForListDomainOutput) SetTCPListenerConfig(v []*TCPListenerConfigForListDomainOutput) *DataForListDomainOutput {
	s.TCPListenerConfig = v
	return s
}

// SetTLSEnable sets the TLSEnable field's value.
func (s *DataForListDomainOutput) SetTLSEnable(v int32) *DataForListDomainOutput {
	s.TLSEnable = &v
	return s
}

// SetTamperProofEnable sets the TamperProofEnable field's value.
func (s *DataForListDomainOutput) SetTamperProofEnable(v int32) *DataForListDomainOutput {
	s.TamperProofEnable = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DataForListDomainOutput) SetUpdateTime(v string) *DataForListDomainOutput {
	s.UpdateTime = &v
	return s
}

// SetVolcCertificateID sets the VolcCertificateID field's value.
func (s *DataForListDomainOutput) SetVolcCertificateID(v string) *DataForListDomainOutput {
	s.VolcCertificateID = &v
	return s
}

// SetVpcID sets the VpcID field's value.
func (s *DataForListDomainOutput) SetVpcID(v string) *DataForListDomainOutput {
	s.VpcID = &v
	return s
}

// SetWafEnable sets the WafEnable field's value.
func (s *DataForListDomainOutput) SetWafEnable(v int32) *DataForListDomainOutput {
	s.WafEnable = &v
	return s
}

// SetWafWhiteReqEnable sets the WafWhiteReqEnable field's value.
func (s *DataForListDomainOutput) SetWafWhiteReqEnable(v int32) *DataForListDomainOutput {
	s.WafWhiteReqEnable = &v
	return s
}

// SetWhiteEnable sets the WhiteEnable field's value.
func (s *DataForListDomainOutput) SetWhiteEnable(v int32) *DataForListDomainOutput {
	s.WhiteEnable = &v
	return s
}

// SetWhiteFieldEnable sets the WhiteFieldEnable field's value.
func (s *DataForListDomainOutput) SetWhiteFieldEnable(v int32) *DataForListDomainOutput {
	s.WhiteFieldEnable = &v
	return s
}

type LBInfoForListDomainInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessMode *int32 `type:"int32" json:",omitempty"`

	LBInstanceID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LBInfoForListDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LBInfoForListDomainInput) GoString() string {
	return s.String()
}

// SetAccessMode sets the AccessMode field's value.
func (s *LBInfoForListDomainInput) SetAccessMode(v int32) *LBInfoForListDomainInput {
	s.AccessMode = &v
	return s
}

// SetLBInstanceID sets the LBInstanceID field's value.
func (s *LBInfoForListDomainInput) SetLBInstanceID(v string) *LBInfoForListDomainInput {
	s.LBInstanceID = &v
	return s
}

type ListDomainInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessMode []*int32 `type:"list" json:",omitempty"`

	AccurateQuery *int32 `type:"int32" json:",omitempty"`

	AttackStatus []*int32 `type:"list" json:",omitempty"`

	ClientIp *string `type:"string" json:",omitempty"`

	DefenceMode []*int32 `type:"list" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	DomainOrPath *string `type:"string" json:",omitempty"`

	LBInfo []*LBInfoForListDomainInput `type:"list" json:",omitempty"`

	// Page is a required field
	Page *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`

	PublicRealServer []*int32 `type:"list" json:",omitempty"`

	// Region is a required field
	Region *string `type:"string" json:",omitempty" required:"true"`

	SortByCreateTime *string `type:"string" json:",omitempty"`

	SortByDomainName *string `type:"string" json:",omitempty"`

	SortByUpdateTime *string `type:"string" json:",omitempty"`

	Status []*int32 `type:"list" json:",omitempty"`

	TLSEnable []*int32 `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	VpcName *string `type:"string" json:",omitempty"`

	VpcOwnerId *string `type:"string" json:",omitempty"`

	VpcOwnerName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainInput"}
	if s.Page == nil {
		invalidParams.Add(request.NewErrParamRequired("Page"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessMode sets the AccessMode field's value.
func (s *ListDomainInput) SetAccessMode(v []*int32) *ListDomainInput {
	s.AccessMode = v
	return s
}

// SetAccurateQuery sets the AccurateQuery field's value.
func (s *ListDomainInput) SetAccurateQuery(v int32) *ListDomainInput {
	s.AccurateQuery = &v
	return s
}

// SetAttackStatus sets the AttackStatus field's value.
func (s *ListDomainInput) SetAttackStatus(v []*int32) *ListDomainInput {
	s.AttackStatus = v
	return s
}

// SetClientIp sets the ClientIp field's value.
func (s *ListDomainInput) SetClientIp(v string) *ListDomainInput {
	s.ClientIp = &v
	return s
}

// SetDefenceMode sets the DefenceMode field's value.
func (s *ListDomainInput) SetDefenceMode(v []*int32) *ListDomainInput {
	s.DefenceMode = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *ListDomainInput) SetDomain(v string) *ListDomainInput {
	s.Domain = &v
	return s
}

// SetDomainOrPath sets the DomainOrPath field's value.
func (s *ListDomainInput) SetDomainOrPath(v string) *ListDomainInput {
	s.DomainOrPath = &v
	return s
}

// SetLBInfo sets the LBInfo field's value.
func (s *ListDomainInput) SetLBInfo(v []*LBInfoForListDomainInput) *ListDomainInput {
	s.LBInfo = v
	return s
}

// SetPage sets the Page field's value.
func (s *ListDomainInput) SetPage(v int32) *ListDomainInput {
	s.Page = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDomainInput) SetPageSize(v int32) *ListDomainInput {
	s.PageSize = &v
	return s
}

// SetPublicRealServer sets the PublicRealServer field's value.
func (s *ListDomainInput) SetPublicRealServer(v []*int32) *ListDomainInput {
	s.PublicRealServer = v
	return s
}

// SetRegion sets the Region field's value.
func (s *ListDomainInput) SetRegion(v string) *ListDomainInput {
	s.Region = &v
	return s
}

// SetSortByCreateTime sets the SortByCreateTime field's value.
func (s *ListDomainInput) SetSortByCreateTime(v string) *ListDomainInput {
	s.SortByCreateTime = &v
	return s
}

// SetSortByDomainName sets the SortByDomainName field's value.
func (s *ListDomainInput) SetSortByDomainName(v string) *ListDomainInput {
	s.SortByDomainName = &v
	return s
}

// SetSortByUpdateTime sets the SortByUpdateTime field's value.
func (s *ListDomainInput) SetSortByUpdateTime(v string) *ListDomainInput {
	s.SortByUpdateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListDomainInput) SetStatus(v []*int32) *ListDomainInput {
	s.Status = v
	return s
}

// SetTLSEnable sets the TLSEnable field's value.
func (s *ListDomainInput) SetTLSEnable(v []*int32) *ListDomainInput {
	s.TLSEnable = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ListDomainInput) SetVpcId(v string) *ListDomainInput {
	s.VpcId = &v
	return s
}

// SetVpcName sets the VpcName field's value.
func (s *ListDomainInput) SetVpcName(v string) *ListDomainInput {
	s.VpcName = &v
	return s
}

// SetVpcOwnerId sets the VpcOwnerId field's value.
func (s *ListDomainInput) SetVpcOwnerId(v string) *ListDomainInput {
	s.VpcOwnerId = &v
	return s
}

// SetVpcOwnerName sets the VpcOwnerName field's value.
func (s *ListDomainInput) SetVpcOwnerName(v string) *ListDomainInput {
	s.VpcOwnerName = &v
	return s
}

type ListDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Count *int32 `type:"int32" json:",omitempty"`

	CurrentPage *int32 `type:"int32" json:",omitempty"`

	Data []*DataForListDomainOutput `type:"list" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ListDomainOutput) SetCount(v int32) *ListDomainOutput {
	s.Count = &v
	return s
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *ListDomainOutput) SetCurrentPage(v int32) *ListDomainOutput {
	s.CurrentPage = &v
	return s
}

// SetData sets the Data field's value.
func (s *ListDomainOutput) SetData(v []*DataForListDomainOutput) *ListDomainOutput {
	s.Data = v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDomainOutput) SetPageSize(v int32) *ListDomainOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListDomainOutput) SetTotalCount(v int32) *ListDomainOutput {
	s.TotalCount = &v
	return s
}

type ProtocolPortsForListDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HTTP []*int32 `type:"list" json:",omitempty"`

	HTTPS []*int32 `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ProtocolPortsForListDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ProtocolPortsForListDomainOutput) GoString() string {
	return s.String()
}

// SetHTTP sets the HTTP field's value.
func (s *ProtocolPortsForListDomainOutput) SetHTTP(v []*int32) *ProtocolPortsForListDomainOutput {
	s.HTTP = v
	return s
}

// SetHTTPS sets the HTTPS field's value.
func (s *ProtocolPortsForListDomainOutput) SetHTTPS(v []*int32) *ProtocolPortsForListDomainOutput {
	s.HTTPS = v
	return s
}

type TCPListenerConfigForListDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessProtocol *string `type:"string" json:",omitempty"`

	DefenceMode *int32 `type:"int32" json:",omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	ListenerID *string `type:"string" json:",omitempty"`

	LostAssociationFromALB *int32 `type:"int32" json:",omitempty"`

	Port *string `type:"string" json:",omitempty"`

	Protocol *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TCPListenerConfigForListDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TCPListenerConfigForListDomainOutput) GoString() string {
	return s.String()
}

// SetAccessProtocol sets the AccessProtocol field's value.
func (s *TCPListenerConfigForListDomainOutput) SetAccessProtocol(v string) *TCPListenerConfigForListDomainOutput {
	s.AccessProtocol = &v
	return s
}

// SetDefenceMode sets the DefenceMode field's value.
func (s *TCPListenerConfigForListDomainOutput) SetDefenceMode(v int32) *TCPListenerConfigForListDomainOutput {
	s.DefenceMode = &v
	return s
}

// SetInstanceID sets the InstanceID field's value.
func (s *TCPListenerConfigForListDomainOutput) SetInstanceID(v string) *TCPListenerConfigForListDomainOutput {
	s.InstanceID = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *TCPListenerConfigForListDomainOutput) SetInstanceName(v string) *TCPListenerConfigForListDomainOutput {
	s.InstanceName = &v
	return s
}

// SetListenerID sets the ListenerID field's value.
func (s *TCPListenerConfigForListDomainOutput) SetListenerID(v string) *TCPListenerConfigForListDomainOutput {
	s.ListenerID = &v
	return s
}

// SetLostAssociationFromALB sets the LostAssociationFromALB field's value.
func (s *TCPListenerConfigForListDomainOutput) SetLostAssociationFromALB(v int32) *TCPListenerConfigForListDomainOutput {
	s.LostAssociationFromALB = &v
	return s
}

// SetPort sets the Port field's value.
func (s *TCPListenerConfigForListDomainOutput) SetPort(v string) *TCPListenerConfigForListDomainOutput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *TCPListenerConfigForListDomainOutput) SetProtocol(v string) *TCPListenerConfigForListDomainOutput {
	s.Protocol = &v
	return s
}
