// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rocketmq

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeTopicQueueCommon = "DescribeTopicQueue"

// DescribeTopicQueueCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicQueueCommon operation. The "output" return
// value will be populated with the DescribeTopicQueueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicQueueCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicQueueCommon Send returns without error.
//
// See DescribeTopicQueueCommon for more information on using the DescribeTopicQueueCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicQueueCommonRequest method.
//    req, resp := client.DescribeTopicQueueCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeTopicQueueCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeTopicQueueCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicQueueCommon API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeTopicQueueCommon for usage and error information.
func (c *ROCKETMQ) DescribeTopicQueueCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicQueueCommonRequest(input)
	return out, req.Send()
}

// DescribeTopicQueueCommonWithContext is the same as DescribeTopicQueueCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicQueueCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeTopicQueueCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicQueueCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicQueue = "DescribeTopicQueue"

// DescribeTopicQueueRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicQueue operation. The "output" return
// value will be populated with the DescribeTopicQueueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicQueueCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicQueueCommon Send returns without error.
//
// See DescribeTopicQueue for more information on using the DescribeTopicQueue
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicQueueRequest method.
//    req, resp := client.DescribeTopicQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeTopicQueueRequest(input *DescribeTopicQueueInput) (req *request.Request, output *DescribeTopicQueueOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicQueueInput{}
	}

	output = &DescribeTopicQueueOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicQueue API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeTopicQueue for usage and error information.
func (c *ROCKETMQ) DescribeTopicQueue(input *DescribeTopicQueueInput) (*DescribeTopicQueueOutput, error) {
	req, out := c.DescribeTopicQueueRequest(input)
	return out, req.Send()
}

// DescribeTopicQueueWithContext is the same as DescribeTopicQueue with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeTopicQueueWithContext(ctx volcengine.Context, input *DescribeTopicQueueInput, opts ...request.Option) (*DescribeTopicQueueOutput, error) {
	req, out := c.DescribeTopicQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeTopicQueueInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`

	QueueIds []*string `type:"list" json:",omitempty"`

	// TopicName is a required field
	TopicName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeTopicQueueInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicQueueInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeTopicQueueInput) SetInstanceId(v string) *DescribeTopicQueueInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeTopicQueueInput) SetPageNumber(v int32) *DescribeTopicQueueInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeTopicQueueInput) SetPageSize(v int32) *DescribeTopicQueueInput {
	s.PageSize = &v
	return s
}

// SetQueueIds sets the QueueIds field's value.
func (s *DescribeTopicQueueInput) SetQueueIds(v []*string) *DescribeTopicQueueInput {
	s.QueueIds = v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *DescribeTopicQueueInput) SetTopicName(v string) *DescribeTopicQueueInput {
	s.TopicName = &v
	return s
}

type DescribeTopicQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	QueuesInfo []*QueuesInfoForDescribeTopicQueueOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeTopicQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicQueueOutput) GoString() string {
	return s.String()
}

// SetQueuesInfo sets the QueuesInfo field's value.
func (s *DescribeTopicQueueOutput) SetQueuesInfo(v []*QueuesInfoForDescribeTopicQueueOutput) *DescribeTopicQueueOutput {
	s.QueuesInfo = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeTopicQueueOutput) SetTotal(v int32) *DescribeTopicQueueOutput {
	s.Total = &v
	return s
}

type QueuesInfoForDescribeTopicQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EndOffset *int32 `type:"int32" json:",omitempty"`

	LastUpdateTimestamp *int64 `type:"int64" json:",omitempty"`

	MessageCount *int32 `type:"int32" json:",omitempty"`

	QueueId *string `type:"string" json:",omitempty"`

	StartOffset *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s QueuesInfoForDescribeTopicQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueuesInfoForDescribeTopicQueueOutput) GoString() string {
	return s.String()
}

// SetEndOffset sets the EndOffset field's value.
func (s *QueuesInfoForDescribeTopicQueueOutput) SetEndOffset(v int32) *QueuesInfoForDescribeTopicQueueOutput {
	s.EndOffset = &v
	return s
}

// SetLastUpdateTimestamp sets the LastUpdateTimestamp field's value.
func (s *QueuesInfoForDescribeTopicQueueOutput) SetLastUpdateTimestamp(v int64) *QueuesInfoForDescribeTopicQueueOutput {
	s.LastUpdateTimestamp = &v
	return s
}

// SetMessageCount sets the MessageCount field's value.
func (s *QueuesInfoForDescribeTopicQueueOutput) SetMessageCount(v int32) *QueuesInfoForDescribeTopicQueueOutput {
	s.MessageCount = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *QueuesInfoForDescribeTopicQueueOutput) SetQueueId(v string) *QueuesInfoForDescribeTopicQueueOutput {
	s.QueueId = &v
	return s
}

// SetStartOffset sets the StartOffset field's value.
func (s *QueuesInfoForDescribeTopicQueueOutput) SetStartOffset(v int32) *QueuesInfoForDescribeTopicQueueOutput {
	s.StartOffset = &v
	return s
}
