// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rocketmq

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateTopicCommon = "CreateTopic"

// CreateTopicCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateTopicCommon operation. The "output" return
// value will be populated with the CreateTopicCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateTopicCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateTopicCommon Send returns without error.
//
// See CreateTopicCommon for more information on using the CreateTopicCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateTopicCommonRequest method.
//    req, resp := client.CreateTopicCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) CreateTopicCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateTopicCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateTopicCommon API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation CreateTopicCommon for usage and error information.
func (c *ROCKETMQ) CreateTopicCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateTopicCommonRequest(input)
	return out, req.Send()
}

// CreateTopicCommonWithContext is the same as CreateTopicCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTopicCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) CreateTopicCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateTopicCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTopic = "CreateTopic"

// CreateTopicRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateTopic operation. The "output" return
// value will be populated with the CreateTopicCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateTopicCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateTopicCommon Send returns without error.
//
// See CreateTopic for more information on using the CreateTopic
// API call, and error handling.
//
//    // Example sending a request using the CreateTopicRequest method.
//    req, resp := client.CreateTopicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) CreateTopicRequest(input *CreateTopicInput) (req *request.Request, output *CreateTopicOutput) {
	op := &request.Operation{
		Name:       opCreateTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTopicInput{}
	}

	output = &CreateTopicOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateTopic API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation CreateTopic for usage and error information.
func (c *ROCKETMQ) CreateTopic(input *CreateTopicInput) (*CreateTopicOutput, error) {
	req, out := c.CreateTopicRequest(input)
	return out, req.Send()
}

// CreateTopicWithContext is the same as CreateTopic with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTopic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) CreateTopicWithContext(ctx volcengine.Context, input *CreateTopicInput, opts ...request.Option) (*CreateTopicOutput, error) {
	req, out := c.CreateTopicRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessPolicyForCreateTopicInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `min:"24" max:"24" type:"string" json:",omitempty"`

	Authority *string `min:"3" max:"4" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AccessPolicyForCreateTopicInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPolicyForCreateTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessPolicyForCreateTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessPolicyForCreateTopicInput"}
	if s.AccessKey != nil && len(*s.AccessKey) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("AccessKey", 24))
	}
	if s.AccessKey != nil && len(*s.AccessKey) > 24 {
		invalidParams.Add(request.NewErrParamMaxLen("AccessKey", 24, *s.AccessKey))
	}
	if s.Authority != nil && len(*s.Authority) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Authority", 3))
	}
	if s.Authority != nil && len(*s.Authority) > 4 {
		invalidParams.Add(request.NewErrParamMaxLen("Authority", 4, *s.Authority))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKey sets the AccessKey field's value.
func (s *AccessPolicyForCreateTopicInput) SetAccessKey(v string) *AccessPolicyForCreateTopicInput {
	s.AccessKey = &v
	return s
}

// SetAuthority sets the Authority field's value.
func (s *AccessPolicyForCreateTopicInput) SetAuthority(v string) *AccessPolicyForCreateTopicInput {
	s.Authority = &v
	return s
}

type CreateTopicInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessPolicies []*AccessPolicyForCreateTopicInput `type:"list" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// MessageType is a required field
	MessageType *int32 `max:"4" type:"int32" json:",omitempty" required:"true"`

	// QueueNumber is a required field
	QueueNumber *int32 `min:"1" max:"120" type:"int32" json:",omitempty" required:"true"`

	// TopicName is a required field
	TopicName *string `max:"128" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateTopicInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTopicInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.MessageType == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageType"))
	}
	if s.MessageType != nil && *s.MessageType > 4 {
		invalidParams.Add(request.NewErrParamMaxValue("MessageType", 4))
	}
	if s.QueueNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueNumber"))
	}
	if s.QueueNumber != nil && *s.QueueNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("QueueNumber", 1))
	}
	if s.QueueNumber != nil && *s.QueueNumber > 120 {
		invalidParams.Add(request.NewErrParamMaxValue("QueueNumber", 120))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}
	if s.TopicName != nil && len(*s.TopicName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("TopicName", 128, *s.TopicName))
	}
	if s.AccessPolicies != nil {
		for i, v := range s.AccessPolicies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessPolicies", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *CreateTopicInput) SetAccessPolicies(v []*AccessPolicyForCreateTopicInput) *CreateTopicInput {
	s.AccessPolicies = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTopicInput) SetDescription(v string) *CreateTopicInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateTopicInput) SetInstanceId(v string) *CreateTopicInput {
	s.InstanceId = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *CreateTopicInput) SetMessageType(v int32) *CreateTopicInput {
	s.MessageType = &v
	return s
}

// SetQueueNumber sets the QueueNumber field's value.
func (s *CreateTopicInput) SetQueueNumber(v int32) *CreateTopicInput {
	s.QueueNumber = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *CreateTopicInput) SetTopicName(v string) *CreateTopicInput {
	s.TopicName = &v
	return s
}

type CreateTopicOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s CreateTopicOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicOutput) GoString() string {
	return s.String()
}
