// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rdspostgresql

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeBackupsCommon = "DescribeBackups"

// DescribeBackupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeBackupsCommon operation. The "output" return
// value will be populated with the DescribeBackupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeBackupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeBackupsCommon Send returns without error.
//
// See DescribeBackupsCommon for more information on using the DescribeBackupsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeBackupsCommonRequest method.
//    req, resp := client.DescribeBackupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSPOSTGRESQL) DescribeBackupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeBackupsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeBackupsCommon API operation for RDS_POSTGRESQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_POSTGRESQL's
// API operation DescribeBackupsCommon for usage and error information.
func (c *RDSPOSTGRESQL) DescribeBackupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeBackupsCommonRequest(input)
	return out, req.Send()
}

// DescribeBackupsCommonWithContext is the same as DescribeBackupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSPOSTGRESQL) DescribeBackupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeBackupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackups = "DescribeBackups"

// DescribeBackupsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeBackups operation. The "output" return
// value will be populated with the DescribeBackupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeBackupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeBackupsCommon Send returns without error.
//
// See DescribeBackups for more information on using the DescribeBackups
// API call, and error handling.
//
//    // Example sending a request using the DescribeBackupsRequest method.
//    req, resp := client.DescribeBackupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSPOSTGRESQL) DescribeBackupsRequest(input *DescribeBackupsInput) (req *request.Request, output *DescribeBackupsOutput) {
	op := &request.Operation{
		Name:       opDescribeBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBackupsInput{}
	}

	output = &DescribeBackupsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeBackups API operation for RDS_POSTGRESQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_POSTGRESQL's
// API operation DescribeBackups for usage and error information.
func (c *RDSPOSTGRESQL) DescribeBackups(input *DescribeBackupsInput) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	return out, req.Send()
}

// DescribeBackupsWithContext is the same as DescribeBackups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSPOSTGRESQL) DescribeBackupsWithContext(ctx volcengine.Context, input *DescribeBackupsInput, opts ...request.Option) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BackupForDescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	BackupEndTime *string `type:"string"`

	BackupFileName *string `type:"string"`

	BackupFileSize *int64 `type:"int64"`

	BackupId *string `type:"string"`

	BackupProgress *int32 `max:"100" type:"int32"`

	BackupStartTime *string `type:"string"`

	BackupStatus *string `type:"string" enum:"EnumOfBackupStatusForDescribeBackupsOutput"`

	BackupType *string `type:"string" enum:"EnumOfBackupTypeForDescribeBackupsOutput"`

	CreateType *string `type:"string" enum:"EnumOfCreateTypeForDescribeBackupsOutput"`

	InstanceInfo *InstanceInfoForDescribeBackupsOutput `type:"structure"`
}

// String returns the string representation
func (s BackupForDescribeBackupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupForDescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetBackupEndTime sets the BackupEndTime field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupEndTime(v string) *BackupForDescribeBackupsOutput {
	s.BackupEndTime = &v
	return s
}

// SetBackupFileName sets the BackupFileName field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupFileName(v string) *BackupForDescribeBackupsOutput {
	s.BackupFileName = &v
	return s
}

// SetBackupFileSize sets the BackupFileSize field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupFileSize(v int64) *BackupForDescribeBackupsOutput {
	s.BackupFileSize = &v
	return s
}

// SetBackupId sets the BackupId field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupId(v string) *BackupForDescribeBackupsOutput {
	s.BackupId = &v
	return s
}

// SetBackupProgress sets the BackupProgress field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupProgress(v int32) *BackupForDescribeBackupsOutput {
	s.BackupProgress = &v
	return s
}

// SetBackupStartTime sets the BackupStartTime field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupStartTime(v string) *BackupForDescribeBackupsOutput {
	s.BackupStartTime = &v
	return s
}

// SetBackupStatus sets the BackupStatus field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupStatus(v string) *BackupForDescribeBackupsOutput {
	s.BackupStatus = &v
	return s
}

// SetBackupType sets the BackupType field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupType(v string) *BackupForDescribeBackupsOutput {
	s.BackupType = &v
	return s
}

// SetCreateType sets the CreateType field's value.
func (s *BackupForDescribeBackupsOutput) SetCreateType(v string) *BackupForDescribeBackupsOutput {
	s.CreateType = &v
	return s
}

// SetInstanceInfo sets the InstanceInfo field's value.
func (s *BackupForDescribeBackupsOutput) SetInstanceInfo(v *InstanceInfoForDescribeBackupsOutput) *BackupForDescribeBackupsOutput {
	s.InstanceInfo = v
	return s
}

type ChargeDetailForDescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	AutoRenew *bool `type:"boolean"`

	ChargeEndTime *string `type:"string"`

	ChargeStartTime *string `type:"string"`

	ChargeStatus *string `type:"string" enum:"EnumOfChargeStatusForDescribeBackupsOutput"`

	ChargeType *string `type:"string" enum:"EnumOfChargeTypeForDescribeBackupsOutput"`

	Number *int32 `type:"int32"`

	OverdueReclaimTime *string `type:"string"`

	OverdueTime *string `type:"string"`

	Period *int32 `type:"int32"`

	PeriodUnit *string `type:"string" enum:"EnumOfPeriodUnitForDescribeBackupsOutput"`

	TempModifyEndTime *string `type:"string"`

	TempModifyStartTime *string `type:"string"`
}

// String returns the string representation
func (s ChargeDetailForDescribeBackupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ChargeDetailForDescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetAutoRenew(v bool) *ChargeDetailForDescribeBackupsOutput {
	s.AutoRenew = &v
	return s
}

// SetChargeEndTime sets the ChargeEndTime field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetChargeEndTime(v string) *ChargeDetailForDescribeBackupsOutput {
	s.ChargeEndTime = &v
	return s
}

// SetChargeStartTime sets the ChargeStartTime field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetChargeStartTime(v string) *ChargeDetailForDescribeBackupsOutput {
	s.ChargeStartTime = &v
	return s
}

// SetChargeStatus sets the ChargeStatus field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetChargeStatus(v string) *ChargeDetailForDescribeBackupsOutput {
	s.ChargeStatus = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetChargeType(v string) *ChargeDetailForDescribeBackupsOutput {
	s.ChargeType = &v
	return s
}

// SetNumber sets the Number field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetNumber(v int32) *ChargeDetailForDescribeBackupsOutput {
	s.Number = &v
	return s
}

// SetOverdueReclaimTime sets the OverdueReclaimTime field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetOverdueReclaimTime(v string) *ChargeDetailForDescribeBackupsOutput {
	s.OverdueReclaimTime = &v
	return s
}

// SetOverdueTime sets the OverdueTime field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetOverdueTime(v string) *ChargeDetailForDescribeBackupsOutput {
	s.OverdueTime = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetPeriod(v int32) *ChargeDetailForDescribeBackupsOutput {
	s.Period = &v
	return s
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetPeriodUnit(v string) *ChargeDetailForDescribeBackupsOutput {
	s.PeriodUnit = &v
	return s
}

// SetTempModifyEndTime sets the TempModifyEndTime field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetTempModifyEndTime(v string) *ChargeDetailForDescribeBackupsOutput {
	s.TempModifyEndTime = &v
	return s
}

// SetTempModifyStartTime sets the TempModifyStartTime field's value.
func (s *ChargeDetailForDescribeBackupsOutput) SetTempModifyStartTime(v string) *ChargeDetailForDescribeBackupsOutput {
	s.TempModifyStartTime = &v
	return s
}

type DescribeBackupsInput struct {
	_ struct{} `type:"structure"`

	BackupEndTime *string `type:"string"`

	BackupId *string `type:"string"`

	BackupStartTime *string `type:"string"`

	BackupStatus *string `type:"string"`

	BackupType *string `type:"string" enum:"EnumOfBackupTypeForDescribeBackupsInput"`

	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`
}

// String returns the string representation
func (s DescribeBackupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupEndTime sets the BackupEndTime field's value.
func (s *DescribeBackupsInput) SetBackupEndTime(v string) *DescribeBackupsInput {
	s.BackupEndTime = &v
	return s
}

// SetBackupId sets the BackupId field's value.
func (s *DescribeBackupsInput) SetBackupId(v string) *DescribeBackupsInput {
	s.BackupId = &v
	return s
}

// SetBackupStartTime sets the BackupStartTime field's value.
func (s *DescribeBackupsInput) SetBackupStartTime(v string) *DescribeBackupsInput {
	s.BackupStartTime = &v
	return s
}

// SetBackupStatus sets the BackupStatus field's value.
func (s *DescribeBackupsInput) SetBackupStatus(v string) *DescribeBackupsInput {
	s.BackupStatus = &v
	return s
}

// SetBackupType sets the BackupType field's value.
func (s *DescribeBackupsInput) SetBackupType(v string) *DescribeBackupsInput {
	s.BackupType = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeBackupsInput) SetInstanceId(v string) *DescribeBackupsInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeBackupsInput) SetPageNumber(v int32) *DescribeBackupsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeBackupsInput) SetPageSize(v int32) *DescribeBackupsInput {
	s.PageSize = &v
	return s
}

type DescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	Backups []*BackupForDescribeBackupsOutput `type:"list"`

	Total *int32 `type:"int32"`
}

// String returns the string representation
func (s DescribeBackupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetBackups sets the Backups field's value.
func (s *DescribeBackupsOutput) SetBackups(v []*BackupForDescribeBackupsOutput) *DescribeBackupsOutput {
	s.Backups = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeBackupsOutput) SetTotal(v int32) *DescribeBackupsOutput {
	s.Total = &v
	return s
}

type InstanceInfoForDescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	ChargeDetail *ChargeDetailForDescribeBackupsOutput `type:"structure"`

	DBEngineVersion *string `type:"string" enum:"EnumOfDBEngineVersionForDescribeBackupsOutput"`

	InstanceId *string `type:"string"`

	InstanceName *string `type:"string"`

	InstanceStatus *string `type:"string" enum:"EnumOfInstanceStatusForDescribeBackupsOutput"`

	InstanceType *string `type:"string" enum:"EnumOfInstanceTypeForDescribeBackupsOutput"`

	Memory *int32 `type:"int32"`

	Nodes []*NodeForDescribeBackupsOutput `type:"list"`

	ProjectName *string `type:"string"`

	StorageSpace *float64 `type:"double"`

	StorageType *string `type:"string" enum:"EnumOfStorageTypeForDescribeBackupsOutput"`

	SubnetId *string `type:"string"`

	VCPU *int32 `type:"int32"`

	VpcId *string `type:"string"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s InstanceInfoForDescribeBackupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInfoForDescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetChargeDetail sets the ChargeDetail field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetChargeDetail(v *ChargeDetailForDescribeBackupsOutput) *InstanceInfoForDescribeBackupsOutput {
	s.ChargeDetail = v
	return s
}

// SetDBEngineVersion sets the DBEngineVersion field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetDBEngineVersion(v string) *InstanceInfoForDescribeBackupsOutput {
	s.DBEngineVersion = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetInstanceId(v string) *InstanceInfoForDescribeBackupsOutput {
	s.InstanceId = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetInstanceName(v string) *InstanceInfoForDescribeBackupsOutput {
	s.InstanceName = &v
	return s
}

// SetInstanceStatus sets the InstanceStatus field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetInstanceStatus(v string) *InstanceInfoForDescribeBackupsOutput {
	s.InstanceStatus = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetInstanceType(v string) *InstanceInfoForDescribeBackupsOutput {
	s.InstanceType = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetMemory(v int32) *InstanceInfoForDescribeBackupsOutput {
	s.Memory = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetNodes(v []*NodeForDescribeBackupsOutput) *InstanceInfoForDescribeBackupsOutput {
	s.Nodes = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetProjectName(v string) *InstanceInfoForDescribeBackupsOutput {
	s.ProjectName = &v
	return s
}

// SetStorageSpace sets the StorageSpace field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetStorageSpace(v float64) *InstanceInfoForDescribeBackupsOutput {
	s.StorageSpace = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetStorageType(v string) *InstanceInfoForDescribeBackupsOutput {
	s.StorageType = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetSubnetId(v string) *InstanceInfoForDescribeBackupsOutput {
	s.SubnetId = &v
	return s
}

// SetVCPU sets the VCPU field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetVCPU(v int32) *InstanceInfoForDescribeBackupsOutput {
	s.VCPU = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetVpcId(v string) *InstanceInfoForDescribeBackupsOutput {
	s.VpcId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *InstanceInfoForDescribeBackupsOutput) SetZoneId(v string) *InstanceInfoForDescribeBackupsOutput {
	s.ZoneId = &v
	return s
}

type NodeForDescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	CreateTime *string `type:"string"`

	InstanceId *string `type:"string"`

	Memory *int32 `type:"int32"`

	NodeId *string `type:"string"`

	NodeSpec *string `type:"string"`

	NodeStatus *string `type:"string" enum:"EnumOfNodeStatusForDescribeBackupsOutput"`

	NodeType *string `type:"string" enum:"EnumOfNodeTypeForDescribeBackupsOutput"`

	RegionId *string `type:"string"`

	UpdateTime *string `type:"string"`

	VCPU *int32 `type:"int32"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s NodeForDescribeBackupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeForDescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *NodeForDescribeBackupsOutput) SetCreateTime(v string) *NodeForDescribeBackupsOutput {
	s.CreateTime = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *NodeForDescribeBackupsOutput) SetInstanceId(v string) *NodeForDescribeBackupsOutput {
	s.InstanceId = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *NodeForDescribeBackupsOutput) SetMemory(v int32) *NodeForDescribeBackupsOutput {
	s.Memory = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *NodeForDescribeBackupsOutput) SetNodeId(v string) *NodeForDescribeBackupsOutput {
	s.NodeId = &v
	return s
}

// SetNodeSpec sets the NodeSpec field's value.
func (s *NodeForDescribeBackupsOutput) SetNodeSpec(v string) *NodeForDescribeBackupsOutput {
	s.NodeSpec = &v
	return s
}

// SetNodeStatus sets the NodeStatus field's value.
func (s *NodeForDescribeBackupsOutput) SetNodeStatus(v string) *NodeForDescribeBackupsOutput {
	s.NodeStatus = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *NodeForDescribeBackupsOutput) SetNodeType(v string) *NodeForDescribeBackupsOutput {
	s.NodeType = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *NodeForDescribeBackupsOutput) SetRegionId(v string) *NodeForDescribeBackupsOutput {
	s.RegionId = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *NodeForDescribeBackupsOutput) SetUpdateTime(v string) *NodeForDescribeBackupsOutput {
	s.UpdateTime = &v
	return s
}

// SetVCPU sets the VCPU field's value.
func (s *NodeForDescribeBackupsOutput) SetVCPU(v int32) *NodeForDescribeBackupsOutput {
	s.VCPU = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *NodeForDescribeBackupsOutput) SetZoneId(v string) *NodeForDescribeBackupsOutput {
	s.ZoneId = &v
	return s
}

const (
	// EnumOfBackupStatusForDescribeBackupsOutputSuccess is a EnumOfBackupStatusForDescribeBackupsOutput enum value
	EnumOfBackupStatusForDescribeBackupsOutputSuccess = "Success"

	// EnumOfBackupStatusForDescribeBackupsOutputFailed is a EnumOfBackupStatusForDescribeBackupsOutput enum value
	EnumOfBackupStatusForDescribeBackupsOutputFailed = "Failed"

	// EnumOfBackupStatusForDescribeBackupsOutputRunning is a EnumOfBackupStatusForDescribeBackupsOutput enum value
	EnumOfBackupStatusForDescribeBackupsOutputRunning = "Running"
)

const (
	// EnumOfBackupTypeForDescribeBackupsInputFull is a EnumOfBackupTypeForDescribeBackupsInput enum value
	EnumOfBackupTypeForDescribeBackupsInputFull = "Full"

	// EnumOfBackupTypeForDescribeBackupsInputIncrement is a EnumOfBackupTypeForDescribeBackupsInput enum value
	EnumOfBackupTypeForDescribeBackupsInputIncrement = "Increment"
)

const (
	// EnumOfBackupTypeForDescribeBackupsOutputFull is a EnumOfBackupTypeForDescribeBackupsOutput enum value
	EnumOfBackupTypeForDescribeBackupsOutputFull = "Full"

	// EnumOfBackupTypeForDescribeBackupsOutputIncrement is a EnumOfBackupTypeForDescribeBackupsOutput enum value
	EnumOfBackupTypeForDescribeBackupsOutputIncrement = "Increment"
)

const (
	// EnumOfChargeStatusForDescribeBackupsOutputNormal is a EnumOfChargeStatusForDescribeBackupsOutput enum value
	EnumOfChargeStatusForDescribeBackupsOutputNormal = "Normal"

	// EnumOfChargeStatusForDescribeBackupsOutputOverdue is a EnumOfChargeStatusForDescribeBackupsOutput enum value
	EnumOfChargeStatusForDescribeBackupsOutputOverdue = "Overdue"

	// EnumOfChargeStatusForDescribeBackupsOutputUnpaid is a EnumOfChargeStatusForDescribeBackupsOutput enum value
	EnumOfChargeStatusForDescribeBackupsOutputUnpaid = "Unpaid"
)

const (
	// EnumOfChargeTypeForDescribeBackupsOutputPostPaid is a EnumOfChargeTypeForDescribeBackupsOutput enum value
	EnumOfChargeTypeForDescribeBackupsOutputPostPaid = "PostPaid"

	// EnumOfChargeTypeForDescribeBackupsOutputPrePaid is a EnumOfChargeTypeForDescribeBackupsOutput enum value
	EnumOfChargeTypeForDescribeBackupsOutputPrePaid = "PrePaid"
)

const (
	// EnumOfCreateTypeForDescribeBackupsOutputSystem is a EnumOfCreateTypeForDescribeBackupsOutput enum value
	EnumOfCreateTypeForDescribeBackupsOutputSystem = "System"

	// EnumOfCreateTypeForDescribeBackupsOutputUser is a EnumOfCreateTypeForDescribeBackupsOutput enum value
	EnumOfCreateTypeForDescribeBackupsOutputUser = "User"
)

const (
	// EnumOfDBEngineVersionForDescribeBackupsOutputPostgreSql11 is a EnumOfDBEngineVersionForDescribeBackupsOutput enum value
	EnumOfDBEngineVersionForDescribeBackupsOutputPostgreSql11 = "PostgreSQL_11"

	// EnumOfDBEngineVersionForDescribeBackupsOutputPostgreSql12 is a EnumOfDBEngineVersionForDescribeBackupsOutput enum value
	EnumOfDBEngineVersionForDescribeBackupsOutputPostgreSql12 = "PostgreSQL_12"

	// EnumOfDBEngineVersionForDescribeBackupsOutputPostgreSql13 is a EnumOfDBEngineVersionForDescribeBackupsOutput enum value
	EnumOfDBEngineVersionForDescribeBackupsOutputPostgreSql13 = "PostgreSQL_13"
)

const (
	// EnumOfInstanceStatusForDescribeBackupsOutputRunning is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputRunning = "Running"

	// EnumOfInstanceStatusForDescribeBackupsOutputCreating is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputCreating = "Creating"

	// EnumOfInstanceStatusForDescribeBackupsOutputDeleting is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputDeleting = "Deleting"

	// EnumOfInstanceStatusForDescribeBackupsOutputRestarting is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputRestarting = "Restarting"

	// EnumOfInstanceStatusForDescribeBackupsOutputRestoring is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputRestoring = "Restoring"

	// EnumOfInstanceStatusForDescribeBackupsOutputUpdating is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputUpdating = "Updating"

	// EnumOfInstanceStatusForDescribeBackupsOutputUpgrading is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputUpgrading = "Upgrading"

	// EnumOfInstanceStatusForDescribeBackupsOutputError is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputError = "Error"

	// EnumOfInstanceStatusForDescribeBackupsOutputReleased is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputReleased = "Released"

	// EnumOfInstanceStatusForDescribeBackupsOutputCreateError is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputCreateError = "CreateError"

	// EnumOfInstanceStatusForDescribeBackupsOutputMasterChanging is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputMasterChanging = "MasterChanging"

	// EnumOfInstanceStatusForDescribeBackupsOutputDeleted is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputDeleted = "Deleted"

	// EnumOfInstanceStatusForDescribeBackupsOutputRecycled is a EnumOfInstanceStatusForDescribeBackupsOutput enum value
	EnumOfInstanceStatusForDescribeBackupsOutputRecycled = "Recycled"
)

const (
	// EnumOfInstanceTypeForDescribeBackupsOutputHa is a EnumOfInstanceTypeForDescribeBackupsOutput enum value
	EnumOfInstanceTypeForDescribeBackupsOutputHa = "HA"
)

const (
	// EnumOfNodeStatusForDescribeBackupsOutputRunning is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputRunning = "Running"

	// EnumOfNodeStatusForDescribeBackupsOutputCreating is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputCreating = "Creating"

	// EnumOfNodeStatusForDescribeBackupsOutputDeleting is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputDeleting = "Deleting"

	// EnumOfNodeStatusForDescribeBackupsOutputRestarting is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputRestarting = "Restarting"

	// EnumOfNodeStatusForDescribeBackupsOutputRestoring is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputRestoring = "Restoring"

	// EnumOfNodeStatusForDescribeBackupsOutputUpdating is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputUpdating = "Updating"

	// EnumOfNodeStatusForDescribeBackupsOutputUpgrading is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputUpgrading = "Upgrading"

	// EnumOfNodeStatusForDescribeBackupsOutputError is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputError = "Error"

	// EnumOfNodeStatusForDescribeBackupsOutputReleased is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputReleased = "Released"

	// EnumOfNodeStatusForDescribeBackupsOutputCreateError is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputCreateError = "CreateError"

	// EnumOfNodeStatusForDescribeBackupsOutputMasterChanging is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputMasterChanging = "MasterChanging"

	// EnumOfNodeStatusForDescribeBackupsOutputDeleted is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputDeleted = "Deleted"

	// EnumOfNodeStatusForDescribeBackupsOutputRecycled is a EnumOfNodeStatusForDescribeBackupsOutput enum value
	EnumOfNodeStatusForDescribeBackupsOutputRecycled = "Recycled"
)

const (
	// EnumOfNodeTypeForDescribeBackupsOutputPrimary is a EnumOfNodeTypeForDescribeBackupsOutput enum value
	EnumOfNodeTypeForDescribeBackupsOutputPrimary = "Primary"

	// EnumOfNodeTypeForDescribeBackupsOutputSecondary is a EnumOfNodeTypeForDescribeBackupsOutput enum value
	EnumOfNodeTypeForDescribeBackupsOutputSecondary = "Secondary"

	// EnumOfNodeTypeForDescribeBackupsOutputReadOnly is a EnumOfNodeTypeForDescribeBackupsOutput enum value
	EnumOfNodeTypeForDescribeBackupsOutputReadOnly = "ReadOnly"
)

const (
	// EnumOfPeriodUnitForDescribeBackupsOutputMonth is a EnumOfPeriodUnitForDescribeBackupsOutput enum value
	EnumOfPeriodUnitForDescribeBackupsOutputMonth = "Month"

	// EnumOfPeriodUnitForDescribeBackupsOutputYear is a EnumOfPeriodUnitForDescribeBackupsOutput enum value
	EnumOfPeriodUnitForDescribeBackupsOutputYear = "Year"
)

const (
	// EnumOfStorageTypeForDescribeBackupsOutputLocalSsd is a EnumOfStorageTypeForDescribeBackupsOutput enum value
	EnumOfStorageTypeForDescribeBackupsOutputLocalSsd = "LocalSSD"
)
