// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetPublicKeyCommon = "GetPublicKey"

// GetPublicKeyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetPublicKeyCommon operation. The "output" return
// value will be populated with the GetPublicKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetPublicKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetPublicKeyCommon Send returns without error.
//
// See GetPublicKeyCommon for more information on using the GetPublicKeyCommon
// API call, and error handling.
//
//    // Example sending a request using the GetPublicKeyCommonRequest method.
//    req, resp := client.GetPublicKeyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) GetPublicKeyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetPublicKeyCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetPublicKeyCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation GetPublicKeyCommon for usage and error information.
func (c *KMS) GetPublicKeyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetPublicKeyCommonRequest(input)
	return out, req.Send()
}

// GetPublicKeyCommonWithContext is the same as GetPublicKeyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicKeyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GetPublicKeyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetPublicKeyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicKey = "GetPublicKey"

// GetPublicKeyRequest generates a "volcengine/request.Request" representing the
// client's request for the GetPublicKey operation. The "output" return
// value will be populated with the GetPublicKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetPublicKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetPublicKeyCommon Send returns without error.
//
// See GetPublicKey for more information on using the GetPublicKey
// API call, and error handling.
//
//    // Example sending a request using the GetPublicKeyRequest method.
//    req, resp := client.GetPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) GetPublicKeyRequest(input *GetPublicKeyInput) (req *request.Request, output *GetPublicKeyOutput) {
	op := &request.Operation{
		Name:       opGetPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPublicKeyInput{}
	}

	output = &GetPublicKeyOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetPublicKey API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation GetPublicKey for usage and error information.
func (c *KMS) GetPublicKey(input *GetPublicKeyInput) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	return out, req.Send()
}

// GetPublicKeyWithContext is the same as GetPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GetPublicKeyWithContext(ctx volcengine.Context, input *GetPublicKeyInput, opts ...request.Option) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type GetPublicKeyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GetPublicKeyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicKeyInput"}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyID sets the KeyID field's value.
func (s *GetPublicKeyInput) SetKeyID(v string) *GetPublicKeyInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *GetPublicKeyInput) SetKeyName(v string) *GetPublicKeyInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *GetPublicKeyInput) SetKeyringName(v string) *GetPublicKeyInput {
	s.KeyringName = &v
	return s
}

type GetPublicKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	KeyID *string `type:"string" json:",omitempty"`

	PublicKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GetPublicKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyOutput) GoString() string {
	return s.String()
}

// SetKeyID sets the KeyID field's value.
func (s *GetPublicKeyOutput) SetKeyID(v string) *GetPublicKeyOutput {
	s.KeyID = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *GetPublicKeyOutput) SetPublicKey(v string) *GetPublicKeyOutput {
	s.PublicKey = &v
	return s
}
