// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGenerateDataKeyCommon = "GenerateDataKey"

// GenerateDataKeyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GenerateDataKeyCommon operation. The "output" return
// value will be populated with the GenerateDataKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GenerateDataKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after GenerateDataKeyCommon Send returns without error.
//
// See GenerateDataKeyCommon for more information on using the GenerateDataKeyCommon
// API call, and error handling.
//
//    // Example sending a request using the GenerateDataKeyCommonRequest method.
//    req, resp := client.GenerateDataKeyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) GenerateDataKeyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGenerateDataKeyCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GenerateDataKeyCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation GenerateDataKeyCommon for usage and error information.
func (c *KMS) GenerateDataKeyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GenerateDataKeyCommonRequest(input)
	return out, req.Send()
}

// GenerateDataKeyCommonWithContext is the same as GenerateDataKeyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateDataKeyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GenerateDataKeyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GenerateDataKeyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateDataKey = "GenerateDataKey"

// GenerateDataKeyRequest generates a "volcengine/request.Request" representing the
// client's request for the GenerateDataKey operation. The "output" return
// value will be populated with the GenerateDataKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GenerateDataKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after GenerateDataKeyCommon Send returns without error.
//
// See GenerateDataKey for more information on using the GenerateDataKey
// API call, and error handling.
//
//    // Example sending a request using the GenerateDataKeyRequest method.
//    req, resp := client.GenerateDataKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) GenerateDataKeyRequest(input *GenerateDataKeyInput) (req *request.Request, output *GenerateDataKeyOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyInput{}
	}

	output = &GenerateDataKeyOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GenerateDataKey API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation GenerateDataKey for usage and error information.
func (c *KMS) GenerateDataKey(input *GenerateDataKeyInput) (*GenerateDataKeyOutput, error) {
	req, out := c.GenerateDataKeyRequest(input)
	return out, req.Send()
}

// GenerateDataKeyWithContext is the same as GenerateDataKey with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateDataKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GenerateDataKeyWithContext(ctx volcengine.Context, input *GenerateDataKeyInput, opts ...request.Option) (*GenerateDataKeyOutput, error) {
	req, out := c.GenerateDataKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type GenerateDataKeyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EncryptionContext map[string]*string `type:"map" json:",omitempty"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	NumberOfBytes *int32 `min:"1" max:"1024" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s GenerateDataKeyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateDataKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateDataKeyInput"}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}
	if s.NumberOfBytes != nil && *s.NumberOfBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBytes", 1))
	}
	if s.NumberOfBytes != nil && *s.NumberOfBytes > 1024 {
		invalidParams.Add(request.NewErrParamMaxValue("NumberOfBytes", 1024))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionContext sets the EncryptionContext field's value.
func (s *GenerateDataKeyInput) SetEncryptionContext(v map[string]*string) *GenerateDataKeyInput {
	s.EncryptionContext = v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *GenerateDataKeyInput) SetKeyID(v string) *GenerateDataKeyInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *GenerateDataKeyInput) SetKeyName(v string) *GenerateDataKeyInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *GenerateDataKeyInput) SetKeyringName(v string) *GenerateDataKeyInput {
	s.KeyringName = &v
	return s
}

// SetNumberOfBytes sets the NumberOfBytes field's value.
func (s *GenerateDataKeyInput) SetNumberOfBytes(v int32) *GenerateDataKeyInput {
	s.NumberOfBytes = &v
	return s
}

type GenerateDataKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CiphertextBlob *string `type:"string" json:",omitempty"`

	Plaintext *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GenerateDataKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyOutput) GoString() string {
	return s.String()
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *GenerateDataKeyOutput) SetCiphertextBlob(v string) *GenerateDataKeyOutput {
	s.CiphertextBlob = &v
	return s
}

// SetPlaintext sets the Plaintext field's value.
func (s *GenerateDataKeyOutput) SetPlaintext(v string) *GenerateDataKeyOutput {
	s.Plaintext = &v
	return s
}
