// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeKeysCommon = "DescribeKeys"

// DescribeKeysCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeKeysCommon operation. The "output" return
// value will be populated with the DescribeKeysCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeKeysCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeKeysCommon Send returns without error.
//
// See DescribeKeysCommon for more information on using the DescribeKeysCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeKeysCommonRequest method.
//    req, resp := client.DescribeKeysCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeKeysCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeKeysCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeKeysCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeKeysCommon for usage and error information.
func (c *KMS) DescribeKeysCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeKeysCommonRequest(input)
	return out, req.Send()
}

// DescribeKeysCommonWithContext is the same as DescribeKeysCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKeysCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeKeysCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeKeysCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeKeys = "DescribeKeys"

// DescribeKeysRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeKeys operation. The "output" return
// value will be populated with the DescribeKeysCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeKeysCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeKeysCommon Send returns without error.
//
// See DescribeKeys for more information on using the DescribeKeys
// API call, and error handling.
//
//    // Example sending a request using the DescribeKeysRequest method.
//    req, resp := client.DescribeKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeKeysRequest(input *DescribeKeysInput) (req *request.Request, output *DescribeKeysOutput) {
	op := &request.Operation{
		Name:       opDescribeKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeysInput{}
	}

	output = &DescribeKeysOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeKeys API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeKeys for usage and error information.
func (c *KMS) DescribeKeys(input *DescribeKeysInput) (*DescribeKeysOutput, error) {
	req, out := c.DescribeKeysRequest(input)
	return out, req.Send()
}

// DescribeKeysWithContext is the same as DescribeKeys with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeKeysWithContext(ctx volcengine.Context, input *DescribeKeysInput, opts ...request.Option) (*DescribeKeysOutput, error) {
	req, out := c.DescribeKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeKeysInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CurrentPage *int32 `min:"1" type:"int32" json:",omitempty"`

	Filters *string `max:"2048" type:"string" json:",omitempty"`

	KeyringID *string `type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeKeysInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeKeysInput"}
	if s.CurrentPage != nil && *s.CurrentPage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentPage", 1))
	}
	if s.Filters != nil && len(*s.Filters) > 2048 {
		invalidParams.Add(request.NewErrParamMaxLen("Filters", 2048, *s.Filters))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *DescribeKeysInput) SetCurrentPage(v int32) *DescribeKeysInput {
	s.CurrentPage = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeKeysInput) SetFilters(v string) *DescribeKeysInput {
	s.Filters = &v
	return s
}

// SetKeyringID sets the KeyringID field's value.
func (s *DescribeKeysInput) SetKeyringID(v string) *DescribeKeysInput {
	s.KeyringID = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *DescribeKeysInput) SetKeyringName(v string) *DescribeKeysInput {
	s.KeyringName = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeKeysInput) SetPageSize(v int32) *DescribeKeysInput {
	s.PageSize = &v
	return s
}

type DescribeKeysOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Keys []*KeyForDescribeKeysOutput `type:"list" json:",omitempty"`

	PageInfo *PageInfoForDescribeKeysOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DescribeKeysOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeysOutput) GoString() string {
	return s.String()
}

// SetKeys sets the Keys field's value.
func (s *DescribeKeysOutput) SetKeys(v []*KeyForDescribeKeysOutput) *DescribeKeysOutput {
	s.Keys = v
	return s
}

// SetPageInfo sets the PageInfo field's value.
func (s *DescribeKeysOutput) SetPageInfo(v *PageInfoForDescribeKeysOutput) *DescribeKeysOutput {
	s.PageInfo = v
	return s
}

type KeyForDescribeKeysOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	KeyMaterialExpireTime *string `type:"string" json:",omitempty"`

	KeyName *string `type:"string" json:",omitempty"`

	KeySpec *string `type:"string" json:",omitempty"`

	KeyState *string `type:"string" json:",omitempty"`

	KeyUsage *string `type:"string" json:",omitempty"`

	LastRotationTime *string `type:"string" json:",omitempty"`

	MultiRegion *bool `type:"boolean" json:",omitempty"`

	MultiRegionConfiguration *MultiRegionConfigurationForDescribeKeysOutput `type:"structure" json:",omitempty"`

	Origin *string `type:"string" json:",omitempty"`

	ProtectionLevel *string `type:"string" json:",omitempty"`

	RotationState *string `type:"string" json:",omitempty"`

	ScheduleDeleteTime *string `type:"string" json:",omitempty"`

	ScheduleRotationTime *string `type:"string" json:",omitempty"`

	Trn *string `type:"string" json:",omitempty"`

	UpdateDate *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s KeyForDescribeKeysOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyForDescribeKeysOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *KeyForDescribeKeysOutput) SetCreationDate(v int64) *KeyForDescribeKeysOutput {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KeyForDescribeKeysOutput) SetDescription(v string) *KeyForDescribeKeysOutput {
	s.Description = &v
	return s
}

// SetID sets the ID field's value.
func (s *KeyForDescribeKeysOutput) SetID(v string) *KeyForDescribeKeysOutput {
	s.ID = &v
	return s
}

// SetKeyMaterialExpireTime sets the KeyMaterialExpireTime field's value.
func (s *KeyForDescribeKeysOutput) SetKeyMaterialExpireTime(v string) *KeyForDescribeKeysOutput {
	s.KeyMaterialExpireTime = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *KeyForDescribeKeysOutput) SetKeyName(v string) *KeyForDescribeKeysOutput {
	s.KeyName = &v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *KeyForDescribeKeysOutput) SetKeySpec(v string) *KeyForDescribeKeysOutput {
	s.KeySpec = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *KeyForDescribeKeysOutput) SetKeyState(v string) *KeyForDescribeKeysOutput {
	s.KeyState = &v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *KeyForDescribeKeysOutput) SetKeyUsage(v string) *KeyForDescribeKeysOutput {
	s.KeyUsage = &v
	return s
}

// SetLastRotationTime sets the LastRotationTime field's value.
func (s *KeyForDescribeKeysOutput) SetLastRotationTime(v string) *KeyForDescribeKeysOutput {
	s.LastRotationTime = &v
	return s
}

// SetMultiRegion sets the MultiRegion field's value.
func (s *KeyForDescribeKeysOutput) SetMultiRegion(v bool) *KeyForDescribeKeysOutput {
	s.MultiRegion = &v
	return s
}

// SetMultiRegionConfiguration sets the MultiRegionConfiguration field's value.
func (s *KeyForDescribeKeysOutput) SetMultiRegionConfiguration(v *MultiRegionConfigurationForDescribeKeysOutput) *KeyForDescribeKeysOutput {
	s.MultiRegionConfiguration = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *KeyForDescribeKeysOutput) SetOrigin(v string) *KeyForDescribeKeysOutput {
	s.Origin = &v
	return s
}

// SetProtectionLevel sets the ProtectionLevel field's value.
func (s *KeyForDescribeKeysOutput) SetProtectionLevel(v string) *KeyForDescribeKeysOutput {
	s.ProtectionLevel = &v
	return s
}

// SetRotationState sets the RotationState field's value.
func (s *KeyForDescribeKeysOutput) SetRotationState(v string) *KeyForDescribeKeysOutput {
	s.RotationState = &v
	return s
}

// SetScheduleDeleteTime sets the ScheduleDeleteTime field's value.
func (s *KeyForDescribeKeysOutput) SetScheduleDeleteTime(v string) *KeyForDescribeKeysOutput {
	s.ScheduleDeleteTime = &v
	return s
}

// SetScheduleRotationTime sets the ScheduleRotationTime field's value.
func (s *KeyForDescribeKeysOutput) SetScheduleRotationTime(v string) *KeyForDescribeKeysOutput {
	s.ScheduleRotationTime = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *KeyForDescribeKeysOutput) SetTrn(v string) *KeyForDescribeKeysOutput {
	s.Trn = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *KeyForDescribeKeysOutput) SetUpdateDate(v int64) *KeyForDescribeKeysOutput {
	s.UpdateDate = &v
	return s
}

type MultiRegionConfigurationForDescribeKeysOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MultiRegionKeyType *string `type:"string" json:",omitempty" enum:"EnumOfMultiRegionKeyTypeForDescribeKeysOutput"`

	PrimaryKey *PrimaryKeyForDescribeKeysOutput `type:"structure" json:",omitempty"`

	ReplicaKeys []*ReplicaKeyForDescribeKeysOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s MultiRegionConfigurationForDescribeKeysOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiRegionConfigurationForDescribeKeysOutput) GoString() string {
	return s.String()
}

// SetMultiRegionKeyType sets the MultiRegionKeyType field's value.
func (s *MultiRegionConfigurationForDescribeKeysOutput) SetMultiRegionKeyType(v string) *MultiRegionConfigurationForDescribeKeysOutput {
	s.MultiRegionKeyType = &v
	return s
}

// SetPrimaryKey sets the PrimaryKey field's value.
func (s *MultiRegionConfigurationForDescribeKeysOutput) SetPrimaryKey(v *PrimaryKeyForDescribeKeysOutput) *MultiRegionConfigurationForDescribeKeysOutput {
	s.PrimaryKey = v
	return s
}

// SetReplicaKeys sets the ReplicaKeys field's value.
func (s *MultiRegionConfigurationForDescribeKeysOutput) SetReplicaKeys(v []*ReplicaKeyForDescribeKeysOutput) *MultiRegionConfigurationForDescribeKeysOutput {
	s.ReplicaKeys = v
	return s
}

type PageInfoForDescribeKeysOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	CurrentPage *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s PageInfoForDescribeKeysOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageInfoForDescribeKeysOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *PageInfoForDescribeKeysOutput) SetCount(v int32) *PageInfoForDescribeKeysOutput {
	s.Count = &v
	return s
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *PageInfoForDescribeKeysOutput) SetCurrentPage(v int32) *PageInfoForDescribeKeysOutput {
	s.CurrentPage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *PageInfoForDescribeKeysOutput) SetPageSize(v int32) *PageInfoForDescribeKeysOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *PageInfoForDescribeKeysOutput) SetTotalCount(v int32) *PageInfoForDescribeKeysOutput {
	s.TotalCount = &v
	return s
}

type PrimaryKeyForDescribeKeysOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	Trn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PrimaryKeyForDescribeKeysOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrimaryKeyForDescribeKeysOutput) GoString() string {
	return s.String()
}

// SetRegion sets the Region field's value.
func (s *PrimaryKeyForDescribeKeysOutput) SetRegion(v string) *PrimaryKeyForDescribeKeysOutput {
	s.Region = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *PrimaryKeyForDescribeKeysOutput) SetTrn(v string) *PrimaryKeyForDescribeKeysOutput {
	s.Trn = &v
	return s
}

type ReplicaKeyForDescribeKeysOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	Trn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ReplicaKeyForDescribeKeysOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaKeyForDescribeKeysOutput) GoString() string {
	return s.String()
}

// SetRegion sets the Region field's value.
func (s *ReplicaKeyForDescribeKeysOutput) SetRegion(v string) *ReplicaKeyForDescribeKeysOutput {
	s.Region = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *ReplicaKeyForDescribeKeysOutput) SetTrn(v string) *ReplicaKeyForDescribeKeysOutput {
	s.Trn = &v
	return s
}

const (
	// EnumOfMultiRegionKeyTypeForDescribeKeysOutputPrimary is a EnumOfMultiRegionKeyTypeForDescribeKeysOutput enum value
	EnumOfMultiRegionKeyTypeForDescribeKeysOutputPrimary = "PRIMARY"

	// EnumOfMultiRegionKeyTypeForDescribeKeysOutputReplica is a EnumOfMultiRegionKeyTypeForDescribeKeysOutput enum value
	EnumOfMultiRegionKeyTypeForDescribeKeysOutputReplica = "REPLICA"
)
