// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package fwcenter

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeAddressBookCommon = "DescribeAddressBook"

// DescribeAddressBookCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeAddressBookCommon operation. The "output" return
// value will be populated with the DescribeAddressBookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeAddressBookCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeAddressBookCommon Send returns without error.
//
// See DescribeAddressBookCommon for more information on using the DescribeAddressBookCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeAddressBookCommonRequest method.
//    req, resp := client.DescribeAddressBookCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) DescribeAddressBookCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeAddressBookCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeAddressBookCommon API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation DescribeAddressBookCommon for usage and error information.
func (c *FWCENTER) DescribeAddressBookCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeAddressBookCommonRequest(input)
	return out, req.Send()
}

// DescribeAddressBookCommonWithContext is the same as DescribeAddressBookCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddressBookCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) DescribeAddressBookCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeAddressBookCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddressBook = "DescribeAddressBook"

// DescribeAddressBookRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeAddressBook operation. The "output" return
// value will be populated with the DescribeAddressBookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeAddressBookCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeAddressBookCommon Send returns without error.
//
// See DescribeAddressBook for more information on using the DescribeAddressBook
// API call, and error handling.
//
//    // Example sending a request using the DescribeAddressBookRequest method.
//    req, resp := client.DescribeAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) DescribeAddressBookRequest(input *DescribeAddressBookInput) (req *request.Request, output *DescribeAddressBookOutput) {
	op := &request.Operation{
		Name:       opDescribeAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressBookInput{}
	}

	output = &DescribeAddressBookOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeAddressBook API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation DescribeAddressBook for usage and error information.
func (c *FWCENTER) DescribeAddressBook(input *DescribeAddressBookInput) (*DescribeAddressBookOutput, error) {
	req, out := c.DescribeAddressBookRequest(input)
	return out, req.Send()
}

// DescribeAddressBookWithContext is the same as DescribeAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) DescribeAddressBookWithContext(ctx volcengine.Context, input *DescribeAddressBookInput, opts ...request.Option) (*DescribeAddressBookOutput, error) {
	req, out := c.DescribeAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DataForDescribeAddressBookOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddressList []*string `type:"list" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	GroupName *string `type:"string" json:",omitempty"`

	GroupType *string `type:"string" json:",omitempty"`

	GroupUuid *string `type:"string" json:",omitempty"`

	RefCnt *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DataForDescribeAddressBookOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForDescribeAddressBookOutput) GoString() string {
	return s.String()
}

// SetAddressList sets the AddressList field's value.
func (s *DataForDescribeAddressBookOutput) SetAddressList(v []*string) *DataForDescribeAddressBookOutput {
	s.AddressList = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataForDescribeAddressBookOutput) SetDescription(v string) *DataForDescribeAddressBookOutput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DataForDescribeAddressBookOutput) SetGroupName(v string) *DataForDescribeAddressBookOutput {
	s.GroupName = &v
	return s
}

// SetGroupType sets the GroupType field's value.
func (s *DataForDescribeAddressBookOutput) SetGroupType(v string) *DataForDescribeAddressBookOutput {
	s.GroupType = &v
	return s
}

// SetGroupUuid sets the GroupUuid field's value.
func (s *DataForDescribeAddressBookOutput) SetGroupUuid(v string) *DataForDescribeAddressBookOutput {
	s.GroupUuid = &v
	return s
}

// SetRefCnt sets the RefCnt field's value.
func (s *DataForDescribeAddressBookOutput) SetRefCnt(v int32) *DataForDescribeAddressBookOutput {
	s.RefCnt = &v
	return s
}

type DescribeAddressBookInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GroupType *string `type:"string" json:",omitempty" enum:"EnumOfGroupTypeForDescribeAddressBookInput"`

	PageNumber *int32 `max:"100" type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Query *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DescribeAddressBookInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddressBookInput"}
	if s.PageNumber != nil && *s.PageNumber > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageNumber", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupType sets the GroupType field's value.
func (s *DescribeAddressBookInput) SetGroupType(v string) *DescribeAddressBookInput {
	s.GroupType = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeAddressBookInput) SetPageNumber(v int32) *DescribeAddressBookInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeAddressBookInput) SetPageSize(v int32) *DescribeAddressBookInput {
	s.PageSize = &v
	return s
}

// SetQuery sets the Query field's value.
func (s *DescribeAddressBookInput) SetQuery(v string) *DescribeAddressBookInput {
	s.Query = &v
	return s
}

type DescribeAddressBookOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Count *int32 `type:"int32" json:",omitempty"`

	Data []*DataForDescribeAddressBookOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeAddressBookOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressBookOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *DescribeAddressBookOutput) SetCount(v int32) *DescribeAddressBookOutput {
	s.Count = &v
	return s
}

// SetData sets the Data field's value.
func (s *DescribeAddressBookOutput) SetData(v []*DataForDescribeAddressBookOutput) *DescribeAddressBookOutput {
	s.Data = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeAddressBookOutput) SetPageNumber(v int32) *DescribeAddressBookOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeAddressBookOutput) SetPageSize(v int32) *DescribeAddressBookOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeAddressBookOutput) SetTotalCount(v int32) *DescribeAddressBookOutput {
	s.TotalCount = &v
	return s
}

const (
	// EnumOfGroupTypeForDescribeAddressBookInputIp is a EnumOfGroupTypeForDescribeAddressBookInput enum value
	EnumOfGroupTypeForDescribeAddressBookInputIp = "ip"

	// EnumOfGroupTypeForDescribeAddressBookInputPort is a EnumOfGroupTypeForDescribeAddressBookInput enum value
	EnumOfGroupTypeForDescribeAddressBookInputPort = "port"

	// EnumOfGroupTypeForDescribeAddressBookInputDomain is a EnumOfGroupTypeForDescribeAddressBookInput enum value
	EnumOfGroupTypeForDescribeAddressBookInputDomain = "domain"
)
