// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dns

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListDomainStatisticsCommon = "ListDomainStatistics"

// ListDomainStatisticsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDomainStatisticsCommon operation. The "output" return
// value will be populated with the ListDomainStatisticsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDomainStatisticsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDomainStatisticsCommon Send returns without error.
//
// See ListDomainStatisticsCommon for more information on using the ListDomainStatisticsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListDomainStatisticsCommonRequest method.
//    req, resp := client.ListDomainStatisticsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) ListDomainStatisticsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListDomainStatisticsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDomainStatisticsCommon API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation ListDomainStatisticsCommon for usage and error information.
func (c *DNS) ListDomainStatisticsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListDomainStatisticsCommonRequest(input)
	return out, req.Send()
}

// ListDomainStatisticsCommonWithContext is the same as ListDomainStatisticsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainStatisticsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) ListDomainStatisticsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListDomainStatisticsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainStatistics = "ListDomainStatistics"

// ListDomainStatisticsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDomainStatistics operation. The "output" return
// value will be populated with the ListDomainStatisticsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDomainStatisticsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDomainStatisticsCommon Send returns without error.
//
// See ListDomainStatistics for more information on using the ListDomainStatistics
// API call, and error handling.
//
//    // Example sending a request using the ListDomainStatisticsRequest method.
//    req, resp := client.ListDomainStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) ListDomainStatisticsRequest(input *ListDomainStatisticsInput) (req *request.Request, output *ListDomainStatisticsOutput) {
	op := &request.Operation{
		Name:       opListDomainStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDomainStatisticsInput{}
	}

	output = &ListDomainStatisticsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDomainStatistics API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation ListDomainStatistics for usage and error information.
func (c *DNS) ListDomainStatistics(input *ListDomainStatisticsInput) (*ListDomainStatisticsOutput, error) {
	req, out := c.ListDomainStatisticsRequest(input)
	return out, req.Send()
}

// ListDomainStatisticsWithContext is the same as ListDomainStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) ListDomainStatisticsWithContext(ctx volcengine.Context, input *ListDomainStatisticsInput, opts ...request.Option) (*ListDomainStatisticsOutput, error) {
	req, out := c.ListDomainStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DataForListDomainStatisticsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheStage *int32 `type:"int32" json:",omitempty"`

	Error *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NotExists *int32 `type:"int32" json:",omitempty"`

	Success *int32 `type:"int32" json:",omitempty"`

	Timestamp *int64 `type:"int64" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`

	ZID *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DataForListDomainStatisticsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForListDomainStatisticsOutput) GoString() string {
	return s.String()
}

// SetCacheStage sets the CacheStage field's value.
func (s *DataForListDomainStatisticsOutput) SetCacheStage(v int32) *DataForListDomainStatisticsOutput {
	s.CacheStage = &v
	return s
}

// SetError sets the Error field's value.
func (s *DataForListDomainStatisticsOutput) SetError(v int32) *DataForListDomainStatisticsOutput {
	s.Error = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataForListDomainStatisticsOutput) SetName(v string) *DataForListDomainStatisticsOutput {
	s.Name = &v
	return s
}

// SetNotExists sets the NotExists field's value.
func (s *DataForListDomainStatisticsOutput) SetNotExists(v int32) *DataForListDomainStatisticsOutput {
	s.NotExists = &v
	return s
}

// SetSuccess sets the Success field's value.
func (s *DataForListDomainStatisticsOutput) SetSuccess(v int32) *DataForListDomainStatisticsOutput {
	s.Success = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *DataForListDomainStatisticsOutput) SetTimestamp(v int64) *DataForListDomainStatisticsOutput {
	s.Timestamp = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *DataForListDomainStatisticsOutput) SetTotal(v int32) *DataForListDomainStatisticsOutput {
	s.Total = &v
	return s
}

// SetZID sets the ZID field's value.
func (s *DataForListDomainStatisticsOutput) SetZID(v int32) *DataForListDomainStatisticsOutput {
	s.ZID = &v
	return s
}

type ListDomainStatisticsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	End *int64 `type:"int64" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	SearchMode *string `type:"string" json:",omitempty"`

	Start *int64 `type:"int64" json:",omitempty"`

	Threshold *int32 `type:"int32" json:",omitempty"`

	// ZID is a required field
	ZID *int64 `type:"int64" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListDomainStatisticsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainStatisticsInput"}
	if s.ZID == nil {
		invalidParams.Add(request.NewErrParamRequired("ZID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnd sets the End field's value.
func (s *ListDomainStatisticsInput) SetEnd(v int64) *ListDomainStatisticsInput {
	s.End = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListDomainStatisticsInput) SetName(v string) *ListDomainStatisticsInput {
	s.Name = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListDomainStatisticsInput) SetPageNumber(v int32) *ListDomainStatisticsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDomainStatisticsInput) SetPageSize(v int32) *ListDomainStatisticsInput {
	s.PageSize = &v
	return s
}

// SetSearchMode sets the SearchMode field's value.
func (s *ListDomainStatisticsInput) SetSearchMode(v string) *ListDomainStatisticsInput {
	s.SearchMode = &v
	return s
}

// SetStart sets the Start field's value.
func (s *ListDomainStatisticsInput) SetStart(v int64) *ListDomainStatisticsInput {
	s.Start = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *ListDomainStatisticsInput) SetThreshold(v int32) *ListDomainStatisticsInput {
	s.Threshold = &v
	return s
}

// SetZID sets the ZID field's value.
func (s *ListDomainStatisticsInput) SetZID(v int64) *ListDomainStatisticsInput {
	s.ZID = &v
	return s
}

type ListDomainStatisticsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data []*DataForListDomainStatisticsOutput `type:"list" json:",omitempty"`

	Page *int32 `type:"int32" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListDomainStatisticsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainStatisticsOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *ListDomainStatisticsOutput) SetData(v []*DataForListDomainStatisticsOutput) *ListDomainStatisticsOutput {
	s.Data = v
	return s
}

// SetPage sets the Page field's value.
func (s *ListDomainStatisticsOutput) SetPage(v int32) *ListDomainStatisticsOutput {
	s.Page = &v
	return s
}

// SetSize sets the Size field's value.
func (s *ListDomainStatisticsOutput) SetSize(v int32) *ListDomainStatisticsOutput {
	s.Size = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListDomainStatisticsOutput) SetTotal(v int32) *ListDomainStatisticsOutput {
	s.Total = &v
	return s
}
