// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dns

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCheckZoneCommon = "CheckZone"

// CheckZoneCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CheckZoneCommon operation. The "output" return
// value will be populated with the CheckZoneCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CheckZoneCommon Request to send the API call to the service.
// the "output" return value is not valid until after CheckZoneCommon Send returns without error.
//
// See CheckZoneCommon for more information on using the CheckZoneCommon
// API call, and error handling.
//
//    // Example sending a request using the CheckZoneCommonRequest method.
//    req, resp := client.CheckZoneCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) CheckZoneCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCheckZoneCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CheckZoneCommon API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation CheckZoneCommon for usage and error information.
func (c *DNS) CheckZoneCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CheckZoneCommonRequest(input)
	return out, req.Send()
}

// CheckZoneCommonWithContext is the same as CheckZoneCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CheckZoneCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) CheckZoneCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CheckZoneCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCheckZone = "CheckZone"

// CheckZoneRequest generates a "volcengine/request.Request" representing the
// client's request for the CheckZone operation. The "output" return
// value will be populated with the CheckZoneCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CheckZoneCommon Request to send the API call to the service.
// the "output" return value is not valid until after CheckZoneCommon Send returns without error.
//
// See CheckZone for more information on using the CheckZone
// API call, and error handling.
//
//    // Example sending a request using the CheckZoneRequest method.
//    req, resp := client.CheckZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) CheckZoneRequest(input *CheckZoneInput) (req *request.Request, output *CheckZoneOutput) {
	op := &request.Operation{
		Name:       opCheckZone,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CheckZoneInput{}
	}

	output = &CheckZoneOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CheckZone API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation CheckZone for usage and error information.
func (c *DNS) CheckZone(input *CheckZoneInput) (*CheckZoneOutput, error) {
	req, out := c.CheckZoneRequest(input)
	return out, req.Send()
}

// CheckZoneWithContext is the same as CheckZone with the addition of
// the ability to pass a context and additional request options.
//
// See CheckZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) CheckZoneWithContext(ctx volcengine.Context, input *CheckZoneInput, opts ...request.Option) (*CheckZoneOutput, error) {
	req, out := c.CheckZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CheckZoneInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// ZoneName is a required field
	ZoneName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CheckZoneInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckZoneInput"}
	if s.ZoneName == nil {
		invalidParams.Add(request.NewErrParamRequired("ZoneName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetZoneName sets the ZoneName field's value.
func (s *CheckZoneInput) SetZoneName(v string) *CheckZoneInput {
	s.ZoneName = &v
	return s
}

type CheckZoneOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	IsSubDomain *bool `type:"boolean" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	NameServer []*string `type:"list" json:",omitempty"`

	Registered *bool `type:"boolean" json:",omitempty"`

	ZoneName *string `type:"string" json:",omitempty"`

	ZoneOwnedByOtherUser *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CheckZoneOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckZoneOutput) GoString() string {
	return s.String()
}

// SetIsSubDomain sets the IsSubDomain field's value.
func (s *CheckZoneOutput) SetIsSubDomain(v bool) *CheckZoneOutput {
	s.IsSubDomain = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *CheckZoneOutput) SetMessage(v string) *CheckZoneOutput {
	s.Message = &v
	return s
}

// SetNameServer sets the NameServer field's value.
func (s *CheckZoneOutput) SetNameServer(v []*string) *CheckZoneOutput {
	s.NameServer = v
	return s
}

// SetRegistered sets the Registered field's value.
func (s *CheckZoneOutput) SetRegistered(v bool) *CheckZoneOutput {
	s.Registered = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *CheckZoneOutput) SetZoneName(v string) *CheckZoneOutput {
	s.ZoneName = &v
	return s
}

// SetZoneOwnedByOtherUser sets the ZoneOwnedByOtherUser field's value.
func (s *CheckZoneOutput) SetZoneOwnedByOtherUser(v bool) *CheckZoneOutput {
	s.ZoneOwnedByOtherUser = &v
	return s
}
