// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListNamespacesCommon = "ListNamespaces"

// ListNamespacesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNamespacesCommon operation. The "output" return
// value will be populated with the ListNamespacesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNamespacesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNamespacesCommon Send returns without error.
//
// See ListNamespacesCommon for more information on using the ListNamespacesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListNamespacesCommonRequest method.
//    req, resp := client.ListNamespacesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) ListNamespacesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListNamespacesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNamespacesCommon API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation ListNamespacesCommon for usage and error information.
func (c *CR) ListNamespacesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListNamespacesCommonRequest(input)
	return out, req.Send()
}

// ListNamespacesCommonWithContext is the same as ListNamespacesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamespacesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) ListNamespacesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListNamespacesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNamespaces = "ListNamespaces"

// ListNamespacesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNamespaces operation. The "output" return
// value will be populated with the ListNamespacesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNamespacesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNamespacesCommon Send returns without error.
//
// See ListNamespaces for more information on using the ListNamespaces
// API call, and error handling.
//
//    // Example sending a request using the ListNamespacesRequest method.
//    req, resp := client.ListNamespacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) ListNamespacesRequest(input *ListNamespacesInput) (req *request.Request, output *ListNamespacesOutput) {
	op := &request.Operation{
		Name:       opListNamespaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListNamespacesInput{}
	}

	output = &ListNamespacesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNamespaces API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation ListNamespaces for usage and error information.
func (c *CR) ListNamespaces(input *ListNamespacesInput) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	return out, req.Send()
}

// ListNamespacesWithContext is the same as ListNamespaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamespaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) ListNamespacesWithContext(ctx volcengine.Context, input *ListNamespacesInput, opts ...request.Option) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FilterForListNamespacesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InProject *bool `type:"boolean" json:",omitempty"`

	Names []*string `type:"list" json:",omitempty"`

	Projects []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListNamespacesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListNamespacesInput) GoString() string {
	return s.String()
}

// SetInProject sets the InProject field's value.
func (s *FilterForListNamespacesInput) SetInProject(v bool) *FilterForListNamespacesInput {
	s.InProject = &v
	return s
}

// SetNames sets the Names field's value.
func (s *FilterForListNamespacesInput) SetNames(v []*string) *FilterForListNamespacesInput {
	s.Names = v
	return s
}

// SetProjects sets the Projects field's value.
func (s *FilterForListNamespacesInput) SetProjects(v []*string) *FilterForListNamespacesInput {
	s.Projects = v
	return s
}

type ItemForListNamespacesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Project *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListNamespacesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListNamespacesOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListNamespacesOutput) SetCreateTime(v string) *ItemForListNamespacesOutput {
	s.CreateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListNamespacesOutput) SetName(v string) *ItemForListNamespacesOutput {
	s.Name = &v
	return s
}

// SetProject sets the Project field's value.
func (s *ItemForListNamespacesOutput) SetProject(v string) *ItemForListNamespacesOutput {
	s.Project = &v
	return s
}

type ListNamespacesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListNamespacesInput `type:"structure" json:",omitempty"`

	PageNumber *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `min:"1" max:"100" type:"int64" json:",omitempty"`

	// Registry is a required field
	Registry *string `min:"3" max:"30" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListNamespacesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamespacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNamespacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNamespacesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.Registry == nil {
		invalidParams.Add(request.NewErrParamRequired("Registry"))
	}
	if s.Registry != nil && len(*s.Registry) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Registry", 3))
	}
	if s.Registry != nil && len(*s.Registry) > 30 {
		invalidParams.Add(request.NewErrParamMaxLen("Registry", 30, *s.Registry))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListNamespacesInput) SetFilter(v *FilterForListNamespacesInput) *ListNamespacesInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListNamespacesInput) SetPageNumber(v int64) *ListNamespacesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListNamespacesInput) SetPageSize(v int64) *ListNamespacesInput {
	s.PageSize = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *ListNamespacesInput) SetRegistry(v string) *ListNamespacesInput {
	s.Registry = &v
	return s
}

type ListNamespacesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListNamespacesOutput `type:"list" json:",omitempty"`

	PageNumber *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `type:"int64" json:",omitempty"`

	Registry *string `type:"string" json:",omitempty"`

	TotalCount *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListNamespacesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamespacesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListNamespacesOutput) SetItems(v []*ItemForListNamespacesOutput) *ListNamespacesOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListNamespacesOutput) SetPageNumber(v int64) *ListNamespacesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListNamespacesOutput) SetPageSize(v int64) *ListNamespacesOutput {
	s.PageSize = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *ListNamespacesOutput) SetRegistry(v string) *ListNamespacesOutput {
	s.Registry = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListNamespacesOutput) SetTotalCount(v int64) *ListNamespacesOutput {
	s.TotalCount = &v
	return s
}
