// Example Code generated by Beijing Volcanoengine Technology.
package vpcexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/vpc"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func DescribeVpcs() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := vpc.New(sess)
	describeVpcsInput := &vpc.DescribeVpcsInput{
		PageNumber: volcengine.Int64(1),
		PageSize:   volcengine.Int64(20),
		VpcIds:     volcengine.StringSlice([]string{"vpc-bp1b1p3ve5yze****", "vpc-bp1b1xjllp3ve5yze****"}),
	}

	resp, err := svc.DescribeVpcs(describeVpcsInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
