// Example Code generated by Beijing Volcanoengine Technology.
package autoscalingexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/autoscaling"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateScalingConfiguration() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := autoscaling.New(sess)
	reqVolumes := &autoscaling.VolumeForCreateScalingConfigurationInput{
		Size:       volcengine.Int32(20),
		VolumeType: volcengine.String("PTSSD"),
	}
	createScalingConfigurationInput := &autoscaling.CreateScalingConfigurationInput{
		ImageId:                  volcengine.String("image-ybmhzqo8u4l8j1ii****"),
		InstanceName:             volcengine.String("instance-test"),
		InstanceTypes:            volcengine.StringSlice([]string{"ecs.g1.2xlarge"}),
		Password:                 volcengine.String("root@123"),
		ScalingConfigurationName: volcengine.String("scaling-config-test"),
		ScalingGroupId:           volcengine.String("scg-ybmssdnnhn5pkgyd****"),
		SecurityGroupIds:         volcengine.StringSlice([]string{"sg-3ti78x9h8t4bw*****"}),
		Volumes:                  []*autoscaling.VolumeForCreateScalingConfigurationInput{reqVolumes},
		ZoneId:                   volcengine.String("cn-beijing-a"),
	}

	resp, err := svc.CreateScalingConfiguration(createScalingConfigurationInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
