package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateChatbotInstance invokes the voicenavigator.AssociateChatbotInstance API synchronously
func (client *Client) AssociateChatbotInstance(request *AssociateChatbotInstanceRequest) (response *AssociateChatbotInstanceResponse, err error) {
	response = CreateAssociateChatbotInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateChatbotInstanceWithChan invokes the voicenavigator.AssociateChatbotInstance API asynchronously
func (client *Client) AssociateChatbotInstanceWithChan(request *AssociateChatbotInstanceRequest) (<-chan *AssociateChatbotInstanceResponse, <-chan error) {
	responseChan := make(chan *AssociateChatbotInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateChatbotInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateChatbotInstanceWithCallback invokes the voicenavigator.AssociateChatbotInstance API asynchronously
func (client *Client) AssociateChatbotInstanceWithCallback(request *AssociateChatbotInstanceRequest, callback func(response *AssociateChatbotInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateChatbotInstanceResponse
		var err error
		defer close(result)
		response, err = client.AssociateChatbotInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateChatbotInstanceRequest is the request struct for api AssociateChatbotInstance
type AssociateChatbotInstanceRequest struct {
	*requests.RpcRequest
	InstanceId        string `position:"Query" name:"InstanceId"`
	ChatbotInstanceId string `position:"Query" name:"ChatbotInstanceId"`
	ChatbotName       string `position:"Query" name:"ChatbotName"`
}

// AssociateChatbotInstanceResponse is the response struct for api AssociateChatbotInstance
type AssociateChatbotInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociateChatbotInstanceRequest creates a request to invoke AssociateChatbotInstance API
func CreateAssociateChatbotInstanceRequest() (request *AssociateChatbotInstanceRequest) {
	request = &AssociateChatbotInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "AssociateChatbotInstance", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssociateChatbotInstanceResponse creates a response to parse from AssociateChatbotInstance response
func CreateAssociateChatbotInstanceResponse() (response *AssociateChatbotInstanceResponse) {
	response = &AssociateChatbotInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
