package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AbstractFilmVideo invokes the videoenhan.AbstractFilmVideo API synchronously
func (client *Client) AbstractFilmVideo(request *AbstractFilmVideoRequest) (response *AbstractFilmVideoResponse, err error) {
	response = CreateAbstractFilmVideoResponse()
	err = client.DoAction(request, response)
	return
}

// AbstractFilmVideoWithChan invokes the videoenhan.AbstractFilmVideo API asynchronously
func (client *Client) AbstractFilmVideoWithChan(request *AbstractFilmVideoRequest) (<-chan *AbstractFilmVideoResponse, <-chan error) {
	responseChan := make(chan *AbstractFilmVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AbstractFilmVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AbstractFilmVideoWithCallback invokes the videoenhan.AbstractFilmVideo API asynchronously
func (client *Client) AbstractFilmVideoWithCallback(request *AbstractFilmVideoRequest, callback func(response *AbstractFilmVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AbstractFilmVideoResponse
		var err error
		defer close(result)
		response, err = client.AbstractFilmVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AbstractFilmVideoRequest is the request struct for api AbstractFilmVideo
type AbstractFilmVideoRequest struct {
	*requests.RpcRequest
	Length   requests.Integer `position:"Body" name:"Length"`
	Async    requests.Boolean `position:"Body" name:"Async"`
	VideoUrl string           `position:"Body" name:"VideoUrl"`
}

// AbstractFilmVideoResponse is the response struct for api AbstractFilmVideo
type AbstractFilmVideoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAbstractFilmVideoRequest creates a request to invoke AbstractFilmVideo API
func CreateAbstractFilmVideoRequest() (request *AbstractFilmVideoRequest) {
	request = &AbstractFilmVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "AbstractFilmVideo", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAbstractFilmVideoResponse creates a response to parse from AbstractFilmVideo response
func CreateAbstractFilmVideoResponse() (response *AbstractFilmVideoResponse) {
	response = &AbstractFilmVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
