package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLabelsetData invokes the viapi_regen.DeleteLabelsetData API synchronously
func (client *Client) DeleteLabelsetData(request *DeleteLabelsetDataRequest) (response *DeleteLabelsetDataResponse, err error) {
	response = CreateDeleteLabelsetDataResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLabelsetDataWithChan invokes the viapi_regen.DeleteLabelsetData API asynchronously
func (client *Client) DeleteLabelsetDataWithChan(request *DeleteLabelsetDataRequest) (<-chan *DeleteLabelsetDataResponse, <-chan error) {
	responseChan := make(chan *DeleteLabelsetDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLabelsetData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLabelsetDataWithCallback invokes the viapi_regen.DeleteLabelsetData API asynchronously
func (client *Client) DeleteLabelsetDataWithCallback(request *DeleteLabelsetDataRequest, callback func(response *DeleteLabelsetDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLabelsetDataResponse
		var err error
		defer close(result)
		response, err = client.DeleteLabelsetData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLabelsetDataRequest is the request struct for api DeleteLabelsetData
type DeleteLabelsetDataRequest struct {
	*requests.RpcRequest
	Id      requests.Integer `position:"Body" name:"Id"`
	LabelId requests.Integer `position:"Body" name:"LabelId"`
}

// DeleteLabelsetDataResponse is the response struct for api DeleteLabelsetData
type DeleteLabelsetDataResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteLabelsetDataRequest creates a request to invoke DeleteLabelsetData API
func CreateDeleteLabelsetDataRequest() (request *DeleteLabelsetDataRequest) {
	request = &DeleteLabelsetDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "DeleteLabelsetData", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLabelsetDataResponse creates a response to parse from DeleteLabelsetData response
func CreateDeleteLabelsetDataResponse() (response *DeleteLabelsetDataResponse) {
	response = &DeleteLabelsetDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
