package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMember invokes the ververica.UpdateMember API synchronously
func (client *Client) UpdateMember(request *UpdateMemberRequest) (response *UpdateMemberResponse, err error) {
	response = CreateUpdateMemberResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMemberWithChan invokes the ververica.UpdateMember API asynchronously
func (client *Client) UpdateMemberWithChan(request *UpdateMemberRequest) (<-chan *UpdateMemberResponse, <-chan error) {
	responseChan := make(chan *UpdateMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMemberWithCallback invokes the ververica.UpdateMember API asynchronously
func (client *Client) UpdateMemberWithCallback(request *UpdateMemberRequest, callback func(response *UpdateMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMemberResponse
		var err error
		defer close(result)
		response, err = client.UpdateMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMemberRequest is the request struct for api UpdateMember
type UpdateMemberRequest struct {
	*requests.RoaRequest
	Workspace  string `position:"Path" name:"workspace"`
	ParamsJson string `position:"Body" name:"paramsJson"`
	Namespace  string `position:"Path" name:"namespace"`
}

// UpdateMemberResponse is the response struct for api UpdateMember
type UpdateMemberResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	RequestId string `json:"requestId" xml:"requestId"`
	Data      string `json:"data" xml:"data"`
}

// CreateUpdateMemberRequest creates a request to invoke UpdateMember API
func CreateUpdateMemberRequest() (request *UpdateMemberRequest) {
	request = &UpdateMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "UpdateMember", "/pop/workspaces/[workspace]/members/v1/namespaces/[namespace]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateMemberResponse creates a response to parse from UpdateMember response
func CreateUpdateMemberResponse() (response *UpdateMemberResponse) {
	response = &UpdateMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
