package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTaskRuleLimit invokes the unimkt.QueryTaskRuleLimit API synchronously
func (client *Client) QueryTaskRuleLimit(request *QueryTaskRuleLimitRequest) (response *QueryTaskRuleLimitResponse, err error) {
	response = CreateQueryTaskRuleLimitResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTaskRuleLimitWithChan invokes the unimkt.QueryTaskRuleLimit API asynchronously
func (client *Client) QueryTaskRuleLimitWithChan(request *QueryTaskRuleLimitRequest) (<-chan *QueryTaskRuleLimitResponse, <-chan error) {
	responseChan := make(chan *QueryTaskRuleLimitResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTaskRuleLimit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTaskRuleLimitWithCallback invokes the unimkt.QueryTaskRuleLimit API asynchronously
func (client *Client) QueryTaskRuleLimitWithCallback(request *QueryTaskRuleLimitRequest, callback func(response *QueryTaskRuleLimitResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTaskRuleLimitResponse
		var err error
		defer close(result)
		response, err = client.QueryTaskRuleLimit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTaskRuleLimitRequest is the request struct for api QueryTaskRuleLimit
type QueryTaskRuleLimitRequest struct {
	*requests.RpcRequest
	ChannelId string `position:"Query" name:"ChannelId"`
}

// QueryTaskRuleLimitResponse is the response struct for api QueryTaskRuleLimit
type QueryTaskRuleLimitResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateQueryTaskRuleLimitRequest creates a request to invoke QueryTaskRuleLimit API
func CreateQueryTaskRuleLimitRequest() (request *QueryTaskRuleLimitRequest) {
	request = &QueryTaskRuleLimitRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryTaskRuleLimit", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTaskRuleLimitResponse creates a response to parse from QueryTaskRuleLimit response
func CreateQueryTaskRuleLimitResponse() (response *QueryTaskRuleLimitResponse) {
	response = &QueryTaskRuleLimitResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
