package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyImageShareStatus invokes the swas_open.ModifyImageShareStatus API synchronously
func (client *Client) ModifyImageShareStatus(request *ModifyImageShareStatusRequest) (response *ModifyImageShareStatusResponse, err error) {
	response = CreateModifyImageShareStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyImageShareStatusWithChan invokes the swas_open.ModifyImageShareStatus API asynchronously
func (client *Client) ModifyImageShareStatusWithChan(request *ModifyImageShareStatusRequest) (<-chan *ModifyImageShareStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyImageShareStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyImageShareStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyImageShareStatusWithCallback invokes the swas_open.ModifyImageShareStatus API asynchronously
func (client *Client) ModifyImageShareStatusWithCallback(request *ModifyImageShareStatusRequest, callback func(response *ModifyImageShareStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyImageShareStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyImageShareStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyImageShareStatusRequest is the request struct for api ModifyImageShareStatus
type ModifyImageShareStatusRequest struct {
	*requests.RpcRequest
	ImageId     string `position:"Query" name:"ImageId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Operation   string `position:"Query" name:"Operation"`
}

// ModifyImageShareStatusResponse is the response struct for api ModifyImageShareStatus
type ModifyImageShareStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyImageShareStatusRequest creates a request to invoke ModifyImageShareStatus API
func CreateModifyImageShareStatusRequest() (request *ModifyImageShareStatusRequest) {
	request = &ModifyImageShareStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ModifyImageShareStatus", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyImageShareStatusResponse creates a response to parse from ModifyImageShareStatus response
func CreateModifyImageShareStatusResponse() (response *ModifyImageShareStatusResponse) {
	response = &ModifyImageShareStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
