package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableFirewallRule invokes the swas_open.DisableFirewallRule API synchronously
func (client *Client) DisableFirewallRule(request *DisableFirewallRuleRequest) (response *DisableFirewallRuleResponse, err error) {
	response = CreateDisableFirewallRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DisableFirewallRuleWithChan invokes the swas_open.DisableFirewallRule API asynchronously
func (client *Client) DisableFirewallRuleWithChan(request *DisableFirewallRuleRequest) (<-chan *DisableFirewallRuleResponse, <-chan error) {
	responseChan := make(chan *DisableFirewallRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableFirewallRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableFirewallRuleWithCallback invokes the swas_open.DisableFirewallRule API asynchronously
func (client *Client) DisableFirewallRuleWithCallback(request *DisableFirewallRuleRequest, callback func(response *DisableFirewallRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableFirewallRuleResponse
		var err error
		defer close(result)
		response, err = client.DisableFirewallRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableFirewallRuleRequest is the request struct for api DisableFirewallRule
type DisableFirewallRuleRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	Remark      string `position:"Query" name:"Remark"`
	InstanceId  string `position:"Query" name:"InstanceId"`
	RuleId      string `position:"Query" name:"RuleId"`
}

// DisableFirewallRuleResponse is the response struct for api DisableFirewallRule
type DisableFirewallRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableFirewallRuleRequest creates a request to invoke DisableFirewallRule API
func CreateDisableFirewallRuleRequest() (request *DisableFirewallRuleRequest) {
	request = &DisableFirewallRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DisableFirewallRule", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableFirewallRuleResponse creates a response to parse from DisableFirewallRule response
func CreateDisableFirewallRuleResponse() (response *DisableFirewallRuleResponse) {
	response = &DisableFirewallRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
