package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateStsToken invokes the sgw.GenerateStsToken API synchronously
func (client *Client) GenerateStsToken(request *GenerateStsTokenRequest) (response *GenerateStsTokenResponse, err error) {
	response = CreateGenerateStsTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateStsTokenWithChan invokes the sgw.GenerateStsToken API asynchronously
func (client *Client) GenerateStsTokenWithChan(request *GenerateStsTokenRequest) (<-chan *GenerateStsTokenResponse, <-chan error) {
	responseChan := make(chan *GenerateStsTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateStsToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateStsTokenWithCallback invokes the sgw.GenerateStsToken API asynchronously
func (client *Client) GenerateStsTokenWithCallback(request *GenerateStsTokenRequest, callback func(response *GenerateStsTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateStsTokenResponse
		var err error
		defer close(result)
		response, err = client.GenerateStsToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateStsTokenRequest is the request struct for api GenerateStsToken
type GenerateStsTokenRequest struct {
	*requests.RpcRequest
	TokenType       string           `position:"Query" name:"TokenType"`
	ExpireInSeconds requests.Integer `position:"Query" name:"ExpireInSeconds"`
	SecurityToken   string           `position:"Query" name:"SecurityToken"`
	GatewayId       string           `position:"Query" name:"GatewayId"`
}

// GenerateStsTokenResponse is the response struct for api GenerateStsToken
type GenerateStsTokenResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	Success             bool   `json:"Success" xml:"Success"`
	Code                string `json:"Code" xml:"Code"`
	Message             string `json:"Message" xml:"Message"`
	AccessKeyId         string `json:"AccessKeyId" xml:"AccessKeyId"`
	AccessKeySecret     string `json:"AccessKeySecret" xml:"AccessKeySecret"`
	Expiration          string `json:"Expiration" xml:"Expiration"`
	SecurityToken       string `json:"SecurityToken" xml:"SecurityToken"`
	SupportBundleTarget string `json:"SupportBundleTarget" xml:"SupportBundleTarget"`
	Environment         string `json:"Environment" xml:"Environment"`
}

// CreateGenerateStsTokenRequest creates a request to invoke GenerateStsToken API
func CreateGenerateStsTokenRequest() (request *GenerateStsTokenRequest) {
	request = &GenerateStsTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "GenerateStsToken", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateStsTokenResponse creates a response to parse from GenerateStsToken response
func CreateGenerateStsTokenResponse() (response *GenerateStsTokenResponse) {
	response = &GenerateStsTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
