package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGateways invokes the sgw.DescribeGateways API synchronously
func (client *Client) DescribeGateways(request *DescribeGatewaysRequest) (response *DescribeGatewaysResponse, err error) {
	response = CreateDescribeGatewaysResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewaysWithChan invokes the sgw.DescribeGateways API asynchronously
func (client *Client) DescribeGatewaysWithChan(request *DescribeGatewaysRequest) (<-chan *DescribeGatewaysResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewaysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGateways(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewaysWithCallback invokes the sgw.DescribeGateways API asynchronously
func (client *Client) DescribeGatewaysWithCallback(request *DescribeGatewaysRequest, callback func(response *DescribeGatewaysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewaysResponse
		var err error
		defer close(result)
		response, err = client.DescribeGateways(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewaysRequest is the request struct for api DescribeGateways
type DescribeGatewaysRequest struct {
	*requests.RpcRequest
	EcsInstanceIds  string           `position:"Query" name:"EcsInstanceIds"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	SecurityToken   string           `position:"Query" name:"SecurityToken"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	StorageBundleId string           `position:"Query" name:"StorageBundleId"`
}

// DescribeGatewaysResponse is the response struct for api DescribeGateways
type DescribeGatewaysResponse struct {
	*responses.BaseResponse
	RequestId  string                     `json:"RequestId" xml:"RequestId"`
	Success    bool                       `json:"Success" xml:"Success"`
	Code       string                     `json:"Code" xml:"Code"`
	Message    string                     `json:"Message" xml:"Message"`
	TotalCount int                        `json:"TotalCount" xml:"TotalCount"`
	PageNumber int                        `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                        `json:"PageSize" xml:"PageSize"`
	Gateways   GatewaysInDescribeGateways `json:"Gateways" xml:"Gateways"`
}

// CreateDescribeGatewaysRequest creates a request to invoke DescribeGateways API
func CreateDescribeGatewaysRequest() (request *DescribeGatewaysRequest) {
	request = &DescribeGatewaysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGateways", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewaysResponse creates a response to parse from DescribeGateways response
func CreateDescribeGatewaysResponse() (response *DescribeGatewaysResponse) {
	response = &DescribeGatewaysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
