package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokePermission invokes the schedulerx2.RevokePermission API synchronously
func (client *Client) RevokePermission(request *RevokePermissionRequest) (response *RevokePermissionResponse, err error) {
	response = CreateRevokePermissionResponse()
	err = client.DoAction(request, response)
	return
}

// RevokePermissionWithChan invokes the schedulerx2.RevokePermission API asynchronously
func (client *Client) RevokePermissionWithChan(request *RevokePermissionRequest) (<-chan *RevokePermissionResponse, <-chan error) {
	responseChan := make(chan *RevokePermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokePermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokePermissionWithCallback invokes the schedulerx2.RevokePermission API asynchronously
func (client *Client) RevokePermissionWithCallback(request *RevokePermissionRequest, callback func(response *RevokePermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokePermissionResponse
		var err error
		defer close(result)
		response, err = client.RevokePermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokePermissionRequest is the request struct for api RevokePermission
type RevokePermissionRequest struct {
	*requests.RpcRequest
	NamespaceSource string `position:"Query" name:"NamespaceSource"`
	GroupId         string `position:"Query" name:"GroupId"`
	UserId          string `position:"Query" name:"UserId"`
	Namespace       string `position:"Query" name:"Namespace"`
}

// RevokePermissionResponse is the response struct for api RevokePermission
type RevokePermissionResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateRevokePermissionRequest creates a request to invoke RevokePermission API
func CreateRevokePermissionRequest() (request *RevokePermissionRequest) {
	request = &RevokePermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "RevokePermission", "schedulerx2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRevokePermissionResponse creates a response to parse from RevokePermission response
func CreateRevokePermissionResponse() (response *RevokePermissionResponse) {
	response = &RevokePermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
