package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateCommonOverallConfig invokes the sas.OperateCommonOverallConfig API synchronously
func (client *Client) OperateCommonOverallConfig(request *OperateCommonOverallConfigRequest) (response *OperateCommonOverallConfigResponse, err error) {
	response = CreateOperateCommonOverallConfigResponse()
	err = client.DoAction(request, response)
	return
}

// OperateCommonOverallConfigWithChan invokes the sas.OperateCommonOverallConfig API asynchronously
func (client *Client) OperateCommonOverallConfigWithChan(request *OperateCommonOverallConfigRequest) (<-chan *OperateCommonOverallConfigResponse, <-chan error) {
	responseChan := make(chan *OperateCommonOverallConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateCommonOverallConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateCommonOverallConfigWithCallback invokes the sas.OperateCommonOverallConfig API asynchronously
func (client *Client) OperateCommonOverallConfigWithCallback(request *OperateCommonOverallConfigRequest, callback func(response *OperateCommonOverallConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateCommonOverallConfigResponse
		var err error
		defer close(result)
		response, err = client.OperateCommonOverallConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateCommonOverallConfigRequest is the request struct for api OperateCommonOverallConfig
type OperateCommonOverallConfigRequest struct {
	*requests.RpcRequest
	Type                       string `position:"Query" name:"Type"`
	SourceIp                   string `position:"Query" name:"SourceIp"`
	ResourceDirectoryAccountId string `position:"Query" name:"ResourceDirectoryAccountId"`
	Config                     string `position:"Query" name:"Config"`
}

// OperateCommonOverallConfigResponse is the response struct for api OperateCommonOverallConfig
type OperateCommonOverallConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOperateCommonOverallConfigRequest creates a request to invoke OperateCommonOverallConfig API
func CreateOperateCommonOverallConfigRequest() (request *OperateCommonOverallConfigRequest) {
	request = &OperateCommonOverallConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "OperateCommonOverallConfig", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOperateCommonOverallConfigResponse creates a response to parse from OperateCommonOverallConfig response
func CreateOperateCommonOverallConfigResponse() (response *OperateCommonOverallConfigResponse) {
	response = &OperateCommonOverallConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
