package sas_api

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIpProfile invokes the sas_api.GetIpProfile API synchronously
// api document: https://help.aliyun.com/api/sas-api/getipprofile.html
func (client *Client) GetIpProfile(request *GetIpProfileRequest) (response *GetIpProfileResponse, err error) {
	response = CreateGetIpProfileResponse()
	err = client.DoAction(request, response)
	return
}

// GetIpProfileWithChan invokes the sas_api.GetIpProfile API asynchronously
// api document: https://help.aliyun.com/api/sas-api/getipprofile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIpProfileWithChan(request *GetIpProfileRequest) (<-chan *GetIpProfileResponse, <-chan error) {
	responseChan := make(chan *GetIpProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIpProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIpProfileWithCallback invokes the sas_api.GetIpProfile API asynchronously
// api document: https://help.aliyun.com/api/sas-api/getipprofile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIpProfileWithCallback(request *GetIpProfileRequest, callback func(response *GetIpProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIpProfileResponse
		var err error
		defer close(result)
		response, err = client.GetIpProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIpProfileRequest is the request struct for api GetIpProfile
type GetIpProfileRequest struct {
	*requests.RpcRequest
	DeviceIdMd5    string           `position:"Query" name:"DeviceIdMd5"`
	Carrier        requests.Integer `position:"Query" name:"Carrier"`
	Os             string           `position:"Query" name:"Os"`
	RequestUrl     string           `position:"Query" name:"RequestUrl"`
	Ip             string           `position:"Query" name:"Ip"`
	UserAgent      string           `position:"Query" name:"UserAgent"`
	ConnectionType requests.Integer `position:"Query" name:"ConnectionType"`
	SensType       requests.Integer `position:"Query" name:"SensType"`
	DeviceType     requests.Integer `position:"Query" name:"DeviceType"`
	BusinessType   requests.Integer `position:"Query" name:"BusinessType"`
}

// GetIpProfileResponse is the response struct for api GetIpProfile
type GetIpProfileResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetIpProfileRequest creates a request to invoke GetIpProfile API
func CreateGetIpProfileRequest() (request *GetIpProfileRequest) {
	request = &GetIpProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas-api", "2017-07-05", "GetIpProfile", "sas-api", "openAPI")
	return
}

// CreateGetIpProfileResponse creates a response to parse from GetIpProfile response
func CreateGetIpProfileResponse() (response *GetIpProfileResponse) {
	response = &GetIpProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
