package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHandshake invokes the resourcemanager.GetHandshake API synchronously
func (client *Client) GetHandshake(request *GetHandshakeRequest) (response *GetHandshakeResponse, err error) {
	response = CreateGetHandshakeResponse()
	err = client.DoAction(request, response)
	return
}

// GetHandshakeWithChan invokes the resourcemanager.GetHandshake API asynchronously
func (client *Client) GetHandshakeWithChan(request *GetHandshakeRequest) (<-chan *GetHandshakeResponse, <-chan error) {
	responseChan := make(chan *GetHandshakeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHandshake(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHandshakeWithCallback invokes the resourcemanager.GetHandshake API asynchronously
func (client *Client) GetHandshakeWithCallback(request *GetHandshakeRequest, callback func(response *GetHandshakeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHandshakeResponse
		var err error
		defer close(result)
		response, err = client.GetHandshake(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHandshakeRequest is the request struct for api GetHandshake
type GetHandshakeRequest struct {
	*requests.RpcRequest
	HandshakeId string `position:"Query" name:"HandshakeId"`
}

// GetHandshakeResponse is the response struct for api GetHandshake
type GetHandshakeResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Handshake Handshake `json:"Handshake" xml:"Handshake"`
}

// CreateGetHandshakeRequest creates a request to invoke GetHandshake API
func CreateGetHandshakeRequest() (request *GetHandshakeRequest) {
	request = &GetHandshakeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "GetHandshake", "", "")
	request.Method = requests.POST
	return
}

// CreateGetHandshakeResponse creates a response to parse from GetHandshake response
func CreateGetHandshakeResponse() (response *GetHandshakeResponse) {
	response = &GetHandshakeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
