package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccountDeletionCheckResult invokes the resourcemanager.GetAccountDeletionCheckResult API synchronously
func (client *Client) GetAccountDeletionCheckResult(request *GetAccountDeletionCheckResultRequest) (response *GetAccountDeletionCheckResultResponse, err error) {
	response = CreateGetAccountDeletionCheckResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccountDeletionCheckResultWithChan invokes the resourcemanager.GetAccountDeletionCheckResult API asynchronously
func (client *Client) GetAccountDeletionCheckResultWithChan(request *GetAccountDeletionCheckResultRequest) (<-chan *GetAccountDeletionCheckResultResponse, <-chan error) {
	responseChan := make(chan *GetAccountDeletionCheckResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccountDeletionCheckResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccountDeletionCheckResultWithCallback invokes the resourcemanager.GetAccountDeletionCheckResult API asynchronously
func (client *Client) GetAccountDeletionCheckResultWithCallback(request *GetAccountDeletionCheckResultRequest, callback func(response *GetAccountDeletionCheckResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccountDeletionCheckResultResponse
		var err error
		defer close(result)
		response, err = client.GetAccountDeletionCheckResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccountDeletionCheckResultRequest is the request struct for api GetAccountDeletionCheckResult
type GetAccountDeletionCheckResultRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
}

// GetAccountDeletionCheckResultResponse is the response struct for api GetAccountDeletionCheckResult
type GetAccountDeletionCheckResultResponse struct {
	*responses.BaseResponse
	RequestId                      string                         `json:"RequestId" xml:"RequestId"`
	AccountDeletionCheckResultInfo AccountDeletionCheckResultInfo `json:"AccountDeletionCheckResultInfo" xml:"AccountDeletionCheckResultInfo"`
}

// CreateGetAccountDeletionCheckResultRequest creates a request to invoke GetAccountDeletionCheckResult API
func CreateGetAccountDeletionCheckResultRequest() (request *GetAccountDeletionCheckResultRequest) {
	request = &GetAccountDeletionCheckResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "GetAccountDeletionCheckResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAccountDeletionCheckResultResponse creates a response to parse from GetAccountDeletionCheckResult response
func CreateGetAccountDeletionCheckResultResponse() (response *GetAccountDeletionCheckResultResponse) {
	response = &GetAccountDeletionCheckResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
