package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// JoinCompany invokes the rdc.JoinCompany API synchronously
// api document: https://help.aliyun.com/api/rdc/joincompany.html
func (client *Client) JoinCompany(request *JoinCompanyRequest) (response *JoinCompanyResponse, err error) {
	response = CreateJoinCompanyResponse()
	err = client.DoAction(request, response)
	return
}

// JoinCompanyWithChan invokes the rdc.JoinCompany API asynchronously
// api document: https://help.aliyun.com/api/rdc/joincompany.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) JoinCompanyWithChan(request *JoinCompanyRequest) (<-chan *JoinCompanyResponse, <-chan error) {
	responseChan := make(chan *JoinCompanyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.JoinCompany(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// JoinCompanyWithCallback invokes the rdc.JoinCompany API asynchronously
// api document: https://help.aliyun.com/api/rdc/joincompany.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) JoinCompanyWithCallback(request *JoinCompanyRequest, callback func(response *JoinCompanyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *JoinCompanyResponse
		var err error
		defer close(result)
		response, err = client.JoinCompany(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// JoinCompanyRequest is the request struct for api JoinCompany
type JoinCompanyRequest struct {
	*requests.RpcRequest
	Code string `position:"Body" name:"Code"`
}

// JoinCompanyResponse is the response struct for api JoinCompany
type JoinCompanyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateJoinCompanyRequest creates a request to invoke JoinCompany API
func CreateJoinCompanyRequest() (request *JoinCompanyRequest) {
	request = &JoinCompanyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "JoinCompany", "rdc", "openAPI")
	return
}

// CreateJoinCompanyResponse creates a response to parse from JoinCompany response
func CreateJoinCompanyResponse() (response *JoinCompanyResponse) {
	response = &JoinCompanyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
