package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetChangeLog invokes the rdc.GetChangeLog API synchronously
// api document: https://help.aliyun.com/api/rdc/getchangelog.html
func (client *Client) GetChangeLog(request *GetChangeLogRequest) (response *GetChangeLogResponse, err error) {
	response = CreateGetChangeLogResponse()
	err = client.DoAction(request, response)
	return
}

// GetChangeLogWithChan invokes the rdc.GetChangeLog API asynchronously
// api document: https://help.aliyun.com/api/rdc/getchangelog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetChangeLogWithChan(request *GetChangeLogRequest) (<-chan *GetChangeLogResponse, <-chan error) {
	responseChan := make(chan *GetChangeLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetChangeLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetChangeLogWithCallback invokes the rdc.GetChangeLog API asynchronously
// api document: https://help.aliyun.com/api/rdc/getchangelog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetChangeLogWithCallback(request *GetChangeLogRequest, callback func(response *GetChangeLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetChangeLogResponse
		var err error
		defer close(result)
		response, err = client.GetChangeLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetChangeLogRequest is the request struct for api GetChangeLog
type GetChangeLogRequest struct {
	*requests.RpcRequest
	TargetType     string `position:"Body" name:"TargetType"`
	TargetIds      string `position:"Body" name:"TargetIds"`
	CorpIdentifier string `position:"Query" name:"CorpIdentifier"`
}

// GetChangeLogResponse is the response struct for api GetChangeLog
type GetChangeLogResponse struct {
	*responses.BaseResponse
	Code      int        `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetChangeLogRequest creates a request to invoke GetChangeLog API
func CreateGetChangeLogRequest() (request *GetChangeLogRequest) {
	request = &GetChangeLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "GetChangeLog", "rdc", "openAPI")
	return
}

// CreateGetChangeLogResponse creates a response to parse from GetChangeLog response
func CreateGetChangeLogResponse() (response *GetChangeLogResponse) {
	response = &GetChangeLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
