package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTairKVCacheCustomInstanceAttribute invokes the r_kvstore.DescribeTairKVCacheCustomInstanceAttribute API synchronously
func (client *Client) DescribeTairKVCacheCustomInstanceAttribute(request *DescribeTairKVCacheCustomInstanceAttributeRequest) (response *DescribeTairKVCacheCustomInstanceAttributeResponse, err error) {
	response = CreateDescribeTairKVCacheCustomInstanceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTairKVCacheCustomInstanceAttributeWithChan invokes the r_kvstore.DescribeTairKVCacheCustomInstanceAttribute API asynchronously
func (client *Client) DescribeTairKVCacheCustomInstanceAttributeWithChan(request *DescribeTairKVCacheCustomInstanceAttributeRequest) (<-chan *DescribeTairKVCacheCustomInstanceAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeTairKVCacheCustomInstanceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTairKVCacheCustomInstanceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTairKVCacheCustomInstanceAttributeWithCallback invokes the r_kvstore.DescribeTairKVCacheCustomInstanceAttribute API asynchronously
func (client *Client) DescribeTairKVCacheCustomInstanceAttributeWithCallback(request *DescribeTairKVCacheCustomInstanceAttributeRequest, callback func(response *DescribeTairKVCacheCustomInstanceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTairKVCacheCustomInstanceAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeTairKVCacheCustomInstanceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTairKVCacheCustomInstanceAttributeRequest is the request struct for api DescribeTairKVCacheCustomInstanceAttribute
type DescribeTairKVCacheCustomInstanceAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// DescribeTairKVCacheCustomInstanceAttributeResponse is the response struct for api DescribeTairKVCacheCustomInstanceAttribute
type DescribeTairKVCacheCustomInstanceAttributeResponse struct {
	*responses.BaseResponse
	RequestId        string                                           `json:"RequestId" xml:"RequestId"`
	VpcId            string                                           `json:"VpcId" xml:"VpcId"`
	PrivateIp        string                                           `json:"PrivateIp" xml:"PrivateIp"`
	CreateTime       string                                           `json:"CreateTime" xml:"CreateTime"`
	ChargeType       string                                           `json:"ChargeType" xml:"ChargeType"`
	StorageType      string                                           `json:"StorageType" xml:"StorageType"`
	ArchitectureType string                                           `json:"ArchitectureType" xml:"ArchitectureType"`
	NetworkType      string                                           `json:"NetworkType" xml:"NetworkType"`
	InstanceName     string                                           `json:"InstanceName" xml:"InstanceName"`
	ZoneType         string                                           `json:"ZoneType" xml:"ZoneType"`
	InstanceClass    string                                           `json:"InstanceClass" xml:"InstanceClass"`
	InstanceId       string                                           `json:"InstanceId" xml:"InstanceId"`
	InstanceType     string                                           `json:"InstanceType" xml:"InstanceType"`
	RegionId         string                                           `json:"RegionId" xml:"RegionId"`
	EndTime          string                                           `json:"EndTime" xml:"EndTime"`
	VSwitchId        string                                           `json:"VSwitchId" xml:"VSwitchId"`
	ResourceGroupId  string                                           `json:"ResourceGroupId" xml:"ResourceGroupId"`
	ZoneId           string                                           `json:"ZoneId" xml:"ZoneId"`
	InstanceStatus   string                                           `json:"InstanceStatus" xml:"InstanceStatus"`
	Storage          int64                                            `json:"Storage" xml:"Storage"`
	IsOrderCompleted bool                                             `json:"IsOrderCompleted" xml:"IsOrderCompleted"`
	ImageId          string                                           `json:"ImageId" xml:"ImageId"`
	Cpu              int64                                            `json:"Cpu" xml:"Cpu"`
	Memory           int64                                            `json:"Memory" xml:"Memory"`
	SecurityGroupId  string                                           `json:"SecurityGroupId" xml:"SecurityGroupId"`
	UseEni           bool                                             `json:"UseEni" xml:"UseEni"`
	Tags             TagsInDescribeTairKVCacheCustomInstanceAttribute `json:"Tags" xml:"Tags"`
	Disks            Disks                                            `json:"Disks" xml:"Disks"`
}

// CreateDescribeTairKVCacheCustomInstanceAttributeRequest creates a request to invoke DescribeTairKVCacheCustomInstanceAttribute API
func CreateDescribeTairKVCacheCustomInstanceAttributeRequest() (request *DescribeTairKVCacheCustomInstanceAttributeRequest) {
	request = &DescribeTairKVCacheCustomInstanceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeTairKVCacheCustomInstanceAttribute", "redisa", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeTairKVCacheCustomInstanceAttributeResponse creates a response to parse from DescribeTairKVCacheCustomInstanceAttribute response
func CreateDescribeTairKVCacheCustomInstanceAttributeResponse() (response *DescribeTairKVCacheCustomInstanceAttributeResponse) {
	response = &DescribeTairKVCacheCustomInstanceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
