package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveOpenJMeterScene invokes the pts.SaveOpenJMeterScene API synchronously
func (client *Client) SaveOpenJMeterScene(request *SaveOpenJMeterSceneRequest) (response *SaveOpenJMeterSceneResponse, err error) {
	response = CreateSaveOpenJMeterSceneResponse()
	err = client.DoAction(request, response)
	return
}

// SaveOpenJMeterSceneWithChan invokes the pts.SaveOpenJMeterScene API asynchronously
func (client *Client) SaveOpenJMeterSceneWithChan(request *SaveOpenJMeterSceneRequest) (<-chan *SaveOpenJMeterSceneResponse, <-chan error) {
	responseChan := make(chan *SaveOpenJMeterSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveOpenJMeterScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveOpenJMeterSceneWithCallback invokes the pts.SaveOpenJMeterScene API asynchronously
func (client *Client) SaveOpenJMeterSceneWithCallback(request *SaveOpenJMeterSceneRequest, callback func(response *SaveOpenJMeterSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveOpenJMeterSceneResponse
		var err error
		defer close(result)
		response, err = client.SaveOpenJMeterScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveOpenJMeterSceneRequest is the request struct for api SaveOpenJMeterScene
type SaveOpenJMeterSceneRequest struct {
	*requests.RpcRequest
	OpenJMeterScene SaveOpenJMeterSceneOpenJMeterScene `position:"Query" name:"OpenJMeterScene"  type:"Struct"`
}

// SaveOpenJMeterSceneOpenJMeterScene is a repeated param struct in SaveOpenJMeterSceneRequest
type SaveOpenJMeterSceneOpenJMeterScene struct {
	StartConcurrency            string                                                    `name:"StartConcurrency"`
	TestFile                    string                                                    `name:"TestFile"`
	ConstantThroughputTimerType string                                                    `name:"ConstantThroughputTimerType"`
	SceneName                   string                                                    `name:"SceneName"`
	SecurityGroupId             string                                                    `name:"SecurityGroupId"`
	FileList                    *[]SaveOpenJMeterSceneOpenJMeterSceneFileListItem         `name:"FileList" type:"Repeated"`
	Steps                       string                                                    `name:"Steps"`
	StartRps                    string                                                    `name:"StartRps"`
	Concurrency                 string                                                    `name:"Concurrency"`
	Duration                    string                                                    `name:"Duration"`
	AgentCount                  string                                                    `name:"AgentCount"`
	VSwitchId                   string                                                    `name:"VSwitchId"`
	Mode                        string                                                    `name:"Mode"`
	IsVpcTest                   string                                                    `name:"IsVpcTest"`
	EnvironmentId               string                                                    `name:"EnvironmentId"`
	RegionId                    string                                                    `name:"RegionId"`
	VpcId                       string                                                    `name:"VpcId"`
	SceneId                     string                                                    `name:"SceneId"`
	JmeterPluginLabel           string                                                    `name:"JmeterPluginLabel"`
	DnsCacheConfig              SaveOpenJMeterSceneOpenJMeterSceneDnsCacheConfig          `name:"DnsCacheConfig" type:"Struct"`
	JMeterProperties            *[]SaveOpenJMeterSceneOpenJMeterSceneJMeterPropertiesItem `name:"JMeterProperties" type:"Repeated"`
	SyncTimerType               string                                                    `name:"SyncTimerType"`
	MaxRps                      string                                                    `name:"MaxRps"`
	RampUp                      string                                                    `name:"RampUp"`
}

// SaveOpenJMeterSceneOpenJMeterSceneFileListItem is a repeated param struct in SaveOpenJMeterSceneRequest
type SaveOpenJMeterSceneOpenJMeterSceneFileListItem struct {
	FileName       string `name:"FileName"`
	SplitCsv       string `name:"SplitCsv"`
	FileSize       string `name:"FileSize"`
	FileOssAddress string `name:"FileOssAddress"`
	Md5            string `name:"Md5"`
	FileId         string `name:"FileId"`
	Tags           string `name:"Tags"`
}

// SaveOpenJMeterSceneOpenJMeterSceneDnsCacheConfig is a repeated param struct in SaveOpenJMeterSceneRequest
type SaveOpenJMeterSceneOpenJMeterSceneDnsCacheConfig struct {
	ClearCacheEachIteration string            `name:"ClearCacheEachIteration"`
	DnsServers              *[]string         `name:"DnsServers" type:"Repeated"`
	HostTable               map[string]string `name:"HostTable" type:"Map"`
}

// SaveOpenJMeterSceneOpenJMeterSceneJMeterPropertiesItem is a repeated param struct in SaveOpenJMeterSceneRequest
type SaveOpenJMeterSceneOpenJMeterSceneJMeterPropertiesItem struct {
	Name  string `name:"Name"`
	Value string `name:"Value"`
}

// SaveOpenJMeterSceneResponse is the response struct for api SaveOpenJMeterScene
type SaveOpenJMeterSceneResponse struct {
	*responses.BaseResponse
	SceneId        string `json:"SceneId" xml:"SceneId"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateSaveOpenJMeterSceneRequest creates a request to invoke SaveOpenJMeterScene API
func CreateSaveOpenJMeterSceneRequest() (request *SaveOpenJMeterSceneRequest) {
	request = &SaveOpenJMeterSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "SaveOpenJMeterScene", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveOpenJMeterSceneResponse creates a response to parse from SaveOpenJMeterScene response
func CreateSaveOpenJMeterSceneResponse() (response *SaveOpenJMeterSceneResponse) {
	response = &SaveOpenJMeterSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
