package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDBInstanceTDE invokes the polardbx.UpdateDBInstanceTDE API synchronously
func (client *Client) UpdateDBInstanceTDE(request *UpdateDBInstanceTDERequest) (response *UpdateDBInstanceTDEResponse, err error) {
	response = CreateUpdateDBInstanceTDEResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDBInstanceTDEWithChan invokes the polardbx.UpdateDBInstanceTDE API asynchronously
func (client *Client) UpdateDBInstanceTDEWithChan(request *UpdateDBInstanceTDERequest) (<-chan *UpdateDBInstanceTDEResponse, <-chan error) {
	responseChan := make(chan *UpdateDBInstanceTDEResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDBInstanceTDE(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDBInstanceTDEWithCallback invokes the polardbx.UpdateDBInstanceTDE API asynchronously
func (client *Client) UpdateDBInstanceTDEWithCallback(request *UpdateDBInstanceTDERequest, callback func(response *UpdateDBInstanceTDEResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDBInstanceTDEResponse
		var err error
		defer close(result)
		response, err = client.UpdateDBInstanceTDE(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDBInstanceTDERequest is the request struct for api UpdateDBInstanceTDE
type UpdateDBInstanceTDERequest struct {
	*requests.RpcRequest
	DBInstanceName string           `position:"Query" name:"DBInstanceName"`
	EncryptionKey  string           `position:"Query" name:"EncryptionKey"`
	RoleArn        string           `position:"Query" name:"RoleArn"`
	TDEStatus      requests.Integer `position:"Query" name:"TDEStatus"`
}

// UpdateDBInstanceTDEResponse is the response struct for api UpdateDBInstanceTDE
type UpdateDBInstanceTDEResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Data      DataInUpdateDBInstanceTDE `json:"Data" xml:"Data"`
}

// CreateUpdateDBInstanceTDERequest creates a request to invoke UpdateDBInstanceTDE API
func CreateUpdateDBInstanceTDERequest() (request *UpdateDBInstanceTDERequest) {
	request = &UpdateDBInstanceTDERequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "UpdateDBInstanceTDE", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDBInstanceTDEResponse creates a response to parse from UpdateDBInstanceTDE response
func CreateUpdateDBInstanceTDEResponse() (response *UpdateDBInstanceTDEResponse) {
	response = &UpdateDBInstanceTDEResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
